<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
include_once "../includes/config.php";
class Order {
    public static function insertShippingDetails($objShippingVo)
    {
        global $tableprefix,$pdo;
            $objResult                           = new stdClass();
            $dataArr                            = array(  'norder_id'                  =>  $objShippingVo->norder_id,
                                                    'vshipping_name'                        =>  $objShippingVo->vshipping_name,
                                                    'nshipping_cost'                      =>  $objShippingVo->nshipping_cost,
                                                    'nshipping_weight'                      =>  $objShippingVo->nshipping_weight,
                                                    'vshipping_currency'                       =>  $objShippingVo->vshipping_currency,
                                                    'dshipped_date'                       =>  'now()',
                                                    'nshp_status'                       =>  $objShippingVo->nshp_status,
                                                    'user_id'                       =>  $objShippingVo->user_id,
                                                    'seller_id'                       =>  $objShippingVo->seller_id);
        $shippingId =  $pdo->insert($tableprefix."shipping_details",$dataArr)->lastInsertId();
            if($shippingId) {
            $objResult->status                  =    SUCCESS;
            $objResult->data                    =    $shippingId;
         }else{
             $objResult->status                 =    ERROR;
         }
         return $objResult;
    }


      public static function updateSellerCoupcodeInformationtoOrder($couponcodeObjVo)
    {
           global $tableprefix,$pdo;
            $objResult                           = new stdClass();
            $orderId        = $pdo->update($tableprefix.'orders', array('couponCode' =>$couponcodeObjVo->couponCode,'couponCodeDiscount'=>$couponcodeObjVo->couponCodeDiscount,'couponCodeSeller_Id'=>$couponcodeObjVo->couponCodeSeller_Id), array("order_id"=>$couponcodeObjVo->order_id))->affectedRows();
            if($orderId) {
            $objResult->status                  =    SUCCESS;
            $objResult->data                    =    $orderId;
         }else{
             $objResult->status                 =    ERROR;
         }

         return $objResult;
    }

     public static function is_free_ship_product($productID)
    {

          global $tableprefix,$pdo;
                 $objResult                      = new stdClass();
                 if(!empty($productID)) {
                 $objResultRow                   = $pdo->select($tableprefix."order_details",array("allow_free_shipping"),array("product_id"=>$productID))->results();
                 }
                 if(!empty($objResultRow)) {
                      $objResult->status         =    SUCCESS;
                      $objResult->data           =   $objResultRow[0]['allow_free_shipping']; // Assign user record  to object
                 }
                 else{
                     $objResult->status          =  ERROR;
                  }
         return $objResult;
    }


     public static function check_free_ship_product_text($productID)
    {
                $freeShipText       =   '';
                 if(!empty($productID)) {
                       $freeshipObj    =   self::is_free_ship_product($productID);
                        if($freeshipObj->status==SUCCESS)
                        {
                            $FreeshipFlag  = $freeshipObj->data;

                            if($FreeshipFlag=='Y')
                            {
                                $freeShipText   =  "( ". FREE_SHIP_TEXT ." )";
                            }
                        }
         // If user exists then assign user data to result object
                 }

         return $freeShipText;

    }

     public static function orderShippingCost($orderID,$sellerId='')
    {
          global $tableprefix,$pdo;

          if(!empty($orderID)) {
            $selectCase                     = ($sellerId==NULL)? "norder_id=".$orderID:"norder_id =".$orderID." AND seller_id =".$sellerId;
            $objResultRow                   = $pdo->pdoQuery("select SUM(nshipping_cost) as shipping_total FROM ".$tableprefix."shipping_details WHERE ".$selectCase)->results();
            }
            if(!empty($objResultRow)) {
                 $shippingCost             =   $objResultRow[0]['shipping_total'];
            }
         return $shippingCost;

    }

     // function to show digital icon
     public static function showDigitalItemIcon($digitalProductFlag)
    {
         if($digitalProductFlag=="Y"){
             $image ='<img src="'.SITE_URL.'/images/digital_icon.png" alt="'.DIGITAL_PRODUCT_FLAG.'" title="'.DIGITAL_PRODUCT_FLAG.'">';
         }else{
             $image ="";
         }

         return $image;

    }

    //Function to show icontext
    public static function showIconTexts($orderId){
         global $tableprefix,$pdo;
        $digital_subscription_prd_count = $pdo->select($tableprefix.'order_details',array('COUNT(order_detail_id) as count'),array("order_id"=>$orderId,"digital_product_flag"=>"'Y' OR subscription_product_flag='Y'"))->results();
        if($digital_subscription_prd_count[0]['count']>0){
            $retVal ='<div><img src="'.SITE_URL.'/images/digital_icon.png" alt="'.DIGITAL_PRODUCT_FLAG.'" title="'.DIGITAL_PRODUCT_FLAG.'">'.DIGITAL_PRODUCT_MARK_TEXT;
        }else{
            $retVal = "&nbsp;";
        }
        return $retVal;
    }



    // Get Order Tax Total

    public static function getorderTaxTotal($orderID, $sellerId = '')
    {
        global $tableprefix, $pdo;
        if (!empty($orderID)) {            
            $where = " WHERE order_id =".$orderID;

            if (!empty($sellerId)) {              
                $where .= " AND artist_id =".$sellerId;
            }
            $sql = "SELECT SUM(product_tax) as tax_total FROM ".$tableprefix."order_details".$where;
           // echo $sql;
            $result = $pdo->pdoQuery($sql)->result();
            if (!empty($result)) {
                return $result['tax_total'];
            } else {
                return 0;
            }
        }
    }


    //get Seller Coupon Code Discount

     public static function getorderCoponDiscount($orderID,$sellerId='')
    {
                 $objResult                      = new stdClass();
                 $tableName                      = DbHelper::setTablePrefix('orders');

                 $taxTotal                  =   0;

                 if(!empty($orderID)) {
                 $selectCase                     = ($sellerId==NULL)?"order_id =".generalMethods::escapeString($orderID):"order_id =".generalMethods::escapeString($orderID)." AND couponCodeSeller_Id =".$sellerId;
                 $objResultRow                   = DbHelper::selectSingleValue($tableName,'(couponCodeDiscount +nused_gift_amount) as discount',$selectCase);
         // If user exists then assign user data to result object
                 }
                 //echopre($objResultRow);
                 if($objResultRow!='') {
                      $discount             =   $objResultRow;

                 }


         return $discount;

    }


     public static function checkShippingBlockRequiredForOrder($orderId = '') {
        $objResult = new stdClass();

        $orderTotalPrdCount = 0;
        $orderDigitalCount = 0;
        $orderGiftCount = 0;
        $hide_shipping_division = 0;
        $cartFreeShiptCount = 0;

        //Get Cart Total Count
        $objCart = self::getOrderProductCount($orderId);
        if ($objCart->status == SUCCESS) {
            $cartObjVal = $objCart->data;
            $orderTotalPrdCount = $cartObjVal['product_count'];
        }

        // Get Digital Products Count
        $objDigitalCart = self::getOrderDigitalItemsCount($orderId);
        if ($objDigitalCart->status == SUCCESS) {
            $orderDigitalObjVal = $objDigitalCart->data;
            $orderDigitalCount = $orderDigitalObjVal['digitalcount'];
        }

        //Get Gift Product Count in order
        $objGiftCart = self::getOrderGiftCertificateItemsCount($orderId);
        if ($objGiftCart->status == SUCCESS) {
            $cartGiftObjVal = $objGiftCart->data;
            $orderGiftCount = $cartGiftObjVal['gift_count'];
        }


        // Get Physical Items Count in order

        $objPhysicalCart = self::getOrderPhysicalItemsCount($orderId);
        if ($objPhysicalCart->status == SUCCESS) {
            $orderPhysicalObjVal = $objPhysicalCart->data;
            $orderPhysicalCount = $orderPhysicalObjVal['physicalcount'];
        }


        $orderDigitalAndGiftItemsCount = $orderGiftCount + $orderDigitalCount;

        if ($orderTotalPrdCount > 0) {
            if ((int) $orderTotalPrdCount == ((int) $orderDigitalAndGiftItemsCount)) {
                $hide_shipping_division = 1;
            }
        }

        return $hide_shipping_division;
    }


    public static function getOrderProductCount($orderId='')
    {
        global $tableprefix,$pdo;
    	$objResult                      =   new stdClass();
    	if($orderId!='')    $whereArray = array('order_id'=>$orderId);
    	$resoptions = $pdo->select($tableprefix.'order_details',array('COUNT(order_detail_id) as product_count'),$whereArray)->results();
        if($resoptions[0]){
                $objResult->status      =     SUCCESS;
    		$objResult->data        =    $resoptions[0];
        }
    	else {
    		$objResult->status      =   ERROR;
    	}
    	return $objResult;



    }

     public static function getOrderDigitalItemsCount($orderId='')
    {
         global $pdo,$tableprefix;
    	$objResult                      =   new stdClass();
    	if($orderId!='')  $whereArray = array('order_id'=>$orderId,'digital_product_flag'=>'Y');
        $resoptions = $pdo->select($tableprefix.'order_details',array('COUNT(order_detail_id) as digitalcount'),$whereArray)->results();
    	if($resoptions[0])
        {
            $objResult->status    =    SUCCESS;
            $objResult->data          =    $resoptions[0];
        }
    	else {
            $objResult->status        =   ERROR;
    	}
    	return $objResult;

    }

     public static function getOrderGiftCertificateItemsCount($orderId='')
    {
          global $pdo,$tableprefix;
    	$objResult                      =   new stdClass();
	if($orderId!='') $whereArray = array('order_id'=>$orderId,'gift_product_flag'=>'Y');
        $resoptions = $pdo->select($tableprefix.'order_details',array('COUNT(order_detail_id) as gift_count'),$whereArray)->results();
        if($resoptions[0])
        {
                $objResult->status    =    SUCCESS;
    		$objResult->data      =   $resoptions[0];
        }
    	else {
    		$objResult->status    =   ERROR;
    	}
    	return $objResult;
    }


    public static function getOrderPhysicalItemsCount($orderId='')
    {
        global $tableprefix,$pdo;
    	$objResult  =   new stdClass();
        $QueryPhysicaltems="SELECT count(ord_det.order_detail_id) as physicalcount
                    FROM ".$tableprefix."order_details ord_det
                    INNER JOIN " . $tableprefix . "product_options po ON po.product_option_id = ord_det.product_option_id
                    INNER JOIN ".$tableprefix."products p ON p.product_id = ord_det.product_id    
                    WHERE p.allow_free_shipping!='Y' AND ord_det.gift_product_flag='N'  AND ord_det.digital_product_flag ='N' ";
                    if($orderId!='')
                    {
                      $QueryPhysicaltems.=' AND ord_det.order_id = :orderid';
                    }
        $resoptions = $pdo->pdoQuery($QueryPhysicaltems,array("orderid"=>$orderId))->results();
    	if($resoptions[0])
        {
                $objResult->status    =    SUCCESS;
    		$objResult->data      =    $resoptions[0];
        }
    	else {
    		$objResult->status    =   ERROR;
    	}
    	return $objResult;

    }


    //get Items in order by sellerwise
    public static function getsellerItemsinOrder($orderId='',$sellerid)
    {
    	global $tableprefix,$pdo;
    	$tableName                      =   $tableprefix.'order_details';
    	$andCase                        =   'SELECT * FROM '.$tableName.' WHERE';
    	 if($sellerid!='')
                 $andCase.= ' order_id = '.$orderId.' AND  ';

         if($orderId!='')
                 $andCase.= ' artist_id = '.$sellerid.' ';

         $andCase        = rtrim($andCase,"AND");

    	$objResultRow     = $pdo->pdoQuery($andCase)->results();

    	return $objResultRow;

    }


}
?>