<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class Store {

    //Function to create seller  account
    public static function createsellerAccount($objStoreVo) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
       $dataArray = array('artist_name' => $objStoreVo->artist_name,
            'password' => $objStoreVo->password,
            'first_name' => $objStoreVo->first_name,
            'last_name' => $objStoreVo->last_name,
            'address1' => $objStoreVo->address1,
            'address2' => $objStoreVo->address2,
            'city' => $objStoreVo->city,
            'state' => $objStoreVo->state,
            'country' => $objStoreVo->country,
            'zip' => $objStoreVo->zip,
            'fax' => $objStoreVo->fax,
            'phone' => $objStoreVo->phone,
            'email' => $objStoreVo->email,
            'storename' => $objStoreVo->storename,
            'date_registered' => $objStoreVo->date_registered,
            'vapproved' => $objStoreVo->vapproved,
            'commission' => $objStoreVo->commission,
            'sellerPlanID' => $objStoreVo->sellerPlanID,
            'defaultflatrate' => $objStoreVo->defaultflatrate,
            'additionalflatrate' => $objStoreVo->additionalflatrate,
            'company' => $objStoreVo->company,
            'seller_time_zone' => $objStoreVo->seller_time_zone,
            'paypalemail' => $objStoreVo->paypalemail);
        $stotreId = $pdo->insert($tableprefix . "artists", $dataArray)->lastInsertId();
        if ($stotreId) {
            $objResult->status = SUCCESS;
            $objResult->data = $stotreId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // Get Seller Approval Status
    public static function getSellerApprovalStatus($sellerId) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $objResultRow = $pdo->select($tableprefix . "artists", array("vapproved"), array("artist_id" => $sellerId))->results();

        if ($objResultRow)
            return $objResultRow[0]['vapproved'];
    }

    //check seller paypal email exists in table
    public static function checksellerPaypalemailExists($txtPaypalEmail, $sellerId = '') {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $selectCase = array("paypalemail" => $txtPaypalEmail);
        if ($sellerId != '') {
            $selectCase['artist_id'] = $sellerId;
        }
        $objResultRow = $pdo->select($tableprefix . "artists", array("artist_id"), $selectCase)->results();
        if (!empty($objResultRow)) {
            $objResult->status = SUCCESS;
            $objResult->data = $objResultRow[0]['artist_id']; // Assign user record  to object
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    //Insert Plan detials to table 
    public static function savesellerPlanDetails($objplanVo) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $dataArray = array('artist_id' => $objplanVo->artist_id,
            'artist_memStartDate' => $objplanVo->artist_memStartDate,
            'artist_memEndDate' => $objplanVo->artist_memEndDate,
            'plan_Id' => $objplanVo->plan_Id,
            'plan_SubscriptionCharge' => $objplanVo->plan_SubscriptionCharge);
        $stotrePlanId = $pdo->insert($tableprefix . "artists_membershipDetails", $dataArray)->lastInsertId();
        if ($stotrePlanId) {
            $objResult->status = SUCCESS;
            $objResult->data = $stotrePlanId;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    // send Seller previlge mail to seller 
    public static function sendSellerAccountActivationMail($sellerVo) {
        global $tableprefix, $pdo;
        $objResult = new stdClass();
        $sellerapproval = getSettingsValue('approve_sellers');

        $sellerid = $sellerVo->seller_id;

        if ($enable_seller_friendly == "Y") {
            $friendly_url = SITE_URL . "/store/" . $sellerVo->storename;
        } else {
            $friendly_url = SITE_URL . "/showportfolio.php?artistid=" . $sellerid;
        }

        $approvalContent = '';

        $sellerapprove_id = base64_encode($sellerid);

        if ($sellerapproval == 3) { // check if seller approval is through Email - Activation
            $approvalContent.="<font color='green'><b>" . MSG_CLICK_LINK . "</b></font><br><br>";
            $approvalContent.="<a href=" . SITE_URL . "/sellers_activation.php?aid=$sellerapprove_id&status='Y'>" . MSG_CLICK_HERE . "</a>";
            $info_msg = MSG_SELLER_ACCOUNT_EMAIL_ACTIVATION;
        } // end email activation check)
        if ($sellerapproval == 1) {
            $approvalContent .= MAIL_PLAN_PURCHASE_TEXT_CLICK . "&nbsp;<a href=" . SITE_URL . "/sellers>" . MAIL_PLAN_PURCHASE_TEXT_HERE . "</a> " . MAIL_PLAN_PURCHASE_TEXT_TO_LOGIN;
            $info_msg = MSG_SELLER_ACCOUNT_ACTIVATED;
        }
        if ($sellerapproval == 2) {
            $approvalContent .= "<font color='green'><b>" . MSG_ACC_APPRV_ADMIN . ".</b></font>";
            $info_msg = MSG_SELLER_ACCOUNT_ACTIVATION;
        }

        // echo $info_msg;

        $mailcontent = '<table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:#F5F5F5;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td style="font-weight:bold; color:#CE0221; font-size:14px; padding:15px 15px 5px 15px;" align="left" valign="top">
		' . MAIL_SELLER_ACCOUNT_INFO . '
		</td>
		</tr>
		<tr>
		<td  align="left" valign="top" style="padding:5px 15px 15px 15px; ">
		<table width="100%" cellpadding="5" cellspacing="0" border="0" style="background-color:#FFFFFF; border:#D5D5D5 solid 1px;font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#000000; ">
		<tr>
		<td width="40%">' . MAIL_SELLER_STORE_NAME . '</td>
		<td width="60%" style="font-size:13px; color:#991818; font-weight:bold; ">' . $sellerVo->storename . '&nbsp;&nbsp;( <a href=' . $friendly_url . ' target=_blank> ' . MY_FAVOURITES_SELLER_VIEW_STORE . ' </a> )</td>
		</tr><tr>
		<td width="40%" colspan="2">' . NOTE_USE_SAME_ACCOUNT_LOGIN . '</td>
		</tr>';
        $mailcontent .= '
		<tr>
		<tr>
		<td colspan=2 >' . $approvalContent . ' </td>
		
		</tr>
                <tr>
		<td colspan=2 >&nbsp;</td>

		</tr> 
		<tr>
		</table>
		</td>
		</tr></table>';


        //echo  $mailcontent;

        $mailcontent_seller_approval = readEmailTemplate('seller_previlge_update');
        $mailcontent_seller_approval = str_replace('[account_details]', $mailcontent, $mailcontent_seller_approval);

        $mail_send_details_seller = '<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <title >' . SITE_NAME . '</title>
  <link href="' . SITE_URL . '/style/template1-admin.css" rel="stylesheet" type="text/css">
</head>
<body>
<table width="100%" cellspacing="10" cellpadding="0" bgcolor="#EAEAEA" >
   <tr>
     <td align="center" valign="top">

         <table width="600" border="0" cellpadding="0" cellspacing="0" bordercolor="#EAEAEA" bgcolor="#FFFFFF" class="manage_table">
            <tr>
               <td align="right" >
              </td>
            </tr>
            <tr>
               <td valign="middle" align="left"><table width="100%"  border="0" cellspacing="0" cellpadding="0">
                 <tr>
                   <td bgcolor="#EAEAEA" ><img src=' . SITE_URL . '/banners/' . getSettingsValue('site_logo') . ' width="125" height="60"/></td>
                 </tr>
               </table></td>
            </tr>
			<tr>
			<td align="left" height="50"> ' . MAIL_ORDER_TEXT_DEAR . ' ' . $sellerVo->first_name . '&nbsp;' . $sellerVo->last_name . ', </td>
			<tr>
			<tr>
			<td align="left">' . $info_msg . '</td>
			</tr>

			<tr>
              <td align="center" valign="top"><table width="100%"  border="0" cellspacing="0" cellpadding="10">
                <tr>
                  <td align="left">' . $mailcontent_seller_approval . '</td>
                </tr>

              </table></td>
            </tr>

            <tr>
               <td align="center" bgcolor="#EAEAEA" class="footer">
                  <p>&nbsp;</p>
              </td>
            </tr>
       </table>

     </td>
   </tr>
</table>
</body>
</html>';

        //echo $mail_send_details_seller;

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
        $headers .= "From: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Reply-To: " . SITE_NAME . "<" . SITE_EMAIL . ">" . "\r\n";
        $headers .= "Return-Path: " . SITE_NAME . "<noreply@" . SITE_NAME . ">" . "\r\n";
        $headers .= "Organization: " . SITE_NAME . "\r\n";
        $sellermail_flag = MAIL_SELLER_ACTIVATION_SUBJECT . " --" . SITE_NAME;
        //$sellerVo->email = 'armiatester@gmail.com';
        $mailsent = mail($sellerVo->email, $sellermail_flag, $mail_send_details_seller, $headers);
    }

    // Get Seller account details
    public static function get_seller_account_info($sellerid) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        if (!empty($sellerid)) {
            $objResultRow = $pdo->select($tableprefix . 'artists', '', array('artist_id' => $sellerid))->result();
            if ($objResultRow) {
                $objResult->status = SUCCESS;
                $objResult->data = (object)($objResultRow); // Assign user record  to object
            } else {
                $objResult->status = ERROR;
            }
        }
        return $objResult;
    }

    // Get Seller account details
    public static function get_buyer_account_info($sellerid) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        if (!empty($sellerid)) {
            $objResultRow = $pdo->select($tableprefix . "users", array("user_id"), array("seller_id" => $sellerid))->result();
            if ($objResultRow) {
                $objResult->status = SUCCESS;
                $objResult->data = $objResultRow['user_id']; // Assign user record  to object
            } else {
                $objResult->status = ERROR;
            }
        }
        return $objResult;
    }

    // Update seller profile information if single account activated for buyer and seller 

    public static function updateSellerProfileInformation($userObjVo) {
        global $tableprefix, $pdo;
        $aWhere = array('artist_id' => $userObjVo->seller_id);
        $sellerId = $pdo->update($tableprefix . 'artists', array('first_name' => $userObjVo->first_name, 'last_name' => $userObjVo->last_name, 'address1' => $userObjVo->address1, 'address2' => $userObjVo->address2, 'city' => $userObjVo->city, 'state' => $userObjVo->state, 'country' => $userObjVo->country, 'zip' => $userObjVo->zip,
                    'email' => $userObjVo->email, 'phone' => $userObjVo->phone, 'fax' => $userObjVo->fax), $aWhere)->affectedRows();
        $objResult = new stdClass();
        if ($sellerId) {
            $objResult->status = SUCCESS;
            $objResult->data = $sellerId;
        } else {
            $objResult->status = ERROR;
        }
        return $objResult;
    }

    // Update seller password 


    public static function updateSellerPassword($userObjVo) {
        global $pdo;
        global $tableprefix;
        $objResult = new stdClass();
        $aWhere = array('artist_id' => $userObjVo->seller_id);
        $q = $pdo->update($tableprefix . 'artists', array('password' => $userObjVo->password), $aWhere)->affectedRows();
        if ($q) {
            $objResult->status = SUCCESS;
            $objResult->data = $q;
        } else {
            $objResult->status = ERROR;
        }

        return $objResult;
    }

    //Check flat rate settings already available

    public static function get_seller_flat_rate_exists($objVo) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        if (!empty($objVo)) {
            $objResultRow = $pdo->select($tableprefix . "flat_rate_seller", array("flat_rate_seller_id"), array("flat_rate_name" => $objVo->flat_rate_name, "seller_id" => $objVo->seller_id))->iAffectedRows;
            return $objResultRow;
        }
    }

    public static function get_flat_rate_exists($objVo) {
        global $pdo, $tableprefix;
        $objResult = new stdClass();
        if (!empty($objVo)) {
            $objResultRow = $pdo->select($tableprefix . "flat_rate_default", array("flat_rate_default_id"), array("flat_rate_name" => $objVo->flat_rate_name))->iAffectedRows;
            return $objResultRow;
        }
    }

}

?>
