<?php 

/*
 * All User Entity Logics should come here.
 */
class Affiliates extends BaseController{
 
	
	/*
	 * function to insert a new user
	 */
	public static function addAffiliate($arrAffiliate, $password_salt) {
		$activationkey = Utils::generateResetPasswordActivationKey();
		$arrAffiliate['aff_activation_key'] = $activationkey;
		$db	    	= new Db();
	 	$userId 	= $db->addFields("affiliates",$arrAffiliate);
		//print_r($arrAffiliate);die('here');
                
		$activateAccountLink = "Click <a href='".BASE_URL."affiliates/activation/".$activationkey."'> Here</a> to Activate your account<br/>Username: ".$arrAffiliate['aff_email']."<br/>Password: ".$password_salt;
        $replaceParameters =  array( 	"email"        => $arrAffiliate['aff_email'], 
                                        "activationLink" => $activateAccountLink );

		// send mail to user for activation
		 if(ENVIRONMENT!='LOCAL')
        	Utils::sendUserMail($arrAffiliate['aff_email'], 'affiliateregister', $replaceParameters);
		
		return $userId;
	}
	
	
	/*
	 * function to check an email exist or not
	 */
	public static function checkAffEmailExist($email)
	{
		$db	    	= new Db();
      	$affEmail 	= $db->checkExists("affiliates","aff_email","aff_email='".$email."'");
      	return $affEmail;
	}
	
	
	
	
	/*
	 * function to activate a user
	 */
	public static function handleUserActivation($activationKey)
	{	
        if(!empty($activationKey)){
            $model 	= new Db();
            $status = $model->checkExists("affiliates", "aff_id", " aff_activation_key='".$activationKey."'");
        }
        if(!empty($activationKey) && $status){ 
            $updateArray = array(	"aff_activation_key"=> "",
                    				"aff_status"		=> 1 );
           $updationStatus = $model->updateFields("affiliates",$updateArray," aff_activation_key='".$activationKey."'");
            if($updationStatus)  
                $message =  1;
            else 
                $message 	=  AFFILIATE_ACTIVATION_ERROR_MESSAGE;
        }else 
             $message 		=  AFFILIATE_INVALID_ACTIVATION_REQUEST;

        return $message;
	}
	
	
	/*
	 * function to check login
	 */
	public static function checkLogin($username,$password)
	{
		$validationStatus = TRUE;
		if(empty($username) && empty($password)){
             $message = AFFILIATE_LOGIN_USERNAME_AND_PASSWORD_MISSING;
             $validationStatus = FALSE;
        }else if(empty($username)){
             $message = AFFILIATE_LOGIN_USERNAME_MISSING;
             $validationStatus = FALSE;
        }else if(empty($password)){
             $message = AFFILIATE_LOGIN_PASSWORD_MISSING;
             $validationStatus = FALSE;
        }
        
        
        
         if($validationStatus){
            $model = new Db;
            $userdetails = $model->selectRecord("affiliates","*"," aff_email='".$username."' AND aff_pwd='".md5($password)."' ");
            if(empty($userdetails)){
                $status = FALSE;
                $message = AFFILIATE_INVALID_LOGIN_MSG;
            }else{
            	// check user is in pending state
            	if($userdetails->aff_status == '' || $userdetails->aff_status == 0) {	
            		$message 	= AFFILIATE_PENDING_STATUS_MESSAGE;
            		$status 	= FALSE;
            	}
             
                $session 	= new LibSession();
                $session->set('affiliateuser',json_encode($userdetails));
                $values 	= json_decode($session->get('users'));        
                $status 	= TRUE;
            }
        }else
            $status = FALSE;

            
        $loginRes = array('msg'=>$message,'status' =>$status);
        return $loginRes;
  
        
	}
	
	/*
	 * function to check the user logined or not. if not logined user will redirct to login page
	 */
	public static function checkLoginUser()
	{
		//TODO: modify the header into this->redirect
		$session = new LibSession();
		$userInfo = json_decode($session->get('affiliateuser'));
		if($userInfo->aff_id == '')
			 header("Location:".ConfigUrl::base().'index');
		else 
			return $userInfo->aff_id;
	}
	
	
	
	/*
	 * public function to get the affiliate links
	 */
	
	public static function getAffiliateLinks($type='')
	{
		$model 			= new Db;     
		if($type != '')
			$where = ' AND link_type='. $type;
				
        $linkDetails 	= $model->selectResult("affiliates_links AS L LEFT JOIN ".MYSQL_TABLE_PREFIX."files AS F ON L.link_image=F.file_id","L.*,F.file_path"," L.link_status=1".$where);
		return $linkDetails;
	}
	
	/*
	 * function to get the registrations happens through affiliate
	 */
	
	public static function getUserActions($actiontype ='',$aff_id='')
	{
		$model 			= new Db;   
		if($actiontype != '')
			$where = ' AND UA.ua_actiontype='. $actiontype;
                if($aff_id != '')
			$where .= ' AND UA.ua_aff_id="'. $aff_id.'"';

        $actionDetails 	= $model->selectResult("affiliate_useraction AS UA LEFT JOIN ".MYSQL_TABLE_PREFIX."customers AS C ON UA.ua_userid = C.nCust_Id","UA.*,C.vFirstname,C.vLastname,C.vEmail,C.vLogin"," UA.ua_displaystatus=1".$where);
		return $actionDetails;
	}
	
	
	
	/*
	 * function to get the affiliate details
	 */
	public static function getAffiliateDetails($affid,$fields='*')
	{
		if($affid != '') {
			$model 		= new Db;
			$affInfo 	= $model->selectRecord("affiliates",$fields," aff_id=".$affid);
			return $affInfo;
		} 
	}
	
	
	/*
	 *  update affiliate details
	 */
	public static function updateAffiliate($userinfo,$affiliateUserid)
	{
		if(  $userinfo['aff_fname'] !=''  && $userinfo['aff_country'] != '' && $userinfo['aff_state'] != '' && $affiliateUserid != '' ){
			$db	    	= new Db();
	 		$userId 	= $db->updateFields("affiliates",$userinfo,'aff_id='.$affiliateUserid);
			$message 	= AFFILIATE_MSG_UPDATE_SUCCESS;	
		}
		else 
			$message 	= AFFILIATE_MSG_ALL_DETAILS;
		return $message;
	}
	
	
	
	/*
	 *  affiliate change password
	 */
	public static function changePassword($userinfo,$affiliateUserid)
	{
		 
		if($userinfo['txtPwd'] != '' && $userinfo['txtPwd1'] !='' && $userinfo['txtPwdOld'] != '') {
			if($userinfo['txtPwd'] == $userinfo['txtPwd1'])	{
				$db	    	= new Db();
				// check the old password
				$affPwd 	= $db->checkExists("affiliates","aff_id","aff_id='".$affiliateUserid."' AND aff_pwd ='".md5($userinfo['txtPwdOld'])."'");
				if($affPwd)	{
					$pwdUpdateStatus 	= $db->updateFields("affiliates",array('aff_pwd'=>md5($userinfo['txtPwd'])),'aff_id='.$affiliateUserid);
					$message 	= AFFILIATE_MSG_PWD_UPDATE_SUCCESS;
				}
				else 
					$message 	= AFFILIATE_MSG_INVALID_OLD_PWD;
			}
			else 
				$message 		= AFFILIATE_MSG_INVALID_PWD;
			
		}
		else 
			$message 	= AFFILIATE_MSG_ALL_DETAILS;
			
		return $message;
	}
	
	
	/*
	 * function to reset the user password
	 */
	public static function resetPassword($useremail)
	{
		if($useremail != '')
		{
			$stat = self::checkAffEmailExist($useremail);
			if($stat)
			{
				$userid 	=  self::getAffIdFromEmail($useremail);
				if($userid != '')
				{
					$activationkey = Utils::generateResetPasswordActivationKey();
					$db	    	= new Db();
					// update the user row
					$pwdUpdate 	= $db->updateFields("affiliates",array('aff_pwd'=>'','aff_activation_key'=>$activationkey,'aff_status'=>'2'),'aff_id='.$userid);
				
					// send mail with reset pwd link
					$resetPwdLink = "Click <a href='".BASE_URL."affiliates/resetpassword/".$activationkey."'> Here</a> to reset your password";
        			$replaceParameters =  array( 	"email"        => $useremail, 
                                        "passwordLink" => $resetPwdLink );

					// send mail to user for activation
		 			//if(ENVIRONMENT!='LOCAL')
        				Utils::sendUserMail($useremail, 'affiliate_pwdrequest', $replaceParameters);
				
					$message = AFFILIATE_RESETPWD_EMAIL_SEND;
				}
			}
			else
				$message = '<label class="error">'.AFFILIATE_RESETPWD_EMAIL_NOT_EXIST.'</label>';
			return $message;
		}
		
	}
	
	/*
	 * function to get the userid from affiliate email
	 */
	public static function getAffIdFromEmail($email)
	{
		if($email != '')
		{
			$model 		= new Db;
			$affInfo 	= $model->selectRecord("affiliates",'aff_id'," aff_email='".$email."'");
			return $affInfo->aff_id;
		}
	}
	
	
	public static function checkPwdResetKey($resetKey)
	{
		if($resetKey != '')
		{
			$model 		= new Db;
			$affInfo 	= $model->selectRecord("affiliates",'*'," aff_activation_key='".$resetKey."'");
			return $affInfo;
		}
	}
	
	
	
	public static function setResetPassword($userinfo)
	{
		
		 $userInfo = self::checkPwdResetKey($userinfo['activationkey']);	// check the reset key
    		if(sizeof($userInfo) > 0)		{
				if($userinfo['pwd'] == $userinfo['pwd1'])
				{
					$userinfo = array('aff_pwd'=>md5($userinfo['pwd']),
										'aff_activation_key' => '',
										'aff_status' => 1);
					$db	    	= new Db();
					$pwdUpdateStatus 	= $db->updateFields("affiliates",$userinfo,'aff_id='.$userInfo->aff_id);
					$message 		= AFFILIATE_MSG_PWD_UPDATE_SUCCESS;
					$status = 1;
				}
				else 
				$message 		= AFFILIATE_MSG_INVALID_PWD;
    			  
    		}
    		else 
    			$message = "Some error occured.Please try again later";
    		 
    		$result = array('message'=>$message,'status'=>$status);
		return $result;
	}
	
	
	
	/*
	 *  function to get the session info of the user
	 */
	public static function getAffiliateSessionInfo()
	{
		$session 	= new LibSession();
		$userInfo 	= json_decode($session->get('affiliateuser'));
		return $userInfo;
	}
	
	
	/*
	 * function to create cookie of the affiliate
	 */
	public static function setAffiliateCookie($affid)
	{
		$cookie	= new LibCookie();
		$cookie->setcookie('reservelogic_affid', trim($affid));
	}
	
	
	
	/*
	 * function to check the cookie exist or not
	 */
	public static function getAffiliateCookie()
	{
		$cookie	= new LibCookie();
        $affid 	= trim($cookie->get('reservelogic_affid'));
        return $affid;
	}
	
	
}


?>