<?php
/*
 * All user entity logics related to locations are coming here.....
*/

class Customer
{

 function __construct()
 {

 }

 public static function doLogin($post)
 {

         $username                   = trim($post['txtUserName']);
         $password                   = trim($post['txtPassword']);
         $rememberMe                 = trim($post['login_remember_me']);

         $validationStatus           = TRUE;

        if(empty($username) && empty($password))
        {
             PageContext::$response->error_message = CUSTOMER_LOGIN_USERNAME_AND_PASSWORD_MISSING;
             $validationStatus       = FALSE;
        }
        else if(empty($username))
        {
             PageContext::$response->error_message = CUSTOMER_LOGIN_USERNAME_MISSING;
             $validationStatus       = FALSE;
        }
        else if(empty($password))
        {
             PageContext::$response->error_message = CUSTOMER_LOGIN_PASSWORD_MISSING;
             $validationStatus       = FALSE;
        }


         

        if($validationStatus)
        {
            
            $model = new ModelCommon;
            $customerDetails = $model->selectRecord("customers","*"," ( `vLogin` = '".mysql_real_escape_string($username)."' OR `vEmail` = '".mysql_real_escape_string($username)."' ) AND `vPassword` = '".$password."'");


            //and `vActive` = 'active'

            
            if(empty($customerDetails))
            {               
                $status = 404;
                 //print 404;
               // print INVALID_USER_LOGIN_MSG;
            }
            else if($customerDetails->vActive != 'active')
            { 
                $status = 403;
                //print 403;
               // print INACTIVE_USER_LOGIN_MSG;
            }

            else
            { 
                
                self::createRememberMeCookie($rememberMe,$username,$password);

                $customer     = new Customerobject();
                $customer->id = $customerDetails->id;

                foreach($customerDetails as $key => $value)
                {
                    $customer->$key = $value;
                }               

                $objSession = new LibSession();

                $objSession->set('customer',serialize($customer));
                $objSession->set('customer',json_encode($customer));
                $values = json_decode($objSession->get('customer'));
                $status = TRUE;

            }

        }
        else
            $status = FALSE;


         

        return $status;


}

    public static function doLoginForCms($post)
    {

         $username                   = trim($post['txtUserName']);
         $password                   = trim($post['txtPassword']);
         $rememberMe                 = trim($post['login_remember_me']);

         $validationStatus           = TRUE;

        if($validationStatus)
        {
            
            $model = new ModelCommon;
            $customerDetails = $model->selectRecord("customers","*"," ( `vLogin` = '".mysql_real_escape_string($username)."' OR `vEmail` = '".mysql_real_escape_string($username)."' ) AND `vPassword` = '".$password."' ");

            if(empty($customerDetails))
            {               
                $status = FALSE;  
                Logger::info(INVALID_USER_LOGIN_MSG);
            }
            else
            {
                  
                $customer = new Customerobject();
                $customer->id=$customerDetails->id;

                foreach($customerDetails as $key => $value)
                {
                    $customer->$key = $value;
                }               

                $objSession = new LibSession();

                $objSession->set('customer',serialize($customer));
                $objSession->set('customer',json_encode($customer));
                $values = json_decode($objSession->get('customer'));
                $status = TRUE;

            }

        }
        else
            $status = FALSE;

        return $status;


    }
    
    //Creates login related remember me cookie
    private static function createRememberMeCookie($value,$username,$password){


         $objCookie = new LibCookie();

         if(isset($value) && $value == '1')
         {
            $objCookie->setcookie('reservelogic_customer_name', trim($username));
            $objCookie->setcookie('reservelogic_customer_password', trim($password));
         }
         else
         {
             $objCookie->delete('reservelogic_customer_name');
             $objCookie->delete('reservelogic_customer_password');
         }

    }

    //Checks and retrieves the value of remmebr me cookie
    public static function checkRememberMeCookie($view)
    {
        $objCookie      = new LibCookie();
        $view->username = trim($objCookie->get('reservelogic_customer_name'));
        $view->password = trim($objCookie->get('reservelogic_customer_password'));

        return ;
    }


    public static function customerLoginCheck()
    {
        $objSession = new LibSession();
        Logger::info(unserialize($objSession->get('customer')));
        return $objSession->get('customer')? TRUE : FALSE;
    }


    public static function generateActivationLink($emailAddress)
    {

        $table                 = 'customers';
        $db                    = new Db();

        $tempQuery             =  "
                                   SELECT `nCust_Id`,`activation_key` 
                                   FROM `".MYSQL_TABLE_PREFIX."customers`
                                   WHERE `vEmail` ='".mysql_real_escape_string($emailAddress)."' LIMIT 1
                                  ";

        $customerDetails       = $db->selectQuery($tempQuery);

        $customerDetails       = $customerDetails[0];
        
        
        if($customerDetails->nCust_Id>0)
        {


           if(trim($customerDetails->activation_key)=='')
           {

              $activationkey = Utils::generateResetPasswordActivationKey();
              $db->update(MYSQL_TABLE_PREFIX.$table, array('activation_key'=>$activationkey),'nCust_Id="'.mysql_real_escape_string($customerDetails->nCust_Id).'" and vActive="active"');

           }
           else
           {
               $activationkey = $customerDetails->activation_key;
           }


           $resetPasswordLink = "Click <a href='".BASE_URL."resetpassword/".$activationkey."'> Here</a> to Reset your password";

           $replaceParameters =  array(
                                         "email"        => trim($emailAddress),
                                         "loginLink"    => BASE_URL.'',
                                         "passwordLink" => $resetPasswordLink
                                       );
            if(ENVIRONMENT!='LOCAL')
            Utils::sendUserMail($emailAddress, 'PasswordRecovery', $replaceParameters);

            print 1;
            
        }
        else
        {
            print 0;
        }


    }



    //Reset password functionality using the activation link
    public static function isValidActivationLink($activationKey)
    {


        $table                 = 'customers';
        $db                    = new Db();
         


        $activationKey    = trim($activationKey);

        if($activationKey!='')
        {

            $tempQuery            = "
                                      SELECT `nCust_Id`,`activation_key`,`vActive`
                                      FROM `".MYSQL_TABLE_PREFIX."customers`
                                      WHERE `activation_key` ='".mysql_real_escape_string($activationKey)."'
                                    ";

            $customerDetails      = $db->selectQuery($tempQuery);
            $customerDetails      = $customerDetails[0];

         }



        if($customerDetails->nCust_Id>0)
        {
            return true;
        }
        else
        {
            return false;
        }


    }




    //Reset password functionality using the activation link 
    public static function handleResetPassword($password,$activationKey)
    {

        $table                 = 'customers';
        $db                    = new Db();
        $success               = 0;


        $activationKey    = trim($activationKey);

        if($activationKey!='')
        {
            
            $tempQuery            = "
                                      SELECT `nCust_Id`,`activation_key`,`vActive`
                                      FROM `".MYSQL_TABLE_PREFIX."customers` 
                                      WHERE `activation_key` ='".mysql_real_escape_string($activationKey)."' 
                                    ";

            $customerDetails      = $db->selectQuery($tempQuery);
            $customerDetails      = $customerDetails[0];

         }



        if($activationKey!='' && $customerDetails->nCust_Id>0 && $customerDetails->vActive=='active')
        {                 

                    $updateArray['vPassword']                        = md5($password);
                    $updateArray["activation_key"]                  = '';
                    $updationStatus                                 = $db->updateFields("customers",$updateArray,"activation_key='".$activationKey."'");

                    if($updationStatus)
                    {
                        $message             = RESET_PASSWORD_SUCCESS_MESSAGE;
                        $success             = 1;
                    }
                    else
                    {
                        $message             = RESET_PASSWORD_ERROR_MESSAGE;
                    }                 


      }
      else if($customerDetails->nCust_Id>0 && $customerDetails->vActive=='active')
      {
          $message             = RESET_PASSWORDS_INACTIVE_ACCOUNT;
      }
      else if($customerDetails->nCust_Id=='')
      {
          $message             = RESET_PASSWORDS_INVALID_ACTIVATION_LINK;
      }
      else
      {
            $message = INVALID_RESET_PASSWORD_REQUEST;
      }


      return $success.'_'.$message;
       
    }


    public static function getCustomerDetailsByEmail($email)
    {


        $db                    = new Db();

        

        $tempQuery             = "
                                   SELECT *
                                   FROM `".MYSQL_TABLE_PREFIX."customers`
                                   WHERE `vEmail` ='".mysql_real_escape_string($email)."'                                       
                                 ";

        $customerDetails      = $db->selectQuery($tempQuery);

        return $customerDetails;

       
    }

    public static function getCustomerDetails($customerId)
    {


        $db                    = new Db();

        $customerId            = (int) $customerId;

        $tempQuery             = "
                                   SELECT *
                                   FROM `".MYSQL_TABLE_PREFIX."customers`
                                   WHERE `nCust_Id` ='".mysql_real_escape_string($customerId)."'                                       
                                 ";

        $customerDetails      = $db->selectQuery($tempQuery);

        return $customerDetails;

       
    }



    public static function updateCustomerDetails($postedArray,$customerId)
    {
        $table                 = 'customers';
        $db                    = new Db();
        
        $db->update(MYSQL_TABLE_PREFIX.$table, $postedArray,'nCust_Id="'.mysql_real_escape_string($customerId).'"');
    }

     

    public static function verifyOldPassword($oldPassword)
    {
        $table                 = 'customers';
        $db                    = new Db();       
        
        return $db->checkExists($table,'nCust_Id','vPassword="'.md5($oldPassword).'"');
    }
    
    
    public static function checkEmailExits($emailAddress,$customerId = '')
    {
        $table                 = 'customers';
        $db                    = new Db();


        if($customerId > 0)
        $andCase               = ' AND nCust_Id !="'.$customerId.'"';
        
        return $db->checkExists($table,'nCust_Id','vEmail = "'.mysql_real_escape_string($emailAddress).'" '.$andCase );
    }





    public static function getCustomerOrders($customerId ,$payment_id = NULL)
    {

        $db                    = new Db();
        if($payment_id == NULL)
        {$tempQuery = "
                       SELECT *,DATE_FORMAT(dArrival_Date,'%m/%d/%Y') as Arrival_Date,DATE_FORMAT(dBooking_Date,'%m/%d/%Y') as dBooking_Date ,B.vStatus as bookingstatus,B.nAmount as paidAmt, DATE_FORMAT(DATE_ADD(dArrival_Date, INTERVAL nNights_Stay DAY),'%m/%d/%Y') as checkout_Date,BK.reference_no ,
                       B.nChildren as children,B.nAdults as adult, B.nRooms as room
                       FROM " . MYSQL_TABLE_PREFIX . "booking B
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "payment P ON P.nBooking_id = B.nBooking_id
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "allotment A ON A.nBooking_id = B.nBooking_id
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "available_acco_type AAT ON AAT.nAat_id = A.nAat_id
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "accomodation_types AT ON AT.nAt_id = AAT.nAt_id
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "locations L ON L.nLocation_Id = AAT.nLocation_Id
                       LEFT JOIN  ".  MYSQL_TABLE_PREFIX . "bank_details BK ON P.nPayment_Id = BK.paymentId
		       WHERE B.nCust_Id = '" . mysql_real_escape_string($customerId) . "' AND AT.vActive='active' GROUP BY B.nBooking_Id ORDER BY A.nBooking_id DESC
                     ";
        }

    else {
       
        $tempQuery = "
                       SELECT *,DATE_FORMAT(dArrival_Date,'%m/%d/%Y') as Arrival_Date,DATE_FORMAT(dBooking_Date,'%m/%d/%Y') as dBooking_Date ,B.vStatus as bookingstatus,B.nAmount as paidAmt, DATE_FORMAT(DATE_ADD(dArrival_Date, INTERVAL nNights_Stay DAY),'%m/%d/%Y') as checkout_Date,BK.reference_no,
                       B.nChildren as children,B.nAdults as adult, B.nRooms as room
                       FROM " . MYSQL_TABLE_PREFIX . "booking B
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "payment P ON P.nBooking_id = B.nBooking_id
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "allotment A ON A.nBooking_id = B.nBooking_id
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "available_acco_type AAT ON AAT.nAat_id = A.nAat_id
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "accomodation_types AT ON AT.nAt_id = AAT.nAt_id
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "locations L ON L.nLocation_Id = AAT.nLocation_Id
                       LEFT JOIN  ".  MYSQL_TABLE_PREFIX . "bank_details BK ON P.nPayment_Id = BK.paymentId
		       WHERE B.nCust_Id = '" . mysql_real_escape_string($customerId) . "' AND P.nPayment_Id = '" .$payment_id."' AND AT.vActive='active' GROUP BY B.nBooking_Id ORDER BY A.nBooking_id DESC
                     ";
    }

        $customerOrderDetails      = $db->selectQuery($tempQuery);

        return $customerOrderDetails;

    }


    public static function getCustomerExpediaOrders($customerId)
    {

        $db                    = new Db();
        $tempQuery = "
                       SELECT *,DATE_FORMAT(dArrival_Date,'%m/%d/%Y') as Arrival_Date,DATE_FORMAT(dBooking_Date,'%m/%d/%Y') as dBooking_Date ,B.vStatus as bookingstatus,B.nAmount as paidAmt, DATE_FORMAT(DATE_ADD(dArrival_Date, INTERVAL nNights_Stay DAY),'%m/%d/%Y') as checkout_Date,EX.location_name ,EX.destination_name ,EX.accomadation_name 
                       FROM " . MYSQL_TABLE_PREFIX . "booking B
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "payment P ON P.nBooking_id = B.nBooking_id
		       INNER JOIN " . MYSQL_TABLE_PREFIX . "allotment A ON A.nBooking_id = B.nBooking_id
                       INNER JOIN ".MYSQL_TABLE_PREFIX."expedia_location_details EX ON EX.booking_id = B.nBooking_Id 
		       WHERE B.nCust_Id = '" . mysql_real_escape_string($customerId) . "' AND B.api_flag='Y' GROUP BY B.nBooking_Id
                     ";

        $customerOrderDetails      = $db->selectQuery($tempQuery);

        return $customerOrderDetails;

    }




    public static function hasRated($entityId,$type,$customerId)
    {

        $db                 = new Db();

       $entityId            = (int) $entityId;
       $customerId          = (int) $customerId;

       $whereCaseString     = ($type=='location') ? ' nLocation_Id="'.mysql_real_escape_string($entityId).'" ' : ' nDestination_Id="'.mysql_real_escape_string($entityId).'" '  ;

       $tempQuery           = " SELECT vRate_Status FROM `".MYSQL_TABLE_PREFIX."rating`
		                WHERE ".$whereCaseString." AND nCust_Id='".mysql_real_escape_string($customerId)."'";


       $tempReviews         = $db->selectQuery($tempQuery);
       $tempReviews         = $tempReviews[0];

       return $tempReviews;

    }



    public static function addCustomer($postedArray,$doLogin=true)
    {
         
        $db                             = new Db();
        $table                          = 'customers';
        $dataArray                      = array();

        $password                       = Utils::generateRandomAlphanumeric();

        if(trim($postedArray['txtFirstName']) == '')
        {
            $username                   = Utils::genRandomString(10);
        }
        else
        {
            $username                   = Utils::genRandomString(5);
            $firstNamePart              = substr(trim($postedArray['txtFirstName']), 0,10);
            $username                   = $firstNamePart . $username;
        }        

        $dataArray['vLogin']            = mysql_real_escape_string($username);
        $dataArray['vPassword']         = md5($password);

        $dataArray['vFirstname']        = mysql_real_escape_string($postedArray['txtFirstName']);
        $dataArray['vLastname']         = mysql_real_escape_string($postedArray['txtLastName']);
        $dataArray['vEmail']            = mysql_real_escape_string($postedArray['txtEmail']);
        $dataArray['vAddress1']         = mysql_real_escape_string($postedArray['txtAddress1']);
        $dataArray['vAddress2']         = mysql_real_escape_string($postedArray['txtAddress2']);
        $dataArray['vCity']             = mysql_real_escape_string($postedArray['txtCity']);
        $dataArray['vState']            = mysql_real_escape_string($postedArray['txtState']);
        $dataArray['vCountry']          = mysql_real_escape_string($postedArray['txtCountry']);
        $dataArray['vZip']              = mysql_real_escape_string($postedArray['txtZip']);
        $dataArray['vMobile']           = mysql_real_escape_string($postedArray['mobile']);
        $dataArray['vTelephone']        = mysql_real_escape_string($postedArray['telephone']);
        $dataArray['vFax']              = mysql_real_escape_string($postedArray['txtFax']);
        $dataArray['dDatejoin']         = date('Y-m-d');
        $dataArray['vActive']           = 'active';


        $customerId = $db->insert(MYSQL_TABLE_PREFIX.$table, $dataArray);
        
        
        
        $credentialArray['txtUserName']        = $dataArray['vLogin'];
        $credentialArray['txtPassword']        = md5($password);
        $credentialArray['login_remember_me']  = false;
          

        if($doLogin)        
          Customer::doLogin($credentialArray);
        

         Customer::sendLoginInfoForFreshUser($postedArray['txtEmail'],$username,$password);
         return $customerId;

        


    }


    public static function updateCustomerRegisterTime($customerId)
    {
        $db                             = new Db();
        $table                          = 'customers';
        $dataArray                      = array();
         

        $dataArray['dDatejoin']         = date('Y-m-d');
        
        $db->update(MYSQL_TABLE_PREFIX.$table, $dataArray,'nCust_Id="'.mysql_real_escape_string($customerId).'"');

        
    }


    public static function updateCustomerProfile($customerId,$postedArray)
    {


        

        $db                             = new Db();
        $table                          = 'customers';
        $dataArray                      = array();



        


        $dataArray['vFirstname']        = $postedArray['txtFirstName'];
        $dataArray['vLastname']         = $postedArray['txtLastName'];
        $dataArray['vEmail']            = $postedArray['txtEmail'];
        $dataArray['vAddress1']         = $postedArray['txtAddress1'];
        $dataArray['vAddress2']         = $postedArray['txtAddress2'];
        $dataArray['vCity']             = $postedArray['txtCity'];
        $dataArray['vState']            = $postedArray['txtState'];
        $dataArray['vCountry']          = $postedArray['txtCountry'];
        $dataArray['vZip']              = $postedArray['txtZip'];
        $dataArray['vMobile']           = $postedArray['mobile'];
        $dataArray['vTelephone']        = $postedArray['telephone'];
        $dataArray['vFax']              = $postedArray['txtFax'];



        


        


        $db->update(MYSQL_TABLE_PREFIX.$table, $dataArray,'nCust_Id="'.mysql_real_escape_string($customerId).'"');


    }


    public static function sendLoginInfoForFreshUser($emailAddress,$username,$password)
    {
        $db                              = new Db();
        $replaceParameters               = array();


        

        $replaceParameters['name']      .= 'User';


        $replaceParameters['mailBody']  .= '<table border="0">';
        $replaceParameters['mailBody']  .= '<tr><th colspan="2" align="left"></th></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>Username:</td><td>'.$emailAddress.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>Password:</td><td>'.$password.'</td></tr>';
        $replaceParameters['mailBody']  .= '</table>';

        
          if(ENVIRONMENT!='LOCAL')
          Utils::sendUserMail($emailAddress, 'LoginInfo', $replaceParameters);
    }


    // Function to save contact us details
    public static function addContactUs($postedArray){ 

        $db                             = new Db();
        $table                          = 'feedbacks';
        $dataArray                      = array();

        $dataArray['vName']        = $postedArray['txtName'];
        $dataArray['vPhone']       = $postedArray['txtPhone'];
        $dataArray['vEmail']       = $postedArray['txtEmail'];
        $dataArray['vAddress']     = $postedArray['txtareaAddress'];
        $dataArray['vDestination'] = $postedArray['cmbContactDestination'];
        $dataArray['tComments']    = $postedArray['txtareaMessage'];
        $dataArray['dPasted_Date'] = date('Y-m-d');
        
        $contactId = $db->insert(MYSQL_TABLE_PREFIX.$table, $dataArray);
        return $contactId;
    }




}

class Customerobject
{
    public $id;
    public $username;
    public $first_name;
    public $last_name;
    public $email;
    public $phone;
    public $password;
    public $fb_login;

}