<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class Home{

    //Function to load banner images
    public static function loadBannerImages(){

        
        $dbh         = new Db();
        $bannerUrls  = array();
        $bannerArray = array();
        $bannerArray = $dbh->selectResult("Banners", "file_id,vlocUrl", " file_id<>0 AND vLocation ='Home' AND vActive='1'");


        

        if(count($bannerArray) > 0)
        {

        foreach($bannerArray as $file)
        {  
               if(file_exists(FILE_UPLOAD_DIR.'/'.Apputils::fetchFileName($file->file_id)))
               {
                  $bannerIds      .= Apputils::fetchFileName($file->file_id) .", ";

                  if(trim($bannerIds) != '')
                  $bannerUrls[]    = $file->vlocUrl ;

               }
        }

        }
        else
        {
                  $bannerNames = FALSE;
        }

        if($bannerIds)
            $bannerNames = substr( $bannerIds,0,strlen($bannerIds)-2);
        else
            $bannerNames = FALSE;


        
        
        return array($bannerNames,$bannerUrls);
        
        

        
    }

    //Function to fetch featured destinations
    public static function fetchFeaturedDestinations($noLimit)
    {
    	 
        $dbh          = new Db();
        $deafultLimit = 3;
/*
        $query = " SELECT D.nDestination_Id,D.vDestination_Name,D.tDestination_Description,D.file_id,count(DISTINCT L.nLocation_Id) AS locationCount
                   FROM ".$dbh->tablePrefix."destination  D
                   LEFT JOIN ".$dbh->tablePrefix."locations L ON (D.nDestination_Id = L.nDestination_Id)
                   INNER JOIN  ".$dbh->tablePrefix."available_acco_type AAT ON (AAT.nLocation_Id = L.nLocation_Id) WHERE D.vStatus='active' AND L.vActive ='active' GROUP BY D.nDestination_Id  ";

*/
         $query = " SELECT D.destination_alias,D.nDestination_Id,D.vDestination_Name,D.tDestination_Description,D.file_id,count(DISTINCT L.nLocation_Id) AS locationCount
                   FROM ".$dbh->tablePrefix."destination  D
                   LEFT JOIN ".$dbh->tablePrefix."locations L ON (D.nDestination_Id = L.nDestination_Id)
                   LEFT JOIN  ".$dbh->tablePrefix."available_acco_type AAT ON (AAT.nLocation_Id = L.nLocation_Id)
                   WHERE D.vStatus='active' GROUP BY D.nDestination_Id  ";   


        if($noLimit)
            $query .= " ORDER BY RAND() LIMIT ".$deafultLimit;
        
        $featuredDestinationsResult = $dbh->execute($query);
        $featuredDestinations = $dbh->fetchAll($featuredDestinationsResult);
        return $featuredDestinations ;
    }
    
    //Function to fetch featured packages
    public static function fetchFeaturedPackages($featured,$destinationId = 0,$pathFrom=''){
        
        $dbh = new Db();
        $defaultLimit = 2;

        // Get Packages
        $query = " SELECT P.nPackage_Id,P.package_alias, P.vPackage_Title,P.vPackage_Description,P.file_id
                   FROM ".$dbh->tablePrefix."packages  P
                   INNER JOIN ".$dbh->tablePrefix."destination D ON (P.nDestination_Id =D.nDestination_Id)
                   WHERE D.vStatus='active' AND P.vPackage_Status='active' ";

         if($destinationId > 0)
              $query .= " AND P.nDestination_Id ='".$destinationId."' ";
        /*
        if($featured)
            $query .= " AND vFeatured ='Yes' ORDER BY RAND() LIMIT ".$defaultLimit;
        */

        $query.= " ORDER BY vFeatured='Yes' DESC, RAND() ";
        if($pathFrom =='packages'){
            $query.= "  ";
        }else{
            $query.= " LIMIT  ".$defaultLimit;
        }

        //echopre($query);

        $featuredPackagesResult = $dbh->execute($query);
        $featuredPackages = $dbh->fetchAll($featuredPackagesResult);

        return $featuredPackages;
        
    }


    //Function to fetch featured packages
    public static function fetchFeaturedPackagesBkp($featured,$destinationId = 0){

        $dbh = new Db();

        $defaultLimit = 2;

        /***********  Non featured package count.  *******************/

         $query = " SELECT count(P.nPackage_Id) as countOfFeaturedPackages FROM ".$dbh->tablePrefix."packages P
                    INNER JOIN ".$dbh->tablePrefix."destination D ON (P.nDestination_Id =D.nDestination_Id)
                    WHERE D.vStatus='active' AND  P.vPackage_Status='active'  ";

         if($destinationId > 0)
              $query .= " AND P.nDestination_Id ='".$destinationId."' ";

         $featuredPackagesResult = $dbh->execute($query);
         $featuredPackages = $dbh->fetchAll($featuredPackagesResult);

         $featuredPackages[0]->countOfFeaturedPackages;


         if($featuredPackages[0]->countOfFeaturedPackages < $defaultLimit )
         {
             $itemCountNeedToFill = $defaultLimit - $featuredPackages[0]->countOfFeaturedPackages ;

             if($itemCountNeedToFill > 0)
             {
                     $query = " SELECT P.nPackage_Id, P.vPackage_Title,P.vPackage_Description,P.file_id  FROM ".$dbh->tablePrefix."packages  P INNER JOIN ".$dbh->tablePrefix."destination D
                                ON (P.nDestination_Id =D.nDestination_Id) WHERE D.vStatus='active' AND vFeatured ='No' AND  P.vPackage_Status='active' ";

                     if($destinationId > 0)
                          $query .= " AND P.nDestination_Id ='".$destinationId."'";

                     $query .= " ORDER BY RAND() LIMIT ".$itemCountNeedToFill;

                      $nonFeaturedPackagesResult = $dbh->execute($query);
                      $nonFeaturedPackages = $dbh->fetchAll($nonFeaturedPackagesResult);
             }
         }
        /***********  Non featured package count end. *******************/

        $query = " SELECT P.nPackage_Id, P.vPackage_Title,P.vPackage_Description,P.file_id  FROM ".$dbh->tablePrefix."packages  P INNER JOIN ".$dbh->tablePrefix."destination D
            ON (P.nDestination_Id =D.nDestination_Id) WHERE D.vStatus='active' AND  P.vPackage_Status='active' ";

         if($destinationId > 0)
              $query .= " AND P.nDestination_Id ='".$destinationId."' ";

        if($featured)
            $query .= " AND vFeatured ='Yes' ORDER BY RAND() LIMIT ".$defaultLimit;

        $featuredPackagesResult = $dbh->execute($query);

        $featuredPackages = $dbh->fetchAll($featuredPackagesResult);

        if(count($nonFeaturedPackages) > 0)
            $featuredPackages = array_merge($featuredPackages,$nonFeaturedPackages);


        return $featuredPackages;

    }

    public static function fetchFeaturedPackagesDetails($id){
        $dbh = new Db();
        $query = " SELECT  
                   P.nPackage_Id,P.package_alias,D.vDestination_Name,
                   P.nDestination_Id, P.vPackage_Title, P.vSpecial_Offer, P.vPackage_Description, P.vPackage_photo_below_Description,
                   P.vPackage_Right_Description, P.vPackage_Bottom_Description, P.nAmount, P.vFeatured, P.vPackage_Image,P.file_id
                   FROM ".$dbh->tablePrefix."packages  P INNER JOIN ".$dbh->tablePrefix."destination D
                   ON (P.nDestination_Id =D.nDestination_Id) WHERE D.vStatus='active' AND  P.vPackage_Status='active'  AND P.nPackage_Id = ".mysql_real_escape_string($id)."";

        
        $featuredPackagesDetailsResult = $dbh->execute($query);
        $featuredPackagesDetails = $dbh->fetchAll($featuredPackagesDetailsResult);
        if(count($featuredPackagesDetails)>0){
            PageContext::$response->featuredPackagesDetailsEnabled = TRUE;

            PageContext::$response->featuredPackagesDetails = $featuredPackagesDetails;
        }

    }

    public static function fetchPackageDestinations()
    {
        $dbh = new Db();
        $query = " SELECT nDestination_Id, vDestination_Name  FROM ".$dbh->tablePrefix."destination WHERE vStatus='active'  ";

        $featuredPackagesResult = $dbh->execute($query);
        $featuredPackages = $dbh->fetchPair($featuredPackagesResult);
        return $featuredPackages;

    }

    //Function to fetch special offer banners
    public static function fetchSpecialOfferBanners()
    {

       $dbh = new Db();
       
       $query = " SELECT F.file_path,S.nLocation_Id,L.*  FROM ".$dbh->tablePrefix."special_offers  S INNER JOIN ".$dbh->tablePrefix."locations L
                  ON (S.nLocation_Id = S.nLocation_Id) INNER JOIN ".$dbh->tablePrefix."destination D
                  ON (L.nDestination_Id =D.nDestination_Id) INNER JOIN ".$dbh->tablePrefix."files F ON
                     (F.file_id = S.file_id)
                  WHERE D.vStatus='active' AND S.vActive='1' AND  L.vActive ='active' AND S.file_id<>0  ORDER BY RAND() LIMIT 1";
       
       $specialOfferResult = $dbh->selectQuery($query);
       $specialOfferResult = $specialOfferResult[0];
       
       return array($specialOfferResult->file_path,$specialOfferResult->nLocation_Id,$specialOfferResult->location_alias);
         
        
    }

    //Function to fetch Static Content
    public static function fetchStaticContent($section){
        $dbh = new Db();
        return $dbh->selectRecord("content", "vContent, vLocation", " vPage='$section'");
    }

    //Function to fetch Meta Content
    public static function fetchMetaContent($section){
        $dbh = new Db();
        return $dbh->selectRecord("MetaTags", "*", " vPageName='$section'");
    }

    //Function to fetch active destination description
    public static function fetchActiveDestinationDescription(){
    	 
        $dbh = new Db();
        return $dbh->selectRecord("destination", "nDestination_Id, vDestination_Name,tDestination_Description, file_id", " vStatus='active'");
       
    }

    //Function to fetch news data
    public static function fetchNews(){
        $dbh = new Db();
        return $dbh->selectResult("News", "ntitle, ndescription, cur_date, file_id", "active='1' AND exp_date>='".date('Y-m-d')."' ORDER BY nposition ASC");

    }

    //Function to fetch featured locations
    public static function fetchFeaturedLocationsBkp($featured = FALSE, $nolimit= FALSE , $destinationId = 0,$limit = '',$siteOperationMode = '') {

        $dbh                      = new Db();
        $nonFeaturedLocations     = array();
        if($limit == '')
            $defaultLimit             = 3;
        else
            $defaultLimit             = $limit;

        if($siteOperationMode == 1) {
            $defaultDestinationId = Search::fetchDefaultDestination();
            $deafultLocationId    = Search::fetchDefaultLocation($defaultDestinationId);
        }
        else {
            $deafultLocationId    = 0;
        }

        /***********  Get count of fetaured locations.  ****************/

        $query = " SELECT count(L.nLocation_Id) as `totalfeturedlocations`
                       FROM ".$dbh->tablePrefix."locations L INNER JOIN ".$dbh->tablePrefix."destination D
                       ON (D.nDestination_Id = L.nDestination_Id) WHERE L.vActive ='active' AND D.vStatus='active'
                     " ;

        if($siteOperationMode > 1)
            $query .= " AND L.vFeatured ='Yes' " ;

        if($destinationId>0)
            $query .= ' AND L.nDestination_Id = "'.$destinationId.'" ';

        if($deafultLocationId > 0)
            $searchQuery .=" AND L.nLocation_Id =$deafultLocationId";

        $query                  .= " GROUP BY L.nLocation_Id ";
        

        $featuredLocationResult  = $dbh->execute($query);
        $featuredLocations       = $dbh->fetchAll($featuredLocationResult);

        if($featuredLocations[0]->totalfeturedlocations < $defaultLimit) {

            $itemCountNeedToFill = $defaultLimit - $featuredLocations[0]->totalfeturedlocations ;

            if($itemCountNeedToFill > 0) {

                $query = " SELECT L.nLocation_Id,L.vLocation_Name,L.vLocation_Description,G.file_id FROM ".$dbh->tablePrefix."locations  L  INNER JOIN ".$dbh->tablePrefix."destination D
                                  ON (D.nDestination_Id = L.nDestination_Id) LEFT JOIN ".$dbh->tablePrefix."gallery G ON (G.nLocation_Id =L.nLocation_Id) WHERE L.vActive ='active'  AND D.vStatus='active' AND  L.vFeatured ='No' ";


                if($destinationId>0)
                    $query .= 'AND L.nDestination_Id = "'.$destinationId.'"';

                $query .= " GROUP BY L.nLocation_Id ORDER BY RAND() LIMIT ".$itemCountNeedToFill;

                $featuredLocationResult    = $dbh->execute($query);
                $nonFeaturedLocations      = $dbh->fetchAll($featuredLocationResult);

            }

        }

        /***********  Get count of fetaured locations end. ****************/


        $query = " SELECT L.nLocation_Id,L.vLocation_Name,L.vLocation_Description,G.file_id FROM ".$dbh->tablePrefix."locations  L  INNER JOIN ".$dbh->tablePrefix."destination D
                       ON (D.nDestination_Id = L.nDestination_Id) LEFT JOIN ".$dbh->tablePrefix."gallery G ON (G.nLocation_Id =L.nLocation_Id) WHERE L.vActive ='active'  AND D.vStatus='active'    ";


        if($destinationId>0)
            $query .='AND L.nDestination_Id = "'.$destinationId.'"';

        if($featured && $siteOperationMode > 1)
            $query.= " AND L.vFeatured ='Yes' ";

        if($deafultLocationId > 0)
            $query .=" AND L.nLocation_Id =$deafultLocationId";


        $query .= " GROUP BY L.nLocation_Id ";

        if($nolimit)
            $query.= " ORDER BY RAND() LIMIT  ".$defaultLimit;

        if($nolimit == false && $limit >0)
            $query.= " LIMIT ".$limit;


        $featuredLocationResult = $dbh->execute($query);
        $featuredLocations      = $dbh->fetchAll($featuredLocationResult);

        if(count($nonFeaturedLocations) > 0)
            $featuredLocations = array_merge($featuredLocations,$nonFeaturedLocations);

        return $featuredLocations;

    }


    //Function to fetch featured locations
    public static function fetchFeaturedLocations($featured = FALSE, $nolimit= FALSE , $destinationId = 0,$limit = '',$siteOperationMode = '',$pathFrom='') {

        $dbh                      = new Db();
        $nonFeaturedLocations     = array();
        
        if($limit == '')
            $defaultLimit         = 3;
        else
            $defaultLimit         = $limit;

        if($siteOperationMode == 1) {
            $defaultDestinationId = Search::fetchDefaultDestination();
            $deafultLocationId    = Search::fetchDefaultLocation($defaultDestinationId);
        }
        else {
            $deafultLocationId    = 0;
        }

        // Get Featured Locations
        $query = " SELECT L.nLocation_Id,L.vLocation_Name,L.vLocation_Description,L.location_alias,G.file_id
                   FROM ".$dbh->tablePrefix."locations  L  
                   INNER JOIN ".$dbh->tablePrefix."destination D ON (D.nDestination_Id = L.nDestination_Id)
                   LEFT JOIN ".$dbh->tablePrefix."gallery G ON (G.nLocation_Id =L.nLocation_Id)
                   WHERE L.vActive ='active' AND D.vStatus='active'";

        if($destinationId>0)
            $query .='AND L.nDestination_Id = "'.$destinationId.'"';

        /*
        if($featured && $siteOperationMode > 1)
            $query.= " AND L.vFeatured ='Yes' "; */

        if($deafultLocationId > 0)
            $query .=" AND L.nLocation_Id =$deafultLocationId";

        $query .= " GROUP BY L.nLocation_Id ";

        if($nolimit){
            $query.= " ORDER BY L.vFeatured='Yes' DESC, RAND() ";
            if($pathFrom =='locations'){
                $query.= "  ";
            }else{
                $query.= " LIMIT  ".$defaultLimit;
            }
        }
        

        if($nolimit == false && $limit >0)
            $query.= " LIMIT ".$limit;  //echopre($query);

        $featuredLocationResult = $dbh->execute($query);
        $featuredLocations      = $dbh->fetchAll($featuredLocationResult);

        return $featuredLocations;
    }
    
     // update location alias in upgrader
    public static function updateAlias($table,$aliasName,$idColumn,$nameField) {

        $db	    = new Db();


        $tempLocationImages    = array();
        $locationImages        = array();
        $db                    = new Db();

        $limitString           = ($limit>0) ? ' LIMIT 0,'.$limit : '';
        $tempQuery             = "
                                   SELECT $aliasName,$idColumn,$nameField
                                   FROM `".MYSQL_TABLE_PREFIX.$table."` 
                                   WHERE $aliasName=''";
      
        $destinations        = $db->selectQuery($tempQuery);
        
   
        
        if(is_array($destinations) && count($destinations)>0) {
            foreach($destinations as $tempKey => $tempValue) {
              
                $db                     = new Db();
                $alias                  = Utils::generateAlias(MYSQL_TABLE_PREFIX. $table, $tempValue->$nameField,'','',$aliasName);
              
                $updateArray = array($aliasName => $alias);

                $condition              = $idColumn."  = ".$tempValue->$idColumn;

                $db->updateFields($table,$updateArray,$condition);
            }
        
       
      }

    }
    
    
    public static function updateAccomodationupgrade() {
        $dbh = new Db();
        $dbh->update($dbh->tablePrefix."available_acco_type", array('additional_guest_allowed'=>10,'additional_guest_rate'=>0), "1");
    }
    
}
?>
