<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/
class Search {
    private  static $resultArrayIndex = 0;
    private static $resultArray = array();
    private static $roomAllocated = FALSE;
    private static $availabilityCount = 1;
    private static $guestCountModified = FALSE;
    private static $singleCombinationArray = array();

    //Function to fetch  destinations
    public static function fetchDestinations($destinationLimit = null) {
        $dbh = new Db();
        /*
        $query = " SELECT D.nDestination_Id,D.vDestination_Name FROM ".$dbh->tablePrefix."destination  D  
                  INNER JOIN  ".$dbh->tablePrefix."locations L
                     ON (L.nDestination_Id = D.nDestination_Id) INNER JOIN ".$dbh->tablePrefix."available_acco_type AAT 
                     ON (AAT.nLocation_Id = L.nLocation_Id) WHERE D.vStatus='active' ";

        $query .= " GROUP BY D.nDestination_Id";
        */

        $query = " SELECT D.nDestination_Id,D.vDestination_Name FROM ".$dbh->tablePrefix."destination  D
                   LEFT JOIN  ".$dbh->tablePrefix."locations L
                   ON (L.nDestination_Id = D.nDestination_Id) LEFT JOIN ".$dbh->tablePrefix."available_acco_type AAT
                   ON (AAT.nLocation_Id = L.nLocation_Id) WHERE D.vStatus='active'  GROUP BY D.nDestination_Id ";





        if(intval($destinationLimit) != 0)
            $query .="  LIMIT ".$destinationLimit;

        $destinationsResult = $dbh->execute($query);
        $destinations = $dbh->fetchAll($destinationsResult);
        return $destinations;

    }

    //Function to load all locations
    public static function fetchLocations($destinationId = NULL, $ajaxCall = FALSE, $destinationLimit = NULL) {
        $dbh = new Db();



        $query = " SELECT L.nLocation_Id,L.vLocation_Name FROM ".$dbh->tablePrefix."locations  L  INNER JOIN ".$dbh->tablePrefix."destination D
                ON (D.nDestination_Id = L.nDestination_Id)  WHERE L.vActive ='active'  AND D.vStatus='active'";

        if(!empty($destinationId))
            $query .= " AND L.nDestination_Id=".mysql_real_escape_string($destinationId);

        if($destinationLimit!=NULL)
            $query .=" LIMIT ".$destinationLimit;




        $locationResult = $dbh->execute($query);
        $locations = $dbh->fetchAll($locationResult);
        return $locations;

    }

    ////Function to fetch  destinations
    public static function fetchAccomodationTypes() {
        $dbh = new Db();
        $accomodationTypes = $dbh->selectResult("accomodation_types", "nAt_Id,vAt_Name", " vActive='active' ");

        return $accomodationTypes;

    }
    /* Function to process search
     * Input- Array containing followinf values
     * $ignoreFilters -- Will be set to true if search panel is disabled (for destination page)
    */
    public static function processSearchObject( $searchRequestArray) {

        $defaults = self::setDefaults();
       
        $objSession    = new LibSession();
        $objSession->delete('SearchObject');
        $objSearch     = new stdClass();


        if(!$searchRequestArray['ignoreFilters']) {

            if($searchRequestArray['startDate'])
                $startDate = str_replace("-", "/",$searchRequestArray['startDate']);
            if($searchRequestArray['endDate'])
                $endDate = str_replace("-", "/",$searchRequestArray['endDate']);

            $objSearch->SearchStartDate      = $startDate?mysql_real_escape_string(trim($startDate)):$defaults['defaultStartDate'];
            $objSearch->SearchEndDate        = $endDate?mysql_real_escape_string(trim($endDate)):$defaults['defaultEndDate'];
            $objSearch->GuestCount           = intval($searchRequestArray['guestCount'])?intval($searchRequestArray['guestCount']):$defaults['defaultGuestCount'];
            $objSearch->GuestChildrenCount   = intval($searchRequestArray['guestChildrenCount']);
            $objSearch->NumberOfRooms        = intval($searchRequestArray['numberOfRooms'])?intval($searchRequestArray['numberOfRooms']):$defaults['defaultRoomCount'];

        }

        $objSearch->searchDestination = intval($searchRequestArray['destination'])?intval($searchRequestArray['destination']):$defaults['defaultDestination'];
        $objSearch->SearchKeyword   = mysql_real_escape_string($searchRequestArray['searchKeyword']);
        $objSearch->SearchSortBy = mysql_real_escape_string($searchRequestArray['searchSortBy']);

        $objSearch->SearchPriceMinRange = intval($searchRequestArray['searchPriceMinRange'])?intval($searchRequestArray['searchPriceMinRange']):$defaults['defaultMinPriceRange'];

        $objSearch->SearchPriceMaxRange = intval($searchRequestArray['searchPriceMaxRange'])!=0?intval($searchRequestArray['searchPriceMaxRange']):$defaults['defaultMaxPriceRange'];
        $objSearch->AccomodationTypes = $searchRequestArray['accomodationTypes'];
        $objSearch->Amneties = $searchRequestArray['amneties'];
        $objSearch->ignoreFilters = $searchRequestArray['ignoreFilters'];
        Logger::info($objSearch);

        $objSession->set('SearchObject', $objSearch);

    }

    //Function to obtain search results
    public static function getSearchResults($limit = 0,$siteOperationMode = '') {

        $objSession    = new LibSession();
        $objSearchParams = $objSession->get('SearchObject');  
        $siteOperationMode; 

        //print_r($objSearchParams);die;

        $dbh = new Db();
       
        if($siteOperationMode == 1) {
            $defaultDestinationId = Search::fetchDefaultDestination();
            $deafultLocationId    = Search::fetchDefaultLocation($defaultDestinationId);
        }
        else {
            $deafultLocationId = 0;
        }
    //PageContext::$includeLatestJquery = true;

        //Query to fetch rating
        //  $ratingQuery = " (SELECT GROUP_CONCAT(nMarks)  FROM ".$dbh->tablePrefix."rating RT WHERE RT.nLocation_Id = L.nLocation_Id AND vFeedback_Status = 'active') AS averageRating";

        /* if(!$objSearchParams->ignoreFilters){
            $dateFilterQuery = "AND '".date("Y-m-d",strtotime($objSearchParams->SearchEndDate))."'   BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )
                OR '".date("Y-m-d",strtotime($objSearchParams->SearchStartDate))."'  BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY ) ";
            
            $bookingDateFilterQuery = "AND '".date("Y-m-d",strtotime($objSearchParams->SearchStartDate))."'   BETWEEN B.dArrival_Date AND DATE_ADD( B.dArrival_Date, INTERVAL B.nNights_Stay DAY )
                OR '".date("Y-m-d",strtotime($objSearchParams->SearchEndDate))."'  BETWEEN B.dArrival_Date AND DATE_ADD( B.dArrival_Date, INTERVAL B.nNights_Stay DAY )  ";
        }else
            $dateFilterQuery = "";*/

//        $searchQuery = " SELECT L.nLocation_Id,L.location_alias,L.vLatitude,L.vLongtitude,L.vLocation_Name,L.vLocation_Description,L.nStartingPrice,
//            CONCAT(L.vAddress,', ',L.vCity,', ',L.vState,', ',L.vZip,', ',L.vCountry) AS Address,
//            AAT.nAt_Id,AAT.nAdults+AAT.additional_guest_allowed CCC, AAT.nAat_Id, AAT.vCode, AAT.nAdults, AAT.nChildren, AAT.nAmount, AAT.nRoom 
//            FROM ".$dbh->tablePrefix."locations L 
//            INNER JOIN ".MYSQL_TABLE_PREFIX."available_acco_type AAT ON (AAT.nLocation_Id = L.nLocation_Id)
//            WHERE  L.vActive='active' AND AAT.vActive='active' ";

           $searchQuery = " SELECT L.nLocation_Id,L.location_alias,L.vLatitude,L.vLongtitude,L.vLocation_Name,L.vLocation_Description,L.nStartingPrice,
            CONCAT(L.vAddress,', ',L.vCity,', ',L.vState,', ',L.vZip,', ',L.vCountry) AS Address,
            AAT.nAt_Id,AAT.nAdults+AAT.additional_guest_allowed CCC, AAT.nAat_Id, AAT.vCode, AAT.nAdults, AAT.nChildren, AAT.nAmount, AAT.nRoom ,AT.vAt_Name
            FROM ".$dbh->tablePrefix."locations L 
            INNER JOIN ".MYSQL_TABLE_PREFIX."available_acco_type AAT ON (AAT.nLocation_Id = L.nLocation_Id)
              JOIN tbl_accomodation_types AT ON (AAT.nAt_Id=AT.nAt_Id)
                WHERE  L.vActive='active' AND AAT.vActive='active'  ";
        if($deafultLocationId > 0)
            $searchQuery .=" AND L.nLocation_Id =$deafultLocationId";

        if(!$objSearchParams->ignoreFilters) {
            if($objSearchParams->searchDestination) {
                $searchQuery    .=" AND L.nDestination_Id =$objSearchParams->searchDestination     ";
            }
            /*if($objSearchParams->GuestCount) {
                $searchQuery        .= " AND AAT.nAdults>=$objSearchParams->GuestCount";
            }*/
            if($objSearchParams->NumberOfRooms) {
                $searchQuery    .= "  AND AAT.nRoom >=".$objSearchParams->NumberOfRooms;
            }
        }
        else {
            $searchQuery .= " AND L.nDestination_Id = ".$objSearchParams->searchDestination ;
        }

        
        //Appending search keyword
        if($objSearchParams->SearchKeyword) {
            $searchQuery .= " AND (vLocation_Name LIKE  '%$objSearchParams->SearchKeyword%' OR vLocation_Description LIKE  '%$objSearchParams->SearchKeyword%' )";
        }

        //Appending search keyword
        if($objSearchParams->AccomodationTypes) {
            $objSearchParams->AccomodationTypes = str_replace("-",",",$objSearchParams->AccomodationTypes);
            $searchQuery .= " AND AAT.nAt_Id IN  ($objSearchParams->AccomodationTypes) ";
        }
        
      

        //Appending Amneties
        if($objSearchParams->Amneties) {
            $amneties = explode("-", rtrim($objSearchParams->Amneties,"-"));

            foreach($amneties as $amnety) {
                $searchQuery .= " AND vAmenities LIKE '%$amnety%' ";

            }
        }
        
         $searchQuery .= " GROUP BY L.nLocation_Id ";

        if(!$objSearchParams->ignoreFilters) {
            if($objSearchParams->GuestCount) {
                $searchQuery        .= " HAVING CCC >= $objSearchParams->GuestCount/$objSearchParams->NumberOfRooms";
            }
        }

        if($objSearchParams->ignoreFilters) {
            $searchQuery .= " GROUP BY L.nLocation_Id";

        }else {
            //$searchQuery .= " GROUP BY L.nLocation_Id";
            //$searchQuery .= " group by AAT.nAat_Id";
            //   $searchQuery .=" HAVING AAT.nRoom-SUM(B.nRooms)>=".$objSearchParams->NumberOfRooms;
        }
        $sortParam = " L.nStartingPrice ASC,L.nLocation_Id, AAT.nAt_Id";
        $searchQuery .= " ORDER BY ".$sortParam;
        
       

        $searchResultSet = $dbh->execute($searchQuery);

        $searchResults = $dbh->fetchAll($searchResultSet);

        //echo $searchQuery;
       
       // echopre($searchResults);
        //echopre($searchResults); die('*-*+');
       // array_shift($searchResults);
        //print_r($searchResults);
        if(!empty($searchResults)) { 

            if(!$objSearchParams->ignoreFilters) {  

                self::filterReservedRooms($searchResults);
               $searchResults = self::$resultArray; 
            }
           // echopre($searchResults);die('here');
            Logger::info($searchResults);
            $sortedSearchResults = self::sortSeacrhResult($searchResults);
            //echopre($sortedSearchResults); 

            Logger::info($sortedSearchResults);
            $totalResultCount = count($sortedSearchResults[0]);

            // $specialOffers = self::fetchLocationSpecialOffers($sortedSearchResults[1]);

            if(count($sortedSearchResults[0])<=$limit) {

                $limitedSearchResults = $sortedSearchResults[0] ;

            }else {

                $limitedSearchResults = array_slice($sortedSearchResults[0], $limit, BASIC_LIST_COUNT);
            }

        }else {
            $searchResults = NULL;
        }
        Logger::info($limitedSearchResults);
        return array("data"=>$limitedSearchResults,"totalResultCount"=>$totalResultCount,"guestCountModified"=>self::$guestCountModified, "special_offers" => $specialOffers);
    }

    private static function filterReservedRooms($searchResults) {
       
        $dbh = new Db();
        $objSession    = new LibSession();
        $objSearchParams = $objSession->get('SearchObject');

        foreach($searchResults as $result) {
            $query  = "SELECT SUM( nRooms ) as reservedRooms FROM ".MYSQL_TABLE_PREFIX."allotment A
                LEFT JOIN ".MYSQL_TABLE_PREFIX."booking B ON ( B.`nBooking_Id` = A.`nBooking_Id` )
                WHERE A.nAat_Id = $result->nAat_Id
                AND A.vStatus != 'blocked' AND A.vStatus != 'canceled'
                AND ('".date("Y-m-d",strtotime($objSearchParams->SearchEndDate))."'   BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )
                OR '".date("Y-m-d",strtotime($objSearchParams->SearchStartDate))."'  BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )) ";
            
            $reservedRoomResult = $dbh->execute($query);

            $reservedRoom = $dbh->fetchOne($reservedRoomResult);
            if(!empty($reservedRoom)) {

                $query = "SELECT * FROM ".MYSQL_TABLE_PREFIX."allotment A
                WHERE A.nAat_Id = $result->nAat_Id
                AND A.vStatus = 'blocked' AND ('".date("Y-m-d",strtotime($objSearchParams->SearchEndDate))."'   BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )
                OR '".date("Y-m-d",strtotime($objSearchParams->SearchStartDate))."'  BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY ))  ";

                $blockedRoomResult = $dbh->execute($query);
                $blockedRoomArray = $dbh->fetchOne($blockedRoomResult);

                if(($result->nRoom -$reservedRoom) >= $objSearchParams->NumberOfRooms && empty($blockedRoomArray))
                    self::formResultObject($result);
            }else {
                $query = "SELECT * FROM ".MYSQL_TABLE_PREFIX."allotment A
                WHERE A.nAat_Id = $result->nAat_Id
                AND A.vStatus = 'blocked' AND ('".date("Y-m-d",strtotime($objSearchParams->SearchEndDate))."'   BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )
                OR '".date("Y-m-d",strtotime($objSearchParams->SearchStartDate))."'  BETWEEN A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY ))  ";
//echopre($query);die('her1');
                $blockedRoomResult = $dbh->execute($query);
                $blockedRoomArray = $dbh->fetchOne($blockedRoomResult);

                if(empty($blockedRoomArray)) {
                    self::formResultObject($result);
                }
                    
            }
        }
    }



    private static function formResultObject($oldResultObject) {
        $objSession    = new LibSession();
        $objSearchParams = $objSession->get('SearchObject');
        $searchResults->nLocation_Id = $oldResultObject->nLocation_Id;
        $searchResults->vLatitude = $oldResultObject->vLatitude;
        $searchResults->vLongtitude = $oldResultObject->vLongtitude;
        $searchResults->vLocation_Name = $oldResultObject->vLocation_Name;
        $searchResults->location_alias = $oldResultObject->location_alias;
        $searchResults->vLocation_Description = $oldResultObject->vLocation_Description;
        $searchResults->Address = $oldResultObject->Address;
        $searchResults->vCode = $oldResultObject->selectedRoomDetails->vCode;
        $startingPrice = Booking::getStartingPrice($oldResultObject->nLocation_Id,$oldResultObject->nAt_Id,Utils::dateFormat($objSearchParams->SearchStartDate, 'm/d/Y', 'm-d-Y'),Utils::dateFormat($objSearchParams->SearchEndDate, 'm/d/Y', 'm-d-Y'));
        $bookingAmount = Booking::getExtraAmount($oldResultObject->nLocation_Id, $oldResultObject->nAt_Id, $objSearchParams->GuestCount, Utils::dateFormat($objSearchParams->SearchStartDate, 'm/d/Y', 'm-d-Y'), Utils::dateFormat($objSearchParams->SearchEndDate, 'm/d/Y', 'm-d-Y'), $startingPrice, $objSearchParams->NumberOfRooms);
        $searchResults->nStartingPrice =  $bookingAmount;
        $rateArray = explode(',', $oldResultObject->nAmount);
        if(min($rateArray))
        $searchResults->nRealStartingPrice = min($rateArray);
        //else
        //$searchResults->nRealStartingPrice =  $oldResultObject->nStartingPrice;
        $searchResults->combinedRooms = $oldResultObject->combinedRooms;
        $searchResults->nAdults = $oldResultObject->nAdults;
        $searchResults->nChildren = $oldResultObject->nChildren;
        $searchResults->nRoom = $oldResultObject->nRoom;
        $searchResults->accomodation_type = $oldResultObject->vAt_Name;
        $searchResults->max_allowed = $oldResultObject->CCC;
        $searchResults->accomodationTypeIds = $oldResultObject->nAt_Id;
        $searchResults->specialOffers = self::fetchLocationSpecialOffers($oldResultObject->nLocation_Id);
        self::$resultArray[self::$resultArrayIndex] = $searchResults;
        self::$resultArrayIndex++;
    }



    //Function to assign location rating and image and sort search results
    private  static function sortSeacrhResult ($searchResults) { 

        Logger::info("Sorting Resutls");
        $objSession    = new LibSession();
        $objSearchParams = $objSession->get('SearchObject'); 
        $sortArray = array();
        $distinctLocationIds = array();
        //print_r($searchResults);
        //Parsing array of objects into array of arrays
        foreach ($searchResults as $result) {
            //echo 'here';
            //echopre($result);die('*-*+');
            if($objSearchParams->ignoreFilters) {
                if(!empty($result->averageRating)) {
                    $averageRatings = explode(",",$result->averageRating);
                    $result->reviewCount = count($averageRatings);
                    for($k=0 ; $k<$result->reviewCount ; $k++) {
                        $totalRating += $averageRatings[$k];
                    }
                    $result->averageRating = $totalRating/$result->reviewCount;
                }
            }

            if(!in_array($result->nLocation_Id, $distinctLocationIds))
                $distinctLocationIds[] = $result->nLocation_Id;
            $result->image = self::fetchLocationImage($result->nLocation_Id);
            $ratingDetails = self::fetchLocationRating($result->nLocation_Id);
            $result->reviewCount = $ratingDetails[0];
            $result->averageRating = $ratingDetails[1];
            $resultArray[] = (array) $result;
        }

        foreach($resultArray as $searchData) { 

            foreach($searchData as $key=>$value) {
                if(!isset($sortArray[$key])) {
                    $sortArray[$key] = array();
                }
                $sortArray[$key][] = $value;
            }
        }

        if($objSearchParams->SearchSortBy == 'popular') {
            $orderby = "averageRating";
            $sortOrder = SORT_DESC;
        }else {
            $orderby = "nRealStartingPrice";
            $sortOrder = SORT_ASC;
        }


        array_multisort($sortArray[$orderby],$sortOrder,$resultArray);

        foreach($resultArray as $result) {  

            if($objSearchParams->SearchPriceMaxRange!=1000){
                //Skipping results not in price range
                if($result["nStartingPrice"]< $objSearchParams->SearchPriceMinRange || $result["nStartingPrice"]>$objSearchParams->SearchPriceMaxRange) {
                    continue;
                }
            }

            $object = new stdClass();
            foreach ($result as $key => $value) {
                $object->$key = $value;
            }
            $resultObjectArray[] = $object;
        }

        return array($resultObjectArray,$distinctLocationIds);

    }




    public static function setDefaults() {
        $default['defaultMinPriceRange'] = Utils::getSettingsData('search_filter_min_value');
        $default['defaultMaxPriceRange'] = Utils::getSettingsData('search_filter_max_value');
        $default['defaultGuestCount'] = 1;
        $default['defaultRoomCount'] = 1;
        $default['defaultStartDate'] = date('m/d/Y');
        $default['defaultEndDate'] = date("m/d/Y", strtotime("+ 1 day"));
        $default['defaultDestination'] = self::fetchDefaultDestination();
        return $default;
    }

    //Function to fetch  default destination
    public static function fetchDefaultDestination() {
        $dbh = new Db();
        $query = " SELECT D.nDestination_Id FROM ".$dbh->tablePrefix."destination  D
                 WHERE D.vStatus='active'  ";

        $destinationsResult = $dbh->execute($query);
        $destination = $dbh->fetchOne($destinationsResult);
        return $destination;

    }


    //Function to fetch  default destination
    public static function fetchDefaultLocation($destinationId) {
        $dbh   = new Db();
        $query = " SELECT L.nLocation_Id FROM ".$dbh->tablePrefix."locations L
                   WHERE L.vActive='active' and L.nDestination_Id='".$destinationId."'";

        $locationsResult = $dbh->execute($query);
        $locations       = $dbh->fetchOne($locationsResult);
        return $locations;

    }

    //Function to fetch location image from gallery
    private static function fetchLocationImage($locationId) {
        $dbh = new Db();
        return $dbh->selectRow("gallery G INNER JOIN ".$dbh->tablePrefix."files F ON (G.file_id = F.file_id)", "file_path", " G.nLocation_Id = ".$locationId."  LIMIT 1");
    }

    //Function to fetch location image from gallery
    private static function fetchLocationRating($locationId) {
        $db                  = new Db();

        $tempQuery           = " SELECT count(R.nRatingId) as raingCount , SUM(R.nMarks) as totalMarks FROM `". $db->tablePrefix."rating` R
                         INNER JOIN   `".$db->tablePrefix."customers` C ON C.nCust_Id = R.nCust_Id 
                                 WHERE  R.`vFeedback_Status`='active' AND R.nLocation_Id =".$locationId;


        $tempReviews         = $db->selectQuery($tempQuery);
        $tempReviews         = $tempReviews[0];

        $tempValue = round(($tempReviews->totalMarks/$tempReviews->raingCount), 0);   // 10

        $tempValue = ($tempValue%2==1) ? ($tempValue-1) : ($tempValue);

        $tempRatingValue = ($tempValue>0) ?  $tempValue : 0;

        return array($tempReviews->raingCount,$tempRatingValue);
    }

    //Function to fetch location image from gallery
    private static function fetchLocationSpecialOffers($locationId) {

        $dbh                  = new Db();
        return $dbh->selectResult("special_offers s INNER JOIN ".MYSQL_TABLE_PREFIX."locations l ON l.nLocation_Id=s.nLocation_Id",
                "s.nSp_Id, s.vTitle, s.tDescription, s.nRate, s.dStartDate, s.dEndDate, s.vActive, s.file_id, s.nLocation_Id,s.vAlias,l.location_alias",
                " s.vActive = '1' AND s.dStartDate <=CURDATE() AND s.dEndDate>=CURDATE() AND s.nLocation_Id = $locationId");

    }
    public static function getExpediaSearchMode() {
        $dbh                  = new Db();
        $data = $dbh->selectRecord("lookup", "vLookUp_Value", 'vLookUp_Name="expedia_search_mode"');
        return $data->vLookUp_Value;
    }


}

?>
