<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | This page is for user section management. Login checking , new user registration, user listing etc.                                      |
// | File name : index.php                                                  |
// | PHP version >= 5.2                                                   |
// | Created On	: 	Nov 17 2011                                               |
// +----------------------------------------------------------------------+
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2010                                      |
// | All rights reserved                                                  |
// +------------------------------------------------------

class ControllerCancel extends BaseController {

    public function init() {

        parent::init();

        $this->_common	                     = new ModelCommon();
        $this->_session                      = new LibSession();
        PageContext::$body_class             = 'payment';
        PageContext::$includeLatestJquery = true;
        PageContext::addJsVar("BASE_URL", BASE_URL);
        PageContext::addStyle('order.css',true);
        PageContext::addStyle('results.css',true);
        PageContext::addScript('cancel.js');
        PageContext::addScript('jquery-ui-timepicker-addon.js');
        PageContext::addStyle('signup.css',true);
        PageContext::addStyle("jquery-ui-1.8.23.custom.css");
        //PageContext::addScript("https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js");
      //  PageContext::addScript('country-state.js');
        PageContext::addJsVar("BASE_URL", BASE_URL);

    }



    public function index($bookingId) {
        // Meta Data
        PageContext::$includeLatestJquery = true;
        Utils::getMetaContents('cancel');
        global $imageConfig;

        if($bookingId > 0) {

            $objSession                              = NEW LibSession();
            $objSession->set("cancel_booking_id", $bookingId);
            $_SESSION['cancel_bookingId']            = $bookingId;

            $customerDetails                         = json_decode($this->_session->get('customer'));
            $cart                                    = new Cart('cancel_customer_cart',$customerDetails->nCust_Id);
            $settings                                = Apputils::loadSettings();
            PageContext::$response->cancellationTerms =  $settings['cancellation_terms'];
            PageContext::addPostAction("cancellationterms", "cancel", "default");

            if($settings['AllowCancel'] == 1) {
                PageContext::$response->showContactAdminMessage = FALSE;
                PageContext::$response->paymentDisabled = FALSE;

                if($settings['CancelType'] == 1) { //Check Penalty
                    PageContext::$response->bookingDetails = Cancel::getBookingDetails($bookingId);

                    $galleryDetails = Location::getLocationImages(PageContext::$response->bookingDetails[0]->nLocation_Id,1);




                    foreach($galleryDetails as $key => $value) {

                        PageContext::$response->defaultGalleryImage =  BASE_URL . 'project/files/'. $imageConfig['locationThumb']['directory'] . '/' .  $imageConfig['locationThumb']['prefix']. $value->file_path;
                        break;

                    }





                    $penaltyDetails = Cancel::checkPenalty(PageContext::$response->bookingDetails[0]->dBooking_Date);

                    if(count($penaltyDetails)>0) {
                        PageContext::$response->penalty = Cancel::calculatePenalty($penaltyDetails, PageContext::$response->bookingDetails[0]->nReserveModeAmount);
                        PageContext::$response->penalty = number_format(PageContext::$response->penalty,2);
                        $objSession->set("penalty", PageContext::$response->penalty);
                    }
                    else
                        PageContext::$response->paymentDisabled = TRUE;

                }
                else
                    PageContext::$response->showContactAdminMessage = TRUE;


                if($customerDetails->nCust_Id>0)
                    PageContext::addJsVar('JQ_is_logged_in', '1');
                else
                    PageContext::addJsVar('JQ_is_logged_in', '0');

                echopre($_SESSION['penalty']);

                //$objSession->set("cancel_penalty", $_SESSION['penalty']);
                $objSession->set("cancel_penalty",PageContext::$response->penalty);

                PageContext::addJsVar('JQ_payment_customer_first_name', $customerDetails->vFirstname);
                PageContext::addJsVar('JQ_payment_customer_last_name', $customerDetails->vLastname);
                PageContext::addJsVar('JQ_payment_customer_email', $customerDetails->vEmail);
                PageContext::addJsVar('JQ_payment_customer_address', $customerDetails->vAddress1);
                PageContext::addJsVar('JQ_payment_customer_city', $customerDetails->vCity);
                PageContext::addJsVar('JQ_payment_customer_state', $customerDetails->vState);
                PageContext::addJsVar('JQ_payment_customer_country', $customerDetails->vCountry);
                PageContext::addJsVar('JQ_payment_customer_zip', $customerDetails->vZip);
                PageContext::addJsVar('JQ_payment_amount', PageContext::$response->penalty);


                //******************end of location details *****************************//

                PageContext::registerPostAction("center-main", "index","cancel","default");
            }
        }
    }




    public function complete($action = 'empty') {
         Utils::getMetaContents('cancel');
        PageContext::$response->penalty = $_SESSION['penalty'];

        PageContext::registerPostAction("center-main", "complete","cancel","default");

        //  $objSearchParams                               = $this->_session->get('SearchObject');
        //  PageContext::$response->objSearchParams        = $objSearchParams;

        $customerDetails                               = json_decode($this->_session->get('customer'));
        $cart 		                                = new Cart('cancel_customer_cart',$customerDetails->nCust_Id);
        if($action == 'cancel') {
            $objSession = NEW LibSession();

            Cancel::cancelBookingWithoutPayment ($objSession->get("cancel_booking_id"));
            //$bookingDetails = Cancel::getBookingDetails($objSession->get("cancel_booking_id"));
            $bookingId      = $objSession->get("cancel_booking_id");

            // Mail send to user/admin/property owner while a user cancel a booking
            Cancel::sendCancelMail($bookingId,'User');
            Cancel::sendCancelMail($bookingId,'Admin');
        }

    }


    /* post action */
    public function paymentInformation() {

        PageContext::$response->isAuthorizeEnabled             = Apputils::fetchSettings('cenable_authorize');
        PageContext::$response->isPaypalEnabled                = Apputils::fetchSettings('cenable_paypal');
        PageContext::$response->isYorpayEnabled                = Apputils::fetchSettings('enableyourpay');
        PageContext::$response->isGooglecheckoutEnabled        = Apputils::fetchSettings('enablegoogle');
        PageContext::$response->isotherOptionsEnabled          = Apputils::fetchSettings('enable_other_payments');
        PageContext::$response->isPaypalProEnabled             = Apputils::fetchSettings('cenable_paypal_pro');
        PageContext::$response->isBluepayEnabled               = Apputils::fetchSettings('enablebluepay');
        PageContext::$full_layout_rendering = false;

        $this->view->disableLayout();

        $currentYear  = (int) date('Y');

        $yearArray    = array();

        PageContext::$response->monthArray   = array('01'=>"January", '02'=>"February", '03'=>"March", '04'=>"April", '05'=>"May", '06'=>"June", '07'=>"July", '08'=>"August", '09'=>"September", '10'=>"October", '11'=>"November", '12'=>"December");


        $currentYear = $currentYear-1;

        for($i=0; $i<10; $i++) {
            $yearArray[] = $currentYear = $currentYear+1;
        }

        PageContext::$response->yearArray = $yearArray;


    }

    // Ajax function
    public function editBookingDetails($numberOfPeople,$arrivalDate,$departureDate,$numberOfChildren,$numberOfRooms) {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();


        $objSession                       = new LibSession();
        $accomadationAvailabilityDetails  = array();

        $customerDetails                  = json_decode($objSession->get('customer'));
        $cart 		                   = new Cart('customer_cart',$customerDetails->nCust_Id);

        $tempLastBookingDetails           = json_decode($objSession->get('last_booking_details'));

        $locationId                       = $tempLastBookingDetails->locationId;
        $accomadationType                 = $tempLastBookingDetails->accomadationType;
        $startingPrice                    = $tempLastBookingDetails->startingPrice;


        print Booking::saveBookingAmount($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfChildren,$numberOfRooms);
        exit();

    }







    /*
 *   Function name : proceedWithPayment
 *   This function do the same as the " proceed " function but consider payment gateways.
    */




    public function proceedWithPayment($payMode) {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        $objSession                     = new LibSession();

        $customerDetails                = json_decode($this->_session->get('customer'));



        if($customerDetails->nCust_Id > 0) {
            /*   $payMode = ($payMode==2) ? DB_BOOKING_PAY_METHOD_PAYPAL : DB_BOOKING_PAY_METHOD_AUTHORIZE_NET;
            $requestArray['nBooking_Id'] = $_SESSION['cancel_bookingId'];
           $requestArray['vTxn_Id'] =  $transactionId;
           $requestArray['dDate_Settled'] =  date('Y-m-d H:i:s');
           $requestArray['vPayment_Type'] =  DB_BOOKING_PAY_METHOD_AUTHORIZE_NET;
           $requestArray['vStatus'] =  'Yes';
           $requestArray['vCapture'] =  'Y';
           $requestArray['vType'] =  DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT;
           $requestArray['nCancelAmt'] =  $status['Amount'];
           Cancel::cancelBooking($requestArray);*/
            // $bookingId = Booking::recordOrder($customerDetails->nCust_Id,$accomadationType,$accomadationAvailabilityId,$numberOfAdults,$numberOfChildren,$arrivalDate,$departureDate,$extraAmount,$tempLastBookingDetails->siteBookingMode,$amountToPay,$payMode,$numberOfRooms);
            //  $objSession->set('last_booking_id',$bookingId);
            print 1;
        }

        exit();

    }


    public function payWithOtherOptions() {
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();


        $customerDetails                = json_decode($this->_session->get('customer'));


        if($customerDetails->nCust_Id > 0) {
            $objSession = NEW LibSession();

            $requestArray['vTxn_Id'] = 0;
            $requestArray['dDate_Settled'] =  date('Y-m-d H:i:s');
            $requestArray['vPayment_Type'] =  PageContext::$request['type'];
            $requestArray['vStatus'] =  'No';
            $requestArray['vCapture'] =  'Y';
            $requestArray['vType'] =  DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT;
            $requestArray['nCancelAmt'] =  $objSession->get("cancel_penalty");

            $requestArray['nBooking_Id'] = $objSession->get("cancel_booking_id");

            $paymentId = Cancel::changeBookingCanceltoPending($requestArray);


            $dataArray['paymentId']         = $paymentId;
            $dataArray['payment_mode']      = PageContext::$request['type'];
            $dataArray['name']              = PageContext::$request['name'];
            $dataArray['reference_no']      = PageContext::$request['referenceNumber'];
            $dataArray['bank']              = PageContext::$request['bank'];
            $dataArray['date']              = Utils::dateFormat(PageContext::$request['date'],'m-d-Y','Y-m-d');
            Cancel::addBankDetails($dataArray);
            $objSession = NEW LibSession();

            $bookingId = $objSession->get("cancel_booking_id");
            $penalty   = $objSession->get("cancel_penalty");
            // Mail send to user/admin while a user cancel a booking
            Cancel::sendCancelPendingMail($bookingId,$penalty,'User');
            Cancel::sendCancelPendingMail($bookingId,$penalty,'Admin');
            
            print 1;
        }

        exit();
    }

    public function cancellationterms() {

    }



}

?>
