<?php ?>
<!--  Orders  -->

{
    "keyColumn": "nBooking_Id",
    "detailHeaderColumnPrefix": "Order: ",
    "detailHeaderColumns": [
        "nBooking_Id"
    ],
    "orderBy": {
        "nBooking_Id": "DESC"
    },
    "listColumns": [
        "OrderId",
        "nCust_Id",
        "dArrival_Date",
        "checkoutDate",
        "dBooking_Date",
        "nNights_Stay",
        "nAmount",
        "vStatus"
    ],
    "detailColumns": [
        "OrderId",
        "nBooking_Id",
        "nCust_Id",
        "dArrival_Date",
        "checkoutDate",
        "dBooking_Date",
        "vBooking_Details",
        "nNights_Stay",
        "nRooms",
        "nAmount",
        "nAdults",
        "nChildren",
        "vStatus"
    ],
    "columns": {

        "OrderId": {
            "name": "Order ID",
            "customColumn": "true",
            "customaction": "Cmshelper::getOrderId",
            "popupoptions": {
                "type": "popup",
                "customaction": "Cmshelper::getInvoicePopupUrl"
            }
        },
        "nBooking_Id": {
            "name": "ID"
        },
        "nCust_Id": {
            "name": "Customer",
            "searchable": "true",
            "sortable": true,
            "external": "true",
            "externalOptions": {
                "externalTable": "tbl_customers",
                "externalColumn": "nCust_Id",
                "externalShowColumn": "vFirstname"
            },
            "popupoptions": {
                "type": "popup",
                "customaction": "Cmshelper::getUserPopupUrl"
            }
        },
        "dArrival_Date": {
            "name": "Check In",
            "dbFormat": "datetime",
            "displayFormat": "m/d/Y",
            "searchable": "true",
            "sortable": true
        },
        "checkoutDate": {
            "name": "Check Out",
            "customColumn": "true",
            "customaction": "Cmshelper::getCheckoutDate"
        },
        "dBooking_Date": {
            "name": "Booking Date",
            "dbFormat": "datetime",
            "displayFormat": "m/d/Y",
            "searchable": "true",
            "sortable": true
        },
        "vBooking_Details": {
            "name": "Booking Details"
        },
        "nNights_Stay": {
            "name": "No. of Days",
            "searchable": "true",
            "sortable": true
        },
        "nRooms": {
            "name": "No. of Rooms"
        },
        "nAmount": {
            "name": "Amount ($)",
            "searchable": "true",
            "sortable": true
        },
        "nAdults": {
            "name": "Adults"
        },
        "nChildren": {
            "name": "Children"
        },
        "vStatus": {
            "name": "Status",
            "searchable": "true",
            "sortable": true
        }
    },
    "opertations": [
        "view"
    ]
}

<!--  Orders  -->

<!--  Dashboard  -->


{
    "dashboardPanel": "true",
    "listingPanel": "true",
    "listinPanelRow": "1",
    "listingPanel1": {
        "columns": "2",
        "column1": {
            "title": "Inquiries",
            "fetchValue": "Cmshelper::fetchRecentEnquiries",
            "listcolumns": {
                "vName": {
                    "name": "Customer"
                },
                "vEmail": {
                    "name": "Email"
                },
                "dPasted_Date": {
                    "name": "Inquired On"
                }
            }
        },
        "column2": {
            "title": "Recent Orders",
            "fetchValue": "Cmshelper::fetchRecentOrders",
            "listcolumns": {
                "vFirstname": {
                    "name": "Customer"
                },
                "nAmount": {
                    "name": "Amount ($)"
                },
                "vStatus": {
                    "name": "Status"
                },
                "dBooking_Date": {
                    "name": "Booked On"
                }
            }
        }
    },
    "graphPanel": "true",
    "graphpanelRow": "1",
    "graphPanel1": {
        "columns": "2",
        "graph1": {
            "type": "MSLine",
            "caption": "Booking",
            "xAxisName": "",
            "yAxisName": "BookingCount",
            "width": "480",
            "height": "300",
            "dataSetsCount": "1",
            "dataSets": {
                "dataset1": {
                    "name": "",
                    "color": "#009933",
                    "fetchValue": "Cmshelper: : getBookingCount"
                }
            }
        },
        "graph2": {
            "type": "MSLine",
            "caption": "Accomodation Availability",
            "xAxisName": "",
            "yAxisName": "Available Room Count",
            "width": "480",
            "height": "300",
            "dataSetsCount": "1",
            "dataSets": {
                "dataset1": {
                    "name": "",
                    "color": "#009933",
                    "fetchValue": "Cmshelper: : getAvailableRoomCount"
                }
            }
        }
    }
}
<!--  Dashboard  -->

<!--  Customers  -->
{
    "keyColumn": "nCust_Id",
    "includeJsFiles": [
        "cms_customer.js"
    ],
    "detailHeaderColumnPrefix": "Customer: ",
    "detailHeaderColumns": [
        "vFirstname"
    ],
    "orderBy": {
        "nCust_Id": "ASC"
    },
    "listColumns": [
        "vFirstname",
        "vEmail",
        "dDatejoin",
        "vActive"
    ],
    "showColumns": [
        "nCust_Id",
        "vLogin",
        "vPassword",
        "vFirstname",
        "vLastname",
        "vEmail",
        "vAddress1",
        "vCity",
        "vCountry",
        "vState",
        "vZip",
        "vTelephone",
        "dDatejoin",
        "vActive"
    ],
    "detailColumns": [
        "nCust_Id",
        "vLogin",
        "vPassword",
        "vFirstname",
        "vLastname",
        "vEmail",
        "vAddress1",
        "vCity",
        "vCountry",
        "vState",
        "vZip",
        "vTelephone",
        "dDatejoin",
        "vActive"
    ],
    "columns": {
        "nCust_Id": {
            "name": "ID",
            "sortable": "true",
            "editoptions": {
                "type": "hidden"
            }
        },
        "vLogin": {
            "name": "Login Name",
            "sortable": "true",
            "editoptions": {
                "type": "textbox",
                "label": "Login Name",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            }
        },
        "vPassword": {
            "name": "Password",
            "editoptions": {
                "type": "password",
                "label": "Password",
                "class": "textbox"
            }
        },
        "vFirstname": {
            "name": "First Name",
            "searchable": "true",
            "sortable": "true",
            "editoptions": {
                "type": "textbox",
                "label": "First Name",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            },
            "customColumn": "true",
            "customaction": "Cmshelper::getUserPopupUrlForCustomersLink"
        },
        "vLastname": {
            "name": "Last Name",
            "sortable": "true",
            "editoptions": {
                "type": "textbox",
                "label": "Last Name",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            }
        },
        "vEmail": {
            "name": "Email",
            "sortable": "true",
            "searchable": "true",
            "editoptions": {
                "type": "textbox",
                "label": "Email",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            }
        },
        "vAddress1": {
            "name": "Address",
            "editoptions": {
                "type": "textarea",
                "label": "Address",
                "class": "textarea",
                "validations": [
                    "required"
                ]
            }
        },
        "vCity": {
            "name": "City",
            "searchable": "true",
            "sortable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textbox",
                "label": "City",
                "class": "textbox"
            }
        },
        "vState": {
            "name": "State",
            "sortable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": "Cmshelper::getAllStates",
                "source_type": "function",
                "label": "State",
                "class": "select"
            },
            "external": "true",
            "externalOptions": {
                "externalTable": "tbl_state",
                "externalColumn": "ts_code",
                "externalShowColumn": "ts_name"
            }
        },
        "vZip": {
            "name": "Zip",
            "editoptions": {
                "type": "textbox",
                "label": "Zip",
                "class": "textbox"
            }
        },
        "vCountry": {
            "name": "Country",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": "Cmshelper::getAllCountries",
                "source_type": "function",
                "label": "Country",
                "class": "select"
            },
            "external": "true",
            "externalOptions": {
                "externalTable": "tbl_country",
                "externalColumn": "tc_code",
                "externalShowColumn": "tc_name"
            }
        },
        "vTelephone": {
            "name": "Telephone",
            "sortable": "true",
            "editoptions": {
                "type": "textbox",
                "label": "Telephone",
                "class": "textbox"
            }
        },
        "vActive": {
            "name": "Status",
            "searchable": "true",
            "editoptions": {
                "type": "select",
                "source": {
                    "active": "Active",
                    "inactive": "Inactive"
                },
                "source_type": "array",
                "label": "Status",
                "class": "select",
                "enumvalues": {
                    "active": "Active",
                    "inactive": "Inactive"
                },
                "validations": [
                    "required"
                ]
            },
            "listoptions": {
                "type": "button",
                "customaction": "Cmshelper::changeUserStatus",
                "enumvalues": {
                    "active": "Active",
                    "inactive": "Inactive"
                },
                "buttonColors": {
                    "active": "green",
                    "inactive": "red"
                }
            }
        },
        "dDatejoin": {
            "name": "Registered On",
            "sortable": "true",
            "dbFormat": "date",
            "displayFormat": "m/d/Y"
        }
    },
    "customActions": {
        "afterAddRecord": "Customer::updateCustomerRegisterTime"
    },
    "customOperations": {
        "login": {
            "options": {
                "target": "newtab",
                "name": "Login",
                "linkSource": "Cmshelper::getuserLoggedInUrl"
            }
        }
    },
    "opertations": [
        "add",
        "view",
        "edit",
        "customdelete"
    ],
    "customDeleteOperation": "Cmshelper::deleteCustomer"
}
<!--  Customers  -->




<!--  Customers Old  -->
{
    "keyColumn": "nCust_Id",
     "includeJsFiles": [
        "cms_customer.js"
    ],
    "detailHeaderColumnPrefix": "Customer: ",
    "detailHeaderColumns": [
        "vFirstname"
    ],
    "orderBy": {
        "nCust_Id": "ASC"
    },
    "listColumns": [
        "vFirstname",
        "vEmail",
        "dDatejoin",
        "vActive"
    ],
    "showColumns": [
        "nCust_Id",
        "vLogin",
"vPassword",
        "vFirstname",
        "vLastname",
        "vEmail",
        "vAddress1",
        "vAddress2",
        "vCity",
"vZip",

        "vCountry",
         "vState",
        "vMobile",
        "vTelephone",
        "vFax",
        "dDatejoin",
        "vActive"
    ],
    "detailColumns": [
        "nCust_Id",
        "vLogin",
"vPassword",
        "vFirstname",
        "vLastname",
        "vEmail",
        "vAddress1",
        "vAddress2",
        "vCity",
"vZip",

        "vCountry",
          "vState",
        "vMobile",
        "vTelephone",
        "vFax",
        "dDatejoin",
        "vActive"
    ],
    "columns": {
        "nCust_Id": {
            "name": "ID",
            "sortable": "true",
            "editoptions": {
                "type": "hidden"
            }
        },
        "vLogin": {
 "name": "Login Name",
            "sortable": "true",
            "editoptions": {
                "type": "textbox",
                "label": "Login Name",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            }
        },
        "vPassword": {
            "name": "Password",
            "editoptions": {
                "type": "password",
                "label": "Password",
                "class": "textbox"
            }
        },
        "vFirstname": {
            "name": "First Name",
            "searchable": "true",
            "sortable": "true",
            "editoptions": {
                "type": "textbox",
                "label": "First Name",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            },
 "popupoptions": {
                "type": "popup",
                "customaction": "Cmshelper::getUserPopupUrlForCustomersLink"
            }
        },
        "vLastname": {
            "name": "Last Name",
            "sortable": "true",
            "editoptions": {
                "type": "textbox",
                "label": "Last Name",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            }
        },
        "vEmail": {
            "name": "Email",
            "sortable": "true",
  "searchable": "true",
            "editoptions": {
                "type": "textbox",
                "label": "Email",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            }
        },
        "vAddress1": {
            "name": "Address",
            "editoptions": {
                "type": "textarea",
                "label": "Address",
                "class": "textarea",
                "validations": [
                    "required"
                ]
            }
        },
        "vAddress2": {
            "name": "Address 2",
            "editoptions": {
                "type": "textarea",
                "label": "Address 2",
                "class": "textarea"
            }
        },
        "vCity": {
            "name": "City",
            "searchable": "true",
            "sortable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textbox",
                "label": "City",
                "class": "textbox"
            }
        },
        "vState": {
            "name": "State",
            "sortable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": "Cmshelper::getAllStates",
                "source_type": "function",
                "label": "State",
                "class": "select"
            },
            "external": "true",
            "externalOptions": {
                "externalTable": "tbl_state",
                "externalColumn": "ts_code",
                "externalShowColumn": "ts_name"
            }
        },
        "vZip": {
            "name": "Zip",
            "editoptions": {
                "type": "textbox",
                "label": "Zip",
                "class": "textbox"
            }
        },
        "vCountry": {
            "name": "Country",

            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": "Cmshelper::getAllCountries",
                "source_type": "function",
                "label": "Country",
                "class": "select"
            },
            "external": "true",
            "externalOptions": {
                "externalTable": "tbl_country",
                "externalColumn": "tc_code",
                "externalShowColumn": "tc_name"
            }
        },
        "vMobile": {
            "name": "Mobile",
            "editoptions": {
                "type": "textbox",
                "label": "Mobile",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            }
        },
        "vTelephone": {
            "name": "Telephone",
            "sortable": "true",
            "editoptions": {
                "type": "textbox",
                "label": "Telephone",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            }
        },
        "vFax": {
            "name": "Fax",
            "editoptions": {
                "type": "textbox",
                "label": "Fax",
                "class": "textbox"
            }
        },
        "vActive": {
            "name": "Status",
            "searchable": "true",
            "editoptions": {
                "type": "select",
                "source": {
                    "active": "Active",
                    "inactive": "Inactive"
                },
                "source_type": "array",
                "label": "Status",
                "class": "select",
                "enumvalues": {
                    "active": "Active",
                    "inactive": "Inactive"
                },
                "validations": [
                    "required"
                ]
            },
            "listoptions": {
                "type": "button",
                "customaction": "Cmshelper::changeUserStatus",
                "enumvalues": {
                   "active": "Active",
                   "inactive": "Inactive"
                },
                "buttonColors": {
                    "active": "green",
                    "inactive":  "red"
                }
            }
        },
        "dDatejoin": {
            "name": "Registered On",
  "sortable": "true",
            "dbFormat": "date",
            "displayFormat": "m/d/Y"
        }
    },
 "customActions":{
        "beforeEditRecord":"Cmshelper::unsetPassword",
"beforeAddRecord":"Cmshelper::sendUserMail"
    },
"customOperations": {
        "login": {
            "options": {
                "target": "newtab",
                "name": "Login",
                "linkSource": "Cmshelper::getuserLoggedInUrl"
            }
        }
    },
    "customActions": {
        "afterAddRecord": "Customer::updateCustomerRegisterTime"
    },
    "opertations": [
        "add",
        "view",
        "edit",
        "customdelete"
    ],
"customDeleteOperation":"Cmshelper::deleteCustomer"
}
<!--  Customers Old  -->


<!-- Feedbacks -->

{
    "keyColumn": "nFeedback_Id",
     "detailHeaderColumnPrefix": "Feedback: ",

    "detailHeaderColumns": [
        "vName"
    ],
    "orderBy": {
        "dPasted_Date": "DESC"
    },
    "listColumns": [
        "vName",
        "vDestination",
        "dPasted_Date",
        "tComments"
    ],
    "showColumns": [
        "nFeedback_Id",
        "vName",
        "vEmail",
        "vPhone",
        "vAddress",
        "vDestination",
        "dPasted_Date",
        "tComments"
    ],
    "detailColumns": [
        "nFeedback_Id",
        "vName",
        "vEmail",
        "vPhone",
        "vAddress",
        "vDestination",
        "dPasted_Date",
        "tComments"
    ],
    "columns": {
        "nFeedback_Id": {
            "name": "ID",
            "sortable": "true"
        },
        "vName": {
            "name": "Customer",
            "sortable": "true",
            "searchable": "true",
            "popupoptions": {
                "type": "popup",
                "customaction": "Cmshelper::getFeedbackUserPopupUrl"
            }
        },
        "vPhone": {
            "name": "Phone"
        },
        "vEmail": {
            "name": "Email",
  "searchable": "true"
        },
        "vAddress": {
            "name": "Address"
        },
        "vDestination": {
            "name": "Destination",
            "searchable": "true",
            "sortable": "true",
             "external": "true",
            "externalOptions": {
                "externalTable": "tbl_destination",
                "externalColumn": "nDestination_Id",
                "externalShowColumn": "vDestination_Name"
            }
        },
        "tComments": {
            "name": "Feedback"
        },
        "dPasted_Date": {
            "name": "Posted Date",
            "dbFormat": "date",
            "displayFormat": "m/d/Y"
        }
    },
    "opertations": [
        "delete",
        "view"
    ]
}
<!-- Feedbacks -->


<!-- Locations -->

{
    "keyColumn": "nLocation_Id",
    "includeJsFiles": [
        "cms_location.js"
    ],
    "handleFile": "true",
    "orderBy": {
        "nLocation_Id": "DESC"
    },
    "breadCrumbColumn": "vLocation_Name",
    "detailHeaderColumnPrefix": "Location: ",
    "detailHeaderColumns": [
        "vLocation_Name"
    ],
    "listColumns": [
        "vLocation_Name",
        "nDestination_Id",
        "vFeatured",
        "vActive",
        "Promote"
    ],
    "detailColumns": [
        "nLocation_Id",
        "nDestination_Id",
        "vLocation_Name",
        "vLocation_Description",
        "vAddress",
        "vCity",
        "vZip",
        "vCountry",
        "vState",
        "nStartingPrice",
        "vFeatured",
        "vActive",
        "vAmenities",
        "Promote"
    ],
    "showColumns": [
        "nLocation_Id",
        "nDestination_Id",
        "vLocation_Name",
        "vLocation_Description",
        "vAddress",
        "vCity",
        "vZip",
        "vCountry",
        "vState",
        "nStartingPrice",
        "vFeatured",
        "vActive",
        "vAmenities"
    ],
    "columns": {
        "nLocation_Id": {
            "name": "ID",
            "sortable": "true",
            "editoptions": {
                "type": "hidden"
            }
        },
        "vLocation_Name": {
            "name": "Location",
            "sortable": "true",
            "searchable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textbox",
                "label": "Location",
                "class": "textbox"
            },
            "popupoptions": {
                "type": "popup",
                "customaction": "Cmshelper::getLocationPopupUrlLocationLink"
            }
        },
        "nDestination_Id": {
            "name": "Destination",
            "sortable": "true",
            "searchable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": "Cmshelper::getAllDestinations",
                "source_type": "function",
                "label": "Destination",
                "class": "select"
            },
            "external": "true",
            "externalOptions": {
                "externalTable": "tbl_destination",
                "externalColumn": "nDestination_Id",
                "externalShowColumn": "vDestination_Name"
            },
            "popupoptions": {
                "type": "popup",
                "customaction": "Cmshelper::getDestinationPopupUrlLocationLink"
            }
        },
        "vLocation_Description": {
            "name": "Description",
            "editoptions": {
                "type": "textarea",
                "label": "Overview",
                "class": "textarea"
            }
        },
        "vAmenities": {
            "name": "Amenities",
            "editoptions": {
                "type": "htmlEditor",
                "label": "Amenities",
                "class": "textarea"
            }
        },
        "vAddress": {
            "name": "Address",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textarea",
                "label": "Address",
                "class": "textarea"
            }
        },
        "vCity": {
            "name": "City",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textbox",
                "label": "City",
                "class": "textbox"
            }
        },
        "vState": {
            "name": "State",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": "Cmshelper::getAllStates",
                "source_type": "function",
                "label": "State",
                "class": "select"
            }
        },
        "vZip": {
            "name": "Zip",
            "editoptions": {
                "type": "textbox",
                "label": "Zip",
                "class": "textbox"
            }
        },
        "vCountry": {
            "name": "Country",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": "Cmshelper::getAllCountries",
                "source_type": "function",
                "label": "Country",
                "class": "select"
            }
        },
        "nStartingPrice": {
            "name": "StartingPrice",
            "sortable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textbox",
                "label": "StartingPrice",
                "class": "textbox"
            }
        },
        "vActive": {
            "name": "Status",
            "searchable": "true",
            "editoptions": {
                "type": "select",
                "source": {
                    "active": "Active",
                    "deactive": "Inactive"
                },
                "source_type": "array",
                "label": "Status",
                "class": "select",
                "enumvalues": {
                    "active": "Active",
                    "deactive": "Inactive"
                }
            },
            "listoptions": {
                "type": "button",
                "customaction": "Cmshelper::changeLocationStatus",
                "enumvalues": {
                    "active": "Active",
                    "deactive": "Inactive"
                },
                "buttonColors": {
                    "active": "green",
                    "deactive": "red"
                }
            }
        },
        "vFeatured": {
            "name": "Featured",
            "searchable": "true",
            "editoptions": {
                "type": "select",
                "source": {
                    "No": "No",
                    "Yes": "Yes"
                },
                "source_type": "array",
                "label": "Featured",
                "class": "select",
                "enumvalues": {
                    "No": "No",
                    "Yes": "Yes"
                }
            },
            "listoptions": {
                "type": "button",
                "customaction": "Cmshelper::changeLocationFeaturedStatus",
                "enumvalues": {
                    "Yes": "Featured",
                    "No": "Nonfeatured"
                },
                "buttonColors": {
                    "Yes": "green",
                    "No": "red"
                }
            }
        },
        "Promote": {
            "name": "Publish",
            "customColumn": "true",
            "customaction": "Cmshelper::displayPromoteLink"
        }
    },
    "relations": {
        "location_offer_tag": {
            "name": "SpecialOffers",
            "section": "location_offer_tag",
            "child_table": "tbl_special_offers",
            "parent_join_column": "nLocation_Id",
            "child_join_column": "nLocation_Id"
        },
        "location_gallery_tag": {
            "name": "Gallery",
            "section": "location_gallery_tag",
            "child_table": "tbl_gallery",
            "parent_join_column": "nLocation_Id",
            "child_join_column": "nLocation_Id"
        },
        "location_accomodation_tag1": {
            "name": "Accomodations",
            "section": "location_accomodation_tag1",
            "child_table": "tbl_available_acco_type",
            "parent_join_column": "nLocation_Id",
            "child_join_column": "nLocation_Id"
        },
        "location_review_tag": {
            "name": "Reviews",
            "section": "location_review_tag",
            "child_table": "tbl_rating",
            "parent_join_column": "nLocation_Id",
            "child_join_column": "nLocation_Id"
        }
    },
    "customActions": {
        "afterAddRecord": "Cmshelper::mapLatLong",
        "afterEditRecord": "Cmshelper::mapLatLong"
    },
    "opertations": [
        "view",
        "edit",
        "delete",
        "add"
    ]
}

<!-- Locations -->

<!-- Meta Tags -->

{
 "keyColumn": "id",
 "detailHeaderColumnPrefix": "Meta Tag : ",
    "detailHeaderColumns": [
        "url"
    ],
    "orderBy": {
        "id": "ASC"
    },
    "listColumns": [
        "url",
        "title",
        "keyword"
    ],
    "showColumns": [
        "id",
        "url",
        "title",
        "keyword",
        "description"
    ],
    "detailColumns": [
        "id",
        "url",
        "title",
        "keyword",
        "description"
    ],
    "columns": {
        "id": {
            "name": "ID",
            "editoptions": {
                "type": "hidden"
            }
        },
        "title": {
            "name": "Meta Title",
            "editoptions": {
                "type": "textbox",
                "label": "Meta Title",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            }
        },
        "keyword": {
            "name": "Meta Keywords",
            "editoptions": {
                "type": "textarea",
                "label": "Meta Keywords",
                "class": "textarea"
            }
        },
        "description": {
            "name": "Meta Description",
            "editoptions": {
                "type": "textarea",
                "label": "Meta Description",
                "class": "textarea"
            }
        },
        "url": {
            "name": "Page Url",
            "sortable": "true",
            "searchable": "searchable",
            "editoptions": {
                "label": "Page Url",
                "type": "textbox",
                "class": "textbox",
                "hint":"<b>Url combinations can be : </b><br/><b style='color:red'> /abc/</b> [exact location abc after your domain name] eg : www.domainname.com/abc/ ,<br/> <b style='color:red'>/abc/* </b> [any combination after location abc after your domain name] eg : www.domainname.com/abc/test1,<br/> <b style='color:red'>* </b>[default value] ",
                "validations": [
                    "required"
                ]
            }
        }
    },
    "opertations": [
        "add",
        "view",
        "edit",
        "delete"
    ]
}

<!-- Meta Tags -->


<!-- Meta Tags Old -->
{
    "keyColumn": "nId",
 "detailHeaderColumnPrefix": "Meta Tag : ",
    "detailHeaderColumns": [
        "nId"
    ],
    "orderBy": {
        "nId": "ASC"
    },
    "listColumns": [
        "vTitle",
        "vKeywords",
        "vDescription",
        "vPageName"
    ],
    "showColumns": [
        "nId",
        "vTitle",
        "vKeywords",
        "vDescription",
        "vPageName"
    ],
    "detailColumns": [
        "nId",
        "vTitle",
        "vKeywords",
        "vDescription",
        "vPageName"
    ],
    "columns": {
        "nId": {
            "name": "ID",
            "editoptions": {
                "type": "hidden"
            }
        },
        "vTitle": {
            "name": "Page Title",
            "editoptions": {
                "type": "textbox",
                "label": "Page Title",
                "class": "textbox",
                "validations": [
                    "required"
                ]
            }
        },
        "vKeywords": {
            "name": "Keywords",
            "editoptions": {
                "type": "textarea",
                "label": "Keywords",
                "class": "textarea",
                "validations": [
                    "required"
                ]
            }
        },
        "vDescription": {
            "name": "Description",
            "editoptions": {
                "type": "textarea",
                "label": "Description",
                "class": "textarea",
                "validations": [
                    "required"
                ]
            }
        },
        "vPageName": {
            "name": "Page Name",
            "sortable": "true",
            "searchable": "searchable",
"editoptions": {
                "label": "Page Name",
"type": "disabled"
            }
        }
    },
    "opertations": [
        "view",
        "edit"
    ]
}
<!-- Meta Tags Old -->


<!-- Banners -->
{
    "keyColumn": "nBId",
    "detailHeaderColumnPrefix": "Banner: ",
    "detailHeaderColumns": [
        "vName"
    ],
    "handleFile": "true",
    "orderBy": {
        "nBId": "DESC"
    },
    "listColumns": [
        "vName",
        "vlocUrl",
        "vLocation",
        "vActive"
    ],
    "showColumns": [
        "nBId",
        "vName",
        "vlocUrl",
        "vLocation",
        "vActive",
        "file_id",
        "nDate"
    ],
    "detailColumns": [
        "nBId",
        "vName",
        "vlocUrl",
        "vLocation",
        "vActive",
        "file_id",
        "nDate"
    ],
    "columns": {
        "nBId": {
            "name": "ID",
            "sortable": "true",
            "editoptions": {
                "type": "hidden"
            }
        },
        "vName": {
            "name": "Name",
            "searchable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "textbox",
                "label": "Name",
                "class": "textbox"
            }
        },
        "vlocUrl": {
            "name": "Target URL",
            "editoptions": {
                "type": "textbox",
                "label": "Target URL",
                "class": "textbox"
            }
        },
        "file_id": {
            "name": "Image",
            "sortable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "file",
                "label": "Image",
                "class": "file",
"hint":"Ideal size 1366 x 500. Allowed file types are jpg,jpeg,gif and png."
            },
            "external": "true",
            "externalOptions": {
                "externalTable": "tbl_files",
                "externalColumn": "file_id",
                "externalShowColumn": "file_id"
            }
        },
        "nDate": {
            "name": "Added Date",
            "dbFormat": "date",
            "displayFormat": "m/d/Y"
        },
        "vLocation": {
            "name": "Location",
            "searchable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": {
                    "Home": "Home Page",
                    "Sub": "Sub Page"
                },
                "source_type": "array",
                "label": "Location",
                "class": "select",
                "hint":"Location where the banner shows, either home page or inner pages",
                "enumvalues": {
                    "Home": "Home Page",
                    "Sub": "Sub Page"
                }
            }
        },
        "vActive": {
            "name": "Status",
            "searchable": "true",
            "editoptions": {
                "validations": [
                    "required"
                ],
                "type": "select",
                "source": {
                    "1": "Active",
                    "0": "Deactive"
                },
                "source_type": "array",
                "label": "Status",
                "class": "select",
                "enumvalues": {
                    "1": "Active",
                    "0": "Deactive"
                }
            },
            "listoptions": {
                "type": "button",
                "customaction": "Cmshelper::changeBannerStatus",
                "enumvalues": {
                    "1": "Active",
                    "0": "In active"
                },
                "buttonColors": {
                    "1": "green",
                    "0": "red"
                }
            }
        }
    },
    "customActions": {
        "beforeEditRecord": "Cmshelper::unsetDateField",
        "afterAddRecord": "Cmshelper::updateBannerAddedDate"
    },
    "opertations": [
        "view",
        "edit",
        "delete",
        "add"
    ]
}
<!-- Banners -->







<!-- Affiliates -->
{
    "keyColumn": "aff_id",
    "detailHeaderColumnPrefix": "Affiliate: ",
    "detailHeaderColumns": [
        "aff_fname"
    ],
    "orderBy": {
        "aff_id": "DESC"
    },
    "listColumns": [
        "aff_fname",
        "aff_email",
        "aff_regdate",
        "amount",
        "settled"
    ],
    "detailColumns": [
        "aff_id",
        "aff_fname",
        "aff_email",
        "aff_regdate",
        "amount",
        "settled"
    ],
    "columns": {
        "aff_id": {
            "name": "ID"
        },
        "aff_fname": {
            "name": "Name",
            "sortable": "true",
            "searchable": "true"
        },
        "aff_email": {
            "name": "Email",
            "sortable": "true",
            "searchable": "true"
        },
        
        "aff_regdate": {
            "name": "Joining Date",
            "dbFormat": "timestamp",
            "displayFormat": "m/d/Y"
        },
        "amount": {
            "name": "Amount",
            "customColumn": "true",
            "customaction": "Cmshelper::getTotalAffilateAmount",
            "listHeaderPostfix": "($)"
        },
        "settled": {
            "name": "Settled",
            "customColumn": "true",
            "customaction": "Cmshelper::getSettledStatus"
        }
        
    },
    "relations": {
        "customer": {
            "name": "Customer",
            "section": "affiliate_customers",
            "child_table": "tbl_affiliate_useraction",
            "parent_join_column": "aff_id",
            "child_join_column": "ua_aff_id"
        }
    },
    
    "opertations": [
        "view"
    ]
}



<!---- -->
"customer": {
    "name": "Customer Count",
    "customColumn": "true",
    "customaction": "Cmshelper::getAffiliateCustomerCount"
}
<!---- -->
<!-- Affiliates -->


<!-- Affiliates Custom -->
{"customAction":"true","controller":"cmshelper","method":"referrals","module":"default"}
<!-- Affiliates Custom -->




<!-- Affiliates User Actions -->
{
    "keyColumn": "ua_id",
    "reference": {
        "referenceTable": " tbl_affiliates",
        "referenceColumn": "ua_aff_id",
        "referenceTableForiegnKey": "aff_id"
    },
    "detailHeaderColumnPrefix": "Customer: ",
    "detailHeaderColumns": [
        "ua_userid"
    ],
    
    "orderBy": {
        "ua_id": "DESC"
    },
    "listColumns": [
        "ua_userid",
        "ua_referalcharge",
        "ua_paystatus",
        "ua_date_settled"
    ],
    "detailColumns": [
        "ua_id",
        "ua_userid",
        "ua_referalcharge",
        "ua_paystatus",
        "ua_date_settled"
    ],
    "columns": {
        "ua_id": {
            "name": "ID"
        },
        "ua_userid": {
            "name": "Customer Name",
            "sortable": "true",
            "searchable": "true",
            "external": "true",
            "externalOptions": {
                "externalTable": "tbl_customers",
                "externalColumn": "nCust_Id",
                "externalShowColumn": "vFirstname"
            }
        },
        "ua_referalcharge": {
            "name": "Referal Charge"
        },

        "ua_date_settled": {
            "name": "Settled Date",
            "dbFormat": "date",
            "displayFormat": "m/d/Y"
        },
        "ua_paystatus": {
            "name": "Status",
            "editoptions": {
                "enumvalues": {
                        "1": "Active",
                        "2": "Inactive"
                }
            }
        }

    },

    "opertations": [
        "view"
    ]
}

<!-- Affiliates User Actions -->
