<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | This page is for user section management. Login checking , new user registration, user listing etc.                                      |
// | File name : index.php                                                  |
// | PHP version >= 5.2                                                   |
// | Created On	: 	Nov 17 2011                                               |
// +----------------------------------------------------------------------+
 // +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2010                                      |
// | All rights reserved                                                  |
// +------------------------------------------------------


class ControllerCustomer extends BaseController
{
     public function init()
     {
        parent::init();

	$this->_common	 	= new ModelCommon();
        $this->_session         = new LibSession();

        //PageContext::addScript('country-state.js');
        PageContext::addJsVar("BASE_URL", BASE_URL);
        PageContext::$response->cancellationStatus = Apputils::fetchSettings("AllowCancel");
	//PageContext::registerPostAction("center-main", "index","customer","default");
        
     	
     }

    /*
    function to load the index template
    */
    public function index()
    {

          
		
    }
    public function editProfile()
    {


         PageContext::$metaTitle   .= 'Profile';

         if(Customer::customerLoginCheck()==false)
         {

                  $this->redirect("home");
         }

         PageContext::$response->editprofileClass = 'active';
         
         
         PageContext::addStyle('signup.css',true);
         PageContext::registerPostAction("center-main", "editProfile","customer","default");
         PageContext::addScript('signup.js');

         $customerDetails = json_decode($this->_session->get('customer'));
         
         
         //btn_create_accout
         
         
         if(PageContext::$request['btn_create_accout']!='' )
         {


             //

                $postedArray      = array();
                $tempErrorMessage = '';

                if(Utils::isEmpty(PageContext::$request['txtFirstName']))
                  $tempErrorMessage .= '* Firstname should not be empty <br />';
                if(Utils::isEmpty(PageContext::$request['txtLastName']))
                  $tempErrorMessage .= '* Lastname  should not be empty <br />';
                if(Utils::isEmpty(PageContext::$request['txtLoginName']))
                  $tempErrorMessage .= '* Loginname should not be empty <br />';
                else if(Utils::isValidUserName(PageContext::$request['txtLoginName'])==false)
                  $tempErrorMessage .= '* Loginname should be valid <br />';

                if(Utils::isEmpty(PageContext::$request['txtEmail']))
                  $tempErrorMessage .= '* Email address should not be empty <br />';
                else if(Utils::validEmail(PageContext::$request['txtEmail'])==false){
                    $tempErrorMessage .= '* Email address should be valid <br />'; }

                if(Utils::isEmpty(PageContext::$request['txtAddress1']))
                  $tempErrorMessage .= '* Address Line1 should not be empty <br />';
                 
                if(Utils::isEmpty(PageContext::$request['txtCountry']))
                  $tempErrorMessage .= '* Country should not be empty <br />';
                if(Utils::isEmpty(PageContext::$request['txtState']))
                  $tempErrorMessage .= '* State should not be empty <br />';
                if(Utils::isEmpty(PageContext::$request['txtCity']))
                  $tempErrorMessage .= '* City should not be empty <br />';
                if(Utils::isEmpty(PageContext::$request['txtZip']))
                  $tempErrorMessage .= '* Zip should not be empty <br />';


                $postedArray['vLogin']            = PageContext::$request['txtLoginName'];
                $postedArray['vFirstname']        = PageContext::$request['txtFirstName'];
                $postedArray['vLastname']         = PageContext::$request['txtLastName'];
                $postedArray['vEmail']            = PageContext::$request['txtEmail'];
                $postedArray['vAddress1']         = PageContext::$request['txtAddress1'];
                $postedArray['vAddress2']         = PageContext::$request['txtAddress2'];
                $postedArray['vCity']             = PageContext::$request['txtCity'];
                $postedArray['vState']            = PageContext::$request['txtState'];
                $postedArray['vCountry']          = PageContext::$request['txtCountry'];
                $postedArray['vZip']              = PageContext::$request['txtZip'];
                $postedArray['vMobile']           = PageContext::$request['txtMobile'];
                $postedArray['vTelephone']        = PageContext::$request['txtTelephone'];
                $postedArray['vFax']              = PageContext::$request['txtFax'];

                $postedArray                      = Utils::escapeArray($postedArray);

                if($tempErrorMessage=='')
                {
	            Customer::updateCustomerDetails($postedArray,$customerDetails->nCust_Id);
                    
                    $tempErrorMessage                             = '<div class="success01">Profile details updated successfully !</div>';
                    PageContext::$response->messageClass          = 'success';


                }
                else
                {
                    $tempErrorMessage                    = 'Please fill following errors to continue <br /><div class="error01">'.$tempErrorMessage.'</div>';
                    PageContext::$response->messageClass = 'error';
                }

                PageContext::$response->message = $tempErrorMessage;


         }

         $tempDetails = Customer::getCustomerDetails($customerDetails->nCust_Id);
         PageContext::$response->countries = Utils::getCountries(); 
         $countryVal = ($tempDetails[0]->vCountry)?$tempDetails[0]->vCountry:'US';  
         PageContext::$response->states   = Utils::getStatesByCountry($countryVal);  
        
         PageContext::$response->customerDetails=$tempDetails[0]; 

    }
    
    public function changePassword()
    {

        PageContext::$metaTitle   .= 'Change Password';

        if(Customer::customerLoginCheck()==false)
        {

              $this->redirect("home");
        }

         

         PageContext::addStyle('signup.css',true);
         PageContext::registerPostAction("center-main", "changePassword","customer","default");
         PageContext::addScript('signup.js');

         

         PageContext::$response->changePasswordClass = 'active';

        

         $customerDetails = json_decode($this->_session->get('customer'));

         if(PageContext::$request['btn_change_password']!='' )
         {
             
                $postedArray                    = array();
                $tempErrorMessage               = '';

                if(Utils::isEmpty(PageContext::$request['txtOldPassword']))
                  $tempErrorMessage .= '* Please enter your old password <br />';

                if(Utils::isEmpty(PageContext::$request['txtNewPassword']))
                  $tempErrorMessage .= '* Please enter your new password <br />';

                if(Utils::isEmpty(PageContext::$request['txtConfirmPassword']))
                  $tempErrorMessage .= '* Please enter confirm password <br />';


                $postedArray['vPassword']         = md5(PageContext::$request['txtNewPassword']);
                $postedArray                      = Utils::escapeArray($postedArray);
                

                if($tempErrorMessage=='')
                {
                    
                    
                    if(Customer::verifyOldPassword(PageContext::$request['txtOldPassword'])>0 && PageContext::$request['txtNewPassword']==PageContext::$request['txtConfirmPassword'])
                    {
                        Customer::updateCustomerDetails($postedArray,$customerDetails->nCust_Id);
                        
                        $tempErrorMessage                             = '<div class="success01">'.CHANGE_PASSWORD_SUCCESS.'</div>';
       
                        PageContext::$response->messageClass          = 'success01';
                       
                        
                    }

                    else if(Customer::verifyOldPassword(PageContext::$request['txtOldPassword'])==0)
                    {
                        $tempErrorMessage                    = 'Wrong old password <br />';
                        PageContext::$response->messageClass = 'error';
                    }

                    else if(PageContext::$request['txtNewPassword']!=PageContext::$request['txtConfirmPassword'])
                    {
                        $tempErrorMessage                    = 'Wrong confirm password <br />';
                        PageContext::$response->messageClass = 'error';
                    }
                    

                }
                else
                {
                    $tempErrorMessage                    = 'Please fill following errors to continue <br /><div class="warning01">'.$tempErrorMessage.'</div>';
                    PageContext::$response->messageClass = 'error';
                }
                
                PageContext::$response->message = $tempErrorMessage;


         }




    }




    public function logout()
    {

         Logger::info('Customer logout :');

         $this->_session->delete('customer');         
         $this->_session->delete('cart','customer');
         $this->_session->delete('last_booking_details');
         
         $this->redirect("home");

    }

    public function ajaxLogout()
    {
         PageContext::$full_layout_rendering = false;
         $this->view->disableView();
         $this->view->disableLayout();
         Logger::info('Customer logout :');

         $this->_session->delete('customer');
         $this->_session->delete('cart','customer');
         $this->_session->delete('last_booking_details');


         $this->cartPrefix	 = 'customer_cart_';
         $customerDetails        = json_decode($this->_session->get('customer'));
         $this->_cart 		 = new Cart($this->cartPrefix.$customerDetails->nCust_Id);

         $this->_cart->removeItem(54);


         exit();

    }

    



    public function authenticateCustomer($userName,$password,$login_remember_me)
    {
        PageContext::$full_layout_rendering = false;
        $this->view->disableView();
        $this->view->disableLayout();

        $credentials['txtUserName']       = $userName;
        $credentials['txtPassword']       = md5($password);
        $credentials['login_remember_me'] = $login_remember_me;

        
        $status = Customer::doLogin($credentials);

        
        if($status != 1)
        {
            if($status == 404)
               print INVALID_USER_LOGIN_MSG;

             else if($status == 403)
               print INACTIVE_USER_LOGIN_MSG;
        }
        else
        {
            print 1;
        }



        
        exit();


    }


         


public function dashboard()
{

    PageContext::$metaTitle   .= 'Dashboard';
    Logger::info('Preparing customer dashboard :');

    if(Customer::customerLoginCheck())
    {
          //Load needed values
          $this->redirect("customer/orders");
    }
    else
    {
          $this->redirect("login");
    }

         
}

     

public function orders()
{

    PageContext::$metaTitle   .= 'My Orders';

    if(Customer::customerLoginCheck()==false)
    {    
          $this->redirect("home");
    }

    PageContext::$response->ordersClass = 'active';
    
    PageContext::registerPostAction("center-main", "orders","customer","default");

    PageContext::$body_class= 'myorders';
    PageContext::addStyle('myorders.css',true);

    $customerDetails = json_decode($this->_session->get('customer'));

    $customerOrderDetails1 = Customer::getCustomerOrders($customerDetails->nCust_Id);
    $customerOrderDetails2 = Customer::getCustomerExpediaOrders($customerDetails->nCust_Id);

    $customerOrderDetails = array_merge($customerOrderDetails1,$customerOrderDetails2);

    PageContext::$response->customerOrderDetails = $customerOrderDetails;

}

public function saveRatings($locationId,$ratingValue,$reviewTitle,$reviewDescription)
     {  

         PageContext::$full_layout_rendering = false;          
         $this->view->disableLayout();

         $postedArray                        = array();
         $reviewTitle                        = str_replace("'", '', $reviewTitle);
         $customerDetails                    = json_decode($this->_session->get('customer'));
         $postedArray['nCust_Id']            = $customerDetails->nCust_Id;
         $postedArray['nLocation_Id']        = mysql_real_escape_string(htmlentities($locationId));
         $postedArray['nDestination_Id']     = 0;
         $postedArray['nMarks']              = mysql_real_escape_string($ratingValue);
         $postedArray['vFeedbackTitle']      = addslashes(rawurldecode($reviewTitle));
         $postedArray['vFeedback']           = addslashes(rawurldecode($reviewDescription));
         $postedArray['dPosted_Date']        = date('Y-m-d H:i:s',time());
         $postedArray['vRate_Status']        = 'inactive';
         $postedArray['vFeedback_Status']    = 'inactive';

         echo Location::saveLocationRatings($postedArray);
         exit();

     }


     public function passwordRecovery()
     {
         // Meta Data
         Utils::getMetaContents('password_recovery');         
         PageContext::addStyle('signup.css',true);
         PageContext::addJsVar('IMAGE_URL', IMAGE_MAIN_URL);
         PageContext::registerPostAction("center-main", "passwordRecovery","customer","default");
     }
     public function orderSummary($id)
     {
         // Meta Data
         
         $customerDetails = json_decode($this->_session->get('customer'));

        $customerOrderDetails1 = Customer::getCustomerOrders($customerDetails->nCust_Id, $id);
        PageContext::$response->dBooking_Date = $customerOrderDetails1[0]->dBooking_Date;
        PageContext::$response->Arrival_Date = $customerOrderDetails1[0]->Arrival_Date;
        PageContext::$response->checkout_Date = $customerOrderDetails1[0]->checkout_Date;
        PageContext::$response->nRooms = $customerOrderDetails1[0]->room;
        PageContext::$response->bookingstatus = $customerOrderDetails1[0]->bookingstatus;
        PageContext::$response->location = $customerOrderDetails1[0]->vLocation_Name;
        PageContext::$response->accomodation = $customerOrderDetails1[0]->vAt_Name;
        PageContext::$response->adults = $customerOrderDetails1[0]->adult;
        PageContext::$response->children = $customerOrderDetails1[0]->children;
        PageContext::$response->days = $customerOrderDetails1[0]->nNights_Stay;
        PageContext::$response->payType = $customerOrderDetails1[0]->vPayment_Type;
        PageContext::$response->amountPaid = $customerOrderDetails1[0]->paidAmt;

         Utils::getMetaContents('order_summary');         
         PageContext::addStyle('signup.css',true);
         PageContext::addJsVar('IMAGE_URL', IMAGE_MAIN_URL);
         PageContext::registerPostAction("center-main", "orderSummary","customer","default");
         
     }

     public function sendActivationLink()
     {

         PageContext::$full_layout_rendering = false;
         $this->view->disableLayout();
         $this->view->disableView();

         $emailAddress = PageContext::$request['emailAddress'];
         print Customer::generateActivationLink($emailAddress);
         exit();

     }


     public function resetPassword($activationKey)
     {

        PageContext::$metaTitle .= ' : Reset password';
        PageContext::addStyle('signup.css',true);
        PageContext::addJsVar('IMAGE_URL', IMAGE_MAIN_URL);

        PageContext::registerPostAction("center-main", "resetPassword","customer","default");
        PageContext::$response->activationKey = $activationKey;
        PageContext::$response->linkValidity = Customer::isValidActivationLink($activationKey);



    }

     public function regeneratePassword()
     {

         PageContext::$full_layout_rendering = false;
         $this->view->disableLayout();
         $this->view->disableView();

         $activationKey = PageContext::$request['activationKey'];
         $password      = PageContext::$request['password'];          

         print Customer::handleResetPassword($password,$activationKey);
         exit();

     }


    public function contactus( $locationId='' )
    {  
         // Meta Data
         Utils::getMetaContents('contactus');
        
         PageContext::registerPostAction('center-main', 'contactus', 'customer');

         PageContext::addStyle('app.css',true);
         PageContext::addStyle('signup.css',true);
         PageContext::addScript('contact.js');
         PageContext::includePath('recaptcha'); 
         PageContext::$response->contactUs             = home::fetchStaticContent('contactus');
         $destinationId                                = Location::getDestinationId($packageId);
         $packageDetails                               = Location::getPackageDetails($packageId);

         PageContext::$response->selectedDestinationId = $destinationId;
         PageContext::$response->destinations          = Home::fetchPackageDestinations();

         $objSession                                   = new LibSession();
         $customerDetails                              = json_decode($objSession->get('customer'));

         if($locationId > 0){
             $locationDetails = Location::getLocationDetails($locationId);
             PageContext::$response->selectedDestinationId = $locationDetails->nDestination_Id;
             PageContext::$response->subjectFromLocation = 'Interest to know more about '.$locationDetails->vLocation_Name.', '.$locationDetails->destinationName->vDestination_Name;
             PageContext::$response->messageFromLocation = 'I am interested to know more about "'.$locationDetails->vLocation_Name.'"';
         }

        if(PageContext::$response->settings['recaptcha_enable']=='Y'){
            // RECAPTCHA ELEMENT
            PageContext::$response->publickey = (!empty(PageContext::$response->settings['recaptcha_public_key'])) ? PageContext::$response->settings['recaptcha_public_key'] : RECAPTCHA_PUBLICKEY;
            PageContext::$response->privatekey = (!empty(PageContext::$response->settings['recaptcha_private_key'])) ? PageContext::$response->settings['recaptcha_private_key']: RECAPTCHA_PRIVATEKEY ;

            $recaptchaHTML = null;
            $recaptchaError = null;

            if(!empty(PageContext::$response->publickey) && !empty(PageContext::$response->privatekey)) {
                PageContext::$response->recaptchaHTML = recaptcha_get_html(PageContext::$response->publickey, $recaptchaError);
            }
        }
        

         if(PageContext::$request['btn_create_accout'] == 'Send Message'){ 

            $postedArray      = array();
            $contactMessage   = '';

            if(Utils::isEmpty(PageContext::$request['txtName']))
              $contactMessage .= '* Name should not be empty <br />';

            if(Utils::isEmpty(PageContext::$request['txtEmail']))
              $contactMessage .= '* Email address should not be empty <br />';
            else if(Utils::validEmail(PageContext::$request['txtEmail'])==false){
                $contactMessage .= '* Email address should be valid <br />'; }

            if(Utils::isEmpty(PageContext::$request['txtPhone']))
              $contactMessage .= '* Phone should not be empty <br />';

            if(Utils::isEmpty(PageContext::$request['txtSubject']))
              $contactMessage .= '* Subject should not be empty <br />';

           if(Utils::isEmpty(PageContext::$request['cmbContactDestination']))
              $contactMessage .= '* Destination Interested should not be empty <br />';


            /* if(empty($_SESSION['captcha']) || trim(strtolower(PageContext::$request['captcha'])) != $_SESSION['captcha']) {
                    $contactMessage .= '*Invalid security code<br />';

             } */

           if(PageContext::$response->settings['recaptcha_enable']=='Y'){
             $resp = recaptcha_check_answer (PageContext::$response->privatekey,
                                            $_SERVER["REMOTE_ADDR"],
                                            PageContext::$request["recaptcha_challenge_field"],
                                            PageContext::$request["recaptcha_response_field"]);
             $captchaError = $resp->error;

             if(!empty($captchaError)) {
                    $contactMessage .= '*Invalid security code<br />';
             }
           }

            $postedArray['txtName']               = PageContext::$request['txtName'];
            $postedArray['txtEmail']              = PageContext::$request['txtEmail'];
            $postedArray['txtPhone']              = PageContext::$request['txtPhone'];
            $postedArray['txtAlternatePhone']     = PageContext::$request['txtAlternatePhone'];
            $postedArray['txtBestTime']           = PageContext::$request['txtBestTime'];
            $postedArray['drpContactTimeFormat']  = PageContext::$request['drpContactTimeFormat'];
            $postedArray['txtareaAddress']        = PageContext::$request['txtareaAddress'];
            $postedArray['cmbContactDestination'] = PageContext::$request['cmbContactDestination'];
            $postedArray['txtSubject']            = PageContext::$request['txtSubject'];
            $postedArray['txtareaMessage']        = PageContext::$request['txtareaMessage'];

            $postedArray                          = Utils::escapeArray($postedArray);

            
            $destinationName = Destination::getDestinationName(PageContext::$request['cmbContactDestination']);
            $destinationName = $destinationName->vDestination_Name;

            if($contactMessage =='')
            {
                
                $arrReplace = array();

                $arrReplace['mailBody'] .= '<table>';
                $arrReplace['mailBody'] .= '<tr><td width=200>Name</td><td>'.PageContext::$request['txtName'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Email</td><td>'.PageContext::$request['txtEmail'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Phone</td><td>'.PageContext::$request['txtPhone'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Alternate Phone</td><td>'.PageContext::$request['txtAlternatePhone'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Best time to contact you</td><td>'.PageContext::$request['txtBestTime'].' '.PageContext::$request['drpContactTimeFormat'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Address</td><td>'.PageContext::$request['txtareaAddress'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Destination interested in</td><td>'.$destinationName.'</td></tr>';                 
                $arrReplace['mailBody'] .= '<tr><td>Subject</td><td>'.PageContext::$request['txtSubject'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Message</td><td>'.PageContext::$request['txtareaMessage'].'</td></tr>';
                $arrReplace['mailBody'] .= '</table>';

                $saveContactData =  Customer::addContactUs($postedArray);
                
                $mailSend = Utils::sendUserMail(Apputils::fetchSettings('vadmin_email'), "contactus", $arrReplace);
                //Mail Script End
                if($mailSend){

                    $contactMessage                      = '<div class="success01">Your message has been successfully sent!</div>';
                    PageContext::$response->messageClass = 'success';


                    foreach(PageContext::$request as $tempKey =>$tempValue)
                    {
                        PageContext::$request[$tempKey] = '';
                    }

                    foreach(PageContext::$response->customerDetails as $tempKey =>$tempValue)
                    {
                        PageContext::$response->customerDetails[$tempKey] = '';
                    }
                }else{
                    $contactMessage                      = '<div class="warning01">Unable to send mail</div>';
                    PageContext::$response->messageClass = 'error';
                }

            }
            else
            {
                $contactMessage                      = 'Please fill following errors to continue :  <br /><div class="warning01">'.$contactMessage.'</div>';
                PageContext::$response->messageClass = 'error';
            }

            PageContext::$response->message          = $contactMessage;

         }


         $tempDetails = Customer::getCustomerDetails($customerDetails->nCust_Id);
         PageContext::$response->customerDetails = $tempDetails[0];         

         if(PageContext::$request['txtName'] != '')
         {
             PageContext::$response->customerDetails->vFirstname   = PageContext::$request['txtName'];
             PageContext::$response->customerDetails->vEmail       = PageContext::$request['txtEmail'];
             PageContext::$response->customerDetails->vMobile      = PageContext::$request['txtPhone'];
             PageContext::$response->selectedDestinationId         = PageContext::$request['cmbContactDestination'];
             PageContext::$response->customerDetails->vAddress1    = PageContext::$request['txtareaAddress'];

         }

    }



    public function inquiry()
    {  

        // Meta Data
        Utils::getMetaContents('inquiry');
        
         $db                       = new Db();

         $objSession               = new LibSession();
         PageContext::registerPostAction('center-main', 'inquiry', 'customer');

         PageContext::addStyle('app.css',true);
         PageContext::addStyle('signup.css',true);
         PageContext::addScript('inquiry.js');   
         PageContext::includePath('recaptcha');
         
         $customerDetails = json_decode($objSession->get('customer'));

        if(PageContext::$response->settings['recaptcha_enable']=='Y'){
            // RECAPTCHA ELEMENT
            PageContext::$response->publickey = (!empty(PageContext::$response->settings['recaptcha_public_key'])) ? PageContext::$response->settings['recaptcha_public_key'] : RECAPTCHA_PUBLICKEY;
            PageContext::$response->privatekey = (!empty(PageContext::$response->settings['recaptcha_private_key'])) ? PageContext::$response->settings['recaptcha_private_key']: RECAPTCHA_PRIVATEKEY ;

            $recaptchaHTML = null;
            $recaptchaError = null;

            if(!empty(PageContext::$response->publickey) && !empty(PageContext::$response->privatekey)) {
                PageContext::$response->recaptchaHTML = recaptcha_get_html(PageContext::$response->publickey, $recaptchaError);
            }
        }
        

         if(PageContext::$request['btn_create_accout'] != '')
         {

            $postedArray      = array();
            $contactMessage   = '';

            if(Utils::isEmpty(PageContext::$request['txtName']))
              $contactMessage .= '* Name should not be empty <br />';

            if(Utils::isEmpty(PageContext::$request['txtEmail']))
              $contactMessage .= '* Email address should not be empty <br />';
            else if(Utils::validEmail(PageContext::$request['txtEmail'])==false){
                $contactMessage .= '* Email address should be valid <br />'; }

            if(Utils::isEmpty(PageContext::$request['txtPhone']))
              $contactMessage .= '* Phone should not be empty <br />';

            if(Utils::isEmpty(PageContext::$request['txtareaAddress']))
              $contactMessage .= '* Address should not be empty <br />';

            if(Utils::isEmpty(PageContext::$request['txtSubject']))
              $contactMessage .= '* Subject should not be empty <br />';

            if(Utils::isEmpty(PageContext::$request['txtareaMessage']))
              $contactMessage .= '* Message should not be empty <br />';


            /*if(empty($_SESSION['captcha']) || trim(strtolower(PageContext::$request['captcha'])) != $_SESSION['captcha']) {
                    $contactMessage .= '*Invalid security code<br />';
             } */

            if(PageContext::$response->settings['recaptcha_enable']=='Y'){
                 $resp = recaptcha_check_answer (PageContext::$response->privatekey,
                                                $_SERVER["REMOTE_ADDR"],
                                                PageContext::$request["recaptcha_challenge_field"],
                                                PageContext::$request["recaptcha_response_field"]);
                 $error = $resp->error;

                 if(!empty($error)) {
                        $contactMessage .= '*Invalid security code<br />';
                 }
            }


            $postedArray['txtName']               = PageContext::$request['txtName'];
            $postedArray['txtEmail']              = PageContext::$request['txtEmail'];
            $postedArray['txtPhone']              = PageContext::$request['txtPhone'];
            $postedArray['txtareaAddress']        = PageContext::$request['txtareaAddress'];
            $postedArray['txtSubject']            = PageContext::$request['txtSubject'];
            $postedArray['txtareaMessage']        = PageContext::$request['txtareaMessage'];

            $postedArray                          = Utils::escapeArray($postedArray);


            

            if($contactMessage =='')
            {



                $postedArray = array();

                $postedArray['vName']               = PageContext::$request['txtName'];
                $postedArray['vEmail']              = PageContext::$request['txtEmail'];
                $postedArray['vPhone']              = PageContext::$request['txtPhone'];
                $postedArray['vAddress']            = PageContext::$request['txtareaAddress'];
                //$postedArray['txtSubject']          = PageContext::$request['txtSubject'];
                $postedArray['tComments']           = PageContext::$request['txtareaMessage'];
                $postedArray['dPasted_Date']        = date('Y-m-d');
                $postedArray['status']              = '0';

                //dPasted_Date

                //status


                $db->addFields('enquiry', $postedArray);


                $arrReplace = array();

                $arrReplace['mailBody'] .= '<table>';
                $arrReplace['mailBody'] .= '<tr><td width=200>Name</td><td>'.PageContext::$request['txtName'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Email</td><td>'.PageContext::$request['txtEmail'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Phone</td><td>'.PageContext::$request['txtPhone'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Address</td><td>'.PageContext::$request['txtareaAddress'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Subject</td><td>'.PageContext::$request['txtSubject'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Message</td><td>'.PageContext::$request['txtareaMessage'].'</td></tr>';
                $arrReplace['mailBody'] .= '</table>';


                


                Utils::sendUserMail(Apputils::fetchSettings('vadmin_email'), "Inquiry", $arrReplace);

                //Mail Script End

                $contactMessage                      = '<div class="success01">Your message has been successfully sent!</div>';
                PageContext::$response->messageClass = 'success';


                foreach(PageContext::$request as $tempKey =>$tempValue)
                {
                    PageContext::$request[$tempKey] = '';
                }

                foreach(PageContext::$response->customerDetails as $tempKey =>$tempValue)
                {
                    PageContext::$response->customerDetails[$tempKey] = '';
                }




            }
            else
            {
                $contactMessage                      = 'Please fill following errors to continue <br /><div class="warning01">'.$contactMessage.'</div>';
                PageContext::$response->messageClass = 'error';
            }

            PageContext::$response->message          = $contactMessage;

         }


         $tempDetails = Customer::getCustomerDetails($customerDetails->nCust_Id);
         PageContext::$response->customerDetails = $tempDetails[0];





         if(PageContext::$request['txtName'] != '')
         {
             PageContext::$response->customerDetails->vFirstname   = PageContext::$request['txtName'];
             PageContext::$response->customerDetails->vEmail       = PageContext::$request['txtEmail'];
             PageContext::$response->customerDetails->vMobile      = PageContext::$request['txtPhone'];
             PageContext::$response->selectedDestinationId         = PageContext::$request['cmbContactDestination'];
             PageContext::$response->customerDetails->vAddress1    = PageContext::$request['txtareaAddress'];

         }





    }








    public function getUserLoggedInSession($userid=''){ 
        $session = new LibSession();
         if($session->get('admin_logged_in','cms') == 1 ){
             
            $userData = Customer::getCustomerDetails($userid);
            $post['txtUserName'] = $userData[0]->vLogin;
            $post['txtPassword'] = $userData[0]->vPassword;
            Customer::doLoginForCms($post);
        }
        $this->redirect('home');
    }
    
    public function updateAlias() {
        //Cmshelper::updatedestinationAlias('destination','destination_alias','nDestination_Id','vDestination_Name');
        //Cmshelper::updatedestinationAlias('locations','location_alias','nLocation_Id','vLocation_Name');
        //Cmshelper::updateAlias('packages','package_alias','nPackage_Id','vPackage_Title');
        Cmshelper::updateAccomodationupgrade();
    }
     
  


}

?>