<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | This page is for user section management. Login checking , new user registration, user listing etc.                                      |
// | File name : index.php                                                |
// | PHP version >= 5.2                                                   |
// | Created On	: 	Nov 17 2011                                       |
// +----------------------------------------------------------------------+
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2010                                      |
// | All rights reserved                                                  |
// +------------------------------------------------------


class ControllerHome extends BaseController
{
    /*
        construction function. we can initialize the models here
    */
     public function init(){
        PageContext::$response->hideSpotLightDestnationsHeader = FALSE;
        PageContext::$response->hideSpotLightPackageHeader = FALSE;
        PageContext::$response->hideSpotLightLocationsHeader = FALSE;
        PageContext::$response->featured = TRUE;
        PageContext::$response->nonLimit = FALSE;
        PageContext::$response->expediaSearchMode = Search::getExpediaSearchMode();
        parent::init();
        $this->_common          = new ModelCommon();
        PageContext::$includeLatestJquery = true;
        
        PageContext::$body_class= 'home';
        PageContext::addStyle("home.css",TRUE);
        /*PageContext::addScript("jquery.validate.js");
        PageContext::addScript("jquery.metadata.js");
        PageContext::addScript('jquery-ui-timepicker-addon.js');*/
        PageContext::addScript("search.js");
        PageContext::addStyle("jquery-ui-1.8.23.custom.css",true);
        //PageContext::addScript("https://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js");
        //PageContext::addScript("https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js");
        PageContext::addScript("fadeslideshow.js");
        PageContext::addScript("fadeimgs.js");
       
        $search_filter_min_value = Utils::getSettingsData('search_filter_min_value');
        $search_filter_max_value = Utils::getSettingsData('search_filter_max_value');
        PageContext::addJsVar("jq_search_filter_min_value", $search_filter_min_value);
        PageContext::addJsVar("jq_search_filter_max_value", $search_filter_max_value);

        
        
        PageContext::addJsVar("BASE_URL", BASE_URL);
       
        $bannerArray = Home::loadBannerImages(); 

        PageContext::addJsVar("FADE_DURATION", 5000);
        
        $banners      = $bannerArray[0]; 
        define('BANNER_IMAGES',$banners);

        //print_r(BANNER_IMAGES);die;

        if($banners){
            PageContext::addJsVar("BANNER_IMAGES", $banners);

        for($i=0; $i<count($bannerArray[1]); $i++) { 
            if(trim($bannerArray[1][$i]) != '') { 
                $urlCheck = explode("://",$bannerArray[1][$i]);
                if($urlCheck[0]=='http' || $urlCheck[0]=='https') {
                    $bannerUrlArray = $bannerArray[1][$i];
                }else {
                    $bannerUrlArray = PROTOCOL.$bannerArray[1][$i];
                }
            }
            else
                $bannerUrlArray = '';
            
                PageContext::addJsVar("BANNER_URLS_".$i, $bannerUrlArray);
            
        }
        }else{
             PageContext::addJsVar("BANNER_URLS_0", '');
             PageContext::addJsVar("BANNER_IMAGES", 'null');
        }
       
        $staticPageData = Home::fetchStaticContent('homecenter');
        PageContext::$response->staticPageContent = $staticPageData->vContent;  

          PageContext::includePath('html2text');

          $h2t           = new html2text(PageContext::$response->staticPageContent);
          $h2t->set_allowed_tags('<br>');
          PageContext::$response->staticPageContent      = $h2t->get_text();

          PageContext::$response->staticPageTitle   = $staticPageData->vLocation;
        
        PageContext::registerPostAction("center-main", "index","home","default");      
        
     }
     
     /*
    function to load the index template
    */
    public function index(){ 
    	
    	// Affiliate url checking
    	$affId = PageContext::$request['aid'];
    	if($affId != '')
     		Affiliates::setAffiliateCookie($affId);
    	 
    	$affid = Affiliates::getAffiliateCookie();

        // Meta Data
        Utils::getMetaContents('home');
        
    	// affiliate url checking ends
        PageContext::$response->featuredPackages                       = TRUE;
        PageContext::$response->specialOfferBannersEnabled             = FALSE;
        PageContext::$response->destinationDescriptionEnabled          = FALSE;
        PageContext::$response->featuredDestinationEnabled             = FALSE;
        PageContext::$response->featuredLocationEnabled                = FALSE;
        
        PageContext::$response->operation_mode = Apputils::fetchSettings("operation_mode");

       // Based on this 'operation_mode' value system will display home page contents.

        if(PageContext::$response->operation_mode == 1 || PageContext::$response->operation_mode == 2){

            $defaultDestinationId = Search::fetchDefaultDestination();
            $deafultLocationId    = Search::fetchDefaultLocation($defaultDestinationId);

            if($deafultLocationId == '')
            {
               PageContext::$response->noContent = HOME_MSG_NO_ACTIVE_LOCATION;             
            }            
            PageContext::$response->homepage="true";
            PageContext::addPostAction("featuredlocations", "home", "default");
        }

        else if(PageContext::$response->operation_mode == 3){

          if(Search::fetchDefaultDestination() == '')
             PageContext::$response->noContent = HOME_MSG_NO_ACTIVE_DESTINATION;
          PageContext::$response->homepage="true";
          PageContext::addPostAction("featureddestinations", "home", "default");
          PageContext::addPostAction("featuredlocations", "home", "default");
          
        }

        PageContext::addPostAction("featuredpackages", "home", "default");
        $specialOfferArray = Home::fetchSpecialOfferBanners();

        $specialOfferFile       = $specialOfferArray[0];
        $specialOfferLocationId =  $specialOfferArray[1];
        $specialOfferlocation_alias = $specialOfferArray[2];

        if($specialOfferFile)
        {
            PageContext::$response->specialOfferBannersEnabled = TRUE;
            PageContext::$response->specialOfferImage          = $specialOfferFile;
            PageContext::$response->specialOfferLocationId     = $specialOfferLocationId;
            PageContext::$response->location_alias     = $specialOfferlocation_alias;
        }
            
        $locations   = Search::fetchLocations();
        if(count($locations)>0)
        {
            PageContext::$response->locations = $locations;
        }
        
        $destinations = Search::fetchDestinations();
        if(count($destinations)>0)
        {
            PageContext::$response->destinations = $destinations;
        }
       
    }

    /* Function to load featured destinations*/
    public function featureddestinations() {


        if(PageContext::$response->operation_mode == 1 || PageContext::$response->operation_mode == 2) {
            $destinationDetails = Home::fetchActiveDestinationDescription();

            PageContext::$response->destinationDescriptionEnabled = TRUE;
            PageContext::$response->destinationDetails            = $destinationDetails;
        }
        else {

            PageContext::$response->featuredDestinationEnabled = TRUE; 

            $featuredDestinations = Home::fetchFeaturedDestinations(PageContext::$response->featured);

            if(count($featuredDestinations)>0) {
                PageContext::$response->featuredDestinations       = $featuredDestinations;
            }
            else {
                PageContext::$response->noContent                  = HOME_MSG_NO_ACTIVE_DESTINATION;
            }
        }
    }


    /* Function to load featured packages*/
    public function featuredpackages() {

        $firstDestinationId = 0;

        if(PageContext::$response->operation_mode == 1 || PageContext::$response->operation_mode == 2) {
            $firstDestinationId = Search::fetchDefaultDestination();
        }

        $featuredPackages = Home::fetchFeaturedPackages(PageContext::$response->featuredPackages,$firstDestinationId);

        if(count($featuredPackages)>0) {
            PageContext::$response->featuredPackagesEnabled = TRUE;
            PageContext::$response->featuredPackages        = $featuredPackages;
        }
    }
    
    /* Function to load featured packages details*/
    public function featuredpackagesdetails(){
        if(PageContext::$response->package_id && PageContext::$response->package_id!= ''){
            Home::fetchFeaturedPackagesDetails(PageContext::$response->package_id);
        }
           
    }

  

    public function featuredpackagescontactus($method,$packageId){
 
        PageContext::addStyle('app.css',true);
        PageContext::addStyle('signup.css',true);
        PageContext::addScript('contact.js');
        $db               = new Db();
        $getpackage       = $db->selectResult('packages','nPackage_Id'," package_alias='$package'");
        $packageId        = $getpackage[0]->nPackage_Id;

         $destinationId   = Location::getDestinationId($packageId);
         $packageDetails  = Location::getPackageDetails($packageId);
         $destinationName = Destination::getDestinationName($destinationId);
         $destinationName = $destinationName->vDestination_Name;

         PageContext::$response->selectedDestinationId = $destinationId;

         PageContext::$response->destinations = Home::fetchPackageDestinations();


         $objSession               = new LibSession();
         $customerDetails = json_decode($objSession->get('customer'));


         if(PageContext::$request['btn_create_accout'] == 'Send Message')
         {          

            $postedArray      = array();
            
            $contactMessage   = '';

            if(Utils::isEmpty(PageContext::$request['txtName']))
              $contactMessage .= '* Name should not be empty <br />';

            if(Utils::isEmpty(PageContext::$request['txtEmail']))
              $contactMessage .= '* Email address should not be empty <br />';
            else if(Utils::validEmail(PageContext::$request['txtEmail'])==false){
                $contactMessage .= '* Email address should be valid <br />'; }

            if(Utils::isEmpty(PageContext::$request['txtPhone']))
              $contactMessage .= '* Phone should not be empty <br />';

            if(Utils::isEmpty(PageContext::$request['txtSubject']))
              $contactMessage .= '* Subject should not be empty <br />';

           if(Utils::isEmpty(PageContext::$request['cmbContactDestination']))
              $contactMessage .= '* Destination Interested should not be empty <br />';


            if(empty($_SESSION['captcha']) || trim(strtolower(PageContext::$request['captcha'])) != $_SESSION['captcha']) {
                    $contactMessage .= '*Invalid security code<br />';

             }




            $postedArray['txtName']               = PageContext::$request['txtName'];
            $postedArray['txtEmail']              = PageContext::$request['txtEmail'];
            $postedArray['txtPhone']              = PageContext::$request['txtPhone'];
            $postedArray['txtAlternatePhone']     = PageContext::$request['txtAlternatePhone'];
            $postedArray['txtBestTime']           = PageContext::$request['txtBestTime'];
            $postedArray['txtareaAddress']        = PageContext::$request['txtareaAddress'];
            $postedArray['cmbContactDestination'] = PageContext::$request['cmbContactDestination'];
            $postedArray['txtSubject']            = PageContext::$request['txtSubject'];
            $postedArray['txtareaMessage']        = PageContext::$request['txtareaMessage'];
            
            $postedArray                          = Utils::escapeArray($postedArray);

            if($contactMessage =='')
            {
                //Customer::updateCustomerDetails($postedArray,$customerDetails->nCust_Id);
                //Mail Script
                
                $arrReplace = array();

                $arrReplace['mailBody'] .= '<table>';
                $arrReplace['mailBody'] .= '<tr><td width=200>Name</td><td>'.PageContext::$request['txtName'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Email</td><td>'.PageContext::$request['txtEmail'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Phone</td><td>'.PageContext::$request['txtPhone'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Alternate Phone</td><td>'.PageContext::$request['txtAlternatePhone'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Best time to contact you</td><td>'.PageContext::$request['txtBestTime'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Address</td><td>'.PageContext::$request['txtareaAddress'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Destination interested in</td><td>'.$destinationName.'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Package interested in</td><td>'.stripslashes($packageDetails->vPackage_Title).'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Subject</td><td>'.PageContext::$request['txtSubject'].'</td></tr>';
                $arrReplace['mailBody'] .= '<tr><td>Message</td><td>'.PageContext::$request['txtareaMessage'].'</td></tr>';
                $arrReplace['mailBody'] .= '</table>';




                if(ENVIRONMENT !='LOCAL')
                Utils::sendUserMail(Apputils::fetchSettings('vadmin_email'), 'PackageInquiry', $arrReplace);

                //Mail Script End
                
                $contactMessage                      = '<div class="success01">Your message has been successfully sent!</div>';
                PageContext::$response->messageClass = 'success';


                foreach(PageContext::$request as $tempKey =>$tempValue)
                {
                    PageContext::$request[$tempKey] = '';
                }

                foreach(PageContext::$response->customerDetails as $tempKey =>$tempValue)
                {
                    PageContext::$response->customerDetails[$tempKey] = '';
                }

            }
            else
            {
                $contactMessage                      = 'Please fill following errors to continue <br /><div class="warning01">'.$contactMessage.'</div>';
                PageContext::$response->messageClass = 'error';
            }
    
            PageContext::$response->message          = $contactMessage;
             
         }


         $tempDetails = Customer::getCustomerDetails($customerDetails->nCust_Id);
         PageContext::$response->customerDetails = $tempDetails[0];


         if(PageContext::$request['txtName'] != '')
         {
             PageContext::$response->customerDetails->vFirstname   = PageContext::$request['txtName'];
             PageContext::$response->customerDetails->vEmail       = PageContext::$request['txtEmail'];
             PageContext::$response->customerDetails->vMobile      = PageContext::$request['txtPhone'];
             PageContext::$response->selectedDestinationId         = PageContext::$request['cmbContactDestination'];
             PageContext::$response->customerDetails->vAddress1    = PageContext::$request['txtareaAddress'];

         }
    }
    
    /* Function to load featured locations*/
    public function featuredlocations() {  

        if(PageContext::$response->operation_mode == 1) {
            $featuredLocations = Home::fetchFeaturedLocations(TRUE,FALSE,PageContext::$response->firstDestinationId,1,PageContext::$response->operation_mode);
        }
        else
            $featuredLocations = Home::fetchFeaturedLocations(TRUE,TRUE,PageContext::$response->firstDestinationId,'',PageContext::$response->operation_mode,PageContext::$response->pathFrom);
           
        if(count($featuredLocations)>0) {
            PageContext::$response->featuredLocationEnabled = TRUE;
            PageContext::$response->featuredlocations       = $featuredLocations;
        }
    }
    public function embedAjax(){
        
        //PageContext::addScript("search.js");
        PageContext::$response->operation_mode = Apputils::fetchSettings("operation_mode");
        PageContext::$response->embed_label = Apputils::fetchSettings("embed_label");
        PageContext::$response->embed_bg_color = Apputils::fetchSettings("embed_bg_color");
        PageContext::$response->embed_div_id = Apputils::fetchSettings("embed_div_id");
        PageContext::$response->embed_display_style = Apputils::fetchSettings("embed_display_style");
        PageContext::$response->embed_url = Apputils::fetchSettings("embed_url");
        PageContext::$response->embed_color = Apputils::fetchSettings("embed_color");
        PageContext::$response->embed_new_tab = Apputils::fetchSettings("embed_new_tab");
        PageContext::$response->embed_operation_mode = Apputils::fetchSettings("embed_operation_mode");

        $embed = "";
        
       $destinations = Search::fetchDestinations();       
       $scrpts = '<script type="text/javascript">$(function(){function e(e){var t=document.createElement("link");t.type="text/css",t.rel="stylesheet",t.href=e,document.getElementsByTagName("head")[0].appendChild(t)}e("//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css")});</script>';
       $styleCode = $scrpts."<style type=\"text/css\">.navbar-form .form-group {display: inline-block;margin-bottom: 0;vertical-align: middle;}.navbar-form .form-control {display: inline-block;vertical-align: middle; width: auto;border: 1px solid #ccc;border-radius: 4px;box-shadow: 0 1px 1px rgba(0, 0, 0, 0.075) inset; height: 34px;line-height: 1.42857;padding: 6px 12px;transition: border-color 0.15s ease-in-out 0s, box-shadow 0.15s ease-in-out 0s; box-sizing: border-box;margin-left:10px;}</style>";
       if(PageContext::$response->embed_display_style==1){
            $newline = '<div style="clear:both;"></div>';
            $marginStyle = 'style="margin-top:10px;"';
       }
       else $newline = "";
       $embed =  '<form action='.BASE_URL.'search class="navbar-form" method="post" id="jqhomeSearch" >';
       if( PageContext::$response->embed_operation_mode=="3"){          
         $embed .=  '<div class="form-group"><select name="jqSearchDestination" id="jqSearchDestination" class="form-control" required><option value="">Destination</option>';
            foreach($destinations as $destination) {
               $embed .=  '<option value="'.$destination->nDestination_Id.'">'.$destination->vDestination_Name.'</option>';  
           }
          $embed .='</select></div>'.$newline;
       }
       $datetime = new DateTime('tomorrow');
       $embed .='<div class="form-group"><input name="jqSearchStartDate" id="jqSearchStartDate" '.$marginStyle.'class="form-control" type="text"  readonly="true" placeholder="Checkin Date" required value="'.date("m/d/Y").'"></div></div><div class="form-group"><input name="jqSearchEndDate" id="jqSearchEndDate" type="text" class="form-control" readonly="true" placeholder="Checkout Date" value="'.$datetime->format('m/d/Y').'" '.$marginStyle.'></div>'.$newline.'<div class="form-group"><div class="form-group"><select name="jqGuestCount" id="jqGuestCount" class="form-control" '.$marginStyle.' required><option value="">Adults</option>';
            for($i=1;$i<= 10;$i++) {
                 $embed .= '<option value="'.$i.'">'.$i.'</option>';
            }                      
       $embed .='</select></div><div class="form-group"><select name="jqGuestChildrenCount" id="jqGuestChildrenCount" class="form-control" '.$marginStyle.'><option value="">Children</option>';
            for($i=1;$i<= 10;$i++) { 
                $embed .= '<option value="'.$i.'">'.$i.'</option>';
            }
        $embed .='</select></div><div class="form-group"><select name="jqNumberOfRooms" id="jqNumberOfRooms" class="form-control" required '.$marginStyle.'><option value="">Room</option>';
            for($i=1;$i<= 10;$i++) { 
                    $embed .= '<option value="'.$i.'">'.$i.'</option>';
                }
                $colorText = NULL;
                if(PageContext::$response->embed_bg_color) $colorText ='background-color:'.PageContext::$response->embed_bg_color.";";                
                if(PageContext::$response->embed_color) $colorText .= 'color:'.PageContext::$response->embed_color.';';;
               
                if($colorText && !$marginStyle) $colorText = "style=\"".$colorText."\"";
                else  if($colorText)  $marginStyle = "style=\"margin-top:10px;".$colorText."\""; 
                
                $embed .='</select></div>'.$newline.'<input name="jqSearchLocations" id="jqSearchLocations" '.$marginStyle.' type="submit" class="btn btn-default red_btn form-control" value="'. PageContext::$response->embed_label.'"></form>';
         $embedCode = $styleCode.$embed.'<script type="text/javascript">$(function(){function e(e){var a=document.createElement("script");a.type="text/javascript",a.async=!1,a.src=e,a.onload=t,(document.getElementsByTagName("head")[0]||document.getElementsByTagName("body")[0]).appendChild(a)}function t(){$("#jqSearchEndDate").datepicker(),$("#jqSearchStartDate").datepicker()}e("//code.jquery.com/ui/1.11.4/jquery-ui.js")});</script>';
             echo "$('#".PageContext::$response->embed_div_id."').html('$embedCode');";exit;
          
        
    }
    public function updateAliasName(){
        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
       $package         =  Home::updateAlias('packages', 'package_alias', 'nPackage_Id', 'vPackage_Title');
       $destination     =  Home::updateAlias('destination', 'destination_alias', 'nDestination_Id', 'vDestination_Name');
       $location        =  Home::updateAlias('locations', 'location_alias', 'nLocation_Id', 'vLocation_Name');
       $updateMaxGuest  =  Home::updateAccomodationupgrade();
       echo "File Updated successfully" ;exit;
       
    }
    

}

?>