INSERT INTO `cms_groups` (`id`, `group_name`, `position`, `published`, `user_privilege`) VALUES
(3, 'Configurations', 6, 1, 's'),
(1, 'General', 1, 1, 'all'),
(4, 'Site Setup', 2, 1, 'all'),
(5, 'Reports', 4, 1, 'all'),
(6, 'Contents', 5, 1, 'all'),
(7, 'Admin Setup', 3, 1, 'all');


INSERT INTO `cms_roles` (`role_id`, `role_name`, `parent_role_id`) VALUES
(1, 'Admin', 0);


INSERT INTO `cms_sections` (`id`, `group_id`, `section_name`, `section_alias`, `table_name`, `section_config`, `visibilty`, `display_order`, `user_privilege`) VALUES
(1, 3, 'Manage Groups', 'groups', 'cms_groups', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"publishColumn":"published",\r\n"listColumns":["id","group_name","user_privilege"],\r\n"showColumns":["id","group_name","position","user_privilege"],\r\n"detailColumns":["id","group_name","position","user_privilege"],\r\n"detailHeaderColumns":["group_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","searchable":"searchable","editoptions":{"type":"hidden"}},\r\n    "group_name":{"name":"Group Name","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Group Name","class":"textbox"}},\r\n    "position":{"name":"Display Order","sortable":"true","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}},\r\n    "user_privilege":{"name":"Privilege","sortable":"true","searchable":"searchable","editoptions":{"type":"select","source":{"all":"All","s":"Superadmin"},"source_type":"array","label":"Privilege","class":"select","enumvalues":{"all":"All","s":"Superadmin"}}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 2, 'dev'),
(2, 3, 'Manage Sections', 'sections', 'cms_sections', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"listColumns":["group_id","section_name","section_alias","visibilty","display_order"],\r\n"showColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailHeaderColumns":["section_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "group_id":{"name":"Group ID","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"select","source":"Cms::getAllGroups","source_type":"function","label":"Group Name","class":"select"},"external":"true","externalOptions":{"externalTable":"cms_groups","externalColumn":"id","externalShowColumn":"group_name"}},\r\n    "section_name":{"name":"Section Name","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Name","class":"textbox"}},\r\n    "section_alias":{"name":"Section Alias","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Alias","class":"textbox"}},\r\n    "table_name":{"name":"Table Name","editoptions":{"validations":["required"],"type":"textbox","label":"Table Name","class":"textbox"}},\r\n    "section_config":{"name":"Section Config","editoptions":{"validations":["required"],"type":"textarea","label":"Section Config","class":"textarea"}},\r\n    "visibilty":{"name":"Make Visible","sortable":"true","searchable":"searchable","editoptions":{"type":"checkbox","label":"Make Visible","class":"inline","default":"yes","enumvalues":{"1":"Visible","0":"Invisible"}}},\r\n    "display_order":{"name":"Display Order","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 3, 'dev'),
(3, 3, 'Manage Settings', 'manage_settings', 'tbl_cms_settings', '{\r\n"keyColumn":"id",\r\n"listColumns":["cms_set_name","cms_set_value"],\r\n"showColumns":["cms_set_name","cms_set_value"],\r\n"detailColumns":["id","cms_set_name","cms_set_value"],\r\n"detailHeaderColumns":["cms_set_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "cms_set_name":{"name":"Name","sortable":"true","searchable":"searchable","editoptions":{"type":"disabled","label":"Name"}},\r\n    "cms_set_value":{"name":"Value","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Value","class":"textbox"}}\r\n},\r\n"opertations":["edit","view"]\r\n}', '1', 1, 'dev'),
(4, 4, 'Settings', 'settings', 'tbl_lookup', '{"customAction":"true","controller":"cmshelper","method":"settingsdisplay","module":"default"}\r\n', '1', 1, 'all'),
(5, 4, 'Destinations', 'destination', 'tbl_destination', '{\r\n    "keyColumn": "nDestination_Id",\r\n"breadCrumbColumn":"vDestination_Name",\r\n     "detailHeaderColumnPrefix": "Destination: ",\r\n    "detailHeaderColumns": [\r\n        "vDestination_Name"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nDestination_Id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vDestination_Name",\r\n        "tDestination_Description",\r\n        "vStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nDestination_Id",\r\n        "vDestination_Name",\r\n        "tDestination_Description",\r\n        "file_id",\r\n        "vStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nDestination_Id",\r\n        "vDestination_Name",\r\n        "tDestination_Description",\r\n        "file_id",\r\n        "vStatus"\r\n    ],\r\n    "columns": {\r\n        "nDestination_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vDestination_Name": {\r\n            "name": "Destination",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Destination",\r\n                "class": "textbox"\r\n            },\r\n "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getDestinationPopupUrlDestinationLink"\r\n            }\r\n        },\r\n        "tDestination_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "nDestination_Price": {\r\n            "name": "Starting Price",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Starting price for flash header",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Current Image",\r\n            "editoptions": {\r\n                "type": "file",\r\n                "label": "Current Image",\r\n                "class": "file",\r\n"hint":"Ideal image size 120 x 112"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "vStatus": {\r\n            "name": "Status",\r\n  "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n"listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeDestinationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "relations": {\r\n        "destination_location_tag": {\r\n            "name": "Locations",\r\n            "section": "destination_location_tag",\r\n            "child_table": "tbl_locations",\r\n            "parent_join_column": "nDestination_Id",\r\n            "child_join_column": "nDestination_Id"\r\n        },\r\n        "destination_package_tag": {\r\n            "name": "Packages",\r\n            "section": "destination_package_tag",\r\n            "child_table": "tbl_packages",\r\n            "parent_join_column": "nDestination_Id",\r\n            "child_join_column": "nDestination_Id"\r\n        },\r\n        "destination_gallery_tag": {\r\n            "name": "Gallery",\r\n            "section": "destination_gallery_tag",\r\n            "child_table": "tbl_gallery",\r\n            "parent_join_column": "nDestination_Id",\r\n            "child_join_column": "nDestination_Id"\r\n        }\r\n    },\r\n"customActions":{"afterAddRecord":"Cmshelper::moveDestinationImagefiles","afterEditRecord":"Cmshelper::moveDestinationImagefiles"},\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "customdelete",\r\n        "add"\r\n    ],\r\n"customDeleteOperation":"Cmshelper::deleteDestination"\r\n}', '1', 3, 'all'),
(6, 4, 'Locations', 'location', 'tbl_locations', '{\r\n    "keyColumn": "nLocation_Id",\r\n    "includeJsFiles": [\r\n        "cms_location.js"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nLocation_Id": "DESC"\r\n    },\r\n    "breadCrumbColumn": "vLocation_Name",\r\n    "detailHeaderColumnPrefix": "Location: ",\r\n    "detailHeaderColumns": [\r\n        "vLocation_Name"\r\n    ],\r\n    "listColumns": [\r\n        "vLocation_Name",\r\n        "nDestination_Id",\r\n        "vFeatured",\r\n        "vActive",\r\n        "Promote"\r\n    ],\r\n    "detailColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAddress",\r\n        "vCity",\r\n        "vZip",\r\n        "vCountry",\r\n        "vState",\r\n        "nStartingPrice",\r\n        "vFeatured",\r\n        "vActive",\r\n        "vAmenities",\r\n        "Promote"\r\n    ],\r\n    "showColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAddress",\r\n        "vCity",\r\n        "vZip",\r\n        "vCountry",\r\n        "vState",\r\n        "nStartingPrice",\r\n        "vFeatured",\r\n        "vActive",\r\n        "vAmenities"\r\n    ],\r\n    "columns": {\r\n        "nLocation_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vLocation_Name": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Location",\r\n                "class": "textbox"\r\n            },\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getLocationPopupUrlLocationLink"\r\n            }\r\n        },\r\n        "nDestination_Id": {\r\n            "name": "Destination",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllDestinations",\r\n                "source_type": "function",\r\n                "label": "Destination",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            },\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getDestinationPopupUrlLocationLink"\r\n            }\r\n        },\r\n        "vLocation_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Overview",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vAmenities": {\r\n            "name": "Amenities",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Amenities",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vAddress": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textarea",\r\n                "label": "Address",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vCity": {\r\n            "name": "City",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vState": {\r\n            "name": "State",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllStates",\r\n                "source_type": "function",\r\n                "label": "State",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "vZip": {\r\n            "name": "Zip",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCountry": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllCountries",\r\n                "source_type": "function",\r\n                "label": "Country",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "nStartingPrice": {\r\n            "name": "StartingPrice",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "StartingPrice",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        },\r\n        "vFeatured": {\r\n            "name": "Featured",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Featured",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationFeaturedStatus",\r\n                "enumvalues": {\r\n                    "Yes": "Featured",\r\n                    "No": "NotFeatured"\r\n                },\r\n                "buttonColors": {\r\n                    "Yes": "green",\r\n                    "No": "red"\r\n                }\r\n            }\r\n        },\r\n        "Promote": {\r\n            "name": "Publish",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::displayPromoteLink"\r\n        }\r\n    },\r\n    "relations": {\r\n        "location_offer_tag": {\r\n            "name": "SpecialOffers",\r\n            "section": "location_offer_tag",\r\n            "child_table": "tbl_special_offers",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        },\r\n        "location_gallery_tag": {\r\n            "name": "Gallery",\r\n            "section": "location_gallery_tag",\r\n            "child_table": "tbl_gallery",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        },\r\n        "location_accomodation_tag1": {\r\n            "name": "Accommodations",\r\n            "section": "location_accomodation_tag1",\r\n            "child_table": "tbl_available_acco_type",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        },\r\n        "location_review_tag": {\r\n            "name": "Reviews",\r\n            "section": "location_review_tag",\r\n            "child_table": "tbl_rating",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::mapLatLong",\r\n        "afterEditRecord": "Cmshelper::mapLatLong"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '1', 4, 'all'),
(9, 6, 'Help Category', 'help_category', 'tbl_HelpCategory', '{\r\n    "keyColumn": "hcid",\r\n"detailHeaderColumns":["hcid"],\r\n    "orderBy": {\r\n        "hcid": "ASC"\r\n    },\r\n    "listColumns": [\r\n        \r\n        "htype",\r\n        "hctitle",\r\n        "hcposition",\r\n        "active"\r\n    ],\r\n    "showColumns": [\r\n        "hcid",\r\n        "htype",\r\n        "hctitle",\r\n        "hcposition",\r\n        "active"\r\n    ],\r\n    "detailColumns": [\r\n        "hcid",\r\n        "htype",\r\n        "hctitle",\r\n        "hcposition",\r\n        "active"\r\n    ],\r\n    "columns": {\r\n        "hcid": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n               \r\n            }\r\n        },\r\n        "htype": {\r\n            "name": "User Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "admin": "Admin",\r\n                    "client": "Client"\r\n                },\r\n                "source_type": "array",\r\n                "label": "User Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "admin": "Admin",\r\n                    "client": "Client"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hctitle": {\r\n            "name": "Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hcposition": {\r\n            "name": "Sort Order",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Sort Order",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 5, 'all'),
(7, 6, 'Static Content', 'static_content', 'tbl_content', '{\r\n    "keyColumn": "nContent_Id",\r\n    "detailHeaderColumns": [\r\n        "display_title"\r\n    ],\r\n    "orderBy": {\r\n        "nContent_Id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vLocation",\r\n        "vContent"\r\n    ],\r\n    "showColumns": [\r\n        "nContent_Id",\r\n        "vLocation",\r\n        "vContent"\r\n    ],\r\n    "detailColumns": [\r\n        "nContent_Id",\r\n        "vLocation",\r\n        "vContent"\r\n    ],\r\n    "columns": {\r\n        "nContent_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vLocation": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vContent": {\r\n            "name": "Content",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit",\r\n        "view"\r\n    ]\r\n}', '1', 4, 'all'),
(8, 1, 'Inquiries', 'enquiries', 'tbl_enquiry', '{\r\n    "keyColumn": "nEnq_Id",\r\n    "orderBy": {\r\n        "dPasted_Date": "DESC"\r\n    },\r\n    "detailHeaderColumns": [\r\n        "nEnq_Id"\r\n    ],\r\n    "listColumns": [\r\n        "vName",\r\n        "dPasted_Date",\r\n        "tComments",\r\n"status"\r\n    ],\r\n    "showColumns": [\r\n        "nEnq_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n"status",\r\n        "dPasted_Date"\r\n    ],\r\n    "detailColumns": [\r\n        "nEnq_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n        "dPasted_Date",\r\n        "tComments",\r\n"status"\r\n    ],\r\n    "columns": {\r\n        "nEnq_Id": {\r\n            "name": "ID",\r\n            "sortable": "true"\r\n        },\r\n"status" :{\r\n"name" :"Status",\r\n"customColumn": "true",\r\n                "customaction": "Cmshelper::getInquiryReplyPopupUrl"\r\n},\r\n        "vName": {\r\n            "name": "Customer",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getInquiryUserPopupUrl"\r\n            }\r\n        },\r\n        "vPhone": {\r\n            "name": "Phone"\r\n        },\r\n        "vEmail": {\r\n            "name": "Email",\r\n            "searchable": "searchable"\r\n        },\r\n        "vAddress": {\r\n            "name": "Address"\r\n        },\r\n        "tComments": {\r\n            "name": "Inquiry"\r\n        },\r\n        "dPasted_Date": {\r\n            "name": "Posted Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "delete"\r\n    ]\r\n}', '1', 4, 'all'),
(10, 6, 'Help Content', 'help_content', 'tbl_Help', '{\r\n    "keyColumn": "hid",\r\n"detailHeaderColumns":[ "hid"],\r\n    "orderBy": {\r\n        "hid": "ASC"\r\n    },\r\n    "listColumns": [\r\n     \r\n        "hcid",\r\n        "htitle",\r\n        "hdescription",\r\n        "hposition",\r\n        "active"\r\n    ],\r\n    "showColumns": [\r\n         "hid",\r\n        "hcid",\r\n        "htitle",\r\n        "hdescription",\r\n        "hposition",\r\n        "active"\r\n    ],\r\n    "detailColumns": [\r\n        "hid",\r\n        "hcid",\r\n        "htitle",\r\n        "hdescription",\r\n        "hposition",\r\n        "active"\r\n    ],\r\n    "columns": {\r\n        "hid": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n                \r\n            }\r\n        },"hcid": {\r\n           "name": "Category",\r\n           "sortable": "true",\r\n           "searchable": "true",\r\n           "editoptions": {\r\n               "validations": [\r\n                   "required"\r\n               ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllHelpCategories",\r\n                "source_type": "function",\r\n                "label": "Category",\r\n                "class": "select"\r\n           },\r\n           "external": "true",\r\n           "externalOptions": {\r\n               "externalTable": "tbl_HelpCategory",\r\n               "externalColumn": "hcid",\r\n               "externalShowColumn": "hctitle"\r\n           }\r\n       },\r\n        "htitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                \r\n                \r\n                "label": "Title",\r\n                "class": "textbox",\r\n                \r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hdescription": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hposition": {\r\n            "name": "Sort Order",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Sort Order",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 12, 'all'),
(11, 1, 'Locations', 'destination_location_tag', 'tbl_locations', '{\r\n    "keyColumn": "nLocation_Id",\r\n    "detailHeaderColumnPrefix": "Location: ",\r\n    "detailHeaderColumns": [\r\n        "vLocation_Name"\r\n    ],\r\n    "reference": {\r\n        "referenceTable": " tbl_destination",\r\n        "referenceColumn": "nDestination_Id",\r\n        "referenceTableForiegnKey": "nDestination_Id"\r\n    },\r\n    "orderBy": {\r\n        "nDestination_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAddress",\r\n        "vActive",\r\n        "vFeatured"\r\n    ],\r\n    "showColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAmenities",\r\n        "vAddress",\r\n        "vCity",\r\n"vZip",\r\n        "vState",\r\n        \r\n        "vCountry",\r\n        "nStartingPrice",\r\n        "vActive",\r\n        "vFeatured"\r\n    ],\r\n    "detailColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAmenities",\r\n        "vAddress",\r\n        "vCity",\r\n  "vZip",\r\n        "vState",\r\n      \r\n        "vCountry",\r\n        "nStartingPrice",\r\n        "vActive",\r\n        "vFeatured"\r\n    ],\r\n    "columns": {\r\n        "nLocation_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vLocation_Name": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Location",\r\n                "class": "textbox"\r\n            },\r\n "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getLocationPopupUrlLocationLink"\r\n            }\r\n        },\r\n        "nDestination_Id": {\r\n            "name": "Destination",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            }\r\n        },\r\n        "vLocation_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Overview",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vAmenities": {\r\n            "name": "Amenities",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Amenities",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vAddress": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textarea",\r\n                "label": "Address",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vCity": {\r\n            "name": "City",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vState": {\r\n            "name": "State",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllStates",\r\n                "source_type": "function",\r\n                "label": "State",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "vZip": {\r\n            "name": "Zip",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCountry": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllCountries",\r\n                "source_type": "function",\r\n                "label": "Country",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "nStartingPrice": {\r\n            "name": "Starting Price",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Starting Price",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        },\r\n        "vFeatured": {\r\n            "name": "Featured",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Is  Featured",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationFeaturedStatus",\r\n                "enumvalues": {\r\n                    "Yes": "Featured",\r\n                    "No": "Nonfeatured"\r\n                },\r\n                "buttonColors": {\r\n                    "Yes": "green",\r\n                    "No": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
(12, 1, 'Feedback', 'feedback', 'tbl_feedbacks', '{\r\n    "keyColumn": "nFeedback_Id",\r\n     "detailHeaderColumnPrefix": "Feedback: ",\r\n\r\n    "detailHeaderColumns": [\r\n        "vName"\r\n    ],\r\n    "orderBy": {\r\n        "dPasted_Date": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vName",\r\n        "vDestination",\r\n        "dPasted_Date",\r\n        "tComments"\r\n    ],\r\n    "showColumns": [\r\n        "nFeedback_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n        "vDestination",\r\n        "dPasted_Date",\r\n        "tComments"\r\n    ],\r\n    "detailColumns": [\r\n        "nFeedback_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n        "vDestination",\r\n        "dPasted_Date",\r\n        "tComments"\r\n    ],\r\n    "columns": {\r\n        "nFeedback_Id": {\r\n            "name": "ID",\r\n            "sortable": "true"\r\n        },\r\n        "vName": {\r\n            "name": "Customer",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getFeedbackUserPopupUrl"\r\n            }\r\n        },\r\n        "vPhone": {\r\n            "name": "Phone"\r\n        },\r\n        "vEmail": {\r\n            "name": "Email",\r\n  "searchable": "true"\r\n        },\r\n        "vAddress": {\r\n            "name": "Address"\r\n        },\r\n        "vDestination": {\r\n            "name": "Destination",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n             "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            }\r\n        },\r\n        "tComments": {\r\n            "name": "Feedback"\r\n        },\r\n        "dPasted_Date": {\r\n            "name": "Posted Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "delete",\r\n        "view"\r\n    ]\r\n}', '1', 4, 'all'),
(15, 4, 'Accommodation Types', 'accomodation_type', 'tbl_accomodation_types', '{\r\n    "keyColumn": "nAt_Id",\r\n    "detailHeaderColumns": [\r\n        "nAt_Id"\r\n    ],\r\n    "orderBy": {\r\n        "nAt_Id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vAt_Name",\r\n        "vAt_Description",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nAt_Id",\r\n        "vAt_Name",\r\n        "vAt_Description",\r\n        "vActive"\r\n    ],\r\n    "detailColumns": [\r\n        "nAt_Id",\r\n        "vAt_Name",\r\n        "vAt_Description",\r\n        "vActive"\r\n    ],\r\n    "columns": {\r\n        "nAt_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vAt_Name": {\r\n            "name": "Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Type",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getAccomodationPopupUrl"\r\n            }\r\n        },\r\n        "vAt_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeAccomodationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 5, 'all'),
(13, 4, 'Packages', 'destination_package_tag', 'tbl_packages', '{\r\n    "keyColumn": "nPackage_Id",\r\n"handleFile" : "true",\r\n   "detailHeaderColumnPrefix": "Package: ",\r\n    "detailHeaderColumns": [\r\n        "vPackage_Title"\r\n    ],\r\n    "reference": {\r\n        "referenceTable": " tbl_destination",\r\n        "referenceColumn": "nDestination_Id",\r\n        "referenceTableForiegnKey": "nDestination_Id"\r\n    },\r\n    "orderBy": {\r\n        "nPackage_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vPackage_Title",\r\n        "vPackage_Description",\r\n        "vSpecial_Offer",\r\n        "nAmount",\r\n        "vFeatured",\r\n        "vPackage_Status"\r\n    ],\r\n    "showColumns": [\r\n        "nPackage_Id",\r\n"nDestination_Id",\r\n        "vPackage_Title",\r\n        "vPackage_Description",\r\n        "vSpecial_Offer",\r\n        "vPackage_photo_below_Description",\r\n        "nAmount",\r\n        "vFeatured",\r\n        "vPackage_Status",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nPackage_Id",\r\n"nDestination_Id",\r\n        "vPackage_Title",\r\n        "vPackage_Description",\r\n        "vSpecial_Offer",\r\n        "vPackage_photo_below_Description",\r\n        "nAmount",\r\n        "vFeatured",\r\n        "vPackage_Status",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nPackage_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n"nDestination_Id":{\r\n"external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "nDestination_Id"\r\n            }\r\n},\r\n        "vPackage_Title": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vSpecial_Offer": {\r\n            "name": "Offer",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Special Offer",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vPackage_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Overview",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vPackage_photo_below_Description": {\r\n            "name": "Description in details page ",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Description in details page",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "nAmount": {\r\n            "name": "Amount ($)",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Amount ($)",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vPackage_Status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            }\r\n        },\r\n        "vFeatured": {\r\n            "name": "Featured",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Featured",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                }\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all');
INSERT INTO `cms_sections` (`id`, `group_id`, `section_name`, `section_alias`, `table_name`, `section_config`, `visibilty`, `display_order`, `user_privilege`) VALUES
(14, 4, 'Special Offers', 'location_offer_tag', 'tbl_special_offers', '{\r\n    "keyColumn": "nSp_Id",\r\n"handleFile":"true",\r\n   "detailHeaderColumnPrefix": "Special Offer: ",\r\n    "detailHeaderColumns": [\r\n        "vTitle"\r\n    ],\r\n    "handleFile": "true",\r\n    "reference": {\r\n        "referenceTable": "tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "orderBy": {\r\n        "nSp_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vTitle",\r\n        "tDescription",\r\n        "nRate",\r\n        "dStartDate",\r\n        "dEndDate",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nSp_Id",\r\n        "nLocation_Id",\r\n        "vTitle",\r\n        "tDescription",\r\n        "nRate",\r\n        "dStartDate",\r\n        "dEndDate",\r\n        "vActive",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nSp_Id",\r\n        "nLocation_Id",\r\n        "vTitle",\r\n        "tDescription",\r\n        "nRate",\r\n        "dStartDate",\r\n        "dEndDate",\r\n        "vActive",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nSp_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "tDescription": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "nRate": {\r\n            "name": "Discount Price (%)",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Discount Price (%)",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "dStartDate": {\r\n            "name": "Start Date",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Start Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "m/d/Y"\r\n            }\r\n        },\r\n        "dEndDate": {\r\n            "name": "End Date",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "End Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "m/d/Y"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint":"Ideal size 200 x 130. Allowed file types are jpeg,jpg,png and gif"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
(16, 1, 'Customers', 'customers', 'tbl_customers', '{\r\n    "keyColumn": "nCust_Id",\r\n    "includeJsFiles": [\r\n        "cms_customer.js"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Customer: ",\r\n    "detailHeaderColumns": [\r\n        "vFirstname"\r\n    ],\r\n    "orderBy": {\r\n        "nCust_Id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vFirstname",\r\n        "vEmail",\r\n        "dDatejoin",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nCust_Id",\r\n        "vLogin",\r\n        "vPassword",\r\n        "vFirstname",\r\n        "vLastname",\r\n        "vEmail",\r\n        "vAddress1",\r\n        "vCity",\r\n        "vCountry",\r\n        "vState",\r\n        "vZip",\r\n        "vTelephone",\r\n        "dDatejoin",\r\n        "vActive"\r\n    ],\r\n    "detailColumns": [\r\n        "nCust_Id",\r\n        "vLogin",\r\n        "vPassword",\r\n        "vFirstname",\r\n        "vLastname",\r\n        "vEmail",\r\n        "vAddress1",\r\n        "vCity",\r\n        "vCountry",\r\n        "vState",\r\n        "vZip",\r\n        "vTelephone",\r\n        "dDatejoin",\r\n        "vActive"\r\n    ],\r\n    "columns": {\r\n        "nCust_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vLogin": {\r\n            "name": "Login Name",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Login Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vPassword": {\r\n            "name": "Password",\r\n            "editoptions": {\r\n                "type": "password",\r\n                "label": "Password",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vFirstname": {\r\n            "name": "First Name",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "First Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getUserPopupUrlForCustomersLink"\r\n        },\r\n        "vLastname": {\r\n            "name": "Last Name",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Last Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vEmail": {\r\n            "name": "Email",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Email",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vAddress1": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Address",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vCity": {\r\n            "name": "City",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vState": {\r\n            "name": "State",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllStates",\r\n                "source_type": "function",\r\n                "label": "State",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_state",\r\n                "externalColumn": "ts_code",\r\n                "externalShowColumn": "ts_name"\r\n            }\r\n        },\r\n        "vZip": {\r\n            "name": "Zip",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCountry": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllCountries",\r\n                "source_type": "function",\r\n                "label": "Country",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_country",\r\n                "externalColumn": "tc_code",\r\n                "externalShowColumn": "tc_name"\r\n            }\r\n        },\r\n        "vTelephone": {\r\n            "name": "Telephone",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Telephone",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeUserStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "inactive": "red"\r\n                }\r\n            }\r\n        },\r\n        "dDatejoin": {\r\n            "name": "Registered On",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Customer::updateCustomerRegisterTime"\r\n    },\r\n    "customOperations": {\r\n        "login": {\r\n            "options": {\r\n                "target": "newtab",\r\n                "name": "Login",\r\n                "linkSource": "Cmshelper::getuserLoggedInUrl"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "customdelete"\r\n    ],\r\n    "customDeleteOperation": "Cmshelper::deleteCustomer"\r\n}', '1', 5, 'all'),
(17, 1, 'Dashboard', 'dashboard', 'tbl_lookup', '{\r\n    "dashboardPanel": "true",\r\n    "listingPanel": "true",\r\n    "listinPanelRow": "2",\r\n    "listingPanel1": {\r\n        "columns": "2",\r\n        "column1": {\r\n            "title": "Inquiries",\r\n            "titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getInquiry",\r\n            "fetchValue": "Cmshelper::fetchRecentEnquiries",\r\n            "listcolumns": {\r\n                "vName": {\r\n                    "name": "Customer"\r\n                },\r\n                "vEmail": {\r\n                    "name": "Email"\r\n                },\r\n                "dPasted_Date": {\r\n                    "name": "Inquired On"\r\n                }\r\n            }\r\n        },\r\n        "column2": {\r\n            "title": "Recent Orders",\r\n"titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getOrders",\r\n            "fetchValue": "Cmshelper::fetchRecentOrders",\r\n            "listcolumns": {\r\n                "vFirstname": {\r\n                    "name": "Customer"\r\n                },\r\n                "nAmount": {\r\n                    "name": "Amount ($)"\r\n                },\r\n                "vStatus": {\r\n                    "name": "Status"\r\n                },\r\n                "dBooking_Date": {\r\n                    "name": "Booked On"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "listingPanel2": {\r\n        "columns": "1",\r\n        "column1": {\r\n            "title": "Cancellations",\r\n"titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getCancelledOrders",\r\n            "fetchValue": "Cmshelper::getCancellations",\r\n            "listcolumns": {\r\n                "vFirstname": {\r\n                    "name": "Customer"\r\n                },\r\n                "nAmount": {\r\n                    "name": "Amount ($)"\r\n                },\r\n                "vStatus": {\r\n                    "name": "Status"\r\n                },\r\n                "dCancelDate": {\r\n                    "name": "Canceled On"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "graphPanel": "true",\r\n    "graphpanelRow": "1",\r\n    "graphPanel1": {\r\n        "columns": "2",\r\n        "graph1": {\r\n            "type": "MSColumn3D",\r\n            "caption": "Bookings",\r\n            "xAxisName": "",\r\n            "yAxisName": "BookingCount",\r\n            "width": "480",\r\n            "height": "300",\r\n            "dataSetsCount": "1",\r\n            "dataSets": {\r\n                "dataset1": {\r\n                    "name": "",\r\n                    "color": "#D3AC4F",\r\n                    "fetchValue": "Cmshelper::getBookingCount"\r\n                }\r\n            }\r\n        },\r\n        "graph2": {\r\n            "type": "MSLine",\r\n            "caption": "Accommodation Availability",\r\n            "xAxisName": "",\r\n            "yAxisName": "Available Room Count",\r\n            "width": "480",\r\n            "height": "300",\r\n            "dataSetsCount": "1",\r\n            "dataSets": {\r\n                "dataset1": {\r\n                    "name": "",\r\n                    "color": "#D3AC4F",\r\n                    "fetchValue": "Cmshelper::getAvailableRoomCount"\r\n                }\r\n            }\r\n        }\r\n    }\r\n}', '1', 1, 'all'),
(18, 4, 'Destination Gallery', 'destination_gallery_tag', 'tbl_gallery', '{\r\n    "keyColumn": "nGallery_Id",\r\n    "detailHeaderColumnPrefix": "Gallery: ",\r\n    "detailHeaderColumns": [\r\n        "vTitle"\r\n    ],\r\n    "handleFile": "true",\r\n    "reference": {\r\n        "referenceTable": " tbl_destination",\r\n        "referenceColumn": "nDestination_Id",\r\n        "referenceTableForiegnKey": "nDestination_Id"\r\n    },\r\n    "orderBy": {\r\n        "nGallery_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "showColumns": [\r\n        "nDestination_Id",\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nDestination_Id",\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nGallery_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Thumbnail Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n"hint":"Ideal image size 120 x 112. Allowed file formats are GIF,JPG,PNG."\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nDestination_Id": {\r\n            "name": "Destination",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            }\r\n        }\r\n    },\r\n"customActions":{"afterAddRecord":"Cmshelper::moveDestinationGalleryImagefiles","afterEditRecord":"Cmshelper::moveDestinationGalleryImagefiles"},\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
(19, 1, 'Gallery', 'location_gallery_tag', 'tbl_gallery', '{\r\n    "keyColumn": "nGallery_Id",\r\n    "handleFile": "true",\r\n    "detailHeaderColumnPrefix": "Gallery: ",\r\n    "detailHeaderColumns": [\r\n        "vTitle"\r\n    ],\r\n    "reference": {\r\n        "referenceTable": " tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "orderBy": {\r\n        "nGallery_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "showColumns": [\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id",\r\n        "nLocation_Id"\r\n    ],\r\n    "detailColumns": [\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id",\r\n        "nLocation_Id"\r\n    ],\r\n    "columns": {\r\n        "nGallery_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Thumbnail Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n"hint":"Ideal image size 915 x 405. Allowed file formats are GIF,JPG,PNG"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        }\r\n    },\r\n"customActions":{"afterAddRecord":"Cmshelper::moveLocationGalleryImagefiles","afterEditRecord":"Cmshelper::moveLocationGalleryImagefiles"},\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
(20, 1, 'Orders', 'booking_orders', 'tbl_booking', '{\r\n    "keyColumn": "nBooking_Id",\r\n    "detailHeaderColumnPrefix": "Order: ",\r\n    "detailHeaderColumns": [\r\n        "OrderId"\r\n    ],\r\n    "dataSource": "external",\r\n    "dataSourceFunction": "Cmshelper::fetchOrderData",\r\n    "dataSourceCountFunction": "Cmshelper::fetchOrderDataCount",\r\n    "orderBy": {\r\n        "dBooking_Date": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "OrderId",\r\n        "nCust_Id",\r\n        "dArrival_Date",\r\n        "checkoutDate",\r\n        "dBooking_Date",\r\n        "nNights_Stay",\r\n        "nAmount",\r\n        "vStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "OrderId",\r\n        "nCust_Id",\r\n        "destination",\r\n        "location",\r\n        "dArrival_Date",\r\n        "checkoutDate",\r\n        "dBooking_Date",\r\n        "vBooking_Details",\r\n        "nNights_Stay",\r\n        "nRooms",\r\n        "nAmount",\r\n        "nAdults",\r\n        "nChildren",\r\n        "vStatus"\r\n    ],\r\n    "columns": {\r\n        "OrderId": {\r\n            "name": "Order ID",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getOrderId",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getInvoicePopupUrl"\r\n            }\r\n        },\r\n        "nBooking_Id": {\r\n            "name": "ID"\r\n        },\r\n        "nCust_Id": {\r\n            "name": "Customer",\r\n            "searchable": "true",\r\n            "sortable": true,\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCustomerFromOrder",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getUserPopupUrl"\r\n            }\r\n        },\r\n        "dArrival_Date": {\r\n            "name": "Check In",\r\n            "dbFormat": "datetime",\r\n            "displayFormat": "m/d/Y",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "checkoutDate": {\r\n            "name": "Check Out",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCheckoutDate"\r\n        },\r\n        "dBooking_Date": {\r\n            "name": "Booking Date",\r\n            "dbFormat": "datetime",\r\n            "displayFormat": "m/d/Y",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "vBooking_Details": {\r\n            "name": "Booking Details"\r\n        },\r\n        "nNights_Stay": {\r\n            "name": "Days",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "nRooms": {\r\n            "name": "Rooms"\r\n        },\r\n        "nAmount": {\r\n            "name": "Amount ($)",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "nAdults": {\r\n            "name": "Adults"\r\n        },\r\n        "nChildren": {\r\n            "name": "Children"\r\n        },\r\n        "vStatus": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "sortable": true,\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getOrderStatusChangeLink"\r\n        },\r\n        "destination": {\r\n            "name": "Destination",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::fetchDestinationFromOrder"\r\n        },\r\n        "location": {\r\n            "name": "Location",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::fetchLocationFromOrder"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '1', 2, 'all'),
(21, 4, 'Reservations', 'reservations', 'tbl_allotment', '{\r\n    "keyColumn": "nAllotment_Id",\r\n    "orderBy": {\r\n        "nAllotment_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "nAllotment_Id",\r\n        "dDate",\r\n        "vStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nAllotment_Id",\r\n        "dDate",\r\n        "vStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nAllotment_Id",\r\n        "dDate",\r\n        "vStatus"\r\n    ],\r\n    "combineTables": {\r\n        "tbl_available_acco_type": {\r\n            "combineColumns": [\r\n                "nAt_Id",\r\n                "nLocation_Id"\r\n            ],\r\n            "combineReferenceColumn": "nAat_Id",\r\n            "combineTableForiegnKey": "nAat_Id",\r\n            "isPrimaryKey": "true",\r\n            "tbl_locations": {\r\n                "combineColumns": [\r\n                    "nDestination_Id",\r\n                    "vLocation_Name"\r\n                ],\r\n                "combineReferenceColumn": "nLocation_Id",\r\n                "combineTableForiegnKey": "nLocation_Id",\r\n                "isPrimaryKey": "true"\r\n            }\r\n        },\r\n        "tbl_booking": {\r\n            "combineColumns": [\r\n                "nCust_Id"\r\n            ],\r\n            "combineReferenceColumn": "nBooking_Id",\r\n            "combineTableForiegnKey": "nBooking_Id",\r\n            "isPrimaryKey": "true",\r\n            "tbl_customers": {\r\n                "combineColumns": [\r\n                    "vFirstname",\r\n                    "vEmail"\r\n                ],\r\n                "combineReferenceColumn": "nCust_Id",\r\n                "combineTableForiegnKey": "nCust_Id",\r\n                "isPrimaryKey": "true"\r\n            }\r\n        }\r\n    },\r\n    "columns": {\r\n        "nAllotment_Id": {\r\n            "name": "ID",\r\n            "searchable": "true",\r\n            "sortable": "true"\r\n        },\r\n        "vLocation_Name": {\r\n            "name": "First Name",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_customers",\r\n                "externalColumn": "nCust_Id",\r\n                "externalShowColumn": "vFirstname"\r\n            }\r\n        },\r\n        "vDestination_Name": {\r\n            "name": "Destination"\r\n        },\r\n        "vAt_Name": {\r\n            "name": "Accomodation Type"\r\n        },\r\n        "dDate": {\r\n            "name": "Booking Details",\r\n            "searchable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "M,j, Y"\r\n        },\r\n        "vFirstname": {\r\n            "name": "Nights Stay",\r\n            "searchable": "true"\r\n        },\r\n        "vEmail": {\r\n            "name": "Amount"\r\n        },\r\n        "vStatus": {\r\n            "name": "Status",\r\n            "searchable": "true"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 0, 'all'),
(22, 4, 'Accomodation', 'location_accomodation_tag', 'tbl_available_acco_type', '{\r\n    "keyColumn": "nAat_Id",\r\n    "detailHeaderColumns": [\r\n        "nAat_Id"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nAat_Id": "DESC"\r\n    },\r\n    "reference": {\r\n        "referenceTable": " tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "listColumns": [\r\n        "vCode",\r\n        "nAt_Id",\r\n        "nAmount",\r\n        "nRoom",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nAat_Id",\r\n        "nLocation_Id",\r\n        "vCode",\r\n        "nAt_Id",\r\n        "nAdults",\r\n        "nChildren",\r\n        "nAmount",\r\n        "nRoom",\r\n        "file_id",\r\n        "vActive"\r\n    ],\r\n    "detailColumns": [\r\n        "nAat_Id",\r\n        "nLocation_Id",\r\n        "vCode",\r\n        "nAt_Id",\r\n        "nAdults",\r\n        "nChildren",\r\n        "nAmount",\r\n        "nRoom",\r\n        "file_id",\r\n        "vActive"\r\n    ],\r\n    "columns": {\r\n        "nAat_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        },\r\n        "nAt_Id": {\r\n            "name": "Accomodation Type",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllAccomodationTypes",\r\n                "source_type": "function",\r\n                "label": "Accomodation Type",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": " tbl_accomodation_types",\r\n                "externalColumn": "nAt_Id",\r\n                "externalShowColumn": "vAt_Name"\r\n            }\r\n        },\r\n        "vCode": {\r\n            "name": "Code",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Code",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nAdults": {\r\n            "name": "Adults",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Adults",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nChildren": {\r\n            "name": "Children",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Children",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nAmount": {\r\n            "name": "Amount",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Amount",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nRoom": {\r\n            "name": "Room",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Room",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "relations": {\r\n        "accomodation_offer_tag": {\r\n            "name": "Offers",\r\n            "section": "accomodation_offer_tag",\r\n            "child_table": "tbl_offer_price",\r\n            "parent_join_column": "nAat_Id ",\r\n            "child_join_column": "nAat_Id "\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 0, 'all'),
(23, 4, 'Banners', 'banners', 'tbl_Banners', '{\r\n    "keyColumn": "nBId",\r\n    "detailHeaderColumnPrefix": "Banner: ",\r\n    "detailHeaderColumns": [\r\n        "vName"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nBId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vName",\r\n        "vlocUrl",\r\n        "vLocation",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nBId",\r\n        "vName",\r\n        "vlocUrl",\r\n        "vLocation",\r\n        "vActive",\r\n        "file_id",\r\n        "nDate"\r\n    ],\r\n    "detailColumns": [\r\n        "nBId",\r\n        "vName",\r\n        "vlocUrl",\r\n        "vLocation",\r\n        "vActive",\r\n        "file_id",\r\n        "nDate"\r\n    ],\r\n    "columns": {\r\n        "nBId": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vName": {\r\n            "name": "Name",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vlocUrl": {\r\n            "name": "Target URL",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Target URL",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n"hint":"Ideal size 1366 x 500. Allowed file types are jpg,jpeg,gif and png."\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nDate": {\r\n            "name": "Added Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "vLocation": {\r\n            "name": "Location",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "Home": "Home Page",\r\n                    "Sub": "Sub Page"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Location",\r\n                "class": "select",\r\n                "hint":"Location where the banner shows, either home page or inner pages",\r\n                "enumvalues": {\r\n                    "Home": "Home Page",\r\n                    "Sub": "Sub Page"\r\n                }\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeBannerStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "In active"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "beforeEditRecord": "Cmshelper::unsetDateField",\r\n        "afterAddRecord": "Cmshelper::updateBannerAddedDate"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '1', 2, 'all'),
(24, 6, 'News', 'news', 'tbl_News', '{\r\n"detailHeaderColumns":[ "nid"],\r\n    "keyColumn": "nid",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nid": "ASC"\r\n    },\r\n    "listColumns": [\r\n        \r\n        "ntitle",\r\n        "ndescription",\r\n        "nposition",\r\n        "exp_date",\r\n        "active"\r\n    ],\r\n    "showColumns": [\r\n        "nid",\r\n        "ntitle",\r\n        "ndescription",\r\n        "nposition",\r\n        "active",\r\n        "exp_date",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nid",\r\n        "ntitle",\r\n        "ndescription",\r\n        "nposition",\r\n        "active",\r\n        "exp_date",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nid": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "ntitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "ndescription": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nposition": {\r\n            "name": "Position",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Position",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "exp_date": {\r\n            "name": "Expiry Date",\r\n  "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Expiry Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "m/d/Y"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint":"Ideal size 1366 x 500. Allowed file types are jpeg,jpg,png and gif"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        }\r\n    },\r\n   \r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::updateNewsDate"        \r\n    },\r\n\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 2, 'all'),
(25, 1, 'Payments', 'payments', 'tbl_payment', '{"customAction":"true","controller":"cmshelper","method":"payments","module":"default"}\r\n', '1', 6, 'all'),
(36, 4, 'Accomodations', 'location_accomodation_tag1', 'tbl_available_acco_type', '{"customAction":"true","controller":"cmshelper","method":"locationbasedaccomodations","module":"default"}\r\n', '0', 0, 'all'),
(37, 5, 'Sales Report', 'sales_report', 'tbl_payment', '{"customAction":"true","controller":"cmshelper","method":"salesreport","module":"default"}\r\n', '1', 1, 'all'),
(38, 5, 'Booking Report', 'booking_report', 'tbl_booking', '{"customAction":"true","controller":"cmshelper","method":"bookingreport","module":"default"}\r\n', '1', 2, 'all'),
(39, 5, 'Customer Report', 'customer_report', 'tbl_customers', '{"customAction":"true","controller":"cmshelper","method":"customerreport","module":"default"}\r\n', '1', 3, 'all'),
(40, 5, 'Inventory Report', 'inventory_report', 'tbl_allotment', '{"customAction":"true","controller":"cmshelper","method":"inventoryreport","module":"default"}\r\n', '1', 4, 'all'),
(41, 7, 'Manage Roles', 'manage_roles', 'cms_roles', '{"customCmsAction":"true","controller":"cms","method":"manageroles","module":"cms"}', '1', 2, 'all'),
(42, 7, 'Manage Privileges ', 'cms_privileges', 'cms_privileges', '{"customCmsAction":"true","controller":"cms","method":"manageprivilege","module":"cms"}\r\n', '1', 2, 'all'),
(43, 7, 'Manage Admin Users', 'cms_users', 'cms_users', '{"customCmsAction":"true","controller":"cms","method":"manageusers","module":"cms"}', '1', 1, 'all'),
(44, 1, 'Offline Bookings', 'booking', 'tbl_booking', '{"customAction":"true","controller":"cmshelper","method":"booking","module":"default"}\r\n', '1', 6, 'all'),
(26, 4, 'Accomodation Offers', 'accomodation_offer_tag', 'tbl_offer_price', '{\r\n    "keyColumn": "offer_price_id",\r\n    "reference": {\r\n        "referenceTable": "tbl_available_acco_type",\r\n        "referenceColumn": "nAat_Id",\r\n        "referenceTableForiegnKey": "nAat_Id"\r\n    },\r\n    "orderBy": {\r\n        "offer_price_id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "offer_price_id",\r\n        "offer_start_date",\r\n        "offer_end_date",\r\n        "price",\r\n        "published",\r\n        "created_on"\r\n    ],\r\n    "showColumns": [\r\n        "offer_price_id",\r\n        "nAat_Id ",\r\n        "offer_start_date",\r\n        "offer_end_date",\r\n        "price",\r\n        "published",\r\n        "created_on"\r\n    ],\r\n    "detailColumns": [\r\n        "offer_price_id",\r\n        "nAat_Id ",\r\n        "offer_start_date ",\r\n        "offer_end_date",\r\n        "price",\r\n        "published",\r\n        "created_on"\r\n    ],\r\n    "columns": {\r\n        "offer_price_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nAat_Id ": {\r\n            "name": "Accomodation Type",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_accomodation_types",\r\n                "externalColumn": "nAat_Id",\r\n                "externalShowColumn": "nAat_Id"\r\n            }\r\n        },\r\n        "price": {\r\n            "name": "Price",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Price",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "offer_start_date": {\r\n            "name": "Offer Start Date",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Offer Start Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "d/m/Y"\r\n            }\r\n        },\r\n        "offer_end_date": {\r\n            "name": "Offer End Date",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Offer End Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "d/m/Y"\r\n            }\r\n        },\r\n        "published": {\r\n            "name": "Published",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Yes",\r\n                    "0": "No"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Published",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Yes",\r\n                    "0": "No"\r\n                }\r\n            }\r\n        },\r\n        "created_on": {\r\n            "name": "Created Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "d/m/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
(35, 1, 'Affiliates', 'referrals', 'tbl_referrals', '{"customAction":"true","controller":"cmshelper","method":"referrals","module":"default"}\r\n', '1', 9, 'all');
INSERT INTO `cms_sections` (`id`, `group_id`, `section_name`, `section_alias`, `table_name`, `section_config`, `visibilty`, `display_order`, `user_privilege`) VALUES
(27, 4, 'Reviews', 'location_review_tag', 'tbl_rating', '{\r\n    "keyColumn": "nRatingId",\r\n    "detailHeaderColumns": [\r\n        "nRatingId"\r\n    ],\r\n    "handleFile": "true",\r\n    "reference": {\r\n        "referenceTable": "tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "orderBy": {\r\n        "nRatingId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "nCust_Id",\r\n        "nMarks",\r\n        "vFeedbackTitle",\r\n        "vFeedback",\r\n        "dPosted_Date",\r\n        "vRate_Status",\r\n        "vFeedback_Status"\r\n    ],\r\n    "showColumns": [\r\n        "nRatingId",\r\n        "nCust_Id",\r\n        "nLocation_Id",\r\n        "nMarks",\r\n        "vFeedbackTitle",\r\n        "vFeedback",\r\n        "dPosted_Date",\r\n        "vRate_Status",\r\n        "vFeedback_Status"\r\n    ],\r\n    "detailColumns": [\r\n        "nRatingId",\r\n        "nCust_Id",\r\n        "nLocation_Id",\r\n        "nMarks",\r\n        "vFeedbackTitle",\r\n        "vFeedback",\r\n        "dPosted_Date",\r\n        "vRate_Status",\r\n        "vFeedback_Status"\r\n    ],\r\n    "columns": {\r\n        "nRatingId": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nCust_Id": {\r\n            "name": "Customer",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_customers",\r\n                "externalColumn": "nCust_Id",\r\n                "externalShowColumn": "vFirstname"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        },\r\n        "nMarks": {\r\n            "name": "Marks",\r\n            "sortable": "true"\r\n            \r\n        },\r\n        "vFeedbackTitle": {\r\n            "name": "Title",\r\n            "sortable": "true"\r\n            \r\n        },\r\n        "vFeedback": {\r\n            "name": "Feedback",\r\n            "sortable": "true"\r\n            \r\n        },\r\n        "dPosted_Date": {\r\n            "name": "Posted On",\r\n            "sortable": "true",\r\n            "dbFormat": "datetime",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "vRate_Status": {\r\n            "name": "Rating Status",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Rating Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                }\r\n            }\r\n        },\r\n        "vFeedback_Status": {\r\n            "name": "Feedback Status",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Feedback Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
(28, 6, 'Mail Templates', 'mail_templates', 'tbl_mail_template', '{\r\n    "keyColumn": "id",\r\n    "detailHeaderColumns": [\r\n        "id"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_status"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_body",\r\n        "mail_template_status",\r\n        "created_on"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_body",\r\n        "mail_template_status",\r\n        "created_on "\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "mail_template_name": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "disabled",\r\n                "label": "Template Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_sub": {\r\n            "name": "Subject",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Subject",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_body": {\r\n            "name": "Body",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Body",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_status": {\r\n            "name": "Status",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeMailTemplateStatus",\r\n                "enumvalues": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "buttonColors": {\r\n                    "0": "red",\r\n                    "1": "green"\r\n                }\r\n            }\r\n        },\r\n        "created_on": {\r\n            "name": "Created On",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 1, 'all'),
(29, 6, 'Meta Tags', 'meta_tags', 'fw_metadata', '{\r\n "keyColumn": "id",\r\n "detailHeaderColumnPrefix": "Meta Tag : ",\r\n    "detailHeaderColumns": [\r\n        "url"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "url",\r\n        "title",\r\n        "keyword"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "title": {\r\n            "name": "Meta Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Meta Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "keyword": {\r\n            "name": "Meta Keywords",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Keywords",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "description": {\r\n            "name": "Meta Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "url": {\r\n            "name": "Page Url",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "label": "Page Url",\r\n                "type": "textbox",\r\n                "class": "textbox",\r\n                "hint":"<b>Url combinations can be : </b><br/><b style=''color:red''> /abc/</b> [exact location abc after your domain name] eg : www.domainname.com/abc/ ,<br/> <b style=''color:red''>/abc/* </b> [any combination after location abc after your domain name] eg : www.domainname.com/abc/test1,<br/> <b style=''color:red''>* </b>[default value] ",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 3, 'all'),
(30, 1, 'Reserved Rooms', 'reserved_rooms', 'tbl_allotment', '{"customAction":"true","controller":"cmshelper","method":"reservedrooms","module":"default"}\r\n', '1', 8, 'all'),
(31, 1, 'Blocked Rooms', 'blocked_rooms', 'tbl_allotment', '{"customAction":"true","controller":"cmshelper","method":"blockedrooms","module":"default"}\r\n', '1', 7, 'all'),
(49, 6, 'Admin Help Listings', 'admin_help_listings', 'tbl_Help', '{"customAction":"true","controller":"cmshelper","method":"adminhelplistings","module":"default"}\r\n', '1', 0, 'all'),
(33, 4, 'Group Discount', 'group_discount', 'tbl_group_discounts', '{"customAction":"true","controller":"cmshelper","method":"groupdiscount","module":"default"}\r\n', '1', 7, 'all'),
(48, 1, 'Cancelled Orders', 'cancelled_orders', 'tbl_payments', '{"customAction":"true","controller":"cmshelper","method":"cancelledpayments","module":"default"}\r\n', '1', 3, 'all'),
(46, 6, 'Admin Help Content', 'admin_help_content', 'tbl_HelpCategory', '{"customAction":"true","controller":"cmshelper","method":"adminhelpcontent","module":"default"}\r\n', '1', 6, 'all'),
(47, 6, 'Client Help Content', 'client_help_content', 'tbl_HelpCategory', '{"customAction":"true","controller":"cmshelper","method":"clienthelpcontent","module":"default"}\r\n', '1', 7, 'all'),
(50, 3, 'Layout', 'cms_layout', 'none', '{\r\n    "headerLinks": {\r\n        "helpListing": {\r\n            "title": "Help",\r\n            "linkSource": "Cmshelper::getAdminHelpListingPopupUrl"\r\n        },\r\n        "quickStartGuide": {\r\n            "title": "Quick Start Guide",\r\n            "linkSource": "Cmshelper::getQuickStartGuidePopupUrl",\r\n            "target": "popup"\r\n        }\r\n    }\r\n}', '0', 4, 'all'),
(51, 1, 'Affiliate Links', 'affiliatelinks', ' tbl_affiliates_links', '{\r\n    "keyColumn": "link_id",\r\n    "detailHeaderColumnPrefix": "Link: ",\r\n    "detailHeaderColumns": [\r\n        "link_name"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "link_id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "link_name",\r\n        "link_status",\r\n        "link_type",\r\n        "link_title"\r\n    ],\r\n    "showColumns": [\r\n        "link_name",\r\n        "link_status",\r\n        "link_type",\r\n        "link_image"\r\n    ],\r\n    "detailColumns": [\r\n        "link_name",\r\n        "link_status",\r\n        "link_type",\r\n        "link_image",\r\n        "link_title"\r\n    ],\r\n    "columns": {\r\n        "link_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "link_title": {\r\n            "name": "Link Title",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getaffiliatelinks"\r\n        },\r\n        "link_name": {\r\n            "name": "Link Name",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Link Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "link_image": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint": "Ideal size 240 x 50"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "link_type": {\r\n            "name": "Location",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "0": "Image Link",\r\n                    "1": "Text Link"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Link Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "0": "Image Link",\r\n                    "1": "Text Link"\r\n                }\r\n            }\r\n        },\r\n        "link_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeAffiliateLinkStatus",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                },\r\n                "buttonColors": {\r\n                    "0": "red",\r\n                    "1": "green"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '1', 10, 'all');


INSERT INTO `cms_users` (`id`, `type`, `username`, `password`, `email`, `role_id`, `status`) VALUES
(9, 'sadmin', 'sadmin', 'c5edac1b8c1d58bad90a246d8f08f53b ', '', 0, 'active'),
(11, 'admin', 'admin', '21232f297a57a5a743894a0e4a801fc3', '', 1, 'active');


INSERT INTO `tbl_files` (`file_id`, `file_orig_name`, `file_extension`, `file_mime_type`, `file_type`, `file_width`, `file_height`, `file_play_time`, `file_size`, `file_path`, `file_status`, `file_title`, `file_caption`, `file_tmp_name`, `created_on`, `created_by`) VALUES
(1, 'affiliate_banner1.jpg', 'jpg', 'image/jpeg', '', 240, 50, 0, 16184, 'mg3tgymk4b7.jpg', NULL, NULL, NULL, NULL, NULL, 0);

INSERT INTO `tbl_mail_template` (`id`, `mail_template_name`, `mail_template_sub`, `mail_template_body`, `mail_template_status`, `created_on`) VALUES
(21, 'PasswordRecovery', '{SITE_NAME} - Password!', '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">       <title></title> <table width="600" cellspacing="0" cellpadding="0" border="0" style="border:1px solid #ccc; background-color:#FDFDFD; ">        <tbody>         <tr>             <td height="5" colspan="3">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table width="100%" cellspacing="0" cellpadding="0" border="0">                     <tbody>                         <tr>                             <td height="56" style="background-color:#FFFFFF; "><table width="100%" cellspacing="0" cellpadding="0" border="0">                                     <tbody>                                         <tr>                                             <td width="2%" height="80">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table width="100%" cellspacing="0" cellpadding="0" border="0">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Forgot password - {SITE_NAME}</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">We have received  your password reset request.</p>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Please ignore the request if it was not made by you.</p>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">&#160;</p></td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>{PasswordLink}</td><td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br> 												Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table width="100%" cellspacing="0" cellpadding="0" border="0">                                     <tbody>                                         <tr>                                             <td height="30" style="background-color:#FFFFFF; "><p style="color:#999999; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td height="10" colspan="3">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p></meta>', 1, '2013-01-15 05:05:51'),
(28, 'LoginInfo', '{SITE_NAME} - Your login informations', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56" ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your login informations is as follows ,</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:31:36'),
(23, 'PackageInquiry', '{SITE_NAME} - Package Inquiry! ', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear Administrator,</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">There is a package inquiry from a customer. The following are the details:</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30" ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:32:16'),
(24, 'OfflineBookingDetails', '{SITE_NAME} - Thank you for booking !', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your class booking has been successfully done. The booking details are as follows :</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:33:45'),
(25, 'BookingInvoice', '{SITE_NAME} - Your invoice details! ', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56" ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your booking has been successfully done. The booking details are as follows :</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30" ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:34:22'),
(26, 'contactus', 'Contact Us Inquiry From {SITE_NAME}', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear Administrator,</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">There is a package inquiry from a customer. The following are the details:</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:35:02'),
(27, 'BookingInvoiceAdmin', '{SITE_NAME} - Booking invoice details! ', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56" ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">A booking has been successfully done in {SITE_NAME}. The booking details are as follows :</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:35:55'),
(29, 'Inquiry', 'Inquiry - {SITE_NAME}', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear Administrator,</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">There is a inquiry from a customer. The following are the details:</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:36:46'),
(32, 'AdminPanelOfflineBookingInvoice', '{SITE_NAME} - Offline invoice details! ', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56" ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your class booking has been successfully done. The booking details are as follows :</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:37:21'),
(33, 'AdminPanelOfflineBookingInvoiceToAdmin', '{SITE_NAME} - Offline Booking invoice details! ', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56" ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">A booking has been successfully done in {SITE_NAME}. The booking details are as follows :</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:38:03'),
(38, 'installer_mail', 'Installer Mail', '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">\r\n<title></title>\r\n<table width="600" cellspacing="0" cellpadding="0" border="0" style="border:1px solid #ccc; background-color:#FDFDFD; ">\r\n    <tbody>\r\n        <tr>\r\n            <td height="5" colspan="3"></td>\r\n        </tr>\r\n        <tr>\r\n            <td width="5"></td>\r\n            <td width="586"><table width="100%" cellspacing="0" cellpadding="0" border="0">\r\n    <tbody>\r\n        <tr>\r\n            <td height="56" style="background-color:#324148; ">\r\n                <table width="100%" cellspacing="0" cellpadding="0" border="0">\r\n                    <tbody>\r\n                        <tr>\r\n                            <td width="2%" height="80">&#160;</td>\r\n                            <td width="37%">{SITE_LOGO}</td>\r\n                            <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>\r\n                        </tr>\r\n                    </tbody>\r\n                </table></td>\r\n        </tr>\r\n        <tr>\r\n            <td height="10">&#160;</td>\r\n        </tr>\r\n        <tr>\r\n            <td>&#160;</td>\r\n        </tr>\r\n        <tr>\r\n            <td><table width="100%" cellspacing="0" cellpadding="0" border="0">\r\n                    <tbody>\r\n                        <tr>\r\n                            <td width="2%">&#160;</td>\r\n                            <td width="28%">{MAIL_CONTENT}</td>\r\n                            <td width="2%">&#160;</td>\r\n                        </tr>\r\n                        <tr>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                        </tr>\r\n                        <tr>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                        </tr>\r\n                        <tr>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                        </tr>\r\n                    </tbody>\r\n                </table></td>\r\n        </tr>\r\n        <tr>\r\n            <td><table width="100%" cellspacing="0" cellpadding="0" border="0">\r\n                    <tbody>\r\n                        <tr>\r\n                            <td height="30" style="background-color:#324148; "><p style="color:#FFFFFF; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>\r\n                        </tr>\r\n                    </tbody>\r\n                </table></td>\r\n        </tr>\r\n    </tbody>\r\n                </table></td>\r\n                <td width="4">&#160;</td>\r\n        </tr>\r\n        <tr>\r\n            <td height="10" colspan="3">&#160;</td>\r\n        </tr>     </tbody> </table> <p>&#160;</p></meta>', 1, '2013-01-15 05:38:53');
INSERT INTO `tbl_mail_template` (`id`, `mail_template_name`, `mail_template_sub`, `mail_template_body`, `mail_template_status`, `created_on`) VALUES
(1, 'affiliateregister', '{SITE_NAME} - Activate your affiliate account ', '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">       <title></title> <table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">        <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%">{SITE_LOGO}</td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Thank you for registering as affiliate</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Click the folowing link to activate your account</p>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">&#160;</p></td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>{ActivationLink}</td><td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br> 												Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p></meta>', 1, '2013-01-15 05:39:29'),
(2, 'affiliate_pwdrequest', 'Affiliate Password reset request', '<meta content="text/html; charset=iso-8859-1" http-equiv="Content-Type">       <title></title> <table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">        <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%">{SITE_LOGO}</td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Forgot password - {SITE_NAME}</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">We have received  your password reset request.</p>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Please ignore the request if it was not made by you.</p>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">&#160;</p></td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>{PasswordLink}</td><td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br> 												Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p></meta>', 1, '2013-01-15 05:40:11'),
(34, 'AdminPanelPendingCancelConfirmation', '{SITE_NAME} - Pending Cancel Confirmation', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your cancellation for the following booking processed successfully</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:40:51'),
(35, 'CancelConfirmation', '{SITE_NAME} - Cancel Confirmation', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your cancellation for the following booking processed successfully.</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:43:06'),
(36, 'PendingBookingConfirmation', '{SITE_NAME} - Booking Confirmed!', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your booking confirmed</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:43:49'),
(37, 'CancelPaymentPending', '{SITE_NAME} - Cancel Request Received', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your cancel request is received. Cancel will be processed once payment is received</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:44:23');


INSERT INTO `tbl_affiliates_links` (`link_id`, `link_name`, `link_image`, `link_status`, `link_type`) VALUES
(1, 'Affiliate banner 1', 1, 1, 0);


INSERT INTO `tbl_lookup` (`nLookUp_Id`, `vLookUp_Name`, `vLookUp_Value`, `settinglabel`, `groupLabel`, `type`) VALUES('', 'social_share_enable', 'Y', 'Enable Social Share', 'General',''),
('', 'expedia_country', 'US', 'Expedia Search Country', 'General',''),
('', 'flash_header', '1', 'Enable Flash Header', 'Advanced',''),
('', 'cancellation_terms', 'cancellation terms', 'Cancellation Terms', 'Advanced',''),
('', 'addressfromemail', '', '', '',''),
('', 'search_filter_min_value', '0', 'Search Filter Minimum Value', 'General',''),
('', 'addressfromemailname', '', '', '',''),
('', 'addressreplyemail', '', '', '',''),
('', 'addressreplyemailname', '', '', '',''),
('', 'affiliate_enable', '1', 'Enable Affiliate', 'General',''),
('', 'affiliate_percentage', '10', 'Affiliate Percentage', 'General',''),
('', 'fbappid', '', 'Faceboo App Id', 'General',''),
('', 'companyPhone', '', 'Comapny Phone Number', 'General',''),
('', 'companyName', '', 'Company Name', 'General',''),
('', 'companySite', '', 'Company Site', 'General',''),
('', 'expedia_enable', 'N', 'Enable Expedia', 'General',''),
('', 'expedia_version', '3', 'Enable Version', 'General',''),
('', 'expedia_cid', '', 'Expedia CID Value', 'General',''),
('', 'expedia_apikey', '', 'Expedia API Key', 'General',''),
('', 'expedia_currency', 'USD', 'Expedia Currency Code', 'General',''),
('', 'expedia_search_mode', '1', 'Expedia Search Mode', 'General',''),
('', 'logoFooter', 'logo-footer.png', '', '',''),
('', 'expedia_locale', 'en_US', 'Expedia Locatiob', 'General',''),
('', 'enable_fb', 'N', 'Enable Facebook', 'Social Settings',''),
('', 'fb_app_id', '', 'Facebook App ID', 'General',''),
('', 'enable_twitter', 'N', 'Enable Twitter', 'Social Settings',''),
('', 'enable_pinterest', 'N', 'Enable Pinterest', 'Social Settings',''),
('', 'enable_gplus', 'N', 'Enable GooglePlus', 'Social Settings',''),
('', 'search_filter_max_value', '1000', 'Search Filter MaximumValue', 'General',''),
('', 'followlink_facebook', '', 'Follow Link : Facebook', 'General',''),
('', 'followlink_twitter', '', 'Follow Link : Twitter', 'General',''),
('', 'followlink_linkedin', '', 'Follow Link : Linkedin', 'General',''),
('', 'admin_booking_message', '', 'Admin Booking Message', 'General', ''),
('', 'recaptcha_enable', 'N', 'Enable Recaptcha', 'General', ''),
('', 'recaptcha_public_key', '', 'Recaptcha Public Key', 'General', ''),
('', 'recaptcha_private_key', '', 'Recaptcha Private Key', 'General', ''),
('', 'calendar_enable', 'Y', 'Enable Calendar', 'General', '');


INSERT INTO `tbl_cms_settings` (`id`, `cms_set_name`, `cms_set_value`, `created_on`) VALUES
(1, 'admin_logo', 'project/themes/default/images/logo.png', '2012-11-26 09:32:20'),
(2, 'admin_copyright', 'Powered by <a href="http://www.iscripts.com/reservelogic/" target="_blank">iScripts ReserveLogic</a> . A premium product from <a href="http://www.iscripts.com" target="_blank">iScripts.com</a>', '2012-12-26 11:53:05'),
(4, 'admin_page_count', '8', '2012-10-03 16:33:33'),
(5, 'site_logo', 'Cmshelper::bindSiteLogo', '2013-01-04 19:34:39');


INSERT INTO `tbl_HelpCategory` (`hcid`, `htype`, `hctitle`, `hcposition`, `active`) VALUES('', 'client', 'Affiliates', '13', '1');
INSERT INTO `tbl_Help` (`hid`,`hcid`, `htitle`, `hdescription`, `hposition`, `active`,`himage`) VALUES('', '11', 'How Affiliates Works ?', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis malesuada arcu et est vestibulum non scelerisque felis eleifend. Morbi sed quam sit amet arcu vulputate interdum sodales a dui.', '12','1','0');
