<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		              |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com � 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
include "../includes/config.php";
include "../includes/session.php";
include "../includes/functions.php";
include "../classes/cls_order.php";
include "../classes/cls_products.php";
include "../classes/cls_combopack.php";

if (get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

if(isset( $_SESSION["sess_adminname"]) and $_SESSION["sess_adminname"]!= ""){
	$adminname = $_SESSION["sess_adminname"];
}else{
	header("Location:login.php");
	exit;
} 
if(isset( $_GET["orderid"]) and $_GET["orderid"]!= ""){
	$orderid = $_GET["orderid"];
}else if(isset( $_POST["orderid"]) and $_POST["orderid"]!= ""){
	$orderid = $_POST["orderid"];
}else{
	header("Location:orders.php");
	exit;
}
$message = '';
if(isset( $_GET["message"])){
	$message = $_GET["message"];
}
if(isset( $_GET["mes"])){
	$success_message = $_GET["mes"];
}


$itemlist = isset($_POST["chkitems"])?$_POST["chkitems"]:'';
$ddlStatus = isset($_POST["ddlStatus"])?$_POST["ddlStatus"]:'';

$btn = '';
foreach ($_POST as $key =>$value){
	if($value == GO){
		$btn = $key;
		break;
	}

}


if(isset($_POST[$btn]) && $_POST[$btn] == GO){ 


	$ar = explode("_",$btn );
	$sid = $ar[1] ;
	$ddl = "ddlStatus_".$sid;
	$status = $_POST[$ddl];
	//echo $ddl;//exit;
	    $sql ="UPDATE  ".$tableprefix."order_details SET
		item_status = :status
		WHERE order_id = :orderid AND artist_id = :sid ";
		
		$res = $pdo->pdoQuery($sql,array("status"=>$status, "orderid"=>$orderid, "sid"=>$sid))->results();
		
		// Update Item Delivery Time
		if($status=="4")
		{
		
			   $sql_deliverytime_up	= "UPDATE  ".$tableprefix."order_details SET item_delivery_date =:now
										WHERE order_id = :orderid AND artist_id = :sid ";
								
				$pdo->pdoQuery($sql_deliverytime_up,array("orderid"=>$orderid, "sid"=>$sid, "now"=>date("Y-m-d H:i:s")))->results();
		}
	
		// End 
		
		$orderstatus_new = getArtistOrderStatus($orderid, $sid); 
                
               // Restock Order Quantity if seller order cancellded 
                if($status=="2")
                {
                    $sellerorderItems = Order::getsellerItemsinOrder($orderid,$sid);
                    $productArray   = array();
                    if(!empty($sellerorderItems))
                    {
                        foreach($sellerorderItems as $products)
                        {
                           $updateStock =  Products::updateCancelledQuantityToProductStock($products['product_id'],$products['product_option_id'],$products['product_quantity']);
                        }
                        
                    }
                    $cancelFlag = true;                 
                    
                    sendOrderStatusChangeMailToBuyer($orderid,$sid,$orderstatus_new,'A',$cancelFlag);
                 
                    sendOrderCancellationMailToSeller($orderid,$sid,$orderstatus_new,$cancelFlag);
                   
                } else {
                   
                    sendOrderStatusChangeMailToBuyer($orderid,$sid,$orderstatus_new,'A');
                 
                    sendOrderCancellationMailToSeller($orderid,$sid,$orderstatus_new);
                }
               
				//echo $_POST["chkStatus"];exit;
                $message = CHANGES_SAVED_SUCCESSFULLY."<br>";
                
		header("Location:vieworder.php?orderid=".$orderid."&mes=".$message); 
		exit;		
} 

if(isset($_POST["btnGo"]) && $_POST["btnGo"] == GO){  
	$message = "";
	 if(!isNotNull($itemlist)){
		$message .= "*".PLEASE_SELECT_ITEMS."! <br>";
	}else{
		$ilist = implode(",",$itemlist );
	} 

	if($message  == ""){ 
		list($qarr,$qstr) = getInQueryString($ilist);
		$sql ="UPDATE  ".$tableprefix."order_details SET
		item_status = :ddlStatus
		WHERE 	order_detail_id IN ( $qstr ) ";
		$qarr['ddlStatus '] = $ddlStatus;
		$res = $pdo->pdoQuery($sql,$qarr)->results();
		
		
		if($ddlStatus=="4")
		{
			list($qarr,$qstr) = getInQueryString($ilist);
			$sql_deliverytime_up = "UPDATE  ".$tableprefix."order_details SET item_delivery_date = :now
							WHERE order_detail_id IN ( $qstr )";
			$qarr['now '] = date("Y-m-d H:i:s");
			$pdo->pdoQuery($sql_deliverytime_up,$qarr)->results();
			
		}

		$success_message = CHANGES_SAVED_SUCCESSFULLY."<br>";  
		header("Location:vieworder.php?orderid=".$orderid);
		exit;
	}else{
		 $message = "<br>".MSG_CORRECT_THE_ERRORS."!<br>" . $message;
	}

} 

if(isset($_GET["msg"]) and $_GET["msg"]!=""){
	$msg = $_GET["msg"];
	switch($msg){
		case "deleted": $success_message = MSG_USER_DELETED;break;
		default:
			;
	} // switch

}

$artistlist = getOrderArtists($orderid);
$artists = explode(",",$artistlist );

$totalshippingcost      =    0;
$select_shipping_cost   = "SELECT sd.vshipping_name, sd.nshipping_cost,sd.nshp_productname
                            FROM ".$tableprefix."shipping_details sd
                           WHERE sd.norder_id = :orderid AND  nshp_status = 'C' order by sd.nshp_productname";
$result_shipping_cost   = $pdo->pdoQuery($select_shipping_cost,array("orderid"=>$orderid))->results();

$shipRow                =    count($result_shipping_cost);

if($shipRow>0) {
        foreach($result_shipping_cost as $shipping_row)
                {
                    $totalshippingcost+=$shipping_row['nshipping_cost'];
                }   
}     
/*---------Display the shipping cost if available----------*/

/*$sql=" SELECT o.*, u.user_name, u.email, od.artist_id, cm.nexchange_price 
		FROM ".$tableprefix."orders o,".$tableprefix."currency_master cm
		INNER JOIN ".$tableprefix."users u ON o.user_id = u.user_id
		INNER JOIN ".$tableprefix."order_details od ON o.order_id = od.order_id
		WHERE o.vorder_currency = cm.vcurrency_code
		 AND o.order_id = '".addslashes($orderid)."'
		" . $qryopt . " ORDER BY o.order_date DESC ";*/

		
		$sql=" SELECT o.*, u.user_name, u.email, od.artist_id,sum( (od.product_price-(od.product_price*product_discount/100)) * od.product_quantity) as total_price
		FROM ".$tableprefix."orders o
		INNER JOIN ".$tableprefix."users u ON o.user_id = u.user_id
		INNER JOIN ".$tableprefix."order_details od ON o.order_id = od.order_id
		WHERE o.order_id = :orderid
		  ".$qryopt . " GROUP BY o.order_id ORDER BY o.order_date DESC ";
		 // echo $sql;
		 
/*echo $sql = "SELECT o. * , u.user_name, u.email, od.artist_id, cm.nexchange_price
		FROM ".$tableprefix."orders o JOIN ".$tableprefix." users u ON o.user_id = u.user_id
		JOIN ".$tableprefix."order_details od ON o.order_id = od.order_id
		JOIN ".$tableprefix."currency_master cm ON o.vorder_currency = cm.vcurrency_code
		WHERE o.order_id  = '".addslashes($orderid)."'" . $qryopt .
		" ORDER BY o.order_date DESC";	*/

$result = $pdo->pdoQuery($sql,array("orderid"=>$orderid))->results();

//echo "result for price and discounts--->"."<br>";
//echopre($result);
if(count($result) != 0)
{
	$row = ($result[0]);
	$ordernumber = $row["order_id"];
	$username = $row["user_name"];
        $taxrate                =      Order::getorderTaxTotal($row["order_id"]);
        
	//$taxrate=$row["taxrate"];
	$ordertotal=$row["total_price"];
        $couponCodeDiscount=$row["couponCodeDiscount"];
        if($row["nused_gift_amount"] >0 || $couponCodeDiscount>0 ) {

           $giftDiscountAmount           = $row["nused_gift_amount"];

           //$couponCodeDiscountAmount = ($ordertotal*$row["couponCodeDiscount"])/100;
           $couponCodeDiscountAmount = $row["couponCodeDiscount"];

           $TotalDiscount   = $giftDiscountAmount + $couponCodeDiscountAmount;

           $priceafterdiscount=$ordertotal-$TotalDiscount;

           $ordertotal=number_format($priceafterdiscount,2,".","");

        }
	$netTotal=$ordertotal+$taxrate;
	$orderdate = $row["order_date"];
	$orderdate = dateFormat($orderdate,"Y-m-d","m/d/Y");
	$userid = $row["user_id"];
	//$exchange_price = $row["nexchange_price"];
        
         $sql_Shipping="SELECT sum(nshipping_cost)as nShippingcost from ".$tableprefix."shipping_details where norder_id= :order_id AND nshp_status='C' ";
         $rs_shipping=$pdo->pdoQuery($sql_Shipping,array("order_id"=>$row["order_id"]))->results();
       if(count($rs_shipping)>0)  {
                $rsShippingObj=(object)($rs_shipping[0]);
                $totalshippingcost =number_format($rsShippingObj->nShippingcost,2,".","");
                $netTotal = $netTotal+$totalshippingcost;
       }
	
} 


$row1 = $row;
//echopre($row1);
$statlist= array();
$statlist[1] = PENDING;
$statlist[2] = CANCELLED;
$statlist[3] = SHIPPED;
$statlist[4] = DELIVERED;

$hide_shipping_display = 0;
$hide_shipping_display = Order::checkShippingBlockRequiredForOrder($orderid);


include "../includes/htmltop1.php";

?>
<SCRIPT>
    $(document).ready(function(){
        $('#order_total_text_top').text($('#order_total_text_bottom').text());
    });
function confirmDelete(){
	if(confirm("<?php echo ARE_YOU_SURE_DELETE_RECORD;?>?") ){
		return true;
	}
	return false;
}
function confirmStatus(){
	if(confirm("<?php echo ARE_YOU_SURE_CHANGE_STATUS;?>?") ){
		return true;
	}
	return false;
}
</SCRIPT>

<body>
		<div class="main_outer">
		<!--header area start -->
	<?php
		include_once("../includes/topheader_admin1.php");
	?>
				<!--header area end -->				
				<div class="contant_area">
				<!--main body start -->
				
<?php
		include_once("../includes/admintopmenu1.php");

?>		
	<div class="right_main_cont_outer">
		<div class="right_main_cont_inner">
			<h1><?php echo VW_ORDERDETAILS;?> <span class="normal_txt_red">#<?php echo $ordernumber;?></span></h1>
			<div class="clearfix"></div>
			<div class="text_information">
				<?php if ($message) { ?>
					<div class='error_msg white_bg'>
						<i class="fa fa-exclamation-triangle" aria-hidden="true"></i> <?php echo $message?>
					</div>			
				<?php } ?>
			</div>
			<div class="text_information_success">
				<?php if ($success_message) { ?>
				<div class='success_msg white_bg'>
				<i class='fa fa-check' aria-hidden='true'></i><?php echo $success_message; ?>
				</div>
				<?php } ?>
			</div>
			
			<div class="clearfix"></div>
			
			<form name="frmFeedback" action="<?php echo $_SERVER["PHP_SELF"]?>" method="POST">
				<input type="hidden" name="orderid" value="<?php echo htmlentities($orderid);?>">
				
				<div class="white_cont_outer no_padding margin_B_30">
					<div class="view_order_top_outer">
						<?php if(checkDigitalOrder($orderid,'')==true) { ?>
						<div class="view_order_top_cell">
							<div class="view_order_top_cont_head one"><?php echo ORDER_TYPE;?></div>
							<div class="view_order_top_cont_txt"><?php echo DIG_PRO_ORDER;?></div>
						</div>
						<?php } ?>


						<div class="view_order_top_cell">
							<div class="view_order_top_cont_head two"><?php echo ORDER_NO;?></div>
							<div class="view_order_top_cont_txt"><?php echo $ordernumber;?></div>
						</div>
						<div class="view_order_top_cell">
							<div class="view_order_top_cont_head three"><?php echo ORDER_DATE;?></div>
							<div class="view_order_top_cont_txt"><?php echo $orderdate;?></div>
						</div>
						<div class="view_order_top_cell">
							<div class="view_order_top_cont_head four"><?php echo ORDER_TOTAL;?></div>
							<div class="view_order_top_cont_txt" id="order_total_text_top"><?php echo $adminCurrency['currency_symbol'];?>  <?php echo  number_format($netTotal,2,".","" );?></div>
						</div>
						<div class="view_order_top_cell">
							<div class="view_order_top_cont_head five"><?php echo ORDER_BY;?></div>
							<div class="view_order_top_cont_txt"><?php echo $username;?></div>
						</div>
					</div>
				</div>
				
				<div class="clearfix"></div>
				
				<h2><?php echo ORDER_PART_DETAILS;?></h2>
				
				<div class="white_cont_outer margin_B_30">
					<?php echo Order::showIconTexts($orderid);?>
					
					
					<?php
						if(isNotNull($artists))
						{
							echo " ".ORDER_CONTAINS." ".count($artists)." ".SUBORDER;
							$grand_total = 0;
							for($i=0;$i< count($artists);$i++)
							{
								switch (getArtistOrderStatus($orderid,$artists[$i])){
									case 'Pending':$stat=PENDING;
									$sclass='pendingstat';
									$sfont='<i class="fa fa-exclamation-triangle" aria-hidden="true"></i>';
									break;
									case 'Cancelled' :$stat=CANCELLED;
									$sclass='cancelstat';
									$sfont='<i class="fa fa-exclamation-triangle" aria-hidden="true"></i>';
									break;
									case 'Shipped':$stat=SHIPPED;
									$sclass='shippedstat';
									$sfont='<i class="fa fa-check" aria-hidden="true"></i>';
									break;
									case 'Delivered':$stat=DELIVERED;
									$sclass='deliveredstat';
									$sfont='<i class="fa fa-check" aria-hidden="true"></i>';
									break;
										
								}
						?>
					<div class="clearfix"></div>
					
				</div>
				<div class="clearfix"></div>
				
				<h2><?php echo ORDER_PART;?> <span class="normal_txt_red"># <?php echo $i+1;?></span></h2>
				<div class="table-responsive no_margin">
					<table class="table admin_table no_margin" >
						<tr>
							<td colspan="7" class="view_order_seller_details_outer">
								<span class="view_order_seller_details">
									<?php echo SELLER;?> : <?php echo stripslashes(getArtistName_Location($artists[$i]));?>
								</span>
								<span class="view_order_status_details"><?php echo PARTIAL_ORDER_STATUS;?> <span class="<?php echo $sclass;?>"><?php echo $sfont; ?><?php echo $stat; ?></font></span>
							</td>
						</tr>
						<tr class="form_header">
							<th width='3%' height="34" align="left">#</th>
							<th width='25%' align="left"><?php echo PRODUCT_NAME;?></th>
							<th width='12%' align="left"><?php echo PRODUCT_CODE;?></th>
							<th width="8%" align="left"><?php echo RATE;?></th>
							<th width='8%' align="left"><?php echo QTY;?></th>
							<th width='8%' align="left"><?php echo PRICE;?></th>
							<th width='8%' align="left"><?php echo STATUS;?></th>
							<?php /*<th width='11%' align="left"><?php echo SHIPPING_COST;?></th>
							<th width='13%' align="left"><?php echo SHIPPING_NAME;?></th>
							<th width='13%' align="left"><?php echo PRODUCT_TYPE;?></th>*/?>
						</tr>
					
													
													
													
<?php
			 $sql= "SELECT od.*, o.vorder_currency,o.taxrate,s.order_status,gm.ngift_product_id,gm.vgift_coupon_code
						  FROM ".$tableprefix."order_details od
			INNER JOIN ".$tableprefix."order_status s ON s.order_status_id = od.item_status
			 LEFT JOIN ".$tableprefix."giftcertificates gm ON gm.ngift_product_id=od.product_id AND gm.ngift_order_id=od.order_id
			 LEFT JOIN ".$tableprefix."orders o ON o.order_id=od.order_id
			 WHERE  od.order_id = :orderid
						   AND  (od.artist_id = :artists)
					  order by  od.product_price DESC";
			 
			 
	//echo "sql for product list--->".$sql."<br>";
	$result1 = $pdo->pdoQuery($sql,array("orderid"=>$orderid, "artists"=>$artists[$i]))->results();
    
//echopre($result1);
//////////////////////////////////////////////combo orders starts

    $combo_items=array();
													   $combo_crt_id_map='';
													   $temp_combo=array();
													   foreach ($result1 as $index=>$prd) {
														   
														   if($prd['combo_id']!='')
														   {
														   	if(!in_array($prd['combo_id'],$temp_combo)){
													         $temp_combo[]=$prd['combo_id'];
															   $combo_items[$prd['combo_id']]['prd_name'][$prd['product_id']]=$prd['product_name'];
															   
															   $combo_items[$prd['combo_id']]['prd_qty'][$prd['product_id']]=$prd['product_quantity'];                                                                
															  $selectCase = array("product_id" => $prd['product_id'],"product_option_id"=>$prd['product_option_id'],"combo_id"=>$prd['combo_id']);
																   $result = $pdo->select($tableprefix . "combo_products", "product_quantity", $selectCase)->results();
																   //echo $prd['product_quantity'].' - '.$result[0]["product_quantity"].'<br/>';
																   $combo_quantity=$prd['product_quantity']/$result[0]["product_quantity"];
																   $combo_items[$prd['combo_id']]['quantity']=$combo_quantity;
//                                                                     if(isset($combo_items[$prd['combo_id']]['productoptionids']))
//                                                                    {
//                                                                        $combo_items[$prd['combo_id']]['productoptionids'].="," .$prd['product_option_id'];
//                                                                    }
//                                                                    else {
//                                                                        $combo_items[$prd['combo_id']]['productoptionids']=$prd['product_option_id'];
//                                                                    }
//
													   //            if(isset($combo_items[$prd['combo_id']]['cartids']))
													   //            {
													   //                $combo_items[$prd['combo_id']]['cartids'].="," .$prd['cart_id'];
													   //            }
													   //            else {
													   //                $combo_items[$prd['combo_id']]['cartids']=$prd['cart_id'];
													   //            }
														   }

														}
													   }

													   $combo_details=array();
													   foreach($combo_items as $index=>$combos)
													   {

														  $combo_details[$index] =  ComboPack::get_combo_details($index);
														   $combo_details[$index]['required_quantity']=$combo_items[$index]['quantity'];
													   }
													   //Combo Section Above

//////////////////////////////////////////////combo orders ends

	$k=1;
	$subtotal = 0;
	$ddlStatus = "ddlStatus_".$artists[$i];
	$$ddlStatus = '';
	$sellerCurrency=getSellerCurrencySybol($artists[$i]);
	$ddl = makeDropDownList($ddlStatus,$statlist,$$ddlStatus ,false ,"textbox" , "","" );
	$btnStatus = "btnGo_".$artists[$i];
	$btn = "<input class='button' type='submit' value='".GO."' name='".$btnStatus."' onClick='return confirmStatus();'> ";
	foreach($result1 as $rw)
	{
		$link = "<a class=links href='editmyproduct.php?productid=".$rw["product_id"]."'>";
		$check = "<input type='hidden' name='chkitems[]' value='" . $rw["order_detail_id"] . "' > ";
		$rate = $rw["product_price"];
		$qty = $rw["product_quantity"];
		$artistid = $rw["artist_id"];
	$ddl = makeDropDownList($ddlStatus,$statlist,$rw['item_status'] ,false ,"form-control" , "","" );
	//$btnStatus = "btnGo_".$artists[$i];
	$btn = "<button class='go_btt' type='submit' value='".GO."' name='btnGo_".$artists[$i]."' onClick='return confirmStatus();'><i class='fa fa-paper-plane' aria-hidden='true'></i> GO</button>";
	//$btn = "AAAA";
	$rate=$rw["product_price"];
	$shippingcost=$row1["nshipping_cost"];
	$totaltax=$rw["taxrate"];
	$price = $rate * $qty;
	
		if($rw['digital_product_flag'] == "Y"){           
			$product_shipping_cost = $adminCurrency['currency_symbol'].'&nbsp;0.00';;
			$shippingName = NO_SHIPPING;
			$producttype = DIGITAL_PRODUCT;
		}
		else{
			$product_shipping_cost = ($rw['product_shipping_price']!=0)?$adminCurrency['currency_symbol'].'&nbsp;'.number_format($rw['product_shipping_price'],2,".",""):$adminCurrency['currency_symbol'].'&nbsp;0.00';
			$shippingName = ($rw['product_shipping_price']!=0)?$rw['product_shipping_name']:FREE_SHIP_TEXT;
			$producttype =  ($rw['subscription_product_flag']=='Y')?SUBSCRIPTION_PRODUCT:NORMAL_PRODUCT;
		}
		
		if($rw["product_discount"] !="0"){ 
			$price=$price-($price*(int)$rw["product_discount"]/100);
			//$discountstr="discount(".$rw["product_discount"]."%)";
			
		}

		  if($rw['combo_id']==''){
		$subtotal += $price; }

		$rate  = number_format($rate,2,".","" );
		$price = number_format($price,2,".","" );
		switch ($rw["order_status"]){
			case 'Pending':$stat1=PENDING;
			break;
			case 'Cancelled' :$stat1=CANCELLED;
			break;
			case 'Shipped':$stat1=SHIPPED;
			break;
			case 'Delivered':$stat1=DELIVERED;
			break;
				
		}


		if($rw['combo_id']==''){
?>


	
				<tr>
					<td height="32" align="left" valign="top"><?php echo $k; ?> </td>
					<td valign="top" align="left"><?php echo Order::showDigitalItemIcon($rw["digital_product_flag"]).(stripslashes($rw["product_name"]))."<br>".DISCOUNT."(".$rw["product_discount"]."%)".Order::check_free_ship_product_text($rw["product_id"]); ?>
					<br><br><?php if($rw['vgift_coupon_code']!='') {  ?><span class="required"><?php echo GIFT_CERT_CODE;?> : <?php echo $rw['vgift_coupon_code'];?></span><?php } ?>
					</td>
					<td valign="top" align="left"><?php echo htmlentities($rw["product_code"]); ?></td>
					<td align="left" valign="top"><?php echo $adminCurrency['currency_symbol'];?>  <?php echo htmlentities($rate); ?></td>
					<td valign="top" align="left"><?php echo htmlentities($qty); ?></td>
					<td valign="top" align="left"><?php echo $adminCurrency['currency_symbol'];?>  <?php echo htmlentities($price); ?></td>
					<td valign="top" align="left"><?php echo $stat1; ?>&nbsp;</td>
										<?php /*<td valign="top" align="left"><?php echo $product_shipping_cost; ?>&nbsp;</td>
										<td valign="top" align="left"><?php echo $shippingName; ?>&nbsp;</td>
										<td valign="top" align="left"><?php echo $producttype; ?>&nbsp;</td>*/?>
				</tr> 



<?php
	$k++;
}
}?>

<?php 

///combo listing foreach starts
$combo_items_for_display=array();
	foreach ($result1 as $index=>$prd) {

$combo_items_for_display[$prd['combo_id']]['prd_name'][$prd['product_id']]=$prd['product_name'];
/*$combo_items_for_display[$prd['combo_id']]['prd_qty'][$prd['product_id']]=$prd['product_quantity']; 
$selectCase = array("product_id" => $prd['product_id'],"product_option_id"=>$prd['product_option_id'],"combo_id"=>$prd['combo_id']);
$result = $pdo->select($tableprefix . "combo_products", "product_quantity", $selectCase)->results();
$combo_quantity=$prd['product_quantity']/$result[0]["product_quantity"];
$combo_items_for_display[$prd['combo_id']]['quantity']=$combo_quantity;*/
					  
      }

$cartcombo_items ='';
					foreach ($combo_details as $combo) {
						
						$currency_attributes = displayCurrencyType();
						//print_r($combo);
					  
					 $cartcombo_items .= "," . $combo["combo_id"];
								   $cntt++;
								   $price=$combo["price"];
								   $combo_products='';
								   

									foreach ($combo_items_for_display[$combo["combo_id"]]['prd_name'] as $index=>$prd_name) {
										$combo_products.='<div class="col-xs-9 col-md-8">'.$prd_name.' <i> </i></div>';
									}                                   
								   
								   $digitalFlag='N';
									$discountstr='';
									$optionsStr='';
									$productname=$combo["combo_name"];
									 $conversionRate = ConvertedCurrencyRate($currency_attributes[2]);
									 //print_r($combo["required_quantity"].' - '.$price.' - '.$conversionRate);
									 //exit;
						$converted_price = $combo["required_quantity"]*$price * $conversionRate;

						$rate = $converted_price;
						$freeship_flag_text='';
						 //$total += $converted_price;
						 $subtotal += $converted_price;
									
								   
								   if($activated_seller_id==$combo['seller_id'])
									{
										 $flag_single_account_flag_class   =   'tr_bg_warning';
									}
									else{
										$flag_single_account_flag_class   =   '';
									}
					  

					 
						$product_weight = $combo["required_quantity"] * ComboPack::get_combo_weight($combo["combo_id"]);
					  
						$total_shipping_weight += $product_weight;
								   
																?>




				 <tr>
					<td height="32" align="left" valign="top"><?php echo $k; ?> </td>
					<td valign="top" align="left"><?php echo Order::showDigitalItemIcon($digitalFlag).(stripslashes($productname)); //"<br>".DISCOUNT."(".$discountstr."%)".$freeship_flag_text; ?>
					<div>
					 <?php echo $combo_products; ?>
					</div>
					<br><br>
					</td>
					<td valign="top" align="left"><?php echo htmlentities('Combo Product'); ?></td>
					<td align="left" valign="top"><?php echo $adminCurrency['currency_symbol'];?>  <?php echo htmlentities($price); ?></td>
					<td valign="top" align="left"><?php echo htmlentities($combo["required_quantity"]); ?></td>
					<td valign="top" align="left"><?php echo $adminCurrency['currency_symbol'];?>  <?php echo htmlentities($rate); ?></td>
					<td valign="top" align="left"><?php echo "Pending" ?>&nbsp;</td>
										<?php /*<td valign="top" align="left"><?php echo $product_shipping_cost; ?>&nbsp;</td>
										<td valign="top" align="left"><?php echo $shippingName; ?>&nbsp;</td>
										<td valign="top" align="left"><?php echo $producttype; ?>&nbsp;</td>*/?>
				</tr> 









																		<?php
								   
								$k++;
						$cnt++;
					}

				///combo listing foreach ends
				
				?>
				</table>
			</div>
			
			<div class="clearfix"></div>
			<div class="vieworder_pricelist margin_B_30">
				<div class="row">
					<?php if(getArtistOrderStatus($orderid,$artists[$i])!= 'Delivered' &&  getArtistOrderStatus($orderid,$artists[$i])!='Cancelled')
					{   ?> 
					<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
						<div class="row">
							<div class="col-xs-12 col-sm-12 col-md-5">
								<?php echo CHANGE_STATUS_TO;?>
							</div>
							<div class="col-xs-12 col-sm-12 col-md-7 vieworder_pricelist_ctrl">
								<?php echo $ddl;?> 
								<!-- <input name="chkStatus" type="checkbox" id="chkStatus" value="Y">
								<?php echo INFRM_ORDERTO_BUYER;?> </span>-->
								<?php echo $btn;?>
							</div>
						</div>
					</div>
					<?php } ?>    
					
					
					<?php
						 $grand_total+=$subtotal;
						}
					}// echo "AAA"; exit();
					
					
					?>
					
					<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
						
						<div class="vieworder_total_pricelist_outer">
								<div class="col-xs-12 col-sm-12 col-md-7 col-lg-7 vieworder_total_pricelist_L"><?php echo ITEM_PRICE_TOTAL;?></div>
								<div class="col-xs-12 col-sm-12 col-md-5 col-lg-5 vieworder_total_pricelist_R">
									<?php echo $adminCurrency['currency_symbol'];?>  <?php echo number_format($grand_total,2,".","" ); ?>
								</div>
							<?php 
							if($row1['vgiftcertificate_code']!='' && $row1['nused_gift_amount']!=0 ){
							?>
								<div class="col-xs-12 col-sm-12 col-md-7 col-lg-7 vieworder_total_pricelist_L"><?php echo GC_AMOUNT;?></div>
								<div class="col-xs-12 col-sm-12 col-md-5 col-lg-5 vieworder_total_pricelist_R">
									- <?php echo $adminCurrency['currency_symbol'];?>  <?php echo number_format($row1['nused_gift_amount'],2,".","" ); ?>
								</div>
							
								<div class="col-xs-12 col-sm-12 col-md-7 col-lg-7 vieworder_total_pricelist_L"><?php echo GIFT_CERT_CODE;?></div>
								<div class="col-xs-12 col-sm-12 col-md-5 col-lg-5 vieworder_total_pricelist_R"><?php echo $row1['vgiftcertificate_code']; ?></div>
							<?php  } ?>
							<?php 
							if($row1['couponCodeDiscount']>0){
								 $couponCodeDiscountAmount = $row1["couponCodeDiscount"];
							?>
								<div class="col-xs-12 col-sm-12 col-md-7 col-lg-7 vieworder_total_pricelist_L">
									<?php echo COUPON_CODE_TEXT1;?>
									<?php echo $row1['couponCode']?>
									<?php echo DISCOUNT_TEXT1;?>
								</div>
								<div class="col-xs-12 col-sm-12 col-md-5 col-lg-5 vieworder_total_pricelist_R"> - 
									<?php echo $adminCurrency['currency_symbol'];?> <?php echo number_format($couponCodeDiscountAmount,2,".","" ); ?>
								</div>
							<?php  } ?>
							<?php 
							 if($row1["nused_gift_amount"]>0 || $row1['couponCodeDiscount']>0 ) {
								$giftDiscountAmount           = $row1["nused_gift_amount"];
																														   
								$couponCodeDiscountAmount       =   $row1['couponCodeDiscount'];
								$TotalDiscount                  =   $giftDiscountAmount + $couponCodeDiscountAmount;
								$priceafterdiscount             =   $grand_total-$TotalDiscount;
								$grand_total=number_format($priceafterdiscount,2,".","");
							 ?>
								<div class="col-xs-12 col-sm-12 col-md-7 col-lg-7 vieworder_total_pricelist_L">
									<?php echo PRODUCT_TOT_TEXT_DISCOUNT;?>
								</div>
								<div class="col-xs-12 col-sm-12 col-md-5 col-lg-5 vieworder_total_pricelist_R">
									<?php echo $adminCurrency['currency_symbol'];?>  <?php echo number_format($grand_total,2,".","" ); ?>
								</div>
							<?php } ?>
							<?php
	
							if(!empty($totalshippingcost))
							{
							?>	
								<div class="col-xs-12 col-sm-12 col-md-7 col-lg-7 vieworder_total_pricelist_L"><?php echo TOTAL_SHP_COST;?></div>
								<div class="col-xs-12 col-sm-12 col-md-5 col-lg-5 vieworder_total_pricelist_R">
									<?php echo $adminCurrency['currency_symbol'];?> <?php echo number_format($totalshippingcost,2,".","" ); ?>
								</div>
							<?php } ?>
							<?php
								$carttotal=$grand_total;
								if(!empty($totalshippingcost))
								{
								
									$carttotal=$carttotal+$totalshippingcost;
								}
								
								if(!empty($totaltax))
								{
									$carttotal=$carttotal+$totaltax;
							?>
							 
								<div class="col-xs-12 col-sm-12 col-md-7 col-lg-7 vieworder_total_pricelist_L"><?php echo TAX_RATE;?></div>
								<div class="col-xs-12 col-sm-12 col-md-5 col-lg-5 vieworder_total_pricelist_R">
									<?php echo $adminCurrency['currency_symbol'];?>  <?php echo number_format($totaltax,2,".","" ); ?>
								</div>
							 
							<?php } ?>
							 
						<div class="clearfix"></div>
	
							 <div class="view_order_main_total">
								<div class="col-xs-12 col-sm-12 col-md-7 col-lg-7 vieworder_total_pricelist_L"><?php echo ORDER_TOTAL;?></div>
								<div class="col-xs-12 col-sm-12 col-md-5 col-lg-5 vieworder_total_pricelist_R" id="order_total_text_bottom">
									<?php echo $adminCurrency['currency_symbol'];?>  <?php echo number_format($carttotal+$TotalDiscount ,2,".","" ); ?>
								</div>
							 
								<div class="col-xs-12 col-sm-12 col-md-7 col-lg-7 vieworder_total_pricelist_L"><?php echo AMOUNT_PAID;?></div>
								<div class="col-xs-12 col-sm-12 col-md-5 col-lg-5 vieworder_total_pricelist_R">
									<?php echo $adminCurrency['currency_symbol'];?>  <?php echo number_format($row1['namount_paid'],2,".","" ); ?>
								</div>
							</div>
						<div class="clearfix"></div>
						</div>
					</div>
				</div>
			</div>
		<div class="clearfix"></div>
		
		
		<?php
		$select_shipping_cost = "SELECT sd.vshipping_name, sd.nshipping_cost,CONCAT(ar.first_name,' ',ar.last_name)as artist_name
			FROM ".$tableprefix."shipping_details sd
			INNER JOIN ".$tableprefix."artists ar ON ar.artist_id = sd.seller_id              
			WHERE sd.norder_id = :orderid AND  nshp_status = 'C' order by ar.artist_name";
		$result_shipping_cost = $pdo->pdoQuery($select_shipping_cost,array("orderid"=>$orderid))->results();
		?>	
		
		<h2><?php echo SHIPPING_DETAILS;?></h2>
		
		<div class="table-responsive">
			<table width="100%" border="0" cellpadding="3" cellspacing="3" class="table admin_table">
				<tr class="form_header">
					<th><?php echo SELLER_NAME;?></th>
					<th><?php echo SHIPPING_TYPE;?></th>
					<th><?php echo SHIPPING_COST;?></th>
				</tr>
					<?php
												
				if(count($result_shipping_cost) > 0)
				{
					foreach($result_shipping_cost as $shipping_row)
					{
					   // $totalshippingcost+=$shipping_row['nshipping_cost'];		
				?>	
				<tr>
				<td><?php echo stripslashes($shipping_row['artist_name']); ?></td>
				<td><?php echo stripslashes($shipping_row['vshipping_name']); ?></td>
				<td><?php echo $adminCurrency['currency_symbol'];?> <?php echo number_format($shipping_row['nshipping_cost'],2,".","" ); ?></td>
				</tr>
				<?php 
					} // end while 
				} // end if number of rows
				else
				{
				?>
				<tr align="center"><td colspan="3" class="text_information"> <?php echo NO_SHIPPING_FOUND;?> .</td>
				</tr>
				<tr><td colspan="3">&nbsp; </td></tr>
				<?php
				
				} // ens else
				?>
			</table>
		</div>
		<div class="clearfix"></div>
		
		<div class="white_cont_outer margin_B_30">
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-6 vieworder_shipping_box">
					<h2><?php echo SHIPPING_DETAILS;?></h2>
					<div class="row">
						<?php 
							if($row["prefered_shippin_method"] !="")
							{	
						?>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo SHIPPING_METHOD;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["prefered_shippin_method"]);?></div>
						<?php 
							} 	
						?>
						<div class="clearfix"></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo FNAME;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo ($row1["shipping_first_name"]);?>&nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo LNAME;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo ($row1["shipping_last_name"]);?>&nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo ADDRESS;?> 1</div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["shipping_address1"]);?>&nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo ADDRESS;?> 2</div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["shipping_address2"]);?>&nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo CITY;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["shipping_city"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo STATE;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["shipping_state"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo COUNTRY;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["shipping_country"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo ZIP;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["shipping_zip"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo PHONE;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["shipping_phone"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo EMAIL;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["shipping_email"]);?> &nbsp;</div>
						<div class="clearfix"></div>
					</div>
				</div>
				
				
				
				<div class="col-xs-12 col-sm-12 col-md-6">
					<h2><?php echo BILLING_DETAILS;?></h2>
					<div class="row">
					
						<?php if($row1['buyer_comments']!='') { ?>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo BUYER_COMMENTS;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo stripslashes($row1['buyer_comments']) ;?> &nbsp;</div>
						<div class="clearfix"></div>
						<?php  } ?>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo FNAME;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo ($row1["billing_first_name"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo LNAME;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo ($row1["billing_last_name"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo ADDRESS;?> 1</div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["billing_address1"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo ADDRESS;?> 2</div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["billing_address2"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo CITY;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["billing_city"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo STATE;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["billing_state"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo COUNTRY;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["billing_country"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo ZIP;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["billing_zip"]);?> &nbsp;</div>	
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo PHONE;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["billing_phone"]);?> &nbsp;</div>
						<div class="clearfix"></div>
						
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_label"><?php echo EMAIL;?></div>
						<div class="col-xs-12 col-sm-12 col-md-6 vieworder_adrs_txt"><?php echo htmlentities($row1["billing_email"]);?> &nbsp;</div>
						<div class="clearfix"></div>						
					</div>
				</div>
				
			</div>
		<div class="clearfix"></div>
		</div>
		
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-3">
				<button type="button" value="<?php echo BACK_ORDER;?>" class="secondary" onClick="window.location.href='orders.php'"><i class="fa fa-chevron-left" aria-hidden="true"></i> <?php echo BACK_ORDER;?></button>
			</div>
			<div class="col-xs-12 col-sm-12 col-md-3"></div>
			<div class="col-xs-12 col-sm-12 col-md-3"></div>
		</div>
		
		</form>
		
	</div>
</div>
																					
								
					
				
								
 				<!--main body end -->
				</div>
				
				
<?php
	include "../includes/admin_new_footer.php";

?>