<?php

/*
 * Description : Script to execute in order to save url based images in the system
 * 
 */
include_once "../includes/config.php";
include_once "../includes/functions.php";
include_once '../includes/S3.php';
ini_set('max_execution_time',0);



if(ENABLE_AMAZON_S3_IMAGES=="Y"){

$s3 = new S3(AMAZON_ACCESS_KEY, AMAZON_SECRET_KEY);


// Move product images to CDN
$select_images = "SELECT product_option_id,image_small,image_big from ".$tableprefix."product_options  WHERE cdn_images_moved='N' order by product_option_id DESC";


$result_images = $pdo->pdoQuery($select_images)->results();
 if(count($result_images)>0){
        
       
        foreach($result_images as $row){

            
            $image_small       = "../products/".$row['image_small'];
            $image_big         = "../products/".$row['image_big'];
            $image_thumb       = "../products/thumb_".$row['image_big'];
             
             $size = getimagesize($image_small); 
             $content_type = $size['mime'];
             $requestHeaders = array(
                'Cache-Control' => 'max-age=2692000',
                'Expires' => gmdate('D, d M Y H:i:s T', strtotime('+1 year')),
                'Content-Type' => $content_type,
             );
             
             $size1 = getimagesize($image_big); 
             $content_type1 = $size1['mime'];
             $requestHeaders1 = array(
                'Cache-Control' => 'max-age=2692000',
                'Expires' => gmdate('D, d M Y H:i:s T', strtotime('+1 year')),
                'Content-Type' => $content_type1,
             );
           
             $s3->putObjectFile($image_small, AMAZON_BUCKET_NAME,$image_small, S3::ACL_PUBLIC_READ,'',$requestHeaders);
             $s3->putObjectFile($image_big, AMAZON_BUCKET_NAME,$image_big, S3::ACL_PUBLIC_READ,'',$requestHeaders1);
             $s3->putObjectFile($image_thumb, AMAZON_BUCKET_NAME,$image_thumb, S3::ACL_PUBLIC_READ,'',$requestHeaders1);
           
            $result_update = $pdo->update($tableprefix.'product_options', array('cdn_images_moved' =>'Y'), array("
                product_option_id" => $row['product_option_id']))->affectedRows();
            

        
        }
} 



// Move More Images to CDN

$select_more =  "SELECT nproduct_image_id,vimage_name from ".$tableprefix."product_view_images WHERE cdn_images_moved='N' order by nproduct_image_id DESC";

$result_more = $pdo->pdoQuery($select_more)->results();
    if(count($result_more)>0){
        
        foreach($result_more as $row){
            
             $image_more       = "../products/".$row['vimage_name'];
             $thumb_image_more = "../products/thumb_".$row['vimage_name'];
           
             $size = getimagesize($image_more); 
             $content_type = $size['mime'];
             $requestHeaders = array(
                'Cache-Control' => 'max-age=2692000',
                'Expires' => gmdate('D, d M Y H:i:s T', strtotime('+1 year')),
                'Content-Type' => $content_type,
             );
            
             
             $s3->putObjectFile($image_more, AMAZON_BUCKET_NAME,$image_more, S3::ACL_PUBLIC_READ,'',$requestHeaders);
             $s3->putObjectFile($thumb_image_more, AMAZON_BUCKET_NAME,$thumb_image_more, S3::ACL_PUBLIC_READ,'',$requestHeaders);
          
            $result_update = $pdo->update($tableprefix.'product_view_images', array('cdn_images_moved' =>'Y'), array("nproduct_image_id" => $row['nproduct_image_id']))->affectedRows();
             
        }
        
    }

}

// Move Home Page banners to CDN

$select_home_banners =  "SELECT image,homepage_banner_id from ".$tableprefix."homepagebanners 
                            WHERE cdn_images_moved='N' order by homepage_banner_id DESC";

$result_home_banners = $pdo->pdoQuery($select_home_banners)->results();
if(count($result_home_banners)>0){
    
    foreach($result_home_banners as $row){
        
         $image_home            = "../homepagebanners/".$row['image'];
         $size                  = getimagesize($image_home); 
         $content_type          = $size['mime'];
         $requestHeaders        = array(
                                    'Cache-Control' => 'max-age=2692000',
                                    'Expires' => gmdate('D, d M Y H:i:s T', strtotime('+1 year')),
                                    'Content-Type' => $content_type,
                                   );
         if(AMAZON_BUCKET_NAME != "")
            $s3->putObjectFile($image_home, AMAZON_BUCKET_NAME,$image_home, S3::ACL_PUBLIC_READ,'',$requestHeaders);
          
         $result_update = $pdo->update($tableprefix.'homepagebanners', array('cdn_images_moved' =>'Y'), array("homepage_banner_id" => $row['homepage_banner_id']))->affectedRows();
             
        
    }
    
}

// Move Bottom Banners to CDN

$select_bottom_banners =  "SELECT vbanner_image,nbanner_id from ".$tableprefix."banners 
                            WHERE cdn_images_moved='N' order by nbanner_id DESC";

$result_bottom_banners = $pdo->pdoQuery($select_bottom_banners)->results();
if(count($result_bottom_banners)>0){
    
    foreach($result_bottom_banners as $row){
        
         $image_home       = "../banners/".$row['vbanner_image'];
         $size             = getimagesize($image_home); 
         $content_type     = $size['mime'];
         $requestHeaders   = array(
                                'Cache-Control' => 'max-age=2692000',
                                'Expires' => gmdate('D, d M Y H:i:s T', strtotime('+1 year')),
                                'Content-Type' => $content_type,
                              );
         if(AMAZON_BUCKET_NAME != "")
            $s3->putObjectFile($image_home, AMAZON_BUCKET_NAME,$image_home, S3::ACL_PUBLIC_READ,'',$requestHeaders);
         
         $result_update = $pdo->update($tableprefix.'banners', array('cdn_images_moved' =>'Y'), array("nbanner_id" => $row['nbanner_id']))->affectedRows();
        
    }
    
}

// Move Category Images to CDN

$select_categories =  "SELECT category_id,avatar from ".$tableprefix."categories 
                            WHERE cdn_images_moved='N' order by category_id DESC";

$result_categories = $pdo->pdoQuery($select_categories)->results();
if(count($result_categories)>0){
    
    foreach($result_categories as $row){
        
         $image_home       = "../categories/avatar/".$row['avatar'];
         $size             = getimagesize($image_home); 
         $content_type     = $size['mime'];
         $requestHeaders   = array(
                                'Cache-Control' => 'max-age=2692000',
                                'Expires' => gmdate('D, d M Y H:i:s T', strtotime('+1 year')),
                                'Content-Type' => $content_type,
                              );
         if(AMAZON_BUCKET_NAME != "")
            $s3->putObjectFile($image_home, AMAZON_BUCKET_NAME,$image_home, S3::ACL_PUBLIC_READ,'',$requestHeaders);
         
         $result_update = $pdo->update($tableprefix.'categories', array('cdn_images_moved' =>'Y'), array("category_id" => $row['category_id']))->affectedRows();
        
    }
    
}


?>
