RENAME TABLE `multicart_products` TO `multicart_products_backup`; 

DROP TABLE IF EXISTS `multicart_products`;
CREATE TABLE IF NOT EXISTS `multicart_products` (
  `product_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_name` varchar(255) DEFAULT NULL,
  `product_code` varchar(20) DEFAULT NULL,
  `product_description` text,
  `product_price` double DEFAULT NULL,
  `product_category` int(11) DEFAULT NULL,
  `product_artist_id` int(11) DEFAULT NULL,
  `date_added` date DEFAULT NULL,
  `deleted` char(1) DEFAULT 'N',
  `featured` char(1) DEFAULT 'N',
  `vdigital_product` char(1) NOT NULL DEFAULT '',
  `vapproved` char(2) NOT NULL DEFAULT 'N',
  `payment_status` enum('PENDING','COMPLETED') NOT NULL DEFAULT 'PENDING',
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `multicart_admin_menu`;
CREATE TABLE IF NOT EXISTS `multicart_admin_menu` (
  `menu_id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(200) NOT NULL default '',
  `link` varchar(200) NOT NULL default '',
  `parent_id` smallint(4) NOT NULL default '0',
  `display_order` tinyint(4) NOT NULL default '0',
  `divname` varchar(200) NOT NULL default '',
  `status` enum('ACTIVE','INACTIVE') NOT NULL default 'ACTIVE',
  PRIMARY KEY  (`menu_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ;


ALTER TABLE multicart_settings ADD enable_rma varchar(10) NOT NULL default 'N' After  approve_products,
ADD rma_repair varchar(10) NOT NULL default 'N' After  enable_rma,
ADD rma_replace varchar(10) NOT NULL default 'N' After  rma_repair,
ADD rma_refund varchar(10) NOT NULL default 'N' After  rma_replace,
ADD rma_confirm_message varchar(10) NOT NULL default 'N' After  rma_refund,
ADD rma_status_change varchar(10) NOT NULL default 'N' After  rma_confirm_message,
ADD enable_bulkupload varchar(10) NOT NULL default 'N' After  rma_status_change;
 
ALTER TABLE multicart_orders ADD taxrate double default '0' After order_total_price;
 
drop table if exists multicart_refunds;
CREATE TABLE multicart_refunds (
  refund_id bigint(20) NOT NULL auto_increment,
  seller_id bigint(20) NOT NULL default '0',
  buyer_id bigint(20) NOT NULL default '0',
  product_id bigint(20) NOT NULL default '0',
  order_id bigint(20) NOT NULL default '0',
  quantity bigint(20) default NULL,
  return_reason text NOT NULL,
  Customer_Feedback text,
  Status varchar(255) default NULL,
  Additional_info text,
  date date NOT NULL default '0000-00-00',
 refund_mode varchar(255) default NULL,
  reference_number varchar(255) default NULL,
  PRIMARY KEY  (`refund_id`)
) TYPE=MyISAM;
drop table if exists multicart_Review;

CREATE TABLE multicart_Review (
nRId INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
nUserId INT NOT NULL DEFAULT '0',
nProdId INT NOT NULL DEFAULT '0',
vDes TEXT NOT NULL ,
vActive ENUM( '0', '1' ) NOT NULL DEFAULT '0'
) ENGINE = MYISAM ;

drop table if exists multicart_shipping_settings;

CREATE TABLE multicart_shipping_settings (
  sid tinyint(11) NOT NULL auto_increment,
  nShippingweight int(11) NOT NULL default '0',
  ups_rate varchar(255) NOT NULL default '',
  container_type varchar(255) NOT NULL default '',
  address_quote_method varchar(255) NOT NULL default '',
  PRIMARY KEY  (sid)
) TYPE=MyISAM;

ALTER TABLE multicart_record_ratings ADD vType CHAR( 1 ) NOT NULL DEFAULT 's' AFTER ntotal_ratings,
ADD vActive ENUM( '0', '1' ) NOT NULL DEFAULT '1' AFTER vType;

ALTER TABLE multicart_settings ADD vReview CHAR( 9 ) NOT NULL DEFAULT 'automatic' AFTER site_logo;





drop table if exists multicart_newsletters;

CREATE TABLE multicart_newsletters (
  nl_id int(11) NOT NULL auto_increment,
  nl_subject varchar(200) NOT NULL default '',
  nl_message text NOT NULL,
  nl_date timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (nl_id),
  UNIQUE KEY nl_id (nl_id)
) ENGINE = MyISAM;


drop table if exists multicart_Subscribers;

CREATE TABLE multicart_Subscribers (
  nl_subscribersID int(11) NOT NULL auto_increment,
  user_id int(11) NOT NULL default '0',
  nl_id int(11) NOT NULL default '0',
  PRIMARY KEY  (nl_subscribersID),
  UNIQUE KEY nl_subscribersID (nl_subscribersID)
) ENGINE=MyISAM;


drop table if exists multicart_couponCode;

CREATE TABLE multicart_couponCode (
  ccID int(11) NOT NULL auto_increment,
  ccStartDate date NOT NULL default '0000-00-00',
  ccEndDate date NOT NULL default '0000-00-00',
  ccCode varchar(50) NOT NULL default '',
  ccDescription text NOT NULL,
  ccDiscount int(11) NOT NULL default '0',
  subscriptionStatus char(1) NOT NULL default '',
  ccStatus char(1) NOT NULL default '',
  PRIMARY KEY  (ccID),
  UNIQUE KEY ccCode (ccCode)
) ENGINE=MyISAM;


drop table if exists multicart_sellerPlans;

CREATE TABLE multicart_sellerPlans (
  plan_Id int(11) NOT NULL auto_increment,
  plan_Title varchar(100) NOT NULL default '',
  plan_Description text NOT NULL,
  plan_Period char(1) NOT NULL default '',
  plan_SubscriptionCharge double NOT NULL default '0',
  plan_Status char(1) NOT NULL default '',
  PRIMARY KEY  (plan_Id)
) ENGINE=MyISAM;


drop table if exists multicart_artists_membershipDetails;

CREATE TABLE multicart_artists_membershipDetails (
  artist_memID int(11) NOT NULL auto_increment,
  artist_id int(11) NOT NULL default '0',
  artist_memStartDate date NOT NULL default '0000-00-00',
  artist_memEndDate date NOT NULL default '0000-00-00',
  plan_Id int(11) NOT NULL default '0',
  plan_SubscriptionCharge double NOT NULL default '0',
  PRIMARY KEY  (artist_memID)
) ENGINE=MyISAM;
        


ALTER TABLE multicart_orders ADD couponCode varchar(50)  NOT NULL DEFAULT '0' AFTER taxrate;
ALTER TABLE multicart_orders ADD couponCodeDiscount int(11) NOT NULL DEFAULT '0' AFTER couponCode;


ALTER TABLE multicart_settings ADD venable_couponCode_payment char(1) NOT NULL DEFAULT 'N' AFTER venable_gift_payment;
ALTER TABLE multicart_settings ADD enable_buyerToseller char(1) NOT NULL DEFAULT 'N' AFTER venable_couponCode_payment;
ALTER TABLE multicart_settings ADD enable_membership char(1) NOT NULL DEFAULT 'N' AFTER enable_buyerToseller,
CHANGE defaulttax_rate defaulttax_rate FLOAT NULL DEFAULT '0';


ALTER TABLE multicart_artists ADD sellerPlanID int(11) NOT NULL  AFTER additionalflatrate;
ALTER TABLE multicart_artists ADD enablepaypal char(1) NOT NULL   DEFAULT '' AFTER sellerPlanID;
ALTER TABLE multicart_artists ADD enablepaypalsandbox char(1) NOT NULL DEFAULT '' AFTER enablepaypal;
ALTER TABLE multicart_artists ADD paypalidentitytoken varchar(200) NOT NULL DEFAULT '' AFTER enablepaypalsandbox;
ALTER TABLE multicart_artists ADD paypalemail varchar(100) NOT NULL DEFAULT '' AFTER paypalidentitytoken;

ALTER TABLE `multicart_orders` ADD `transaction_id` VARCHAR( 255 ) ;
ALTER TABLE `multicart_shipping_details` ADD `user_id` INT( 11 ) NOT NULL DEFAULT '0';
ALTER TABLE `multicart_artist_payments` ADD `payment_status` ENUM( 'P', 'C' ) NOT NULL DEFAULT 'P';

 ALTER TABLE `multicart_settings` ADD `flatrate_displayname` VARCHAR( 255 ) NOT NULL DEFAULT 'Over night ground';


ALTER TABLE `multicart_affiliate_registrations` CHANGE `user_totalpurchasedamount` `user_totalpurchasedamount` DOUBLE NULL;


CREATE TABLE IF NOT EXISTS `multicart_giftcertificates` (
  `gift_id` int(11) NOT NULL AUTO_INCREMENT,
  `vgift_coupon_code` varchar(255) NOT NULL,
  `ngift_order_id` int(11) NOT NULL,
  `ngift_coupon_amount` double NOT NULL,
  `ngift_product_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `nused_gift_amount` double NOT NULL DEFAULT '0',
  `seller_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gift_id`)
) ENGINE=MyISAM  ;


ALTER TABLE `multicart_orders` ADD `nused_gift_amount` DOUBLE NOT NULL DEFAULT '0',
ADD `namount_paid` DOUBLE NOT NULL DEFAULT '0';


CREATE TABLE IF NOT EXISTS `multicart_admin_menu` (
  `menu_id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(200) NOT NULL default '',
  `link` varchar(200) NOT NULL default '',
  `parent_id` smallint(4) NOT NULL default '0',
  `display_order` tinyint(4) NOT NULL default '0',
  `divname` varchar(200) NOT NULL default '',
  `status` enum('ACTIVE','INACTIVE') NOT NULL default 'ACTIVE',
  PRIMARY KEY  (`menu_id`)
) ENGINE=MyISAM   ;


ALTER TABLE `multicart_orders` ADD `vgiftcertificate_code` VARCHAR( 255 ) NOT NULL ;


ALTER TABLE `multicart_settings` ADD `admin_currency` VARCHAR( 255 ) NOT NULL DEFAULT 'USD';


ALTER TABLE `multicart_currency_master` ADD `usdollar_rate` FLOAT NOT NULL DEFAULT '1';


ALTER TABLE `multicart_couponcode` CHANGE `ccDiscount` `ccDiscount` DOUBLE NOT NULL DEFAULT '0';

ALTER TABLE `multicart_affiliate_registrations` ADD `order_id` INT NOT NULL AFTER `user_id`; 

ALTER TABLE `multicart_affiliate_payments` ADD `order_id` INT NOT NULL AFTER `affiliate_id` ;


ALTER TABLE `multicart_artists` ADD `plan_expired` ENUM( 'Y', 'N' ) NOT NULL DEFAULT 'N' COMMENT 'Whether plan expired or not';

ALTER TABLE `multicart_artists_membershipDetails` ADD `transaction_id` VARCHAR( 255 ) NOT NULL ;


ALTER TABLE `multicart_order_details` ADD `item_delivery_date` DATETIME NOT NULL ;


CREATE TABLE IF NOT EXISTS `multicart_metatags` (
  `nId` int(11) NOT NULL auto_increment,
  `vTitle` varchar(200) default NULL,
  `vKeywords` text,
  `vDescription` text,
  `vPageName` varchar(20) default NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1  ;

ALTER TABLE `multicart_artists` 
	CHANGE `sellerPlanID` `sellerPlanID` int(11)   NOT NULL DEFAULT '0' after `additionalflatrate`, 
	CHANGE `plan_expired` `plan_expired` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' COMMENT 'Whether \r\n\r\nplan expired or not' after `paypalemail`;

ALTER TABLE `multicart_cart` 
	ADD COLUMN `product_option_id` bigint(20)   NOT NULL after `product_id`, 
	CHANGE `quantity` `quantity` int(11)   NULL after `product_option_id`, 
	CHANGE `status` `status` tinyint(4)   NULL after `quantity`, 
	CHANGE `datetime_added` `datetime_added` varchar(20)  COLLATE latin1_swedish_ci NULL after `status`;


ALTER TABLE `multicart_categories` 
	ADD COLUMN `avatar` varchar(250)  COLLATE latin1_swedish_ci NOT NULL after `gift_certificate_flag`;

CREATE TABLE `multicart_category_options`(
	`category_option_id` bigint(20) NOT NULL  auto_increment , 
	`category_id` bigint(20) NOT NULL  , 
	`option_id` bigint(20) NOT NULL  , 
	PRIMARY KEY (`category_option_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


ALTER TABLE `multicart_couponcode` 
	CHANGE `ccDiscount` `ccDiscount` int(11)   NOT NULL DEFAULT '0' after `ccDescription`;

CREATE TABLE `multicart_email_templates_back`(
	`nemail_id` int(11) NOT NULL  auto_increment , 
	`vtemplate_name` varchar(100) COLLATE latin1_swedish_ci NOT NULL  DEFAULT '' , 
	`vtemplate_title` varchar(100) COLLATE latin1_swedish_ci NOT NULL  DEFAULT '' , 
	`vemail_body` text COLLATE latin1_swedish_ci NOT NULL  , 
	`vreplaceable_variables` text COLLATE latin1_swedish_ci NOT NULL  , 
	`vtemplate_flag` char(1) COLLATE latin1_swedish_ci NULL  DEFAULT '' , 
	PRIMARY KEY (`nemail_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_flat_rate_default`(
	`flat_rate_default_id` bigint(20) NOT NULL  auto_increment , 
	`flat_rate_name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`first_Item_charge` float NOT NULL  , 
	`additional_Item_charge` float NOT NULL  , 
	PRIMARY KEY (`flat_rate_default_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_flat_rate_seller`(
	`flat_rate_seller_id` bigint(20) NOT NULL  auto_increment , 
	`flat_rate_name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`first_Item_charge` float NOT NULL  , 
	`additional_Item_charge` float NOT NULL  , 
	`seller_id` bigint(20) NOT NULL  , 
	PRIMARY KEY (`flat_rate_seller_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_help`(
	`hid` int(11) NOT NULL  auto_increment , 
	`hcid` int(11) NULL  , 
	`htitle` varchar(100) COLLATE latin1_swedish_ci NULL  , 
	`hdescription` text COLLATE latin1_swedish_ci NULL  , 
	`hposition` int(11) NULL  , 
	`active` enum('0','1') COLLATE latin1_swedish_ci NULL  , 
	`himage` varchar(100) COLLATE latin1_swedish_ci NULL  , 
	PRIMARY KEY (`hid`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_helpcategory`(
	`hcid` int(11) NOT NULL  auto_increment , 
	`htype` varchar(10) COLLATE latin1_swedish_ci NULL  , 
	`hctitle` varchar(100) COLLATE latin1_swedish_ci NULL  , 
	`hcposition` int(11) NULL  , 
	`active` enum('0','1') COLLATE latin1_swedish_ci NULL  , 
	PRIMARY KEY (`hcid`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_homepagebanners`(
	`homepage_banner_id` bigint(20) NOT NULL  auto_increment , 
	`image` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`deleted` enum('Y','N') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'N' , 
	`created_on` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	PRIMARY KEY (`homepage_banner_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_message_to_seller`(
	`message_to_seller_id` bigint(20) NOT NULL  auto_increment , 
	`artist_id` int(11) NOT NULL  , 
	`name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`email` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`subject` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`message` text COLLATE latin1_swedish_ci NOT NULL  , 
	`created_on` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	`read` enum('Y','N') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'N' , 
	PRIMARY KEY (`message_to_seller_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';



CREATE TABLE `multicart_options`(
	`option_id` bigint(20) NOT NULL  auto_increment , 
	`option_name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	PRIMARY KEY (`option_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


ALTER TABLE `multicart_order_details` 
	ADD COLUMN `product_option_id` int(11)   NOT NULL after `product_id`, 
	CHANGE `product_name` `product_name` varchar(200)  COLLATE latin1_swedish_ci NULL after `product_option_id`, 
	CHANGE `product_code` `product_code` varchar(20)  COLLATE latin1_swedish_ci NULL after `product_name`, 
	CHANGE `product_price` `product_price` double   NULL after `product_code`, 
	ADD COLUMN `product_tax` float   NOT NULL after `product_price`, 
	CHANGE `product_quantity` `product_quantity` int(11)   NULL after `product_tax`, 
	CHANGE `artist_id` `artist_id` bigint(20)   NULL after `product_quantity`, 
	CHANGE `item_status` `item_status` smallint(6)   NULL after `artist_id`, 
	CHANGE `artist_payment_status` `artist_payment_status` smallint(6)   NULL after `item_status`, 
	CHANGE `artist_payment_id` `artist_payment_id` bigint(20)   NULL after `artist_payment_status`, 
	CHANGE `user_refund_id` `user_refund_id` bigint(20)   NULL DEFAULT '0' after `artist_payment_id`, 
	CHANGE `product_discount` `product_discount` int(11)   NULL DEFAULT '0' after `user_refund_id`, 
	CHANGE `item_delivery_date` `item_delivery_date` datetime   NOT NULL after `product_discount`, 
	ADD COLUMN `product_commission_amount` float   NOT NULL DEFAULT '0' after `item_delivery_date`;

ALTER TABLE `multicart_orders` 
	CHANGE `vgiftcertificate_code` `vgiftcertificate_code` varchar(255)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `transaction_id`, 
	CHANGE `nused_gift_amount` `nused_gift_amount` double   NOT NULL DEFAULT '0' after `vgiftcertificate_code`, 
	CHANGE `namount_paid` `namount_paid` double   NOT NULL DEFAULT '0' after `nused_gift_amount`, 
	ADD COLUMN `buyer_comments` text  COLLATE latin1_swedish_ci NOT NULL after `namount_paid`;

CREATE TABLE `multicart_product_impression`(
	`product_impression_id` bigint(20) NOT NULL  auto_increment , 
	`product_id` bigint(20) NOT NULL  , 
	`ip` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`visited_on` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	PRIMARY KEY (`product_impression_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_product_listing_fee_payment`(
	`product_listing_fee_payment_id` bigint(20) NOT NULL  auto_increment , 
	`product_id` bigint(20) NOT NULL  , 
	`total_amount` int(11) NOT NULL  , 
	`amount_paid` int(11) NOT NULL  , 
	`payment_method` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`payment_date` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	`payment_status` enum('PENDING','COMPLETED') COLLATE latin1_swedish_ci NOT NULL  , 
	PRIMARY KEY (`product_listing_fee_payment_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_product_option_values`(
	`product_option_value_id` bigint(20) NOT NULL  auto_increment , 
	`product_option_id` bigint(20) NOT NULL  , 
	`option_id` bigint(20) NOT NULL  , 
	`value` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	PRIMARY KEY (`product_option_value_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_product_options`(
	`product_option_id` bigint(20) NOT NULL  auto_increment , 
	`product_id` bigint(20) NOT NULL  , 
	`additional_price` float NOT NULL  , 
	`image_small` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`image_big` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`product_stock` int(11) NOT NULL  , 
	`reorder_level` int(11) NOT NULL  , 
	`product_shipping_weight` float NOT NULL  , 
	`default_option` enum('YES','NO') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'YES' , 
	`discount` float NOT NULL  , 
	`discount_description` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`product_width` int(11) NOT NULL  , 
	`product_height` int(11) NOT NULL  , 
	`product_length` int(11) NOT NULL  , 
	PRIMARY KEY (`product_option_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


ALTER TABLE `multicart_settings` 
	CHANGE `vReview` `vReview` varchar(9)  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'automatic' after `site_logo`, 
	ADD COLUMN `enable_multicurrency` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' after `site_logo`, 
	ADD COLUMN `slideshow_delay` int(5)   NOT NULL after `enable_multicurrency`, 
	ADD COLUMN `enable_affiliates` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'Y' after `slideshow_delay`, 
	ADD COLUMN `more_image_limit` int(11)   NOT NULL after `enable_affiliates`, 
	ADD COLUMN `vyourpay_userid` varchar(100)  COLLATE latin1_swedish_ci NOT NULL after `more_image_limit`, 
	ADD COLUMN `paypal_api_username` varchar(200)  COLLATE latin1_swedish_ci NOT NULL after `vyourpay_userid`, 
	ADD COLUMN `paypal_api_password` varchar(200)  COLLATE latin1_swedish_ci NOT NULL after `paypal_api_username`, 
	ADD COLUMN `paypal_api_signature` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `paypal_api_password`, 
	ADD COLUMN `paypal_application_app_id` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `paypal_api_signature`, 
	ADD COLUMN `product_listing_fee` int(11)   NOT NULL after `paypal_application_app_id`, 
	ADD COLUMN `enable_commentbox` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' after `product_listing_fee`, 
	ADD COLUMN `vbluepay_enable` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' after `enable_commentbox`, 
	ADD COLUMN `bluepay_accountid` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `vbluepay_enable`, 
	ADD COLUMN `bluepay_secretkey` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `bluepay_accountid`, 
	ADD COLUMN `bluepay_test_mode` enum('TEST','LIVE')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'TEST' after `bluepay_secretkey`;

ALTER TABLE `multicart_shipping_details` 
	ADD COLUMN `nproduct_option_id` int(11)   NOT NULL after `nshp_productid`, 
	ADD COLUMN `nshp_productname` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `nproduct_option_id`, 
	CHANGE `vshipping_name` `vshipping_name` varchar(250)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `nshp_productname`, 
	CHANGE `nshipping_cost` `nshipping_cost` float   NOT NULL DEFAULT '0' after `vshipping_name`, 
	CHANGE `nshipping_weight` `nshipping_weight` int(11)   NOT NULL DEFAULT '0' after `nshipping_cost`, 
	CHANGE `vshipping_currency` `vshipping_currency` varchar(10)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `nshipping_weight`, 
	CHANGE `dshipped_date` `dshipped_date` datetime   NOT NULL DEFAULT '0000-00-00 00:00:00' after `vshipping_currency`, 
	CHANGE `nshp_status` `nshp_status` char(1)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `dshipped_date`, 
	CHANGE `user_id` `user_id` bigint(11)   NOT NULL DEFAULT '0' after `nshp_status`;

CREATE TABLE `multicart_social_media`(
	`social_media_id` int(11) NOT NULL  auto_increment , 
	`name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`title` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`link` text COLLATE latin1_swedish_ci NOT NULL  , 
	`logo` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`active` enum('Y','N') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'Y' , 
	PRIMARY KEY (`social_media_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


ALTER TABLE `multicart_artist_payments` ADD `seller_order_total_amount` DOUBLE NOT NULL DEFAULT '0' AFTER `commission_percentage` ,ADD `admin_commision_amount` DOUBLE NOT NULL DEFAULT '0' AFTER `seller_order_total_amount` ;

ALTER TABLE `multicart_orders` ADD `payment_completed_status` ENUM( 'Y', 'N' ) NOT NULL DEFAULT 'N';

ALTER TABLE `multicart_artists` ADD INDEX `seller_index` ( `vapproved` , `deleted` );

ALTER TABLE `multicart_artists` ADD INDEX `date_register` ( `date_registered` );

ALTER TABLE multicart_product_options  ADD INDEX `defaultoption` ( `product_id` , `default_option` );

ALTER TABLE `multicart_products` ADD INDEX `vapproved` (`vapproved`);

ALTER TABLE `multicart_products` ADD INDEX `date_added` (`date_added`);

ALTER TABLE `multicart_products` ADD INDEX `deleted` (`deleted`);

ALTER TABLE `multicart_product_impression` ADD INDEX `product_id` (`product_id`) ;

ALTER TABLE `multicart_orders` ADD INDEX `paymentstatus` ( `vpayment_status` );

ALTER TABLE `multicart_artist_payments` ADD INDEX ( `order_id` );

ALTER TABLE `multicart_artist_payments` ADD INDEX ( `payment_status`);

ALTER TABLE `multicart_shipping_details` ADD INDEX ( `norder_id`);

ALTER TABLE `multicart_fedexsettings`
	ADD COLUMN `FedexPassword` VARCHAR(50) NULL DEFAULT NULL AFTER `FedexCurrency`,
	ADD COLUMN `FedexKey` VARCHAR(50) NULL DEFAULT NULL AFTER `FedexPassword`;
	
	
DROP TABLE IF EXISTS `multicart_sections`;
CREATE TABLE `multicart_sections` (
  `section_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_name` varchar(100) NOT NULL,
  `avatar` varchar(250) DEFAULT NULL,
  `status` enum('Y','N') NOT NULL DEFAULT 'Y',
  `alias` varchar(100) DEFAULT NULL,
  `cdn_images_moved` enum('Y','N') DEFAULT 'N',
  PRIMARY KEY (`section_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `multicart_section_category`;
CREATE TABLE `multicart_section_category` (
  `section_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`section_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `multicart_combo`;
CREATE TABLE `multicart_combo` (
  `combo_id` int(11) NOT NULL AUTO_INCREMENT,
  `combo_name` varchar(100) NOT NULL,
  `status` enum('Y','N') NOT NULL DEFAULT 'Y',
  `alias` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`combo_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `multicart_combo_products`;
CREATE TABLE `multicart_combo_products` (
  `combo_products_id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `combo_id` int NOT NULL,
  `products_id` int NOT NULL
) ENGINE='MyISAM' COLLATE 'utf8_general_ci';

ALTER TABLE `multicart_settings`
ADD COLUMN `enable_recommendation` CHAR(1) NOT NULL DEFAULT '' AFTER `enable_google`,
ADD COLUMN `recommendation_licence_value` TEXT NOT NULL AFTER `google_adsense_value`;

ALTER TABLE `multicart_settings`
ADD `enable_sectioncategory` varchar(10) COLLATE 'utf8_general_ci' NOT NULL DEFAULT 'N' AFTER `enable_bulkupload`;

ALTER TABLE `multicart_products`
ADD `product_section` text NULL AFTER `product_category`;

ALTER TABLE `multicart_combo`
ADD `quantity` int(11) NOT NULL AFTER `combo_name`;

ALTER TABLE `multicart_combo`
ADD `price` float NOT NULL AFTER `quantity`;

ALTER TABLE `multicart_combo`
ADD `avatar` varchar(250) COLLATE 'utf8_general_ci' NULL AFTER `price`,
ADD `cdn_images_moved` enum('Y','N') COLLATE 'utf8_general_ci' NULL DEFAULT 'N';

ALTER TABLE `multicart_combo_products`
CHANGE `products_id` `product_id` int(11) NOT NULL AFTER `combo_id`,
ADD `product_option_id` int(11) NOT NULL;

ALTER TABLE `multicart_combo_products`
ADD `product_quantity` int(11) NOT NULL DEFAULT '1' AFTER `product_option_id`;

ALTER TABLE `multicart_cart`
ADD COLUMN `combo_id` INT(11) NULL DEFAULT NULL AFTER `subscription_duration`;

ALTER TABLE `multicart_combo`
ADD COLUMN `seller_id` int(11) DEFAULT NULL;

ALTER TABLE `multicart_order_details`
ADD COLUMN `combo_id` int(11) DEFAULT NULL;

ALTER TABLE `multicart_combo`
ADD `combo_description` TEXT NOT NULL AFTER `combo_name`;

ALTER TABLE `multicart_settings`
ADD `cloudfront_cdn_url` varchar(255) NULL AFTER `enable_amazon_cdn_images`;

ALTER TABLE `multicart_settings`
ADD `enable_megamenu` varchar(100) DEFAULT 'N' NOT NULL ;

ALTER TABLE `multicart_settings`
ADD `enable_cookie` varchar(100) DEFAULT 'N' NOT NULL ;