<?php
class Booking
{

 /*
  * 
  * Function name : isLocationAvailable
  * Functionality : Checking whether a location available or not.
  * 
  */
 
 public static function isAccomadationAvailable($locationId,$accomadationId,$arrivalDate,$departureDate,$roomCount,$skipLastDay = true, $messageOption = false)
 {

    $db                   = new Db();

    $arrivalDate          = Utils::dateFormat($arrivalDate, 'm-d-Y', 'Y-m-d');
    $departureDate        = Utils::dateFormat($departureDate, 'm-d-Y', 'Y-m-d');

    
    $fetchIdQuery         = "select GROUP_CONCAT(AAT.nAat_Id) as ids from ".$db->tablePrefix."available_acco_type AAT
                             where nLocation_Id = '".$locationId."' and AAT.nAt_Id =  '".$accomadationId."'";

    $idResult             = $db->execute($fetchIdQuery);
    $ids                  = $db->fetchOne($idResult);

    if(trim($ids)!='')
    {
        if($messageOption)
        {   
            $response = Booking::isAccomadationAvailabilityBlocked($ids,$arrivalDate,$departureDate,$messageOption,true);

            if(is_array($response))            
               return $response;                        

        }
        else
        {
           if(Booking::isAccomadationAvailabilityBlocked($ids,$arrivalDate,$departureDate,$messageOption))
           return array();
        }

        



        $searchCriteriaQuery  = " nAat_Id in ($ids)";
        $availableRoomDetails = $db->selectRecord("available_acco_type AAT ",  " AAT.nRoom, AAT.`nAat_id`,AAT.`nAmount` ",$searchCriteriaQuery);

        $query               = " select sum(`nRooms`) as `reservedRooms`
                                  from `".MYSQL_TABLE_PREFIX."allotment` A
                                  left join ".$db->tablePrefix."booking B ON ( B.`nBooking_Id` = A.`nBooking_Id` )
                                  inner join ".$db->tablePrefix."customers C ON(B.nCust_Id = C.nCust_Id)
                                  where A.nAat_Id in ($ids)
                                  and A.vStatus = 'booked'
                                  and '".$arrivalDate."' between A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )
                                  or '".$departureDate."' between A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )
                                ";


       if($skipLastDay)
       {
           $departureDate1 = strtotime($departureDate . " -1 day");
           $departureDate1 = date("Y-m-d",$departureDate1);
       }
       else
       {
           $departureDate1 = $departureDate;
       }


        $query                = " select sum(`nRooms`) as `reservedRooms`
                                  from `".MYSQL_TABLE_PREFIX."allotment` A
                                  inner join ".$db->tablePrefix."booking B ON ( B.`nBooking_Id` = A.`nBooking_Id` )
                                  where A.nAat_Id in ($ids)
                                  and A.vStatus = 'booked'
                                  and A.dDate between '".$arrivalDate."' and '".$departureDate1."'
                                ";

//inner join ".$db->tablePrefix."customers C ON(B.nCust_Id = C.nCust_Id)


         $reservedRoom        = $db->fetchSingleRow($query);

         if($reservedRoom->reservedRooms == '' || $reservedRoom->reservedRooms == NULL)
            $reservedRoom->reservedRooms = 0;


         

         if( $roomCount <= ($availableRoomDetails->nRoom - $reservedRoom->reservedRooms) )
         {
            return array($availableRoomDetails->nAat_id,$availableRoomDetails->nAmount);
         }
         else
         {
             return array();
         }

    }
    else
    {
         return array();
    }


 }

public static function isNumberOfPeopleAllowed($ids,$numberOfPeople) {
	$db                   = new Db();
        $quevars = '';
        if($ids!=''){
            $quevars = " AND nAat_Id IN ($ids)";
        }
            
	$query          = "SELECT * FROM ".$db->tablePrefix."available_acco_type WHERE  nAdults > 0" .$quevars;
	//echo $query;die;
    $availableRoomDetails           = $db->fetchAll($db->execute($query));
    return $availableRoomDetails;
}

public static function isSeasonalRateAvailable($locationId,$accomadationId,$arrivalDate,$departureDate,$roomCount,$skipLastDay = true, $messageOption = false, $numberOfPeople = null) {
	$db                   = new Db();
    $arrivalDate          = Utils::dateFormat($arrivalDate, 'm-d-Y', 'Y-m-d');
    $departureDate        = Utils::dateFormat($departureDate, 'm-d-Y', 'Y-m-d');
    $fetchIdQuery         = "select GROUP_CONCAT(AAT.nAat_Id) as ids from ".$db->tablePrefix."available_acco_type AAT where nLocation_Id = '".$locationId."' and AAT.nAt_Id =  '".$accomadationId."'";
    $idResult             = $db->execute($fetchIdQuery);
    $ids                  = $db->fetchOne($idResult);
	//echo $ids;die;
    if(trim($ids)!='') {
    	
    	if(Booking::isAccomadationAvailabilityBlocked($ids,$arrivalDate,$departureDate,$messageOption)) {
           return array();
    	}
    	$searchCriteriaQuery  = " accomodationId in ($ids) AND (AAT.start_date between '".$arrivalDate."' and '".$departureDate."' OR AAT.end_date between '".$arrivalDate."' and '".$departureDate."' OR '".$arrivalDate."' between AAT.start_date and AAT.end_date OR '".$departureDate."' between AAT.start_date and AAT.end_date)";
        $availableRoomDetails = $db->selectRecord("accomodation_seasonal_rates AAT ",  " AAT.* ",$searchCriteriaQuery);

        $query          = "SELECT * FROM ".$db->tablePrefix."accomodation_seasonal_rates WHERE accomodationId in ($ids) AND (start_date between '".$arrivalDate."' and '".$departureDate."' OR end_date between '".$arrivalDate."' and '".$departureDate."' OR '".$arrivalDate."' between start_date and end_date OR '".$departureDate."' between start_date and end_date)";
        $availableRoomDetails           = $db->fetchAll($db->execute($query));
        /*select * FROM tbl_accomodation_seasonal_rates 
WHERE ( ('2015-09-02' between start_date and end_date ) OR ('2015-09-06' between start_date and end_date) 
OR (start_date between '2015-09-02' and '2015-09-06'  ) OR (end_date between '2015-09-02' and '2015-09-06'  ) 
)*/
        //print_r($availableRoomDetails);die;

        /*if($skipLastDay) {
           $departureDate1 = strtotime($departureDate . " -1 day");
           $departureDate1 = date("Y-m-d",$departureDate1);
       	}
       	else {
           $departureDate1 = $departureDate;
       	}*/
       /* $query             = " select sum(`nRooms`) as `reservedRooms` from `".MYSQL_TABLE_PREFIX."allotment` A inner join ".$db->tablePrefix."booking B ON ( B.`nBooking_Id` = A.`nBooking_Id` ) where A.nAat_Id in ($ids) and A.vStatus = 'booked' and A.dDate between '".$arrivalDate."' and '".$departureDate1."'";
         $reservedRoom     = $db->fetchSingleRow($query);*/

         //print_r($availableRoomDetails);die;

         /*if($reservedRoom->reservedRooms == '' || $reservedRoom->reservedRooms == NULL)
            $reservedRoom->reservedRooms = 0;
         if( $roomCount <= ($availableRoomDetails->nRoom - $reservedRoom->reservedRooms) )
         {
            return array($availableRoomDetails->accomodationId,$availableRoomDetails->rates);
         }
         else
         {
             return array();
         }*/
         return $availableRoomDetails;
    }
    return array();
    //print_r($ids);die('**');
}

 public static function isAccomadationAvailabilityBlocked($accomadationAvailabilityIds,$arrivalDate,$departureDate,$messageOption = false)
 {
     $db                    = new Db();     

     $query                = " select `nAat_Id`,dDate, DATE_ADD( dDate, INTERVAL nDays DAY ) as eDate
                               from `".MYSQL_TABLE_PREFIX."allotment`
                               where `nAat_Id` in ($accomadationAvailabilityIds)
                               and `vStatus` = 'blocked'                               
                               and ('".$arrivalDate."' between dDate AND DATE_ADD( dDate, INTERVAL nDays DAY )
                               or '".$departureDate."' between dDate AND DATE_ADD( dDate, INTERVAL nDays DAY ))
                             ";
//     $query                = " select `nAat_Id`,dDate, DATE_ADD( dDate, INTERVAL nDays DAY ) as eDate
//                               from `".MYSQL_TABLE_PREFIX."allotment`
//                               where `nAat_Id` in ($accomadationAvailabilityIds)
//                               and `vStatus` = 'blocked'                               
//                               and ('".$arrivalDate."' between dDate AND DATE_ADD( dDate, INTERVAL nDays DAY )
//                               or '".$departureDate."' between dDate AND DATE_ADD( dDate, INTERVAL nDays DAY ))
//                               or dDate between '".$arrivalDate."' and '".$departureDate."'
//                               or DATE_ADD( dDate, INTERVAL nDays DAY ) between '".$arrivalDate."' and '".$departureDate."'
//                                    
//                             ";
     
     $blockedRoom        = $db->fetchSingleRow($query);
    
     
     
     if($messageOption == true)
     {        
         
        if($blockedRoom->eDate == $blockedRoom->dDate) 
        {
           $endDate = strtotime($blockedRoom->eDate . " +".$numberOfDays." day");
           $endDate = date("Y-m-d",$date);
        }
        else
        {
            $endDate = $blockedRoom->eDate;
        }


        if($blockedRoom->nAat_Id > 0)
        return array('','','blocked',$blockedRoom->dDate,$endDate);
        else
        return false;
        

     }
     else if($blockedRoom->nAat_Id > 0)
     return true;
     else
       return false;


 }



 public static function getCostRate($locationId,$accomadationId,$arrivalDate,$departureDate,$roomCount)
 {

    $db                   = new Db();

    $arrivalDate          = Utils::dateFormat($arrivalDate, 'm-d-Y', 'Y-m-d');
    $departureDate        = Utils::dateFormat($departureDate, 'm-d-Y', 'Y-m-d');

    $fetchIdQuery         = "select GROUP_CONCAT(AAT.nAat_Id) as ids from ".$db->tablePrefix."available_acco_type AAT
                             where nLocation_Id = '".$locationId."' and AAT.nAt_Id =  '".$accomadationId."'";

    $idResult             = $db->execute($fetchIdQuery);
    $ids                  = $db->fetchOne($idResult);


    if(trim($ids)!='')
    {


        

        $searchCriteriaQuery  = " nAat_Id in ($ids)";

        $availableRoomDetails = $db->selectRecord("available_acco_type AAT ",  " AAT.nRoom, AAT.`nAat_id`,AAT.`nAmount` ",$searchCriteriaQuery);

        $query                = " select sum(`nRooms`) as `reservedRooms`
                                  from `".MYSQL_TABLE_PREFIX."allotment` A
                                  inner join ".$db->tablePrefix."booking B ON ( B.`nBooking_Id` = A.`nBooking_Id` )
                                  where A.nAat_Id in ($ids)
                                  and A.vStatus = 'booked'
                                  and '".$arrivalDate."' between A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )
                                  or '".$departureDate."' between A.dDate AND DATE_ADD( A.dDate, INTERVAL A.nDays DAY )
                                ";


         $query                = " select sum(`nRooms`) as `reservedRooms`
                                   from `".MYSQL_TABLE_PREFIX."allotment` A
                                   inner join ".$db->tablePrefix."booking B ON ( B.`nBooking_Id` = A.`nBooking_Id` )
                                   
                                   where A.nAat_Id in ($ids)
                                   and A.vStatus = 'booked'
                                   and A.dDate between '".$arrivalDate."' and '".$departureDate."'
                                ";

//inner join ".$db->tablePrefix."customers C ON(B.nCust_Id = C.nCust_Id)

         $reservedRoom        = $db->fetchSingleRow($query);

         if($reservedRoom->reservedRooms == '')
            $reservedRoom->reservedRooms = 0;

         return array($availableRoomDetails->nAat_id,$availableRoomDetails->nAmount);


    }
    else
    {
         return array();
    }


 }




 /*
  *
  * * Function Name: getExtraAmount
  * * This function will calculate the accomadation based extra amount of a location for a particular criteria
  * * The booking amount may vary based on the criteria for ex: arriaval date, departure date
  *
  */


 public static function getStartingPrice($locationId,$accomadationType,$arrivalDate,$departureDate)
 {
     return 10;
 }

    
 public static function getExtraAmount($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfRooms=1)
 {   
 	$db                   = new Db();
   	$objSession           = new LibSession();
   	$accomadationAvailabilityDetails  = array();

   	$fetchIdQuery         = "select GROUP_CONCAT(AAT.nAat_Id) as ids from ".$db->tablePrefix."available_acco_type AAT where nLocation_Id = '".$locationId."' and AAT.nAt_Id =  '".$accomadationType."'";
    $idResult             = $db->execute($fetchIdQuery);
    $ids                  = $db->fetchOne($idResult);
   	if($numberOfPeople) {
   		$details 		  = Booking::isNumberOfPeopleAllowed($ids,$numberOfPeople);
		if(!$details) {
           return 'ER001'; //'Not Available'
    	}
    	else {
    		$adultsCount  				= (int)$details[0]->nAdults;
    		$additional_guest_allowed  	= (int)$details[0]->additional_guest_allowed;
    		$totalCount 				= $adultsCount + $additional_guest_allowed;
    		if($numberOfRooms*$totalCount < $numberOfPeople) {
    			return "ER002-$totalCount";//"Only $adultsCount adult(s) are allowed";
    		}
    	}
    }

   $seasonalCostArray                = Booking::isSeasonalRateAvailable($locationId,$accomadationType,$arrivalDate,$departureDate,$numberOfRooms,true,true,$numberOfPeople);

   $costArray                        = Booking::isAccomadationAvailable($locationId,$accomadationType,$arrivalDate,$departureDate,$numberOfRooms,true,true);
   $cost                             = $costArray[1];
   $accomadationAvailabilityId       = $costArray[0];

   if($costArray[2] == 'blocked')
   {  
       return 'blocked-This location has been blocked by admin for period '.Utils::dateFormat($costArray[3], 'Y-m-d', 'm/d/Y') . ' to '.  Utils::dateFormat($costArray[4], 'Y-m-d', 'm/d/Y') ;
   }


   if(trim($cost)=='')
      return ERROR_RETURN_INTEGER_FLAG;

   else if($accomadationAvailabilityId>0)
   {       
     $groupDiscountDetails           = Location::getGruopDiscount($accomadationAvailabilityId,$numberOfPeople);
     $specialOfferDetails            = Location::getSpecialOfferDetails($locationId);

     $groupDiscountAmount            = $groupDiscountDetails->discount_percentage;
     $dayAmount	                     = explode(',',$cost);
     $extraPrice		     		= Apputils::calculateExtraAmount($numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$dayAmount,$offerRateDetails,$specialOfferDetails,$seasonalCostArray,$accomadationAvailabilityId,$numberOfRooms);   

     //echo $extraPrice;die;



     if($extraPrice>0 && $groupDiscountAmount>0)
        $extraPrice = $extraPrice - ($extraPrice * $groupDiscountAmount / 100);
 

 /*
  **********************************************************************************
  ** Advance amount(actual amount to be paid) calculation section starts here.....**
  **********************************************************************************
  */

     $siteBookingMode                = Apputils::fetchSettings('ReserveMode'); // P => payment via payment gateways other will be offline payment

     if($siteBookingMode != DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT)  // When site is in offline payment mode...

        $siteBookingMode             = DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT;
        $bookingPaymentMode          = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
        $reservationModeAmount       = Apputils::fetchSettings('ReserveModeAmount'); // Amount to be paid for booking

        if($reservationModeAmount>0)
        {

          if($bookingPaymentMode == DB_BOOKING_PAYMENT_MODE_AMOUNT_TEXT)
             $amountToPayForBooking  = $reservationModeAmount;

          else
             $amountToPayForBooking = ($extraPrice * $reservationModeAmount / 100);
         }
         else  // When site is in offline payment mode...
             $amountToPayForBooking = LOCATION_NO_AMOUNT_TO_PAY_FOR_BOOKING;


  /*
  * ********************************************************************************
  ** Advance amount(actual amount to be paid) calculation section ends here.....****
  **********************************************************************************
  */

          $extraPrice = ($extraPrice>0) ? $extraPrice : LOCATION_NO_EXTRA_AMOUNT;
          $extraPrice = $extraPrice * $numberOfRooms;

          return $extraPrice;

   }
   
 }

 
  public static function getAdiitionalguestrate($locationId,$acctype,$limit=0)
  {
      $db                  = new Db();

       $limitString         = ($limit>0)             ? ' LIMIT 0,'.  $limit          : '';
        

      
       $tempQuery = "SELECT AAT.additional_guest_allowed,AAT.additional_guest_rate FROM ".MYSQL_TABLE_PREFIX."available_acco_type AAT
		     
		     WHERE AAT.vActive='active' AND AAT.nLocation_Id = '".mysql_real_escape_string($locationId)."' AND AAT.nAt_Id = '".mysql_real_escape_string($acctype)."'";



       $tempLocationRates     = $db->selectQuery($tempQuery);

       return $tempLocationRates;
  }

 public static function getMonthPrices($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfRooms = 1)
 {

   $arrivalDate                      = date("m-d-Y",strtotime($arrivalDate));
   $departureDate                    = date("m-d-Y",strtotime($departureDate));

   $objSession                       = new LibSession();
   $accomadationAvailabilityDetails  = array();
   $priceArray                       = array();

   $costArray                        = Booking::getCostRate($locationId,$accomadationType,$arrivalDate,$departureDate,$numberOfRooms);

   

   $cost                             = $costArray[1];
   $accomadationAvailabilityId       = $costArray[0];

   if($accomadationAvailabilityId>0)
   {

     $groupDiscountDetails           = Location::getGruopDiscount($accomadationAvailabilityId,$numberOfPeople);
     $specialOfferDetails            = Location::getSpecialOfferDetails($locationId);    

     $groupDiscountAmount            = $groupDiscountDetails->discount_percentage;
     $dayAmount	                     = explode(',',$cost);     

     $priceArray		     = Apputils::calculateMonthlyPrices($locationId,$accomadationType,$arrivalDate,$departureDate,$dayAmount,$numberOfRooms,$groupDiscountAmount,$specialOfferDetails);
 
   }

   return $priceArray;

 }




 public static function getAmountToPayForBooking($extraPrice)
 {

    $siteBookingMode             = Apputils::fetchSettings('ReserveMode'); // P => payment via payment gateways other will be offline payment

    if($siteBookingMode != DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT)  // When site is in offline payment mode...
       $siteBookingMode          = DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT;

    $bookingPaymentMode          = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount
    $reservationModeAmount       = Apputils::fetchSettings('ReserveModeAmount'); // Amount to be paid for booking

     if($reservationModeAmount>0)
     {

        if($bookingPaymentMode == DB_BOOKING_PAYMENT_MODE_AMOUNT_TEXT)
           $amountToPayForBooking = $reservationModeAmount;
        
        else
           $amountToPayForBooking = $extraPrice * $reservationModeAmount / 100;


      }
      else  // When site is in offline payment mode...
           $amountToPayForBooking = LOCATION_NO_AMOUNT_TO_PAY_FOR_BOOKING;
     
      return $amountToPayForBooking;

 }


 public static function setSession($accomadationAvailabilityDetails)
 {
    //echopre1($accomadationAvailabilityDetails['accomadationType']);
     $db                                  = new Db();
     $tempQuery                           = "SELECT * FROM ".MYSQL_TABLE_PREFIX."accomodation_types WHERE nAt_Id =".$accomadationAvailabilityDetails['accomadationType'];
     $tempResult                          = $db->selectQuery($tempQuery);
     $accomadationAvailabilityDetails['accomodationTypeName'] = $tempResult[0]->vAt_Name;

     //print_r($tempResult[0]->vAt_Name);die('*-*');

     $objSession                     = new LibSession();
     $cart                 = new Cart('customer_cart',$customerDetails->nCust_Id);
     
     $cart->addItem($locationId, $accomadationAvailabilityDetails);
     $objSession->delete('last_booking_details');
     $objSession->set('last_booking_details',serialize($accomadationAvailabilityDetails));
     $objSession->set('last_booking_details',json_encode($accomadationAvailabilityDetails));
 }






 public static function saveBookingAmount($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfChildren,$numberOfRooms=1)
 {   

   $arrivalDate                      = urldecode($arrivalDate);
   $departureDate                    = urldecode($departureDate);

   $costArray                        = Booking::isAccomadationAvailable($locationId,$accomadationType,$arrivalDate,$departureDate,$numberOfRooms,true,true);
   
   $cost                             = $costArray[1];
   $accomadationAvailabilityId       = $costArray[0];


   if($costArray[2] == 'blocked')
   {
       return 'blocked-This location has been blocked by admin for period '.Utils::dateFormat($costArray[3], 'Y-m-d', 'm/d/Y') . ' to '.  Utils::dateFormat($costArray[4], 'Y-m-d', 'm/d/Y') ;
   }


   if(trim($cost)=='' || $accomadationAvailabilityId == '')
   {
     return ERROR_RETURN_INTEGER_FLAG;
   }
   else if($accomadationAvailabilityId>0)
   {
                             
     $extraPrice = Booking::getExtraAmount($locationId,$accomadationType,$numberOfPeople,$arrivalDate,$departureDate,$startingPrice,$numberOfRooms);

     if($extraPrice == 'ER001')
         return 0;
     if(strstr($extraPrice ,'ER002')!= FALSE)
         return $extraPrice;

     if($extraPrice>0)
     {
         $amountToPayForBooking = Booking::getAmountToPayForBooking($extraPrice);
         if($amountToPayForBooking > $extraPrice)
             $amountToPayForBooking = $extraPrice;
     }
     else
     $amountToPayForBooking = 0;


     $siteBookingMode             = Apputils::fetchSettings('ReserveMode'); // P => payment via payment gateways other will be offline payment

     if($siteBookingMode != DB_BOOKING_SITE_BOOOKING_MODE_WITH_PAYMENT_TEXT)  // When site is in offline payment mode...
       $siteBookingMode          = DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT;

     $bookingPaymentMode         = Apputils::fetchSettings('ReservePayMode'); // Per => percentage of booking amount else a fixed amount from booking amount


     $groupDiscountDetails                                          = Location::getGruopDiscount($accomadationAvailabilityId,$numberOfPeople);

     $accomadationAvailabilityDetails                               = array();
     $accomadationAvailabilityDetails['locationId']                 = $locationId;
     $accomadationAvailabilityDetails['accomadationType']           = $accomadationType;
     $accomadationAvailabilityDetails['accomadationAvailabilityId'] = $accomadationAvailabilityId;
     $accomadationAvailabilityDetails['numberOfPeople']             = $numberOfPeople;
     $accomadationAvailabilityDetails['arrivalDate']                = $arrivalDate;
     $accomadationAvailabilityDetails['departureDate']              = $departureDate;
     $accomadationAvailabilityDetails['startingPrice']              = $startingPrice;
     $accomadationAvailabilityDetails['extraPrice']                 = $extraPrice;
     $accomadationAvailabilityDetails['siteBookingMode']            = $siteBookingMode;
     $accomadationAvailabilityDetails['bookingPaymentMode']         = $bookingPaymentMode;
     $accomadationAvailabilityDetails['specialOfferPrice']          = $specialOfferDetails[0];
     $accomadationAvailabilityDetails['groupDiscountPrice']         = $groupDiscountDetails->discount_percentage;
     $accomadationAvailabilityDetails['numberOfChildren']           = $numberOfChildren;
     $accomadationAvailabilityDetails['amountToPayForBooking']      = $amountToPayForBooking;
     $accomadationAvailabilityDetails['numberOfRooms']              = $numberOfRooms;
     
     Booking::setSession($accomadationAvailabilityDetails);

     if($siteBookingMode != 'P')
     $amountToPayForBooking = 0;
     
     return $extraPrice.'_'.$amountToPayForBooking.'_'.DEFAULT_CURRENCY;
     
   }
 
 }



 public static function checkForConfirmedBooking($bookingId)
 {
     $db                                  = new Db();
     if($db->checkExists('booking', 'nBooking_Id', 'vStatus = "'.DB_BOOKING_CONFIRMED_TEXT.'" and nBooking_Id="'.$bookingId.'"') == 0)
        return false;
     else
        return true;
 }


 /*
  *
  * The below function is used to save the booking details of a customer.
  *
  */


  public static function recordOrder($customerId,$accomadationType,$accomadationAvailabilityId,$numberOfAdults,$numberOfChildren,$arrivalDate,$departureDate,$extraAmount,$siteBookingMode,$amountToPay,$payType,$numberOfRooms,$userLevel='USERS')
  {

    $db                                  = new Db();

    $numberOfDaysArray                   = Utils::buildInBetweenDates($arrivalDate,$departureDate);
    $numberOfDays                        = count(Utils::buildInBetweenDates($arrivalDate,$departureDate));


    if(DB_BOOKING_SITE_BOOKING_MODE_FREE_TEXT == $payType)
       $amountToPay = 0.00;

    $postedArray                         = array();
    $postedArray['nCust_Id']             = mysql_real_escape_string(trim($customerId));
    $postedArray['dArrival_Date']        = mysql_real_escape_string(trim($arrivalDate));
    $postedArray['dBooking_Date']        = date('Y-m-d H:i:s');
    $postedArray['vBooking_Details']     = DB_BOOKING_BOOKING_DETAILS_TEXT;
    $postedArray['nNights_Stay']         = mysql_real_escape_string(trim($numberOfDays));
    $postedArray['nAdults']              = mysql_real_escape_string(trim($numberOfAdults));
    $postedArray['nChildren']            = mysql_real_escape_string(trim($numberOfChildren));
    $postedArray['nAmount']              = mysql_real_escape_string(trim($extraAmount));
    $postedArray['nReserveModeAmount']   = mysql_real_escape_string(trim($amountToPay));
    $postedArray['nRooms']               = mysql_real_escape_string(trim($numberOfRooms));
    $postedArray['vBookedBy']            = mysql_real_escape_string(trim($userLevel));


    if(($siteBookingMode == DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT  || $amountToPay == 0) && $payType != DB_BOOKING_PAY_METHOD_CHECK && $payType != DB_BOOKING_PAY_METHOD_DD )
    $postedArray['vStatus']              = DB_BOOKING_CONFIRMED_TEXT;
    else
    $postedArray['vStatus']              = DB_BOOKING_PENDING_TEXT;    

    $bookingId                           = $db->addFields('booking',$postedArray);

    // Recording allotment details

    $accomadationAvailabilityId          = (int) $accomadationAvailabilityId;

    $tempQuery                           = "SELECT `nAdults`,`nChildren`
                                            FROM `".MYSQL_TABLE_PREFIX."available_acco_type`
                                            WHERE `nAat_Id` ='".$accomadationAvailabilityId."'";

    $tempResult                          = $db->selectQuery($tempQuery);
    $tempResult                          = $tempResult[0];

    $availableNumberOfAdults             = ($tempResult->nAdults>0) ? $tempResult->nAdults : 0;
    $availableNumberOfChildren           = ($tempResult->nChildren>0) ? $tempResult->nChildren : 0;
    $blockedDates                        = Utils::buildInBetweenDates($arrivalDate,$departureDate);


    


    foreach($blockedDates as $tempKey =>$tempValue)
    {

      $postedArray                       = array();
      $postedArray['nBooking_Id']        = $bookingId;
      $postedArray['nAat_Id']            = mysql_real_escape_string(trim($accomadationAvailabilityId));
      $postedArray['dDate']              = $tempValue;
      $postedArray['nAdults']            = mysql_real_escape_string(trim($availableNumberOfAdults));
      $postedArray['nChildren']          = mysql_real_escape_string(trim($availableNumberOfChildren));
      $postedArray['dNewDate']           = mysql_real_escape_string(trim($tempValue));      

      $db->addFields('allotment',$postedArray);

    }

        // Recording to payment details in db

    $postedArray                     = array();
    $postedArray['nBooking_Id']      = $bookingId;
    $postedArray['vTxn_id']          = DB_BOOKING_PAYMENT_NO_TAX_ID;
    $postedArray['dDate_Settled']    = date("Y-m-d H:i:s");
    $postedArray['vPayment_Type']    = $payType;

    if(($siteBookingMode == DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT || $amountToPay == 0) && $payType != DB_BOOKING_PAY_METHOD_CHECK && $payType != DB_BOOKING_PAY_METHOD_DD)
    $postedArray['vStatus']          = DB_BOOKING_PAYMENT_STATUS_NO_TEXT;
    else
    $postedArray['vStatus']          = DB_BOOKING_PAYMENT_STATUS_NO_TEXT;

    $settings = Apputils::loadSettings();
  
    if($payType == DB_BOOKING_PAY_METHOD_AUTHORIZE_NET && $settings['AuthorizeTransMode'] == 'AUTH_ONLY')
        $postedArray['vCapture']         = DB_BOOKING_PAYMENT_VCAPTURE_NO_TEXT;
    else
        $postedArray['vCapture']         = DB_BOOKING_PAYMENT_VCAPTURE_YES_TEXT;
    
    $postedArray['vType']            = DB_BOOKING_PAYMENT_VTYPE_O_TEXT;
    $postedArray['nCancelAmt']       = DB_BOOKING_PAYMENT_NO_CANCEL_AMOUNT;



    //************  Section store referral details of affiliates ************************//

    $affiliateId                           = Affiliates::getAffiliateCookie();

    if($affiliateId > 0)
    {
        
        $tempPostedArray                             = array();

        $tempPostedArray['ua_aff_id']                = $affiliateId;
        $tempPostedArray['ua_userid']                = $customerId;
        $tempPostedArray['ua_booking_id']            = $bookingId;
        $tempPostedArray['ua_actiontype']            = 2;
        $tempPostedArray['ua_payment']               = 0;
        $tempPostedArray['ua_referalcharge']         = 0;
        $tempPostedArray['ua_paystatus']             = 1;
        $tempPostedArray['ua_displaystatus']         = 1;

        if($db->checkExists('affiliate_useraction', 'ua_id', 'ua_userid="'.$customerId.'"') == 0)
        {
            $db->addFields('affiliate_useraction', $tempPostedArray);
        }


    }

    //************  Section store referral details of affiliates ************************//

    $db->addFields('payment',$postedArray);
    return $bookingId;

    }


    public static function sendInvoice($emailAddress,$bookingDetails,$userLevel = 'User')
    {

        $db                              = new Db();        
        $replaceParameters               = array();        

        $accommdationType                = $bookingDetails['accomadationType'];
        $accommdationType                = (int) $accommdationType;
        
        $tempQuery                       = "
                                             SELECT `vAt_Name`
                                             FROM `".MYSQL_TABLE_PREFIX."accomodation_types`
                                             WHERE `nAt_Id` = '".mysql_real_escape_string($accommdationType)."' LIMIT 1
                                           ";

        $roomInfo                        = $db->selectQuery($tempQuery);
        $roomInfo                        = $roomInfo[0];

        $checkInDate                     = $bookingDetails['arrivalDate'];
        $checkOutDate                    = $bookingDetails['departureDate'];
        $numberOfAdults                  = $bookingDetails['nAdults'];
        $numberOfChildren                = $bookingDetails['numberOfChildren'];
        $totalAmountPaid                 = $bookingDetails['amountToPayForBooking'];
        $groupDiscount                   = $bookingDetails['groupDiscountPrice'];
        $specialOffer                    = $bookingDetails['specialOfferPrice'];
        $siteBookingMode                 = $bookingDetails['siteBookingMode'];
        $locationName                    = $bookingDetails['locationName'];
        $totalAmount                     = $bookingDetails['extraPrice'];
        $destinationName                 = $bookingDetails['destinationName'];
        $numberOfRooms                   = $bookingDetails['numberOfRooms'];
        $firstName                       = stripslashes($bookingDetails['firstName']);
        $lastName                        = stripslashes($bookingDetails['lastName']);
        $adminMessageForBooking          = stripslashes(trim(Apputils::fetchSettings('admin_booking_message')));        
        $address                         = $bookingDetails['address'];


        
        if($userLevel=='Admin')
        $replaceParameters['name']      .= 'Administrator';    
        else    
        $replaceParameters['name']      .= $bookingDetails['name'];

        $replaceParameters['mailBody']  .= '<table border="0">';
        $replaceParameters['mailBody']  .= '<tr><th colspan="2" align="left">'.INVOICE_MAIL_ORDER_DETAIL_HEADING.'</th></tr>';

        if($userLevel == 'Admin')
        {
         $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_FIRSTNAME.':</td><td>'.stripslashes($firstName).'</td></tr>';
         $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_LASTNAME.':</td><td>'.stripslashes($lastName).'</td></tr>';
        }

        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_DESTINATION_NAME.':</td><td>'.stripslashes($destinationName).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_LOCATION_NAME.':</td><td>'.stripslashes($locationName).'</td></tr>';

        if($address != '')
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_LOCATION_ADDRESS.':</td><td>'.stripslashes($address).'</td></tr>';   


        if(trim($bookingDetails['accomadationName']) != '')
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_ACCOMMODATION_NAME.':</td><td>'.stripslashes($bookingDetails['accomadationName']).'</td></tr>';
        else
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_ACCOMMODATION_NAME.':</td><td>'.stripslashes($roomInfo->vAt_Name).'</td></tr>';


        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_NO_OF_ROOMS.':</td><td>'.$numberOfRooms.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_CHECK_IN.':</td><td>'.$checkInDate.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_CHECK_OUT.':</td><td>'.$checkOutDate.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_NO_OF_ADULTS.':</td><td>'.$numberOfAdults.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_NO_OF_CHILDREN.':</td><td>'.$numberOfChildren.'</td></tr>';

        if($groupDiscount>0)
           $replaceParameters['mailBody'] .= '<tr><td>'.INVOICE_MAIL_LABEL_GROUP_DISCOUNT.':</td><td>'.$groupDiscount.'%</td></tr>';

        if($specialOffer>0)
           $replaceParameters['mailBody'] .= '<tr><td>'.INVOICE_MAIL_LABEL_SPECIAL_OFFER.':</td><td>$'.$specialOffer.'</td></tr>';

        $replaceParameters['mailBody'] .= '<tr><td>'.INVOICE_MAIL_LABEL_TOTAL_AMOUNT.':</td><td>$'.$totalAmount.'</td></tr>';

        if($siteBookingMode != DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT)
           $replaceParameters['mailBody'] .= '<tr><td>'.INVOICE_MAIL_LABEL_AMOUNT_PAID.':</td><td>$'.$totalAmountPaid.'</td></tr>';


        if($adminMessageForBooking != '')
           $replaceParameters['mailBody'] .= '<tr><td colspan="2" align="left">'.$adminMessageForBooking.'</td></tr>';

       // else
           //$replaceParameters['mailBody'] .= '<tr><td>'.INVOICE_MAIL_LABEL_AMOUNT_TO_BE_PAID.':</td><td>$'.$totalAmountPaid.'</td></tr>';

        $replaceParameters['mailBody']    .= '</table>';

        if($userLevel == 'Admin')
        {
            $emailAddress = Apputils::fetchSettings('vadmin_email');

            if(ENVIRONMENT!='LOCAL')
            Utils::sendUserMail($emailAddress, 'BookingInvoiceAdmin', $replaceParameters);

        }
        else if(ENVIRONMENT!='LOCAL')
          Utils::sendUserMail($emailAddress, 'BookingInvoice', $replaceParameters);

    }


    public static function sendOfflineInvoice($emailAddress,$bookingDetails,$userLevel = 'User')
    {

        $db                              = new Db();        
        $replaceParameters               = array();        

        $accommdationType                = $bookingDetails['accomadationType'];
        $accommdationType                = (int) $accommdationType;
        
        $tempQuery                       = "
                                             SELECT `vAt_Name`
                                             FROM `".MYSQL_TABLE_PREFIX."accomodation_types`
                                             WHERE `nAt_Id` = '".mysql_real_escape_string($accommdationType)."' LIMIT 1
                                           ";

        $roomInfo                        = $db->selectQuery($tempQuery);
        $roomInfo                        = $roomInfo[0];

        $checkInDate                     = $bookingDetails['arrivalDate'];
        $checkOutDate                    = $bookingDetails['departureDate'];
        $numberOfAdults                  = $bookingDetails['nAdults'];
        $numberOfChildren                = $bookingDetails['numberOfChildren'];
        $totalAmountPaid                 = $bookingDetails['amountToPayForBooking'];
        $groupDiscount                   = $bookingDetails['groupDiscountPrice'];
        $specialOffer                    = $bookingDetails['specialOfferPrice'];
        $siteBookingMode                 = $bookingDetails['siteBookingMode'];
        $locationName                    = $bookingDetails['locationName'];
        $totalAmount                     = $bookingDetails['extraPrice'];
        $destinationName                 = $bookingDetails['destinationName'];
        $numberOfRooms                   = $bookingDetails['numberOfRooms'];
        $firstName                       = stripslashes($bookingDetails['firstName']);
        $lastName                        = stripslashes($bookingDetails['lastName']);

        
        if($userLevel=='Admin')
        $replaceParameters['name']      .= 'Administrator';    
        else    
        $replaceParameters['name']      .= $bookingDetails['name'];

        $replaceParameters['mailBody']  .= '<table border="0">';
        $replaceParameters['mailBody']  .= '<tr><th colspan="2" align="left">'.INVOICE_MAIL_ORDER_DETAIL_HEADING.'</th></tr>';

        if($userLevel == 'Admin')
        {
         $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_FIRSTNAME.':</td><td>'.stripslashes($firstName).'</td></tr>';
         $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_LASTNAME.':</td><td>'.stripslashes($lastName).'</td></tr>';
        }

        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_DESTINATION_NAME.':</td><td>'.stripslashes($destinationName).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_LOCATION_NAME.':</td><td>'.stripslashes($locationName).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_ACCOMMODATION_NAME.':</td><td>'.stripslashes($roomInfo->vAt_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_NO_OF_ROOMS.':</td><td>'.$numberOfRooms.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_CHECK_IN.':</td><td>'.$checkInDate.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_CHECK_OUT.':</td><td>'.$checkOutDate.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_NO_OF_ADULTS.':</td><td>'.$numberOfAdults.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.INVOICE_MAIL_LABEL_NO_OF_CHILDREN.':</td><td>'.$numberOfChildren.'</td></tr>';

        if($groupDiscount>0)
           $replaceParameters['mailBody'] .= '<tr><td>'.INVOICE_MAIL_LABEL_GROUP_DISCOUNT.':</td><td>'.$groupDiscount.'%</td></tr>';

        if($specialOffer>0)
           $replaceParameters['mailBody'] .= '<tr><td>'.INVOICE_MAIL_LABEL_SPECIAL_OFFER.':</td><td>$'.$specialOffer.'</td></tr>';

        $replaceParameters['mailBody'] .= '<tr><td>'.INVOICE_MAIL_LABEL_TOTAL_AMOUNT.':</td><td>$'.$totalAmount.'</td></tr>';

        if($siteBookingMode != DB_BOOKING_SITE_BOOKING_MODE_OFFLINE_TEXT)
           $replaceParameters['mailBody'] .= '<tr><td>'.INVOICE_MAIL_LABEL_AMOUNT_PAID.':</td><td>$'.$totalAmountPaid.'</td></tr>';

        else
           $replaceParameters['mailBody'] .= '<tr><td>'.INVOICE_MAIL_LABEL_AMOUNT_TO_BE_PAID.':</td><td>$'.$totalAmountPaid.'</td></tr>';

        $replaceParameters['mailBody']    .= '</table>';

        if($userLevel == 'Admin')
        {
            $emailAddress = Apputils::fetchSettings('vadmin_email');

            if(ENVIRONMENT!='LOCAL')
            Utils::sendUserMail($emailAddress, 'AdminPanelOfflineBookingInvoiceToAdmin', $replaceParameters);

        }
        else if(ENVIRONMENT!='LOCAL')
          Utils::sendUserMail($emailAddress, 'AdminPanelOfflineBookingInvoice', $replaceParameters);

    }

    public static function updateBookingStatus($bookingId,$transactionId=0)
    {

        $db                                  = new Db();
        $bookingId                           = (int) $bookingId;

        if($bookingId>0)
        {
            $table                           = 'booking';
            
            $db->update(MYSQL_TABLE_PREFIX.$table, array('vStatus'=>DB_BOOKING_CONFIRMED_TEXT),'nBooking_Id="'.mysql_real_escape_string($bookingId).'"');

            $table                           = 'payment';

            $db->update(MYSQL_TABLE_PREFIX.$table, array('vStatus'=>DB_BOOKING_PAYMENT_STATUS_YES_TEXT,'vTxn_Id'=>$transactionId),'nBooking_Id="'.mysql_real_escape_string($bookingId).'"');
        }
        
    }
    
    
    public static function updateRefferalStatus($bookingId,$amount)
    {

        $db                                 = new Db();
        $bookingId                          = (int) $bookingId;

        $table                               = 'affiliate_useraction';
        
        $affiliatePercentage                 = Apputils::fetchSettings('affiliate_percentage');

        if($affiliatePercentage > 0 && $amount > 0)
           $refferalCharge                   = ($amount * $affiliatePercentage / 100);
        else
           $refferalCharge                   = 0;

        $refferalCharge = ($refferalCharge > 0) ? $refferalCharge : 0;

        $updateArray                        = array();
        $updateArray['ua_paystatus']        = '1';
        $updateArray['ua_payment']          = $amount;
        $updateArray['ua_referalcharge']    = round($refferalCharge,2);
        $updateArray['ua_actiondate']       = time();
        $updateArray['ua_settled_ref']      = Utils::genRandomString();
        
        $db->update(MYSQL_TABLE_PREFIX.$table,$updateArray,'ua_booking_id="'.mysql_real_escape_string($bookingId).'"');
        
    }





    public static function getCustomerDetails($bookingId)
    {

      $db                              = new Db();
      
      $bookingId = (int) $bookingId;

      $tempQuery = " SELECT C.* FROM `".MYSQL_TABLE_PREFIX."booking` B
	             INNER JOIN `".MYSQL_TABLE_PREFIX."customers` C ON B.`nCust_Id` = C.`nCust_Id`
	    	     WHERE B.`nBooking_Id` = '".mysql_real_escape_string($bookingId)."' LIMIT 1 ";

      $cutomerInfo   = $db->selectQuery($tempQuery);

      $cutomerInfo = $cutomerInfo[0];

      return $cutomerInfo;
    }
    
    
    public static function getBookingDetails($bookingId)
    {

      $db            = new Db();
      $bookingId     = (int) $bookingId;

      $tempQuery     = " SELECT *,DATE_FORMAT(dArrival_Date,'%m/%d/%Y') as checkin_Date,DATE_FORMAT(DATE_ADD(dArrival_Date, INTERVAL nNights_Stay DAY),'%m/%d/%Y') as checkout_Date FROM `".MYSQL_TABLE_PREFIX."booking`
	    	         WHERE `nBooking_Id` = '".mysql_real_escape_string($bookingId)."' LIMIT 1 ";

      $bookingInfo   = $db->selectQuery($tempQuery);

      $bookingInfo    = $bookingInfo[0];

      return $bookingInfo;
    }




    public static function getAccommadationDetails($bookingId)
    {

      $db            = new Db();
      $bookingId     = (int) $bookingId;

      $tempQuery     = " SELECT AT.* FROM `".MYSQL_TABLE_PREFIX."booking` B
                         INNER JOIN ".MYSQL_TABLE_PREFIX."allotment A ON A.nBooking_Id = B.nBooking_Id
                         INNER JOIN ".MYSQL_TABLE_PREFIX."available_acco_type AAT ON A.nAat_Id = AAT.nAat_Id
                         INNER JOIN ".MYSQL_TABLE_PREFIX."accomodation_types AT ON AT.nAt_Id = AAT.nAt_Id
	    	         WHERE B.`nBooking_Id` = '".mysql_real_escape_string($bookingId)."' LIMIT 1 ";

      $accommadationInfo   = $db->selectQuery($tempQuery);
      $accommadationInfo   = $accommadationInfo[0];

      return $accommadationInfo;

    }


    public static function getLocationName($bookingId)
    {

      $db                  = new Db();
      $bookingId           = (int) $bookingId;

      $tempQuery           = "
                               SELECT L.`vLocation_Name` FROM `".MYSQL_TABLE_PREFIX."allotment` A
                               INNER JOIN ".MYSQL_TABLE_PREFIX."available_acco_type AAT ON AAT.nAat_Id = A.nAat_Id
                               INNER JOIN ".MYSQL_TABLE_PREFIX."locations L ON AAT.nLocation_Id = L.nLocation_Id 
	    	               WHERE A.`nBooking_Id` = '".mysql_real_escape_string($bookingId)."' LIMIT 1
                             ";

      $locationInfo        = $db->selectQuery($tempQuery);
      $accommadationInfo   = $locationInfo[0];

      return trim($locationInfo[0]->vLocation_Name);

    }


     public static function getLocationAddress($bookingId)
     {

        $db                      = new Db();
        $bookingId               = (int) $bookingId;

        $tempQuery               = "
                                    SELECT L.`vAddress`, L.`vCity`,  L.`vState`, L.`vZip`,L.`vCountry` 
                                    FROM `".MYSQL_TABLE_PREFIX."allotment` A
                                    INNER JOIN ".MYSQL_TABLE_PREFIX."available_acco_type AAT ON AAT.nAat_Id = A.nAat_Id
                                    INNER JOIN ".MYSQL_TABLE_PREFIX."locations L ON AAT.nLocation_Id = L.nLocation_Id
	    	                    WHERE A.`nBooking_Id` = '".mysql_real_escape_string($bookingId)."' LIMIT 1
                                  " ;

        $locationDetails         = $db->selectQuery($tempQuery);
        $locationAddressDetails  = $locationDetails[0];



        if(trim($locationAddressDetails->vAddress) != '')
        $locationAddress        .= $locationAddressDetails->vAddress . '<br />' ;

        if(trim($locationAddressDetails->vCity) != '')
        $locationAddress        .= $locationAddressDetails->vCity . '<br />' ;

        if(trim($locationAddressDetails->vState) != '')
        $locationAddress        .= $locationAddressDetails->vState . ' ' ;

        if(trim($locationAddressDetails->vZip) != '')
        $locationAddress        .= $locationAddressDetails->vZip . ' <br /> ' ;

        if(trim($locationAddressDetails->vCountry) != '')
        $locationAddress        .= $locationAddressDetails->vCountry ;

        
        return trim(stripslashes($locationAddress));

    }



    public static function getDestinationName($bookingId)
    {

      $db                  = new Db();
      $bookingId           = (int) $bookingId;

      $tempQuery           = "
                               SELECT D.`vDestination_Name` FROM `".MYSQL_TABLE_PREFIX."allotment` A
                               INNER JOIN ".MYSQL_TABLE_PREFIX."available_acco_type AAT ON AAT.nAat_Id = A.nAat_Id
                               INNER JOIN ".MYSQL_TABLE_PREFIX."locations L ON AAT.nLocation_Id = L.nLocation_Id
                               INNER JOIN ".MYSQL_TABLE_PREFIX."destination D ON D.nDestination_Id = L.nDestination_Id
	    	               WHERE A.`nBooking_Id` = '".mysql_real_escape_string($bookingId)."' LIMIT 1
                             ";

      $locationInfo        = $db->selectQuery($tempQuery);
      $accommadationInfo   = $locationInfo[0];

      return trim($locationInfo[0]->vDestination_Name);

    }


    public static function saveExpediaLocationDetails($bookingId,$tempLastBookingDetails)
    {
        $db = new Db();
        $db->update(MYSQL_TABLE_PREFIX.'booking',array('api_flag'=>'Y') ,'nBooking_Id="'.$bookingId.'"' );


        $searchParams['hotelId'] = $tempLastBookingDetails->locationId;
        $hotelInfo = Apisearch::expediaHotelInfo($searchParams);



         foreach($hotelInfo->roomTypes as $key => $value)
         {
             if($value->nAt_Id == $tempLastBookingDetails->accomadationType)
             {
                     $accomadationName = $value->vAt_Name;
                     break;
             }
         }

        $dataArray                         = array();
        $dataArray['locationid']           = $tempLastBookingDetails->locationId;
        $dataArray['booking_id']           = $bookingId;
        $dataArray['location_name']        = $hotelInfo->locationName;
        $dataArray['destination_name']     = $hotelInfo->city;
        $dataArray['accomadation_name']    = $accomadationName;


        $db->insert(MYSQL_TABLE_PREFIX.'expedia_location_details', $dataArray);
        $db->deleteRecord("booking", 'nBooking_Id="'.$bookingId.'"');

        return $dataArray;


    }



    /*
     * function to do the expedia payment
     */
    public static function doExpediaBooking($bookData, $paymentData,$expediaSettings) {

	    //Secure API URL	
	    $url	= "https://book.api.ean.com/ean-services/rs/hotel/v3/res";
	    
	    //Appended URL
	    $append  = "?cid=".$expediaSettings['cid'];
	    $append .= "&apiKey=".$expediaSettings['apiKey'];
	    $append .= "&customerIpAddress=" . $_SERVER['REMOTE_ADDR'];
	    $append .= "&customerSessionId=".$bookData['sessionID'];
	    $append .= "&minorRev=".$expediaSettings['minorRev']."&locale=".$bookData['locale']."&currencyCode=".$bookData['currency'];
	    
	    // generating XML request
	    $xml="<HotelRoomReservationRequest>"; //Open XML
	    $xml.="<hotelId>".$bookData['hotelID']."</hotelId>";
	    $xml.="<arrivalDate>".$bookData['arrivalDate']."</arrivalDate><departureDate>".$bookData['departureDate']."</departureDate>";
	    $xml.="<supplierType>".$bookData['supplierType']."</supplierType>";
	    $xml.="<rateKey>".$bookData['rateKey']."</rateKey>";
	    $xml.="<roomTypeCode>".$bookData['roomType']."</roomTypeCode>";
	    $xml.="<rateCode>".$bookData['rateCode']."</rateCode>";
	    $xml.="<chargeableRate>".$bookData['chargeableRate']."</chargeableRate>";
	    $xml.="<RoomGroup><Room>"; //Open RoomGroup Open Room1
	    $xml.="<numberOfAdults>".$bookData['Adults']."</numberOfAdults>";
	    $xml.="<numberOfChildren>".$bookData['Children']."</numberOfChildren>";
	    $xml.="<childAges></childAges>";
	    $xml.="<firstName>".$bookData['firstName']."</firstName>";
	    $xml.="<lastName>".$bookData['lastName']."</lastName>";
	    $xml.="<bedTypeId>".$bookData['bedTypeID']."</bedTypeId>";
	    $xml.="<smokingPreference>".$bookData['smoking']."</smokingPreference>";
	    $xml.="</Room></RoomGroup><ReservationInfo>"; //END roomGroup, Open Reservation Information
	    $xml.="<email>".$bookData['eMail']."</email>";
	    $xml.="<firstName>".$paymentData['firstName']."</firstName>";
	    $xml.="<lastName>".$paymentData['lastName']."</lastName>";
	    $xml.="<homePhone>".$bookData['homePhone']."</homePhone>";
	    $xml.="<workPhone>".$bookData['workPhone']."</workPhone>";
	    $xml.="<creditCardType>".$paymentData['ccType']."</creditCardType>";
	    $xml.="<creditCardNumber>".$paymentData['ccNumber']."</creditCardNumber>";
	    $xml.="<creditCardExpirationMonth>".$paymentData['expiryMonth']."</creditCardExpirationMonth>";
	    $xml.="<creditCardExpirationYear>".$paymentData['expiryYear']."</creditCardExpirationYear>";
	    $xml.="<creditCardIdentifier>".$paymentData['ccIdentifier']."</creditCardIdentifier>";
	    $xml.="</ReservationInfo><AddressInfo>";//Close Reservation Info, Open Address Information
	    $xml.="<address1>".$bookData['address1']."</address1>";
	    $xml.="<city>".$bookData['city']."</city>";
	    $xml.="<stateProvinceCode>".$bookData['state']."</stateProvinceCode>";
	    $xml.="<countryCode>".$bookData['countryCode']."</countryCode>";
	    $xml.="<postalCode>".$bookData['postCode']."</postalCode>";
	    $xml.="</AddressInfo></HotelRoomReservationRequest>";//Close Address Close XML
	    
	    //Create URL to use in request
	    $sendurl 	= $url.$append."&xml=".urlencode($xml); // !!IMPORTANT!! url encode the XML
	    
	    //creating cUrl request  	  
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL,$sendurl);
	    curl_setopt($ch, CURLOPT_HEADER, true); 
	    curl_setopt($ch, CURLOPT_POST, true);
	    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 65000);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, array("Accept: application/xml",  "Content-type: application/x-www-form-urlencoded","Content-length: 0" ));
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true );
	
	    $response 	= curl_exec($ch);
	    $error 		= curl_error($ch); //getting error for debugging
	    $info 		= curl_getinfo($ch); //getting info to analyse header
	    curl_close($ch); //close cUrl request
	    
	    //Transform Response into Object:	    
	    $xmlBody 	= substr($response, $info['header_size']); //Body of the message is complete message without the header.
	    $returnValue= simplexml_load_string($xmlBody); //Make an Object out of the response
	    return $returnValue;
	}
	//END doExpediaBooking




}
?>
