<?php
/*
 * All user entity logics related to locations are coming here.....
*/




class Location
{

    function __construct()
    {        
        
    }
    
    /*
     * Get complete location details
    */    

    public static function getLocationDetails($locationId)
    {
        
        $db                                         = new Db();
        $locationId                                 = (int) $locationId;

        $table                                      = 'locations L ';
        $field                                      = ' L.*,G.vURL,L.nDestination_Id as destinationId ';        
        $join                                       = ' LEFT JOIN '.MYSQL_TABLE_PREFIX.'gallery G  ON L.nLocation_Id = G.nLocation_Id ';
        $where                                      = ' L.nLocation_Id ="'.mysql_real_escape_string($locationId).'" ';
        $where                                      = (!empty($where)) ? $where : ' 1';
        $groupby                                    = ' GROUP BY L.nLocation_Id ';
        $tempQuery 	                            = 'SELECT '.$field.' FROM '.MYSQL_TABLE_PREFIX.$table .' ' . $join .' where '.$where;
        $locationDetails                            = $db->selectQuery($tempQuery);

        

        $locationDetails = $locationDetails[0];
        $locationDetails->destinationName     = Destination::getDestinationName($locationDetails->nDestination_Id);
        return $locationDetails;
        
    }



    



    public static function getLocationImages($locationId,$limit=NULL)
    {

        $tempLocationImages    = array();
        $locationImages        = array();
        $db                    = new Db();

        $limitString           = ($limit>0) ? ' LIMIT 0,'.$limit : '';
        $tempQuery             = "
                                   SELECT F.`file_orig_name`,F.`file_width`,F.`file_height`,F.`file_path`,G.`vTitle`,G.`nGallery_Id` 
                                   FROM `".MYSQL_TABLE_PREFIX."locations` L
                                   INNER JOIN `".MYSQL_TABLE_PREFIX."gallery` G ON L.`nLocation_Id` = G.`nLocation_Id` 
                                   INNER JOIN `".MYSQL_TABLE_PREFIX."files` F ON F.`file_id` = G.`file_id` 
                                   WHERE L.`nLocation_Id` ='".mysql_real_escape_string($locationId)."'
                                   ORDER BY F.file_id ASC
                                 ".$limitString;

        $locationImages        = $db->selectQuery($tempQuery);      
        

        if(is_array($locationImages) && count($locationImages)>0)
        { 
            foreach($locationImages as $tempKey => $tempValue)
            {               
                $tempLocationImages[$locationImages[$tempKey]->nGallery_Id] = $locationImages[$tempKey];
            }
        }      

        return $tempLocationImages;

    }
    
    
    public static function getLocationRoomInfo($locationId)
    {         

       $db        = new Db();
       
       $tempQuery = "SELECT *,AAT.nAdults as adults,AAT.nChildren as children,AAT.nAat_id as Aat_Id FROM ".MYSQL_TABLE_PREFIX."locations L
		     LEFT JOIN ".MYSQL_TABLE_PREFIX."destination D ON D.nDestination_Id = L.nDestination_Id
		     JOIN ".MYSQL_TABLE_PREFIX."available_acco_type AAT ON AAT.nLocation_Id = L.nLocation_Id
		     LEFT JOIN ".MYSQL_TABLE_PREFIX."accomodation_types AT ON AT.nAt_Id = AAT.nAt_Id
		     WHERE AAT.vActive='active' AND L.nLocation_Id = '".$locationId."'
		     ORDER BY vLocation_Name ASC";

        $roomInfo   = $db->selectQuery($tempQuery);       

        return $roomInfo;

    }


    public static function getSimilarLocations($destinationId,$extraCase=NULL,$orderBy=NULL,$limit=NULL)
    {

       $db                  = new Db();
       
       $limitString         = ($limit>0)             ? ' LIMIT 0,'.  $limit          : '';
       $orderByString       = (trim($orderBy)!='')   ? ' ORDER BY '. $orderBy        : '';
       $extraCaseString     = (trim($extraCase)!='') ? ' AND '.      $extraCase      : '';
       
       $tempQuery         = " SELECT L.* FROM `".MYSQL_TABLE_PREFIX."locations` L
		              LEFT JOIN `".MYSQL_TABLE_PREFIX."destination` D ON L.`nDestination_Id` = D.`nDestination_Id`
		              WHERE D.`nDestination_Id`='".mysql_real_escape_string($destinationId)."' AND `vActive`='active'".$extraCaseString."
		              GROUP BY L.`nLocation_Id` ".$orderByString.' '.$limitString;
                            

       $tempLocations     = $db->selectQuery($tempQuery);

       return $tempLocations;

    }
    
     public static function getLocationReviews($locationId,$extraCase=NULL,$orderBy=NULL,$limit=NULL)
     {

       $db                  = new Db();
       
       $limitString         = ($limit>0)             ? ' LIMIT 0,'.  $limit          : '';
       $orderByString       = (trim($orderBy)!='')   ? ' ORDER BY '. $orderBy        : '';
       $extraCaseString     = (trim($extraCase)!='') ? ' AND '.      $extraCase      : '';

       
       $tempQuery         = " SELECT R.*,C.*,DATE_FORMAT(R.dPosted_Date,'%b %d %y %H:%i:%s') as dPosted_Date FROM `".MYSQL_TABLE_PREFIX."rating` R
                              INNER JOIN   `".MYSQL_TABLE_PREFIX."customers` C ON C.nCust_Id = R.nCust_Id 
		              WHERE R.`vFeedback_Status`='active' AND R.`nLocation_Id`='".$locationId."' ".$extraCaseString."
		              ".$orderByString.' '.$limitString;                            

       $tempReviews     = $db->selectQuery($tempQuery);
       return $tempReviews;

     }


      public static function getAverageRating($entityId,$type)
      {       

        $db                  = new Db();
        $whereCaseString     = ($type=='location') ? ' nLocation_Id="'.$entityId.'" ' : ' nDestination_Id="'.$entityId.'" '  ;

        $tempQuery           = " SELECT count(nRatingId) as raingCount , SUM(nMarks) as totalMarks FROM `".MYSQL_TABLE_PREFIX."rating`
		               WHERE ".$whereCaseString." AND `vRate_Status`='active' ";


       $tempReviews         = $db->selectQuery($tempQuery);
       $tempReviews         = $tempReviews[0];

       $tempValue = round(($tempReviews->totalMarks/$tempReviews->raingCount), 0);   // 10

       $tempValue = ($tempValue%2==1) ? ($tempValue-1) : ($tempValue);

       $tempRatingValue = ($tempValue>0) ?  $tempValue : 0;

       return $tempRatingValue;

      }


      

     public static function getLocationRatecodes($locationId,$limit=NULL)
     {

       $db                  = new Db();

       $limitString         = ($limit>0)             ? ' LIMIT 0,'.  $limit          : '';
        

      
       $tempQuery = "SELECT AT.vAt_Name,AT.nAt_Id,AAT.additional_guest_allowed,AAT.additional_guest_rate FROM ".MYSQL_TABLE_PREFIX."locations L
		     INNER JOIN ".MYSQL_TABLE_PREFIX."destination D ON D.nDestination_Id = L.nDestination_Id
		     INNER JOIN ".MYSQL_TABLE_PREFIX."available_acco_type AAT ON AAT.nLocation_Id = L.nLocation_Id
		     INNER JOIN ".MYSQL_TABLE_PREFIX."accomodation_types AT ON AT.nAt_Id = AAT.nAt_Id
		     WHERE AAT.vActive='active' AND L.nLocation_Id = '".mysql_real_escape_string($locationId)."' AND AT.vActive='active'
                     GROUP BY AT.nAt_Id ORDER BY AT.vAt_Name ASC".$limitString;



       $tempLocationRates     = $db->selectQuery($tempQuery);

       return $tempLocationRates;

     }



     public static function saveLocationRatings($postedArray)
     {
        
        $db                    = new Db();        
        $table                 = 'rating';       

        $db->insert(MYSQL_TABLE_PREFIX.$table, $postedArray);

       return 1;

     }


     

  



     public static function getAccomadationName($accomadationId)
     {
         $db         = new Db();

         $table      = 'accomodation_types';
         $field      = 'vAt_Name';

         $tempResult =  $db->selectRow($table, $field, 'nAt_Id="'.mysql_real_escape_string($accomadationId).'"');

         return $tempResult;


     }

     public static function getLocationName($locationId)
     {
         $db         = new Db();

         $table      = 'locations';
         $field      = 'vLocation_Name';

         $tempResult =  $db->selectRow($table, $field, 'nLocation_Id="'.mysql_real_escape_string($locationId).'"');
         return $tempResult;

     }





public static function getOfferRateDetails($accomadationAvailabiltyId)
{

     $db         = new Db();
     $tempQuery  = 'select offer_start_date,offer_end_date,offer_price_id,price from '.MYSQL_TABLE_PREFIX.'offer_price where  nAat_Id="'.mysql_real_escape_string($accomadationAvailabiltyId).'" AND published="1" ';
               $tempResult =  $db->selectQuery($tempQuery);



		$specialOfferDates = array();

                if(count($tempResult)>0)
                {
                      foreach($tempResult as $tempKey => $tempVal)
                      {

                             $startDate = $tempVal->offer_start_date;
                             $endDate   = $tempVal->offer_end_date;
                             
                             $specialOfferDates[$tempVal->price] = Utils::buildInBetweenDates($startDate,$endDate);
                              


                      }
                }



                return $specialOfferDates;


}


//function to calculate group discount applied to accomadation availability types by admin
public static function getGruopDiscount($accomadationAvailabiltyId,$numberOfPeople=1)
{

    $db         = new Db();

   $tempQuery  = 'select `discount_percentage` from `'.MYSQL_TABLE_PREFIX.'group_discounts` where  `nAat_id` = "'.mysql_real_escape_string($accomadationAvailabiltyId).'"
                   AND  group_size <= '.$numberOfPeople. ' AND group_size_range >= '.$numberOfPeople.' order by discount_percentage desc limit 0,1';

    $tempResult =  $db->selectQuery($tempQuery);
    return $tempResult[0];


}



public static function getDestinationId($packageId)
{

    $db         = new Db();
    $packageId  = (int) $packageId;

    $tempQuery  = 'select `nDestination_Id` from `'.MYSQL_TABLE_PREFIX.'packages` where  `nPackage_Id` = "'.mysql_real_escape_string($packageId).'" limit 0,1';

    $tempResult =  $db->selectQuery($tempQuery);

     
    return $tempResult[0]->nDestination_Id;


}

public static function getPackageDetails($packageId)
{

    $db         = new Db();
    $packageId  = (int) $packageId;

    $tempQuery  = 'select * from `'.MYSQL_TABLE_PREFIX.'packages` where  `nPackage_Id` = "'.mysql_real_escape_string($packageId).'" limit 0,1';

    $tempResult =  $db->selectQuery($tempQuery);


    return $tempResult[0];


}


public static function getRateCard($accomadationId)
{

    $db              = new Db();
    $accomadationId  = (int) $accomadationId;

    $tempQuery  = 'select AAT.`nAmount` from `'.MYSQL_TABLE_PREFIX.'accomodation_types` AT
                   INNER JOIN `'.MYSQL_TABLE_PREFIX.'available_acco_type` AAT
                   where  AT.`nAt_Id` = "'.mysql_real_escape_string($accomadationId).'" limit 0,1';

    $tempResult =  $db->selectQuery($tempQuery);

    return $tempResult[0]->nAmount;

}


public static function getSpecialOfferDetails($locationId)
{

    $db         = new Db();
    $locationId = (int) $locationId;

    $tempQuery  = 'select `dStartDate`,`dEndDate`,`nRate` from `'.MYSQL_TABLE_PREFIX.'special_offers` 
                   where  `nLocation_Id` = "'.mysql_real_escape_string($locationId).'"
                   and `vActive` = "1"';
    
    $tempResult =  $db->selectQuery($tempQuery);

    $specialOfferDates = array();

    if(count($tempResult)>0)
    {
        foreach($tempResult as $tempKey => $tempVal)
        {

           $startDate                          = $tempVal->dStartDate;
           $endDate                            = $tempVal->dEndDate;
           $specialOfferDates[$tempVal->nRate] = Utils::buildInBetweenDates($startDate,$endDate);           

        }
     }
     //print_r($specialOfferDates);die;
     return $specialOfferDates;

}



public static function getSpecialOfferDetailsByOfferId($offerId){

    $db         = new Db();
    $offerId    = (int) $offerId;

    $tempQuery  = 'select dStartDate,dEndDate,nRate from '.MYSQL_TABLE_PREFIX.'special_offers
                   where  nSp_Id = "'.mysql_real_escape_string($offerId).'"
                   and vActive = "1" AND dStartDate >=CURDATE()';
    $specialOfferDetails =  $db->fetchSingleRow($tempQuery);
    return $specialOfferDetails;
}


public static function getAvailableAccomodationTypeId($locationId,$accomodationTypeId){

    $db                    = new Db();
    $accomodationTypeId    = (int) $accomodationTypeId;

    $tempQuery  = "select nAat_Id from ".MYSQL_TABLE_PREFIX."available_acco_type
                   where  nAt_Id = '".mysql_real_escape_string($accomodationTypeId)."' AND nLocation_Id='".$locationId."'";
    $availableAccoDetails =  $db->fetchSingleRow($tempQuery);
    return $availableAccoDetails;
}

public static function getGroupDiscountDetailsByAccomodationType($availableAccomodationTypeId){

    $db                    = new Db();
    $availableAccomodationTypeId    = (int) $availableAccomodationTypeId;

    $tempQuery  = 'select * from '.MYSQL_TABLE_PREFIX.'group_discounts
                   where  nAat_id = "'.mysql_real_escape_string($availableAccomodationTypeId).'"';
    $groupDiscountDetails =  $db->selectQuery($tempQuery);
    return $groupDiscountDetails;
}








      
}




?>