<?php 

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | File name : Utils.php                                         		  |
// | PHP version >= 5.2                                                   |
// +----------------------------------------------------------------------+
// | Author: ARUN SADASIVAN<arun.s@armiasystems.com>              		  |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems � 2010                                    |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+

class Utils {


    public static function echopre($array) {
        print "<pre>";
        print_r($array);
        print "</pre>";
    }

    public static function isEmpty($data) {


        $data = trim($data);

        if($data == '' || $data === null) {
            return true;
        }
        else

            return false;

    }

    public static function checkPanelExists($panel) {
        $found = 0;
        if(PageContext::$layoutPostActionObj) {
            foreach(PageContext::$layoutPostActionObj->actions as $action) {
                if($action->position == $panel) {
                    $found = 1;
                }
            }
        }
        return $found;
    }

    public static function validEmail($email) {


        if(!preg_match('/^[_A-z0-9-]+((\.|\+)[_A-z0-9-]+)*@[A-z0-9-]+(\.[A-z0-9-]+)*(\.[A-z]{2,4})$/',$email)) {
            return false;
        }
        else {
            return true;
        }
    }


    /*
     * function to generate the alias for the input text
    */

    public static function generateAlias($table_name, $alias_text, $id_column = "id", $id = "", $alias_column = "alias") {
        //format alias
        $alias = str_replace("&amp;", "and", $alias_text);
        $alias = htmlspecialchars_decode($alias, ENT_QUOTES);
        $alias = str_replace("-", " ", $alias);
        $alias = preg_replace("/[^a-zA-Z0-9\s]/", "", $alias);
        $alias = preg_replace('/[\r\n\s]+/xms', ' ', trim($alias));
        $alias = strtolower(str_replace(" ", "-", $alias));

        $db = new db();
        //check for duplicates
        $sql = "select count(*) as total from $table_name where $alias_column = '" . $alias . "'";
        if ($id)
            $sql .= " and $id_column <> $id";
        $duplicates = $db->fetchSingleRow($sql);
        //if duplicates exist recursively create a new alias and try
        if ($duplicates->total > 0) {
            $rand_str =Globalutils::rand_str(4);    //$rand_str = self::rand_str(4);
            $alias = self::generateAlias($table_name, $alias . "-" . $rand_str, $id_column, $id, $alias_column);
        }
        return strtolower($alias);
    }



    public static function escapeArray($array) {



        foreach($array as $key => $value) {
            if(!is_array($value)) {
                $array[$key] = mysql_real_escape_string(trim($value));
            }
            else {
                $array[$key] = escapeArray($value);
            }
        }


        return $array;


    }


    public static function isValidUserName($string) {

        if(trim($string)!= '') {
            if(preg_match( '/^\d*$/'  , $string) == 1) {
                return false;
            }
            if (preg_match("[^0-9a-zA-Z+_]", $string) == 1) {
                return false;
            }
            else {
                return true;
            }
        }
        else {
            return false;
        }
    }

    public static function dateFormat($input_date, $input_format, $output_format) {
        @preg_match("/^([\w]*)/i", $input_date, $regs);
        $sep = @substr($input_date, strlen($regs[0]), 1);

        $label       = @explode($sep, $input_format);
        $value       = @explode($sep, $input_date);
        $array_date  = @array_combine($label, $value);

        if(@in_array('Y', $label)) {
            $year = $array_date['Y'];
            $hour                  = 0;
            $minitue               = 0;
        }
        else if(@in_array('y', $label)) {
            $year = $year = $array_date['y'];
            $hour                  = 0;
            $minitue               = 0;
        }
        else {
            return false;
        }

        $output_date = @date($output_format, @mktime(0, 0, 59, $array_date['m'], $array_date['d'], $year));
        return $output_date;
    }



    public static function buildInBetweenDates($startDate,$endDate) {

        $diff           = abs(strtotime($startDate) - strtotime($endDate));

        $years          = floor($diff / (365*60*60*24));
        $months         = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
        $nDays          = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));

        $rangeArray[]   = $startDate;

        for($i=1;$i<$nDays;$i++) {
            $newDate        = date('Y-m-d',strtotime($startDate. "+1 day"));
            $rangeArray[]   = $newDate;
            $startDate      = $newDate;
        }

        return $rangeArray;


    }





    public static function genRandomString($length = 10) {

        $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
        $string     = '';

        for ($p = 0; $p < $length; $p++) {
            $string .= $characters[mt_rand(0, strlen($characters))];
        }

        return $string;

    }


    public static function generateRandomAlphanumeric() {

        $len            = 8;
        // $randNumber     = mt_rand(0, 1000000);
        $strAlphanum    = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $len            = (int)$len;
        $aAlphanum      = str_split($strAlphanum);
        $strRes         = '';

        for ($i = 0; $i < $len; $i += 1) {
            $key       = mt_rand(0, 35);
            $char      = $aAlphanum[$key];
            $strRes   .= (1 === mt_rand(0, 1) && !is_numeric($char)) ? strtoupper($char) : $char;
        }

        return $strRes;

    }




    /*
     * function to generate thumbnail
    */
    public function createThumbnail($photoid,$thumbtype,$crop=true) {


        global $imageConfig;
        $imageTypes = $imageConfig;

        $model 			= new Db();
        $fileDet 	= $model->selectRecord("files","file_orig_name,file_path","file_id=".$photoid);
        $sourceFile = FILE_UPLOAD_DIR.'/'. $fileDet->file_path;
        $destFile  = FILE_UPLOAD_DIR.'/'.$imageTypes[$thumbtype]['prefix']. $fileDet->file_path;
        $ih = new Gdimagehandler($sourceFile);
        $ih->generateThumbnail($destFile,$imageTypes[$thumbtype]['width'],$imageTypes[$thumbtype]['height'],$crop);

    }

    public function generateThumbnail($imgUrl,$thumbtype,$crop=true) {


        global $imageConfig;
        $imageTypes = $imageConfig;

        $sourceFile = FILE_UPLOAD_DIR.'/'. $imgUrl;
        $destFile  = FILE_UPLOAD_DIR.'/'.$imageTypes[$thumbtype]['prefix']. $imgUrl;
        $ih = new Gdimagehandler($sourceFile);
        $ih->generateThumbnail($destFile,$imageTypes[$thumbtype]['width'],$imageTypes[$thumbtype]['height'],$crop);
        return $imageTypes[$thumbtype]['prefix']. $imgUrl;
    }



    public static function imageCheck($source_file,$type,$destination_prefix,$default_file,$additional_file='') {


        global $imageConfig;

        $imageTypes           = $imageConfig;
        $finalImage           = '';


        if(trim($imageTypes[$type]['directory']) != '')
            $directoryString = $imageTypes[$type]['directory'] .'/';


        if($source_file && file_exists(FILE_UPLOAD_DIR.'/'.$directoryString.$source_file)) {




            $imgName = $imageTypes[$destination_prefix]['prefix'].$source_file;

            if(file_exists(FILE_UPLOAD_DIR.'/'.$imageTypes[$destination_prefix]['directory'].'/'.$imgName)) {


                $imgUrl     = USER_IMAGE_URL.''.$imageTypes[$destination_prefix]['directory'].'/'.$imgName;
                $finalImage = $imgName;
            }
            else {


                $newImage   = Utils::generateImage($source_file, $imageTypes[$destination_prefix]['directory'].'/'.$imgName, $imageConfig[$destination_prefix]['width'], $imageConfig[$destination_prefix]['height'],true);

                $imgUrl     = USER_IMAGE_URL.$newImage;
                $finalImage = $newImage;
            }

        }
        else {
            $imgUrl = IMAGE_MAIN_URL.$default_file;
            $finalImage = $default_file;
        }



        $imagPath = $imgUrl;
        return $imagPath;
    }

    public static function generateImage($sourceimage,$newimagename,$width,$height,$crop=false) {

        $sourceFile = FILE_UPLOAD_DIR.'/'. $sourceimage;
        $destFile  = FILE_UPLOAD_DIR.'/'.$newimagename;
        $ih = new Gdimagehandler($sourceFile);
        $ih->generateThumbnail($destFile,$width,$height,$crop);
        return $newimagename;
    }

    //Generates reset password activation key
    public static function generateResetPasswordActivationKey() {
        Logger::info("Generating reset password activation key :");
        $activationkey  =   're'.uniqid();
        return $activationkey;
    }

    public static function sendUserMail($userMailId, $mailTemplateName, $arrReplace,$userMailName = '') {

        PageContext::includePath('phpmailer');
        Logger::info("Entering email functionality.");

        $smtpEnable =  Apputils::fetchSettings('EnableSMTP'); 

        $model                = new Db();
        $mailTemplate         = $model->selectRecord("mail_template", "*", "mail_template_name='".$mailTemplateName."' AND mail_template_status=1");

        $adfromemail          = $model->selectRow("lookup","vLookUp_Value","vLookUp_Name='addressfromemail'");
        $adfromemailname      = $model->selectRow("lookup","vLookUp_Value","vLookUp_Name='addressfromemailname'");
        $adreplyemail         = $model->selectRow("lookup","vLookUp_Value","vLookUp_Name='addressreplyemail'");
        $adreplyemailname     = $model->selectRow("lookup","vLookUp_Value","vLookUp_Name='addressreplyemailname'");


        $userName = self::getMailNameOfUser($userMailId);

        if(sizeof($mailTemplate)>0) {

            $logo                       = Apputils::getSiteLogoUrl();
            $copyRightText		= 'copyright '.date('Y').' '.SITENAME.' All rights reserved';
            $arrTSearch     		= array("{LOGO_URL}","{SITE_NAME}","{SITE_URL}","{FirstName}","{LastName}","{Email}","{ActivationLink}","{ADDRESS}","{Date}","{PasswordLink}","{ReferenceLink}","{CLASS_NAME}","{ACTIVITY_NAME}","{ZIP}","{DATE}","{NAME}","{MAIL_BODY}","{USER}","{TEXT}","{SHARE_LINK}","{PASSWORD}","{SITE_LOGO}","{COPYRIGHT}");
            $arrTReplace    		= array($logoUrl,SITENAME, BASE_URL,$arrReplace['firstName'],$arrReplace['lastName'],$arrReplace['email'],$arrReplace['activationLink'],$arrReplace['address'],date('F d, Y'),$arrReplace['passwordLink'],$arrReplace['referenceLink'],$arrReplace['className'],$arrReplace['activityName'],$arrReplace['zip'],$arrReplace['date'],$arrReplace['name'],$arrReplace['mailBody'],$arrReplace['user'],$arrReplace['text'],$arrReplace['shareLink'],$arrReplace['password'],$logo,$copyRightText);

            foreach($arrTSearch as $tempkey =>$tempValue) {
                $mailTemplate->mail_template_body = str_replace($tempValue, $arrTReplace[$tempkey], $mailTemplate->mail_template_body);
                $mailTemplate->mail_template_sub  = str_replace($tempValue, $arrTReplace[$tempkey], $mailTemplate->mail_template_sub);
            }

            $mailBody   		= $mailTemplate->mail_template_body;
            $mailSubject		= $mailTemplate->mail_template_sub;

            $mail                       = new PHPMailer();

            if($smtpEnable =='Y') {

                // SMTP Credentials
                $SMTPHost     =  Apputils::fetchSettings('SMTPHost');
                $SMTPUsername =  Apputils::fetchSettings('SMTPUsername');
                $SMTPPassword =  Apputils::fetchSettings('SMTPPassword');
                $SMTPPort     =  Apputils::fetchSettings('SMTPPort');
                $SSLEnabled   =  Apputils::fetchSettings('SSLEnabled');
                $SSLStatus    = ($SSLEnabled=='Y')?'ssl':''; 
        
                $mail->IsSMTP(); 		        // telling the class to use SMTP
                $mail->Host       = $SMTPHost; 	        // SMTP server
                if(PageContext::$debug) {               // enables SMTP debug information (for testing)
                    $mail->SMTPDebug  = 2;
                }
                $mail->SMTPSecure = $SSLStatus;
                $mail->SMTPAuth   = true;             // enable SMTP authentication
                $mail->Port       = $SMTPPort;       // set the SMTP port for the GMAIL server
                $mail->Username   = $SMTPUsername;   // SMTP account username
                $mail->Password   = $SMTPPassword;
            }
            
            $mail->AddReplyTo($adreplyemail,$adreplyemailname);
            $mail->SetFrom($adfromemail, $adfromemailname);
            $mail->AddAddress($userMailId, $userName);
            $mail->Subject              = $mailSubject;
            $mail->AltBody              = ''; // Optional, comment out and test.

            if(Apputils::fetchSettings('email_type') == 'html' ) {
                $mail->MsgHTML($mailBody);        // Send mail as html.
            }
            else {

                PageContext::includePath('html2text');

                $h2t           = new html2text($mailBody);
                //$h2t->set_allowed_tags('<table><tr></tr><th></th><td></td></table>');
                $mailBody      = $h2t->get_text();

                $mail->MsgPlaintext($mailBody); // Send mail as html.

                //$mail->MsgHTML($mailBody);        // Send mail as html.
            }


            if(ENVIRONMENT != 'LOCAL'){
                $mailsent           = $mail->Send();
            }
            
            return $mailsent;
        }
        else{
            Logger::info("No active email template found.");
        }

    }



    /**
     * Method to create a select drop down
     * @param : $name(string), $values(array), $selected(string), $class(string)
     */
    public static function select($name, $options = array(), $selected = '', $class = '', $append = '', $id = '', $param = '') {
        if($id == '')   $id    =    $name;
        $selectString = '<select name="' . $name . '" class="' . $class . '" id="'. $id .'" '.$param.'>';
        if($append != '') {
            $selectString .= '<option value="" >' . $append . '</option>';
        }
        if(!empty($options)) {
            foreach($options AS $key => $option) {
                if($selected != '' && $selected == $key) {
                    $selectString .= '<option value="' . $key . '" selected = "selected" >' . $option . '</option>';
                } else {
                    $selectString .= '<option value="' . $key . '" >' . $option . '</option>';
                }
            }
        }
        $selectString .= '</select>';
        //if($name=='Category1')
        //print_r($selectString);exit;
        return $selectString;
    }



    /*
     * public function to return the lookup table data
    */
    public static function getSettingsData($field ,$code = NULL) {
        $db 			= new Db();
        $settingsData 	= $db->selectResult('lookup', 'vLookUp_Value', "vLookUp_Name='".$field."'");
        $settingsVal 	= $settingsData[0]->vLookUp_Value; 
        $curr_table = '';
        if($field =='currency'){
             if(mysql_num_rows(mysql_query("SHOW TABLES LIKE '".MYSQL_TABLE_PREFIX."currency_master'"))==1) {
                 $curr_table = 1;
             }
        }
         if($field == 'currency' && $code == NULL){
             if($curr_table==1){
                 $currencyData 	= $db->selectResult('currency_master', 'currency_symbol', "currency_id='".$settingsVal."'");
                 $settingsVal = $currencyData[0]->currency_symbol;
             }else{
                 $settingsVal  = '$';
             }
         }
         else if($field == 'currency' && $code == 'code'){
             if($curr_table==1){
                 $currencyData 	= $db->selectResult('currency_master', 'currency_code', "currency_id='".$settingsVal."'");
                 $settingsVal = $currencyData[0]->currency_code;
             }else{
                 $settingsVal  = 'USD';
             }
         }
        return $settingsVal;

    }


    /*
     * function to change the timestamp value to date format
    */
    public static function fdate($dateval,$sperator='-') {
        if($dateval != '')
            return date('m'.$sperator.'d'.$sperator.'Y',$dateval);
    }



    /*
	 * function to get the feed data
    */

    public static function getFeedData() {
        $db 			= new Db();
        $feedData 		= $db->selectResult('destination D LEFT JOIN '.MYSQL_TABLE_PREFIX.'gallery G ON D.nDestination_Id = G.nDestination_Id ', 'D.*,G.vURL', "vStatus='active' GROUP BY vDestination_Name ORDER BY vDestination_Name ASC");
        return $feedData;
    }

    /*
	 * function for feed generation
    */

    public static function feedGenerator($feeddata) {

        $siteName = Utils::getSettingsData('sitename');

        $num = sizeof($feeddata);

        // First we print the overall xml information
        $outPut .= '<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">';
        $outPut .= "\n";
        $outPut .= "<channel>\n";
        $outPut .= '<atom:link href="'.BASE_URL.'index/feed" rel="self" type="application/rss+xml" />';
        $outPut .= "\n";
        // Here comes the global title for you rss
        $outPut .= "<title>".$siteName."</title>\n";
        // Here comes the url for the page that the rss applies for
        $outPut .= "<link>".BASE_URL."</link>\n";
        // Here comes a short description of the page
        $outPut .= "<description>Latest Destination Feed</description>\n";

        // Now over to the dynamic part

        if($num == 0) {
            $outPut .= "<item>\n";
            $outPut .= "<title>Sorry, no records to display.</title>\n";
            $outPut .= "<link>".BASE_URL."destinations</link>\n";
            $outPut .= "<description>\n";
            $outPut .= "Sorry, no records to display.";
            $outPut .= "</description>\n";
            $outPut .= "<guid isPermaLink='true'>".BASE_URL."/destinations</guid>\n";
            $outPut .= "</item>\n";
        }
        else {
            $arrFind=array('<p>','&nbsp;</p>','<span style=\"font-size: large\">','<span>','<span style=\"color: #0000ff\">','</span>','</p>','<p style=\"text-align: center\">','</sp','<span style=\"font-size: xx-large\">','&');
            $arrReplace=array('','','','','','','','','','','and');
            foreach($feeddata as $feed) {
                $showDes=str_replace($arrFind,$arrReplace,substr($feed->tDestination_Description,0,325)."...");
                $outPut .= "<item>\n";
                $outPut .= "<title>".ucfirst($feed->vDestination_Name)."</title>\n";
                $outPut .= "<link>".BASE_URL."destination/".$feed->nDestination_Id."</link>\n";
                $outPut .= "<description>\n";
                $outPut .= '<![CDATA['.html_entity_decode(stripslashes($showDes)).']]>';
                $outPut .= "</description>\n";
                $outPut .= "<guid isPermaLink='true'>".BASE_URL."destination/".$feed->nDestination_Id."&amp;source=s</guid>\n";
                $outPut .= "</item>\n";
            }
        }
        // And at last the closing tags for the overall info
        $outPut .= "</channel>\n";
        $outPut .= "</rss>\n";
        return $outPut;
    }


    public static function getMetaContents($section) {
        $metaData = Home::fetchMetaContent($section);
        PageContext::$metaTitle .= $metaData->vTitle;
        PageContext::$metaKey = $metaData->vKeywords;
        PageContext::$metaDes = $metaData->vDescription;
    }



    /*
         * function to get the city name and state data for search
    */
    public static function getStateCode($cityCode) {
        $db 			= new Db();
        $stateData 		= $db->selectRecord('destination AS D INNER JOIN '.MYSQL_TABLE_PREFIX.'locations AS L ON D.nDestination_Id = L.nDestination_Id ', 'D.vDestination_Name,L.vState', " D.nDestination_Id= ".$cityCode. " and D.vStatus='active'");
        return $stateData;

    }



    /*
		 * get the help categories 
    */
    public static function getHelpCategories($catType) {
        if($catType != '')
            $where = " htype='".$catType."' AND active='1'";
        $db 			= new Db();
        $helpData 		= $db->selectResult('HelpCategory', '*', $where." ORDER BY hcposition ASC");
        return $helpData;
    }



    /*
		 * function to get the help subcategories
    */
    public static function getHelpDetails($catid) {
        if($catid != '')
            $where = " hcid='".$catid."' AND active='1'";
        $db 			= new Db();
        $helpDatas 		= $db->selectResult('Help', '*', $where." ORDER BY hposition ASC");
        return $helpDatas;
    }

    /*
		 * function to get a helpitem
    */
    public static function getHelpItem() {
        $db 			= new Db();
        $helpData 		= $db->selectRecord('HelpCategory', 'hcid',"active='1' AND htype='client' LIMIT 0,1");
        return $helpData->hcid;
    }

    /*
 		 * function to get the details of the help page
    */
    public static function getHelpPage($pageid) {
        $db 			= new Db();
        $helpData 		= $db->selectRecord('Help', '*',"active='1' AND hid=".$pageid);
        return $helpData;
    }
    
 



    /*
 		 * function to get the name of user for email
    */
    public static function getMailNameOfUser($useremail) {

        $db 			= new Db();
        $userDet 		= $db->selectRecord('customers', 'vFirstname,vLastname',"vEmail='".$useremail."'");
        if(sizeof($userDet) > 0) {// mail already exist
            if($userDet->vFirstname != '')
                return ucfirst($userDet->vFirstname.' '. $userDet->vLastname );
            else {
                $parts = explode('@', $useremail);
                return ucfirst($parts[0]);

            }

        }
        else {  // no email in user table. lets search in affiliate table
            $affInfo 		= $db->selectRecord('affiliates', 'aff_fname,aff_lname',"aff_email='".$useremail."'");
            if(sizeof($affInfo) > 0) {
                return ucfirst($affInfo->aff_fname.' '. $affInfo->aff_lname );
            }
            else {	// no email in affiliates. lets split the email
                $parts = explode('@', $useremail);
                return ucfirst($parts[0]);

            }

        }
        /*
 			$db 			= new Db();
 			$affInfo 		= $db->selectRecord('affiliates', 'aff_fname,aff_lname',"active='1' AND hid=".$pageid);
        	return $helpData;
        */
    }

    public static function getCountries() {
        $db 			= new Db();
        $countryData 		= $db->selectResult('country ', '*', " tc_status='A'");
        return $countryData;
    }

    public static function getStatesByCountry($countryCode) {
        $db 			= new Db();
        $stateData 		= $db->selectResult('state S INNER JOIN '.MYSQL_TABLE_PREFIX.'country C ON S.tc_id=C.tc_id ', 'S.*', "C.tc_code='".$countryCode."'");
        return $stateData;
    }
    
     public static function getUnixDateFormat($affid) {
          $db 			= new Db();
         $affInfo 		= $db->selectRecord('affiliates', 'aff_regdate',"aff_id='".$affid."'");
            if(sizeof($affInfo) > 0) {
                return date('m/d/Y', $affInfo->aff_regdate);
            }
         
        
         
    }

    




}


?>