<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Programmer<programmer@armia.com>        		              |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com Â© 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+
?>
<?php
ini_set('display_errors', '0');
error_reporting(0);
include "../includes/config.php";
include_once "../classes/cls_dbhelper.php";
include_once "../classes/cls_generalmethods.php";
include_once("../classes/cls_utils.php");
//include "../includes/session.php";
$imagefolder = "../images";
$stylesfolder = "../themes";
$sitestyle = "LifeStyle-Antique/style.css";
$logoimage = "multicart_logo.png";
$productname = "Multicart Shopping Cart";
$adminCurrency = "USD";


$txtSiteNameArr = explode('.', $_SERVER['SERVER_NAME']);
$txtSiteName = $txtSiteNameArr[0];
$tableprefix = "multicart_";
$txtAdminName = "admin"; 
$txtAdminPassword = "admin"; 
$txtCurrency = "USD";

define("SITE_NAME", "Multicart 3.4");
define("SITE_META", "Online Shopping");
session_start();

function fileWritable($file) {

if (is_writable($file)) {
$file_status['status'] = true;
$file_status['message'] = " * '" . $userDisplaypath . "' is writable";
} else {
$file_status['status'] = false;
$file_status['message'] = " * Change the permission of '" . $userDisplaypath . "' to 777 <br/>";
}

return $file_status;
}

function isValidUsername($str) {
if (trim($str) != "") {
if (preg_match("[^0-9a-zA-Z+_]", $str)) {
return false;
} else {
return true;
}
} else {
return false;
}
}

function splitsqlfile($sql, $delimiter) {
// Split up our string into "possible" SQL statements.
$tokens = explode($delimiter, $sql);
// try to save mem.
$sql = "";
$output = array();
// we don't actually care about the matches preg gives us.
$matches = array();
// this is faster than calling count($oktens) every time thru the loop.
$token_count = count($tokens);
for ($i = 0; $i < $token_count; $i++) {
// Don't wanna add an empty string as the last thing in the array.
if (($i != ($token_count - 1)) || (strlen($tokens[$i] > 0))) {
// This is the total number of single quotes in the token.
$total_quotes = preg_match_all("/'/", $tokens[$i], $matches);
// Counts single quotes that are preceded by an odd number of backslashes,
// which means they're escaped quotes.
$escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$i], $matches);

$unescaped_quotes = $total_quotes - $escaped_quotes;
// If the number of unescaped quotes is even, then the delimiter did NOT occur inside a string literal.
if (($unescaped_quotes % 2) == 0) {
// It's a complete sql statement.
$output[] = $tokens[$i];
// save memory.
$tokens[$i] = "";
} else {
// incomplete sql statement. keep adding tokens until we have a complete one.
// $temp will hold what we have so far.
$temp = $tokens[$i] . $delimiter;
// save memory..
$tokens[$i] = "";
// Do we have a complete statement yet?
$complete_stmt = false;

for ($j = $i + 1; (!$complete_stmt && ($j < $token_count)); $j++) {
// This is the total number of single quotes in the token.
$total_quotes = preg_match_all("/'/", $tokens[$j], $matches);
// Counts single quotes that are preceded by an odd number of backslashes,
// which means they're escaped quotes.
$escaped_quotes = preg_match_all("/(?<!\\\\)(\\\\\\\\)*\\\\'/", $tokens[$j], $matches);

$unescaped_quotes = $total_quotes - $escaped_quotes;

if (($unescaped_quotes % 2) == 1) {
// odd number of unescaped quotes. In combination with the previous incomplete
// statement(s), we now have a complete statement. (2 odds always make an even)
$output[] = $temp . $tokens[$j];
// save memory.
$tokens[$j] = "";
$temp = "";
// exit the loop.
$complete_stmt = true;
// make sure the outer loop continues at the right point.
$i = $j;
} else {
// even number of unescaped quotes. We still don't have a complete statement.
// (1 odd and 1 even always make an odd)
$temp .= $tokens[$j] . $delimiter;
// save memory.
$tokens[$j] = "";
}
} // for..
} // else
}
}
return $output;
}

function isValidTableName($str) {
if (trim($str) != "") {
if (preg_match("[^a-zA-Z+_]", $str)) {
return false;
} else {
return true;
}
} else {
return false;
}
}

function getServerOS() {
return strtoupper(substr(PHP_OS, 0, 3));
}

function isValidEmail($email) {
$$email = trim($email);
    if ($email == "") {
        return false;
    }
    $pattern = '/^(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){255,})(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){65,}@)(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22))(?:\\.(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-+[a-z0-9]+)*\\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-+[a-z0-9]+)*)|(?:\\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\\]))$/iD';
    return preg_match($pattern, $email);
}

function isNotNull($value) {
if (is_array($value)) {
if (sizeof($value) > 0) {
return true;
} else {
return false;
}
} else {
if (($value != '') && (strtolower($value) != 'null') && (strlen(trim($value)) > 0)) {
return true;
} else {
return false;
}
}
}

function isValidWebImageType($mimetype, $filename, $tempname) {
$blacklist = array("php", "phtml", "php3", "php4", "js", "shtml", "pl", "py", "exe");
foreach ($blacklist as $file) {
if (preg_match("/\.$file\$/i", "$filename")) {
return false;
}
}
//check if its image file
if (!getimagesize($tempname)) {
return false;
}

if (($mimetype == "image/pjpeg") || ($mimetype == "image/jpeg") || ($mimetype == "image/x-png") || ($mimetype == "image/png") || ($mimetype == "image/gif") ||
($mimetype == "image/x-windows-bmp") || ($mimetype == "image/bmp")) {
return true;
} else {
return false;
}
}

function isValidWMImageType($mimetype, $filename, $tempname) {
/* if (($mimetype == "image/pjpeg") || ($mimetype == "image/jpeg") || ($mimetype == "image/gif")) {
 return true;
 } else {
 return false;
 } */
$blacklist = array("php", "phtml", "php3", "php4", "js", "shtml", "pl", "py", "exe");
foreach ($blacklist as $file) {
if (preg_match("/\.$file\$/i", "$filename")) {
return false;
}
}
//check if its image file
if (!getimagesize($tempname)) {
return false;
}
if ($mimetype == "image/gif") {
return true;
} else {
return false;
}
}

function getFilePermission($file) {
$perm = fileperms($file);
if ($perm === false) {
return "0000";
} else {
return substr(sprintf('%o', $perm), -4);
}
}

function stripslashes_deep($value) {
$value = is_array($value) ? array_map('stripslashes_deep', $value) : stripslashes($value);
return $value;
}




$schemafile = "schema.sql";
$datafile = "data.sql";
$configfile = "../includes/config.php";

$configcontents = @fread(@fopen($configfile, 'r'), @filesize($configfile));
$pos = strpos($configcontents, "INSTALLED");
if ($pos === false) {
;
} else {
header("Location:./index.php");
}


$fullurl = $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
if ($_SERVER['HTTPS'] == 'on') {
$http = "https://";
} else {
$http = "http://";
}
$pos = strrpos($fullurl, "/");
if ($pos === false) { // note: three equal signs
// not found...
} else {
$fullurl = substr($fullurl, 0, $pos);
}

$txtSiteURL = "http://" . $fullurl;
$txtSecureSiteURL = "https://" . $fullurl;

/* * ********************************check server configuration **************************************************** */
$OS = getServerOS();
$val1 = ini_get("safe_mode");
//Short Open Tags Check Commented out php5.4,php5.5
//$val2 = ini_get("short_open_tag");
$val3 = ini_get("file_uploads");


$mysqlsupport = true;

if (!defined('PDO::ATTR_DRIVER_NAME')) {
$mysqlsupport = false;
}

if ((!empty($val1) || $val1 == 1)  or (empty($val3) || $val3 != 1) or !$mysqlsupport) {
$serverconfiguration = "FAILURE";
} else {

$serverconfiguration = "OK";
}

$installed = false;
$txtDBServerName = "localhost";

if ($_POST["btnContinue"] == "Continue" || $_POST['cldpack'] == 1) {


if ($_POST['cldpack'] == 1) {
$installPath = $_POST['returnurl'];
$txtDBServerName = 'localhost';
$txtDBName = $_POST["db_name"];
$txtDBUserName = $_POST["db_user"];
$txtDBPassword = $_POST["db_password"];
$txtSiteName = $_POST["store_name"];
$tableprefix = "multicart_";
$txtAdminName = "admin"; //$_POST["txtAdminName"];
$txtAdminPassword = "q1w2e3"; //$_POST["txtAdminPassword"];
// $txtConfirmAdminPassword = "q1w2e3"; //$_POST["txtConfirmAdminPassword"];
$txtAdminEmail = $_POST['contactemail'];
$cmbCurrency = $_POST["cmbCurrency"];
$txtSiteURL = "http://" . $_POST["domain"];
$txtSecureSiteURL = "http://" . $_POST["domain"];
$txtCurrency = "USD";
} else {
$txtLicenseKey = $_POST["txtLicenseKey"];
$txtDBServerName = $_POST["txtDBServerName"];
$txtDBName = $_POST["txtDBName"];
$txtDBUserName = $_POST["txtDBUserName"];
$txtDBPassword = $_POST["txtDBPassword"];
$tableprefix = "multicart_";
$txtSiteName = $_POST["txtSiteName"];
// $txtAdminName = $_POST["txtAdminName"];
// $txtAdminPassword = $_POST["txtAdminPassword"];
// $txtConfirmAdminPassword = $_POST["txtConfirmAdminPassword"];
$txtAdminEmail = $_POST["txtAdminEmail"];
$txtCurrency = $_POST['txtCurrency'];
}


/* ----------Multicart 2.1 Upgradation starts----------- */

//$imagedir = "../images/";
$imagedir = "../banners/";

/* ----------Multicart 2.1 Upgradation ends----------- */


$portfoliodir   = "../portfolios/";
$productsdir    = "../products/";
$zipdir         = "../products/zip/";
$csvdir         = "../csv/";

$template1_file = "../themes/Deep Purple/style.css";
$template2_file = "../themes/Shopping Girl/style.css";
$template3_file = "../themes/Happy Holidays/style.css";

$template1_original_file = "../style/template1_original.css";
$template2_original_file = "../style/template2_original.css";
$template3_original_file = "../style/template3_original.css";

/* ----------Multicart 2.1 Upgradation starts----------- */

$bulk_images_dir        = "../products/bulk_images";
$pem_dir                = "../pem";
$banner_dir             = "../banners";
$digital_dir            = "../digital_product";

$category_dir           = "../categories";
$categories_avatar_dir  = "../categories/avatar";
$home_page_banner_dir   = "../homepagebanners";

$backup_dir             = "../dbbackups";
$language_dir           = "../language";
$seller_banner_dir      = "../sellerbanners";


// (isset($_POST['sellerFriendly'])) ? $sellerFriendly = $_POST['sellerFriendly'] : $sellerFriendly = 'N';
$sellerFriendly = 'Y';

// creating .htaccess file
$htaccess_file = "../.htaccess";
/* ----------Multicart 2.1 Upgradation ends----------- */

$logofile = $_FILES['userfile'][0];
$logofilename = $_FILES['userfile']['name'][0];
$logofiletype = $_FILES['userfile']['type'][0];
$logotempname = $_FILES['userfile']['tmp_name'][0];

$logoimagedest = $imagedir . $logofilename;
$wmfilesmalldest = $imagedir . $wmfilesmallname;
$wmfilebigdest = $imagedir . $wmfilebigname;

$message = "";

if ($_POST['cldpack'] != 1) {
if (!isNotNull($txtLicenseKey)) {
$message .= " * License key is empty!" . "<br>";
$error = true;
}
if (!isNotNull($txtDBServerName)) {
$message .= " * Database Server Name is empty!" . "<br>";
$error = true;
}
if (!isNotNull($txtDBName)) {
$message .= " * Database Name is empty!" . "<br>";
$error = true;
}
if (!isNotNull($txtDBUserName)) {
$message .= " * Database User Name is empty!" . "<br>";
$error = true;
}
if (!isNotNull($txtSiteName)) {
$message .= " * Site Name is empty!" . "<br>";
$error = true;
}
if (!isNotNull($txtSiteURL)) {
$message .= " * Site URL is empty!" . "<br>";
$error = true;
}

if ($_FILES['userfile']['name'][0] != "") {
if (!isValidWebImageType($logofiletype, $logofilename, $logotempname)) {
$message .= " * Invalid Logo file ! Upload an image (jpg/gif/bmp/png)" . "<br>";
$error = true;
} else {
if (file_exists($logoimagedest)) {
$message .= " * Logo file with the same name exists! Please rename the logo file and upload! " . "<br>";
$error = true;
}
}
}


if (!isNotNull($txtAdminName)) {
$message .= " * Admin Login Name is empty!" . "<br>";
$error = true;
} else {
if (!isValidUsername($txtAdminName)) {
$message .= " * Invalid Admin Login Name! Please use only alphabets (aA-zZ) and underscore ( _ )!" . "<br>";
$error = true;
}
}
if (!isNotNull($txtAdminPassword)) {
$message .= " * Admin Password is empty!" . "<br>";
$error = true;
}
// if (!isNotNull($txtConfirmAdminPassword)) {
// $message .= " * Admin Confirmation Password is empty!" . "<br>";
// $error = true;
// }

if (isNotNull($txtAdminPassword)) {

// if ($txtAdminPassword != $txtConfirmAdminPassword) {

// $message .= " * Admin Passwords should match!" . "<br>";
// $error = true;
// }
}

if (!isNotNull($txtAdminEmail)) {
$message .= " * Admin Email is empty!" . "<br>";
$error = true;
} else {
if (!isValidEmail($txtAdminEmail)) {
$message .= " * Invalid Admin Email!" . "<br>";
$error = true;
}
}
if (isNotNull($tableprefix)) {
if (!isValidTableName($tableprefix)) {
$message .= " * Invalid database prefix! (Use only letters (aA-zZ) and underscore( _ ) with no spaces)" . "<br>";
$error = true;
}
}

if (!is_writable($configfile) || !is_readable($configfile)) {
$error = true;
$message .= " * Config file not writable! Please change the permission of 'includes/config.php' to 777 <br>";
}

/* ---------Multicart 2.1 upgradation starts-------------- */


// checking the frindly url of seller and write the htaccess accordingly


if ($sellerFriendly == "Y") {

if (!is_writable($htaccess_file) || !is_readable($htaccess_file)) {
$error = true;
$message .= " * htaccess file is not writable! Please change the permission of '.htaccess' to 777 <br>";
}
}

/* ---------Multicart 2.1 upgradation ends-------------- */
if ($OS != "WIN") { // check OS permission
    if (!is_writable($portfoliodir) || !is_readable($portfoliodir) || !@file_exists("$portfoliodir" . ".")) {
    $error = true;
    $message .= " * Change the permission (chmod 777 for linux server) of 'portfolios' folder in the root to 777 <br>";
    }
    if (!is_writable($productsdir) || !is_readable($productsdir) || !@file_exists("$productsdir" . ".")) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'products' folder in the root to 777 <br>";
    }

    if (!is_writable($zipdir) || !is_readable($zipdir) || !@file_exists("$zipdir" . ".")) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'products/zip' folder in the root to 777 <br>";
    }
    if (!is_writable($csvdir) || !is_readable($csvdir) || !@file_exists("$csvdir" . ".")) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'csv' folder in the root to 777 <br>";
    }

    /* ---------Multicart 3.3 upgradation starts-------------- */
    $combodir               = "../combo/";
    $comboavatardir         = "../combo/avatar/";
    $ckuploadsdir           = "../ckeditor/ckfinder/core/connector/php/uploads/";
    $sellerbannersdir       = "../sellerbanners/";
    $sectionsdir            = "../sections/";
    $sectionsavatardir      = "../sections/avatar/";

    if (!is_writable($combodir) || !is_readable($combodir) || !@file_exists("$combodir" . ".")) {
        $error = true;
        $message .= " * Change the permission  (chmod 777 for linux server) of 'combo' folder in the root to 777 <br>";
    }
    if (!is_writable($comboavatardir) || !is_readable($comboavatardir) || !@file_exists("$comboavatardir" . ".")) {
        $error = true;
        $message .= " * Change the permission  (chmod 777 for linux server) of 'combo/avatar' folder in the root to 777 <br>";
    }
    if (!is_writable($ckuploadsdir) || !is_readable($ckuploadsdir) || !@file_exists("$ckuploadsdir" . ".")) {
        $error = true;
        $message .= " * Change the permission  (chmod 777 for linux server) of 'ckeditor/ckfinder/core/connector/php/uploads/' folder in the root to 777 <br>";
    }
    if (!is_writable($sellerbannersdir) || !is_readable($sellerbannersdir) || !@file_exists("$sellerbannersdir" . ".")) {
        $error = true;
        $message .= " * Change the permission  (chmod 777 for linux server) of 'sellerbanners' folder in the root to 777 <br>";
    }
    if (!is_writable($sectionsdir) || !is_readable($sectionsdir) || !@file_exists("$sectionsdir" . ".")) {
        $error = true;
        $message .= " * Change the permission  (chmod 777 for linux server) of 'sections' folder in the root to 777 <br>";
    }
    if (!is_writable($sectionsavatardir) || !is_readable($sectionsavatardir) || !@file_exists("$sectionsavatardir" . ".")) {
        $error = true;
        $message .= " * Change the permission  (chmod 777 for linux server) of 'sections/avatar' folder in the root to 777 <br>";
    }
    /* ---------Multicart 3.3 upgradation starts-------------- */

    /* ---------Multicart 2.1 upgradation starts-------------- */

    if (!is_writable($bulk_images_dir) || !is_readable($bulk_images_dir)) {
    $error = true;
    $message .= " * Change the permission (chmod 777 for linux server) of 'products/bulk_images' folder in the root to 777 <br>";
    }
    if (!is_writable($pem_dir) || !is_readable($pem_dir)) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'pem' folder in the root to 777 <br>";
    }
    if (!is_writable($banner_dir) || !is_readable($banner_dir)) {
    $error = true;
    $message .= " * Change the permission (chmod 777 for linux server) of 'banners' folder in the root to 777 <br>";
    }
    if (!is_writable($digital_dir) || !is_readable($digital_dir)) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'digital_product' folder in the root to 777 <br>";
    }

    if (!is_writable($category_dir) || !is_readable($category_dir)) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'categories' folder in the root to 777 <br>";
    }

    if (!is_writable($categories_avatar_dir) || !is_readable($categories_avatar_dir)) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'categories/avatar' folder in the root to 777 <br>";
    }

    if (!is_writable($home_page_banner_dir) || !is_readable($home_page_banner_dir)) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'homepagebanners' folder in the root to 777 <br>";
    }

    //-------------newly added for 2.4 december release -----------//
    if (!is_writable($backup_dir) || !is_readable($backup_dir)) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'dbbackups' folder in the root to 777 <br>";
    }

    if (!is_writable($language_dir) || !is_readable($language_dir)) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'language' folder in the root to 777 <br>";
    }

    if (!is_writable($seller_banner_dir) || !is_readable($seller_banner_dir)) {
    $error = true;
    $message .= " * Change the permission  (chmod 777 for linux server) of 'sellerbanners' folder in the root to 777 <br>";
    }
} // end OS permission check
}
$txtSiteBaseFolderfull	= getcwd();
$txtSiteBaseFolder	= str_replace(array('/install', '\install'), array('', ''), $txtSiteBaseFolderfull);
/* ---------Multicart 2.1 upgradation ends-------------- */
include_once $txtSiteBaseFolder.'/pdo/pdoclass.php';
/*
 * PDO initialization
 */
// database connection setings
$dbConfig = array("host"=>$txtDBServerName, "dbname"=>$txtDBName, "username"=>$txtDBUserName, "password"=>$txtDBPassword);
// get instance of PDO Wrapper object
try{
    $pdo = new PdoClass($dbConfig);
}catch(Exception $e)
{
     $error = true;
     $message .= " * Connection Not Successful! ".$e->getMessage();
}

if (ini_get('safe_mode')) {//safe_mode is on
$error = true;
$message .= " * The script requires PHP with safe mode Off to work properly. Installation cannot continue! <br>";
}



//exit;

if ($error) {
$message = "<u><b>Please correct the following errors to continue:</b></u>" . "<br>" . $message;
// echo $message;
} else {

//uploading logo

if ($logofilename == "") {
$logofilename = $logoimage;
} else {
if (move_uploaded_file($_FILES['userfile']['tmp_name'][0], $logoimagedest)) {
include "../includes/class.upload.php";
$dir_dest = "../banners/";
$handle = new Upload($logoimagedest);
$logoNewfilename = substr($logofilename, 0, strrpos($logofilename, '.'));
list($origWidth, $origHeight) = getimagesize($logoimagedest);
$maxResizeWidth = 203;
$maxResizeHeight = 105;
$resizedWidth = $origWidth;
$resizedHeight = $origHeight;
if ($resizedWidth > $maxResizeWidth) {
$aspectRatio = $maxResizeWidth / $resizedWidth;
$resizedWidth = round($aspectRatio * $resizedWidth);
$resizedHeight = round($aspectRatio * $resizedHeight);
}
if ($resizedHeight > $maxResizeHeight) {
$aspectRatio = $maxResizeHeight / $resizedHeight;
$resizedWidth = round($aspectRatio * $resizedWidth);
$resizedHeight = round($aspectRatio * $resizedHeight);
}

if ($handle->uploaded) {
$handle->image_resize = true;
$handle->image_x = $resizedWidth;
$handle->image_y = $resizedHeight;
$handle->file_new_name_body = $logoNewfilename;
$handle->Process($dir_dest);
$logofilename = $handle->file_dst_name;
}
unlink($logoimagedest);
} else {
$logofilename = $logoimage;
}
}


/* --------writing .htaccess file---------- */

//set 777 permission to .htaccess file if the installation is on cloud pack 

@chmod($htaccess_file, 0777);

$base_write = dirname(dirname($_SERVER['PHP_SELF']));
$fp_htaccess = @fopen($htaccess_file, "w+");
$htaccess_content = "Options +FollowSymLinks\n";
$htaccess_content .= "ServerSignature Off\n\n";
$htaccess_content .= "RewriteEngine On\n\n";
$htaccess_content .= "RewriteBase " . $base_write . "\n\n";  // <rewrite base is not important>
$htaccess_content .= "RewriteRule ^store\/(.*) showportfolio.php?artistid=$1 [L,NC]\n";
$htaccess_content .= "RewriteRule ^stores\/(.*) showportfolio.php?storename=$1 [L,NC]\n";
$htaccess_content .= "RewriteRule ^store(.*) - [L]\n";

$htaccess_content .= "#RewriteRule ^([_A-Za-z0-9-]+)/([_A-Za-z0-9-]+)$ productdetails.php?productid=$1 [L]\n";
$htaccess_content .= "RewriteRule ^([_A-Za-z0-9-]+)([_A-Za-z0-9-/]*)([_A-Za-z0-9-/]*)([_A-Za-z0-9-/]*)([_A-Za-z0-9-/]*)$ productdetails.php?productid=$1 [L]\n";

$htaccess_content .= "RewriteCond %{REQUEST_FILENAME}  !-d\n";
$htaccess_content .= "RewriteCond %{REQUEST_URI} (.+).php/(.*)$\n";
$htaccess_content .= "RewriteRule ^ %1.php [R=301,L]\n";
//$htaccess_content .= "php_flag output_buffering On";

@fwrite($fp_htaccess, $htaccess_content);

@chmod($htaccess_file, 0644);

// writing to the config file....................



$installedDir = str_replace(array('/install', '\install'), array('', ''), dirname($_SERVER[PHP_SELF]));
if($installedDir == '/' || $installedDir == '\\') {
$installedDir = '';
}

$uniqueid = time() . mt_rand() . session_id();
if (strlen($uniqueid) > 15) {
$uniqueid = substr($uniqueid, 0, 15);
$uniqueid = md5($uniqueid);
}
$fp = fopen($configfile, "w+");
$configcontent = "<?php\n";
//cloud pdo conversion not done
if ($_POST['cldpack'] == 1) {
$configcontent .= "define('CLOUDINSTALLED', true); \n\n";
$configcontent .= "define('VERSION', '3.4'); \n\n";
$configcontent .= "define('SOURCE', 'SOURCE'); \n\n";
$configcontent .= "define('FIELD', 'vLookUp_Value'); \n\n";
$configcontent .= "define('CONDITION', \"vLookUp_Name = 'vLicenceKey'\"); \n\n";
$configcontent .= "define('PID',24); \n\n";
}

$configcontent .= "define('INSTALLED', true); \n\n";
$configcontent .= "define('VERSION', '3.4'); \n\n";
$configcontent .= "define('BASE_URL', '" . $txtSiteBaseFolder . "'); \n\n";
$configcontent .= "ini_set('display_errors', '0'); \n\n";
$configcontent .= "error_reporting(0); \n\n";

$configcontent .= '$HOST = "' . $txtDBServerName . "\";" . "\n";
$configcontent .= '$DATABASENAME = "' . $txtDBName . "\";" . "\n";
$configcontent .= '$USER = "' . $txtDBUserName . "\";" . "\n";
$configcontent .= '$PASSWORD = "' . $txtDBPassword . "\";" . "\n\n";
$configcontent .= '$tableprefix = "' . $tableprefix . "\";" . "\n";


$configcontent .= 'include_once BASE_URL."/pdo/pdoclass.php";';
$configcontent .= "\n";
$configcontent .= '$dbConfig = array("host"=>$HOST, "dbname"=>$DATABASENAME, "username"=>$USER, "password"=>$PASSWORD);';
$configcontent .= "\n";
$configcontent .= '$pdo = new PdoClass($dbConfig);';
$configcontent .= "\n";
$configcontent .= '$settings = $pdo->select($tableprefix."settings")->results();';
$configcontent .= "\n";
$configcontent .= '$row = $settings;';
$configcontent .= "\n";

$configcontent .='$logoimage=$row[0]["site_logo"];' . "\n";
$configcontent .='$featureddisplay=$row[0]["publish_featured"];' . "\n";
$configcontent .='$newitemdisplay=$row[0]["publish_newitem"];' . "\n";
$configcontent .='$sitestyle=$row[0]["site_style"];' . "\n";
$configcontent .='$shopingcartdisplay=$row[0]["publish_shoppingcart"];' . "\n";
$configcontent .='define("SITE_EMAIL", $row[0]["site_email"]);' . "\n";
$configcontent .='define("SITE_NAME", $row[0]["site_name"]);'."\n";
$configcontent .='define("SECURE_SITE_URL", $row[0]["site_secure_url"]);'."\n";
if($_POST['cldpack'] == 1) {
$configcontent.='if(isset($_SERVER["HTTPS"]) &&  $_SERVER["HTTPS"]=="on")
{
   define("SITE_URL", "https://" . $_SERVER[HTTP_HOST] );
}
else {
   define("SITE_URL", "http://" . $_SERVER[HTTP_HOST] );
}';
} else  {
$configcontent.='if(isset($_SERVER["HTTPS"]) &&  $_SERVER["HTTPS"]=="on")
{
   define("SITE_URL", "https://" . $_SERVER[HTTP_HOST] . "' . $installedDir . '");
}
else {
   define("SITE_URL", "http://" . $_SERVER[HTTP_HOST] . "' . $installedDir . '");
}';
}

$configcontent .= '$imagefolder = SITE_URL . "/images";' . "\n";
$configcontent .= '$rootserver = SITE_URL;' . "\n" . "\n";
/* ---------Multicart 2.1 Upgradation Starts------------- */
$configcontent .= '$logofolder = SITE_URL . "/banners";' . "\n";
$configcontent .= '$enable_seller_friendly = "' . $sellerFriendly . "\";" . "\n";

/* ---------Multicart 2.1 Upgradation Ends--------------- */
$configcontent .= '$stylesfolder = SITE_URL . "/style";' . "\n\n";
/* ---------Include language file configuration--------------- */
$configcontent .= "include_once('config_language.php'); \n";
$configcontent .= "define('MYSQL_TABLE_PREFIX', '" . $tableprefix . "'); \n";
$configcontent .= 'include_once BASE_URL."/classes/cls_generalmethods.php";'." \n";
$configcontent .= "?>";
fwrite($fp, $configcontent);

$sqlquery = @fread(@fopen($schemafile, 'r'), @filesize($schemafile));
$sqlquery = preg_replace('/multicart_/', $tableprefix, $sqlquery);
$sqlquery = splitsqlfile($sqlquery, ";");
// creating the tables......................................
for ($i = 0; $i < sizeof($sqlquery); $i++) {
$pdo->pdoQuery($sqlquery[$i]);
}

$dataquery = @fread(@fopen($datafile, 'r'), @filesize($datafile));
$dataquery = preg_replace('/multicart_/', $tableprefix, $dataquery);
$dataquery = splitsqlfile($dataquery, ";");
// populating the tables with initial data......................................
for ($i = 0; $i < sizeof($dataquery); $i++) {
 $pdo->pdoQuery($dataquery[$i]);
}


$adminusername = $txtAdminName;
$adminpassword = md5($txtAdminPassword);

/* ---------Multicart 2.1 Upgradation starts----------- */

$updateArr =array("vLicenceKey"=>$txtLicenseKey,
                "site_name"=>$txtSiteName,
                "site_email"=>$txtAdminEmail,
                "site_url"=>$txtSiteURL,
                "site_secure_url"=>$txtSecureSiteURL,
                "site_logo"=>$logofilename,
                "site_style"=>$sitestyle,
                "admin_name"=>$adminusername,
                "admin_currency"=>$adminCurrency,
                "admin_password"=>$adminpassword);
$test = $pdo->update($tableprefix.'settings', $updateArr,array("nsettings_id"=>1))->affectedRows();

define('MYSQL_TABLE_PREFIX',  $tableprefix );
$currency_list_array = Utils::GetCountryList();
//Check currency codes already updated to table , if no value exists then save data to table
$currencyObj    =   Utils::getCurrencyCodeCount();
if($currencyObj->status==SUCCESS)
        {
            //Delete and insert Data
            $currencyObjVal =   $currencyObj->data;
            $currencyCount  =   $currencyObjVal['currency_count'];
            
            if($currencyCount>0)
                {
                   // Save currency data to table // get Json data from global array and insert to table                 
                     $pdo->pdoQuery("TRUNCATE TABLE ".$tableprefix."currency_master")->results();
                }     
                if(!empty($currency_list_array))
                    {
                        foreach($currency_list_array->results as $key=>$objVals)
                            {
                                $objCurrencyVo->vcurrency_name      = $objVals->currencyName;
                                $objCurrencyVo->vcurrency_code      = $objVals->currencyId;
                                $objCurrencyVo->vcurrency_symbol    = $objVals->currencySymbol;
                                $objCurrencyVo->nexchange_price     = '1';
                                $objCurrencyVo->vactive             = "Y";
                                $currencyInfo                       =  Utils::saveAllCurrencyCodes($objCurrencyVo);
                            }
                    }

            
        }
              
// Currency Settings Updation

//include_once("../cron/currencyUpdate.php");


// if ($txtCurrency == 'EUR') {

// $sqlsettings_eur = @mysql_query("UPDATE " . $txtDBPrefix . "currency_master set nexchange_price='1',usdollar_rate='0.673718251'
// 								 where vcurrency_code='EUR' ");
// }

// if ($txtCurrency == 'GBP') {

// $sqlsettings_eur = @mysql_query("UPDATE " . $txtDBPrefix . "currency_master set nexchange_price='1',usdollar_rate='0.598300826'
// 								 where vcurrency_code='GBP' ");
// }

// if ($txtCurrency == 'AUD') {

// $sqlsettings_eur = @mysql_query("UPDATE " . $txtDBPrefix . "currency_master set nexchange_price='1',usdollar_rate='1.04'
// 								 where vcurrency_code='AUD' ");
// $sqlsettings_eur = @mysql_query("UPDATE " . $txtDBPrefix . "settings set enable_google='N',enable_shipping ='N',enable_fedexshipping 	='N',enable_uspsshipping='N',enable_canadapost ='N',enableworldpay ='N',vgoogle_check_enable ='N',vyourpay_enable ='N',vbluepay_enable ='N'");
// }
// inserting the admin details in to the settings table.............

/* $sqlsettings="update " . $txtDBPrefix . "settings set site_name='".addslashes($txtSiteName)."',
 site_email='".addslashes($txtAdminEmail)."',site_logo='".$logofilename."',
 admin_name='".addslashes($adminusername)."',admin_password='".$adminpassword."'" ; */

$installed = true;

/* ---------Code for the install tracker-------------- */

$string = "";
$pro = urlencode("Multicart 3.4");
$dom = urlencode($txtSiteURL);
$ipv = urlencode($_SERVER['REMOTE_ADDR']);
$mai = urlencode(addslashes($txtAdminEmail));
$string = "pro=$pro&dom=$dom&ipv=$ipv&mai=$mai";
$contents = "no";
$file = @fopen("http://www.iscripts.com/installtracker.php?$string", 'r');
if ($file) {
$contents = @fread($file, 8192);
}



/* ---------Code for the install tracker-------------- */
}
}

function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
$theValue = (!get_magic_quotes_gpc()) ? addslashes($theValue) : $theValue;

switch ($theType) {
case "text":
$theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
break;
case "long":
case "int":
$theValue = ($theValue != "") ? intval($theValue) : "''";
break;
case "double":
$theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "''";
break;
case "date":
$theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";
break;
case "defined":
$theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
break;
}
return $theValue;
}

include "../includes/installhtmltop.php";
?>

<link
	href="../themes/Deep Purple/style.css" rel="stylesheet" type="text/css">
<script language="javascript1.1"
	type="text/javascript" src="../js/bubble-tooltip.js"></script>
<link rel="stylesheet"
	href="../style/bubble-tooltip.css" type="text/css" media="screen">
<style type="text/css">
<!--
.install_option {
	font-family: Verdana, Arial, Helvetica, sans-serif;
	font-size: 9pt;
	color: #333333
}

.install_value_ok {
	font-family: Verdana, Arial, Helvetica, sans-serif;
	font-size: 9pt;
	font-weight: bold;
	color: #009900
}

.install_value_fail {
	font-family: Verdana, Arial, Helvetica, sans-serif;
	font-size: 7pt;
	font-weight: bold;
	color: #CC0000
}

.block_class {
	color: #F4700E;
	font-family: Verdana, Arial, Helvetica, sans-serif;
	font-weight: bold;
}
-->
</style>

<script>
    function checkInstallForm()
    {

        var form_name = new Array('txtLicenseKey', 'txtDBServerName', 'txtDBName', 'txtDBUserName', 'txtDBPassword', 'txtSiteName', 'txtAdminName', 'txtAdminPassword',  'txtAdminEmail');
        var display_name = new Array('License key', 'Database Server Hostname', 'Database Name', 'Database User Name', 'Database Password', 'Site Name', 'Admin Login Name', 'Admin Password', 'Confirm Admin Password', 'Admin Email');
        var count = 9;

        if (check_fields('frmInstall', form_name, display_name, count))
        {

            // if (document.frmInstall.txtAdminPassword.value != document.frmInstall.txtConfirmAdminPassword.value)
            // {

            //     alert('Password Mismatch !!');
            //     document.frmInstall.txtConfirmAdminPassword.focus();
            //     return false;

            // }

            if (trimSpaces(checkEmail(document.frmInstall.txtAdminEmail.value)))
            {


            }
            else
            {

                document.frmInstall.txtAdminEmail.focus();
                return false;

            }

        }
        else
        {

            return false;

        }

    }

    function DisplayHtAccessDiv()
    {

        if (document.frmInstall.sellerFriendly.checked)
        {
            document.getElementById("htaccessDiv").style.display = "";
            document.getElementById("htaccessDivMsg").style.display = "";
        }
        else
        {
            document.getElementById("htaccessDiv").style.display = "none";
            document.getElementById("htaccessDivMsg").style.display = "none";
        }

    }
</script>


<body>

<center>

<div align="left" id="layout">

<div align="left" id="header"><!--header area start -->

<div align="left" id="logo"><img src="../banners/multicart_logo.png" alt=""
	border="0" /></div>

<div align="right" id="header_right"><!--
                                             <a href="javascript:;">Contact Us</a>&nbsp;|&nbsp;
                --> <a href="javascript:;">&nbsp;</a></div>

<!--header area end --></div>

<div align="left" class="main_body"><!--mainbody area start -->


<div align="left" id="item_details"><!--items display area start -->

<div align="left" id="items_top_area">

<div align="left" id="items_top_area_ttl">
<h2>Multicart 3.4 Installation</h2>
</div>
&nbsp;&nbsp; <a title="OnlineInstallationManual" href="#"
	onClick="window.open('<?php echo htmlentities($txtSiteURL); ?>/docs/multicart.pdf', 'OnlineInstallationManual', 'top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Installation
manual</strong></a> | <a title="Readme" href="#"
	onClick="window.open('<?php echo htmlentities($txtSiteURL); ?>/Readme.txt', 'Readme', 'top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd');"><strong>Readme</strong></a>
| <a
	title="If you have any difficulty, submit a ticket to the support department"
	href="#"
	onClick="window.open('http://www.iscripts.com/support/postticketbeforeregister.php', '', 'top=100,left=100,width=820,height=550,scrollbars=yes,toolbar=no,status=yrd,resizable=yes');">
<strong>Get Support</strong></a></div>

<div>&nbsp;</div>



<div><?php
if ($serverconfiguration == "FAILURE") {
?>


<table width="100%" border=0>

<?php
$ivo = "<span class='install_value_ok'>";
$ivf = "<span class='install_value_fail'>";
$sc = "</span>";
echo "<tr><td class=maintext><b></b><br><br></td></tr>";


echo "<tr><td class=maintext>Checking PHP Version... " . $ivo . PHP_VERSION . $sc . " ";
if (version_compare(PHP_VERSION, "4.2.0") >= 0)
echo $ivo . "" . $sc; else {
echo $ivf . "(4.2.0 or higher required)" . $sc;
$fatal = true;
}
echo "</td></tr>";

echo "<tr><td class=maintext>Checking System Information... " . $ivo . PHP_OS . $sc . "</td></tr>";

echo "<tr><td class=maintext>Checking PHP Server API... " . $ivo . php_sapi_name() . $sc . "</td></tr>";

echo "<tr><td class=maintext>Checking Path to 'php.ini'... " . $ivo . PHP_CONFIG_FILE_PATH . $sc . "</td></tr>";
$mysqlsupport = true;
if (!function_exists('mysql_connect')) {


$mysqlsupport = false;
}

echo "<tr><td class=maintext>Checking Mysql support... ";

echo $ivo . (( $mysqlsupport) ? "On" : " $ivf This program requires MYSQL support. Please recompile your PHP with MYSQL Support.") . $sc;
echo "</td></tr>";
echo "<tr><td class=maintext>Checking safe_mode... ";
$val1 = ini_get("safe_mode");
echo ((!empty($val1) || $val1 == 1) ? $ivf . "On-Please turn off safe_mode in the php.ini" : $ivo . "Off") . $sc;
echo "</td></tr>";
//Short Open Tags Commented out for php5.4,php5.5
/*echo "<tr><td class=maintext>Checking short_tags... ";
 $val2 = ini_get("short_open_tag");
 echo ((!empty($val2) || $val2 == 1) ? $ivo . "On" : $ivf . "Off-Please turn on short_tags in the php.ini") . $sc;
 echo "</td></tr>";*/
echo "<tr><td class=maintext>Checking file_uploads...";
$val3 = ini_get("file_uploads");
echo ((!empty($val3) || $val3 == 1) ? $ivo . "On" : $ivf . "Off - Please turn on file_uplaods in the php.ini file") . $sc;
echo "</td></tr>";

if ((!empty($val1) || $val1 == 1) or (empty($val3) || $val3 != 1) or !$gdv) {
echo "<tr><td class=maintext>" . $ivf . "Fatal errors detected.  Please correct the above red items and reload.</td></tr>";
}
?>



	</td>

	</tr>

</table>
</td>
</tr>
<?php
} else if (!$installed) {
?>
<tr>
	<td align="center"><b><font size="1">
	<div align="justify"><br>
	<font color="#F4700E" size="+1">Thank you for choosing <?php echo $productname ?>&nbsp;3.4</font>
	<br>
	<br>
	<?php   
	$error == false;
	$serverPermission = "false";
	$directories = array(
                                'includes/config.php',
                                'images',
                                'products',
                                'portfolios',
                                'products/bulk_images',
                                'products/zip',
                                'csv',
                                'pem',
                                'banners',
                                'digital_product',
                                'categories/avatar',
                                'categories',
                                'homepagebanners',
                                'dbbackups',
                                'language',
                                'sellerbanners',
                                'combo',
                                'combo/avatar',
                                'ckeditor/ckfinder/core/connector/php/uploads',
                                'sellerbanners',
                                'sections',
                                'sections/avatar',            
                                '.htaccess'
                                );
                                foreach ($directories as $dir) {
                                $permission = fileWritable("../" . $dir);

                                if (!$permission['status'] && $error == false) {
                                $error = true;
                                $serverPermission = "true";
                                }
                                }

                                if ($serverPermission == "true") {
                                ?> <font color="#000000"><img
		src="../images/dot.jpg">&nbsp;In order to complete this install please
	fill out the details requested below. <br>
	<br>
	<img src="../images/dot.jpg">&nbsp;Please note the following points
	before you continue:<br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod) of 'includes/config.php' to 777. <br>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(After
	installation dont forget to change it back to 644)<br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'products' to 777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'portfolios' to 777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'products/bulk_images'
	to 777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'products/zip' to 777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'csv' to 777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'pem' to 777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'banners' to 777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'digital_product' to
	777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'categories/avatar' to
	777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'categories' to 777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'homepagebanners' to
	777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'dbbackups' to 777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'language' to 777. <br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'sellerbanners' to 777.
        <br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'sections' to 777.
        <br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'sections/avatar' to 777.
        <br>	
        &nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'ckeditor/ckfinder/core/connector/php/uploads' to 777.
	<br>
        &nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'combo' to 777.
        <br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Change
	the permission (chmod 777 for linux server) of 'combo/avatar' to 777.
	<br>
	<div id="htaccessDiv" style="display: none">&nbsp;&nbsp;&nbsp;&nbsp;<img
		src="../images/install_steps.jpg"> Change the permission (chmod 777
	for linux server) of '.htaccess' to 777. <br>
	<br>

	</div>
	<!--
                                                                            Multicart 2.1 Upgradation ends
                                            --> &nbsp;&nbsp;&nbsp;&nbsp;<img
		src="../images/install_steps.jpg"> The database you install into
	should already exist.<br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> Provide
	a database prefix to distinguish the Multicart Shopping Cart tables
	from other tables or <br>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if you have some
	similar tables.<br>
	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;<img src="../images/install_steps.jpg"> After
	the install process delete the 'install' folder and its contents.</font>
	<!-- &nbsp;&nbsp;&nbsp;&nbsp;5. All tables (prefixed with the database prefix if any) will be overwritten) -->
	<?php
                                } else if (($serverPermission == "fasle")) {
                                ?> <font color="#000000"><img
		src="../images/dot.jpg">&nbsp;File Permission ok.</font> <?php } ?></div>

	</font></b></td>
</tr>
<tr>
	<td align=center class="message">
	<div align="left" class="text_information"><?php echo  $message; ?></div>
	</td>
</tr>
<tr>
	<td align=center class=maintext><br>
	<form name="frmInstall" method="post"
		action="<?php echo  $_SERVER["PHP_SELF"]; ?>"
		enctype="multipart/form-data" onSubmit="return checkInstallForm();">
	<FIELDSET><LEGEND class='block_class'>License Key</LEGEND>
	<table width=95% border=0 cellpadding="2" cellspacing="2"
		class=maintext>
		<tr>
			<td colspan="2" class=maintext>License Key</td>
			<td width="42%" align=left><input name="txtLicenseKey"
				id="txtLicenseKey" type="text" class="textbox" size="50"
				maxlength="40" value="<?php echo htmlentities($txtLicenseKey); ?>"
				
				> <img src="css/Help.png" width="20" height="20" title="The script would function only for the domain it is licensed. If you cannot recall the license, its also included in the email you received with subject: 'iScripts.com software download link'. You can also get the license key from your user panel at www.iscripts.com"></td>
			<td width="26%" class="maintext">
			<div id="bubble_tooltiplicensekey">
			<div class="bubble_top"><span>&nbsp;</span></div>
			<div class="bubble_middle"><span
				id="bubble_tooltip_contentlicensekey">&nbsp;</span></div>
			<div class="bubble_bottom"></div>
			
			</td>
		</tr>
	</table>
	</FIELDSET>
	<br>
	<FIELDSET><LEGEND class='block_class'>Database Details</LEGEND>
	<table width=95% border=0 cellpadding="2" cellspacing="2">
		<tr>
			<td width="32%" class=maintext>Database Server Hostname</td>
			<td align=left colspan="2"><input name="txtDBServerName"
				id="txtDBServerName" type="text" maxlength="100"
				value="<?php echo  htmlentities($txtDBServerName); ?>" size="50"> <img src="css/Help.png" width="20" height="20" title="Database server name,eg:localhost"></td>
		</tr>
		<tr>
			<td class=maintext>Database Name</td>
			<td align=left colspan="2"><input name="txtDBName" id="txtDBName"
				type="text" class="textbox" maxlength="100" size="50"
				value="<?php echo  htmlentities($txtDBName); ?>"> <img src="css/Help.png" width="20" height="20" title="Name of your Mysql Database"></td>
		</tr>
		<tr>
			<td class=maintext>Database User Name</td>
			<td align=left colspan="2"><input name="txtDBUserName"
				id="txtDBUserName" type="text" maxlength="100" size="50"
				value="<?php echo  htmlentities($txtDBUserName); ?>"> <img src="css/Help.png" width="20" height="20" title="Mysql Username"></td>
		</tr>
		<tr>
			<td class=maintext>Database Password</td>
			<td align=left colspan="2"><input name="txtDBPassword"
				id="txtDBPassword" type="password" maxlength="100" size="50"
				value="<?php echo htmlentities($txtDBPassword); ?>"> <img src="css/Help.png" width="20" height="20" title="Mysql Password"></td>
		</tr>
		<!-- <tr>
			<td class=maintext>Table Prefix</td>
			<td width="43%" align=left><input name="txtDBPrefix" id="txtDBPrefix"
				type="text" maxlength="100" size="50"
				value="<?php echo  htmlentities($tableprefix); ?>"
				onFocus="showToolTip(event, 'Some hosts allow only a certain DB name per site. Use table prefix in this case for distinct iScripts MultiCart. eg: mul_', 'tblprefix', 'txtDBPrefix');"
				onBlur="hideToolTip('tblprefix')"></td>
			<td width="25%" class="maintext">
			<div id="bubble_tooltiptblprefix">
			<div class="bubble_top"><span>&nbsp;</span></div>
			<div class="bubble_middle"><span id="bubble_tooltip_contenttblprefix">&nbsp;</span></div>
			<div class="bubble_bottom"></div>
			
			</td>
		</tr> -->
	</table>
	</FIELDSET>
	<br>
	<FIELDSET><LEGEND class='block_class'>Site Details</LEGEND>
	<table width=95% border=0 cellpadding="2" cellspacing="2"
		class=maintext>
		<tr>
			<td colspan="2" class=maintext>Site Name</td>
			<td width="68%" align=left><input name="txtSiteName" id="txtSiteName"
				type="text" maxlength="100" size="50"
				value="<?php echo htmlentities($txtSiteName); ?>"> <input
				name="txtSiteURL" id="txtSiteURL" type="hidden" maxlength="100"
				value="<?php echo  htmlentities($txtSiteURL); ?>" readonly> <img src="css/Help.png" width="20" height="20" title="Official Sitename"></td>
		</tr>

	</table>
	</FIELDSET>
	<!-- <br>
	<FIELDSET><LEGEND class='block_class'>Display & Image Settings</LEGEND>
	<table width=95% border=0 cellpadding="2" cellspacing="2"
		class=maintext>
		<tr>
			<td colspan="2" class=maintext>Site Logo</td>
			<td width="68%" align=left><input type="file" name="userfile[]"
				size="50">&nbsp;Suitable Size (203X 105)</td>
		</tr>

	</table>
	</FIELDSET> -->
	<br>

	<FIELDSET><LEGEND class="block_class">Administration Details</font></LEGEND>
	<table width=95% border=0 cellpadding="2" cellspacing="2"
		class=maintext>
		<!-- <tr>
			<td colspan="2" class=maintext>Admin Login Name</td>
			<td width="68%" align=left><input name="txtAdminName"
				id="txtAdminName" type="text" maxlength="100" size="50"
				value="<?php echo  htmlentities($txtAdminName); ?>"></td>
		</tr>
		<tr>
			<td colspan="2" class=maintext>Admin Password</td>
			<td align=left><input name="txtAdminPassword" id="txtAdminPassword"
				type="password" maxlength="100" size="50" value=""></td>
		</tr>
		<tr>
			<td colspan="2" class=maintext>Confirm Admin Password</td>
			<td align=left><input name="txtConfirmAdminPassword"
				id="txtConfirmAdminPassword" type="password" maxlength="100"
				size="50" value=""></td>
		</tr> -->
		<tr>
			<td colspan="2" class=maintext>Admin Email</td>
			<td align=left width="68%"><input name="txtAdminEmail" id="txtAdminEmail"
				type="text" maxlength="100" size="50"
				value="<?php echo htmlentities($txtAdminEmail); ?>"> <img src="css/Help.png" width="20" height="20" title="Email of Site Admin"></td>
		</tr>
		<!-- <tr>
			<td colspan="2" class=maintext>Admin Currency</td>
			<td align=left><select name="txtCurrency">
				<option value="USD"
				<?php
				if ($_POST['txtCurrency'] == 'USD') {
				echo "selected";
				}
				?>>US Dollar</option>
				<option value="AUD"
				<?php
				if ($_POST['txtCurrency'] == 'AUD') {
				echo "selected";
				}
				?>>Australian Dollar</option>
				<option value="EUR"
				<?php
				if ($_POST['txtCurrency'] == 'EUR') {
				echo "selected";
				}
				?>>Euro</option>
				<option value="GBP"
				<?php
				if ($_POST['txtCurrency'] == 'GBP') {
				echo "selected";
				}
				?>>GB Pound</option>
			</select></td>
		</tr> -->
	</table>
	</FIELDSET>
	<br>
	<!-- <FIELDSET><LEGEND class="block_class">Seller Store</font></LEGEND>
	<table width="95%" border="0" cellpadding="2" cellspacing="2">
		<tr>
			<td colspan="2">Enable Friendly Url</td>
			<td width="10%" align="left"><input name="sellerFriendly"
				id="sellerFriendly" type="checkbox" value="Y"
				onClick="DisplayHtAccessDiv();"
				<?php
				if ($_POST['sellerFriendly'] == 'Y') {
				echo "checked";
				}
				?>></td>
			<td width="65%">
			<div id="htaccessDivMsg" style="display: none">
			<table cellpadding="0" cellspacing="0" width="100%">
				<tr>
					<td><img src="../images/htaccess_msg.jpg"> Change the permission
					(chmod) of '.htaccess' to 777. <br>
					<br>


					</td>
				</tr>
			</table>
			</div>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="required">&nbsp;</td>
			<td align="left" colspan="2"><span class="required">*</span> Friendly
			url will not work in IIS Server,So enable the <br>
			&nbsp;&nbsp;&nbsp;friendly url only if your webserver is other than
			IIS Server.<br>
			<br>
			&nbsp;&nbsp;&nbsp;eg:-&nbsp;<?php echo $txtSiteURL ?>/store/[seller
			name]</td>
		</tr>

	</table>
	</FIELDSET> -->


	<table width=95% border=0 cellpadding="2" cellspacing="2"
		class=maintext>
		<tr>
			<td>&nbsp;</td>
		</tr>
		<tr>
			<td align="center"><input type="submit" name="btnContinue"
				value="Continue" class="button"></td>
		</tr>
	</table>
	</form>



	<?php
} else {
?> <br>


<tr>
	<td align="center" class="maintext"><font color="#F4700E" size="+1">Congratulations!
	The Installation Process is completed successfully!</font></td>
</tr>
<br>
<br>
<br>
<tr>
	<td align="left"><span class="required">*</span><b> All Payment
	Gateways are disabled by default,Please enable atleast one payment
	gateway.</b></td>
</tr>

<br>
<br>
<tr>
	<td align="left"><span class="required">*</span><b> To ensure complete
	security, now you should remove the 'install' directory.</b></td>
</tr>
<br>
<br>
<?php
if ($serverPermission == "true") {
?>
<tr>
	<td align="left"><span class="required">*</span><b> Change the
	permission of 'includes/config.php' to 644</b></td>
</tr>
<?php
if ($sellerFriendly == "Y") {
?> <br>
<tr>
	<td align="left"><span class="required">*</span><b> Change the
	permission of '.htaccess' to 644</b></td>
</tr>

<?php
}
}
?>
<tr>
	<td>&nbsp;</td>
</tr>
<br>
<br>

<?php
$request_uri = explode('/', $_SERVER['REQUEST_URI']);
$script_filename = explode('/', $_SERVER['SCRIPT_FILENAME']);
$build_path = "http://" . $_SERVER['HTTP_HOST'] . "/" . $request_uri[1] . "/admin/login.php";
$build_path_home = "http://" . $_SERVER['HTTP_HOST'] . "/" . $request_uri[1] . "/index.php";
?>

<tr>
	<td>
	<fieldset><legend class="block_class">Site Login Details</font></legend>
	<table cellpadding="0" cellspacing="0" width="100%">
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td width="15%"><b><font size="-1">Admin URL&nbsp;:</font></b></td>
			<td width="85%"><a style="cursor: pointer" href="../admin/index.php"><?php echo $txtSiteURL . "/admin/index.php" ?><img
				src="<?php echo $txtSiteURL ?>/images/admin_login_install.jpg" border="0" height="25"></a></td>
		</tr>

		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td width="15%"><b><font size="-1">Home URL&nbsp;:</font></b></td>
			<td width="85%"><a style="cursor: pointer" href="../index.php"><?php echo $txtSiteURL . "/index.php" ?><img
				src="<?php echo $txtSiteURL ?>/images/home_page.jpg" border="0" height="25"></a></td>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td width="15%"><b><font size="-1">Admin Username&nbsp;:</font></b></td>
			<td width="85%"><font size="-1"><?php echo $txtAdminName ; ?></font></b></td>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td width="15%"><b><font size="-1">Admin Password&nbsp;:</font></b></td>
			<td width="85%"><b><font size="-1"><?php echo $txtAdminPassword ; ?></font></b></td>
		</tr>
	</table>
	</fieldset>
	</td>
</tr>



<?php
}
?>
</table>




</div>


<div align="left" class="float_clear1"></div>


<!--items display area end --></div>


<!--center content area end-->


<div align="left" class="float_clear"><img src="../images/clear.gif"
	alt="" width="1" height="1" /></div>
<!--mainbody area end --></div>
<div align="left" class="float_clear"><img src="../images/clear.gif"
	alt="" width="1" height="1" /></div>


<div class="clear"></div>
</div>
<!-- content Area Right End -->


<div class="clear"></div>
</div>

<!-- Content Area End --> <!-- Footer Section Start -->
<div id="footersection">



<div class="copyrightsectins">
<div class="coprigght_left">
<p>Powered by <a rel="nofollow" href="http://www.iscripts.com/multicart/"
	target="_blank">iScripts Multicart</a> &nbsp; A Premium Product from <a rel="nofollow"
	href="http://www.iscripts.com/" target="_blank">iScripts.com</a> <br>
</p>

<div class="clear"></div>
</div>


<div class="coprigght_right">
<div class="copyright_txtright">Copyright@iScripts.com | All rights
Reserved
<div class="footer_links"></div>
</div>

</div>

</div>

<div style="width: 100%; background-color: #FFFFFF; height: 100px;">

<div
	style="width: 100%; height: 50px; margin: 0px auto; padding: 25px 0 0 0; text-align: center">









<div class="clear"></div>
</div>

<div class="clear"></div>
</div>





<div class="clear"></div>
</div>
<!-- Footer Section End -->



<div class="clear"></div>
</div>

</body>
</html>

                            
                            
                            
