INSERT INTO `cms_groups` (`id`, `group_name`, `position`, `published`, `user_privilege`) VALUES
(3, 'Configurations', 6, 1, 's'),
(1, 'General', 1, 1, 'all'),
(4, 'Site Setup', 2, 1, 'all'),
(5, 'Reports', 4, 1, 'all'),
(6, 'Contents', 5, 1, 'all'),
(7, 'Admin Setup', 3, 1, 'all');


INSERT INTO `cms_roles` (`role_id`, `role_name`, `parent_role_id`) VALUES
(1, 'Admin', 0);

INSERT INTO `cms_sections` (`id`, `group_id`, `section_name`, `section_alias`, `table_name`, `section_config`, `visibilty`, `display_order`, `user_privilege`) VALUES
	(1, 3, 'Manage Groups', 'groups', 'cms_groups', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"publishColumn":"published",\r\n"listColumns":["id","group_name","user_privilege"],\r\n"showColumns":["id","group_name","position","user_privilege"],\r\n"detailColumns":["id","group_name","position","user_privilege"],\r\n"detailHeaderColumns":["group_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","searchable":"searchable","editoptions":{"type":"hidden"}},\r\n    "group_name":{"name":"Group Name","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Group Name","class":"textbox"}},\r\n    "position":{"name":"Display Order","sortable":"true","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}},\r\n    "user_privilege":{"name":"Privilege","sortable":"true","searchable":"searchable","editoptions":{"type":"select","source":{"all":"All","s":"Superadmin"},"source_type":"array","label":"Privilege","class":"select","enumvalues":{"all":"All","s":"Superadmin"}}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 2, 'dev'),
	(2, 3, 'Manage Sections', 'sections', 'cms_sections', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"listColumns":["group_id","section_name","section_alias","visibilty","display_order"],\r\n"showColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailHeaderColumns":["section_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "group_id":{"name":"Group ID","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"select","source":"Cms::getAllGroups","source_type":"function","label":"Group Name","class":"select"},"external":"true","externalOptions":{"externalTable":"cms_groups","externalColumn":"id","externalShowColumn":"group_name"}},\r\n    "section_name":{"name":"Section Name","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Name","class":"textbox"}},\r\n    "section_alias":{"name":"Section Alias","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Alias","class":"textbox"}},\r\n    "table_name":{"name":"Table Name","editoptions":{"validations":["required"],"type":"textbox","label":"Table Name","class":"textbox"}},\r\n    "section_config":{"name":"Section Config","editoptions":{"validations":["required"],"type":"textarea","label":"Section Config","class":"textarea"}},\r\n    "visibilty":{"name":"Make Visible","sortable":"true","searchable":"searchable","editoptions":{"type":"checkbox","label":"Make Visible","class":"inline","default":"yes","enumvalues":{"1":"Visible","0":"Invisible"}}},\r\n    "display_order":{"name":"Display Order","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 3, 'dev'),
	(3, 3, 'Manage Settings', 'manage_settings', 'tbl_cms_settings', '{\r\n"keyColumn":"id",\r\n"listColumns":["cms_set_name","cms_set_value"],\r\n"showColumns":["cms_set_name","cms_set_value"],\r\n"detailColumns":["id","cms_set_name","cms_set_value"],\r\n"detailHeaderColumns":["cms_set_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "cms_set_name":{"name":"Name","sortable":"true","searchable":"searchable","editoptions":{"type":"disabled","label":"Name"}},\r\n    "cms_set_value":{"name":"Value","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Value","class":"textbox"}}\r\n},\r\n"opertations":["edit","view"]\r\n}', '1', 1, 'dev'),
	(4, 4, 'Settings', 'settings', 'tbl_lookup', '{"customAction":"true","controller":"cmshelper","method":"settingsdisplay","module":"default"}\r\n', '1', 1, 'all'),
	(5, 4, 'Destinations', 'destination', 'tbl_destination', '{\r\n    "keyColumn": "nDestination_Id",\r\n"breadCrumbColumn":"vDestination_Name",\r\n     "detailHeaderColumnPrefix": "Destination: ",\r\n    "detailHeaderColumns": [\r\n        "vDestination_Name"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nDestination_Id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vDestination_Name",\r\n        "tDestination_Description",\r\n        "vStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nDestination_Id",\r\n        "vDestination_Name",\r\n        "tDestination_Description",\r\n        "file_id",\r\n        "vStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nDestination_Id",\r\n        "vDestination_Name",\r\n        "tDestination_Description",\r\n        "file_id",\r\n        "vStatus"\r\n    ],\r\n    "columns": {\r\n        "nDestination_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vDestination_Name": {\r\n            "name": "Destination",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Destination",\r\n                "class": "textbox"\r\n            },\r\n "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getDestinationPopupUrlDestinationLink"\r\n            }\r\n        },\r\n        "tDestination_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "nDestination_Price": {\r\n            "name": "Starting Price",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Starting price for flash header",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Current Image",\r\n            "editoptions": {\r\n                "type": "file",\r\n                "label": "Current Image",\r\n                "class": "file",\r\n"hint":"Ideal image size 120 x 112"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "vStatus": {\r\n            "name": "Status",\r\n  "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n"listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeDestinationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "relations": {\r\n        "destination_location_tag": {\r\n            "name": "Locations",\r\n            "section": "destination_location_tag",\r\n            "child_table": "tbl_locations",\r\n            "parent_join_column": "nDestination_Id",\r\n            "child_join_column": "nDestination_Id"\r\n        },\r\n        "destination_package_tag": {\r\n            "name": "Packages",\r\n            "section": "destination_package_tag",\r\n            "child_table": "tbl_packages",\r\n            "parent_join_column": "nDestination_Id",\r\n            "child_join_column": "nDestination_Id"\r\n        }\r\n    },\r\n"customActions":{"afterAddRecord":"Cmshelper::moveDestinationImagefiles","afterEditRecord":"Cmshelper::moveDestinationImagefiles"},\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "customdelete",\r\n        "add"\r\n    ],\r\n"customDeleteOperation":"Cmshelper::deleteDestination"\r\n}', '1', 4, 'all'),
	(6, 4, 'Locations', 'location', 'tbl_locations', '{\r\n    "keyColumn": "nLocation_Id",\r\n    "includeJsFiles": [\r\n        "cms_location.js"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nLocation_Id": "DESC"\r\n    },\r\n    "breadCrumbColumn": "vLocation_Name",\r\n    "detailHeaderColumnPrefix": "Location: ",\r\n    "detailHeaderColumns": [\r\n        "vLocation_Name"\r\n    ],\r\n    "listColumns": [\r\n        "vLocation_Name",\r\n        "nDestination_Id",\r\n        "vFeatured",\r\n        "vActive",\r\n        "Promote"\r\n    ],\r\n    "detailColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAddress",\r\n        "vCity",\r\n        "vCountry",\r\n        "vState",\r\n        "vZip",\r\n        "nStartingPrice",\r\n        "vFeatured",\r\n        "vActive",\r\n        "vAmenities",\r\n        "Promote"\r\n    ],\r\n    "showColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAddress",\r\n        "vCity",\r\n        "vCountry",\r\n        "vState",\r\n        "vZip",\r\n        "nStartingPrice",\r\n        "vFeatured",\r\n        "vActive",\r\n        "vAmenities"\r\n    ],\r\n    "columns": {\r\n        "nLocation_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vLocation_Name": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Location",\r\n                "class": "textbox"\r\n            },\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getLocationPopupUrlLocationLink"\r\n            }\r\n        },\r\n        "nDestination_Id": {\r\n            "name": "Destination",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllDestinations",\r\n                "source_type": "function",\r\n                "label": "Destination",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            },\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getDestinationPopupUrlLocationLink"\r\n            }\r\n        },\r\n        "vLocation_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Overview",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vAmenities": {\r\n            "name": "Amenities",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Amenities",\r\n                "class": "textarea",\r\n                "editorType": "ckeditor"\r\n            }\r\n        },\r\n        "vAddress": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textarea",\r\n                "label": "Address",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vCity": {\r\n            "name": "City",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vState": {\r\n            "name": "State",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllStates",\r\n                "source_type": "function",\r\n                "label": "State",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "vZip": {\r\n            "name": "Zip",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCountry": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllCountries",\r\n                "source_type": "function",\r\n                "label": "Country",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "nStartingPrice": {\r\n            "name": "StartingPrice ($)",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "StartingPrice ($)",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        },\r\n        "vFeatured": {\r\n            "name": "Featured",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Featured",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationFeaturedStatus",\r\n                "enumvalues": {\r\n                    "Yes": "Featured",\r\n                    "No": "Not Featured"\r\n                },\r\n                "buttonColors": {\r\n                    "Yes": "green",\r\n                    "No": "red"\r\n                }\r\n            }\r\n        },\r\n        "Promote": {\r\n            "name": "Publish",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::displayPromoteLink"\r\n        }\r\n    },\r\n    "relations": {\r\n        "location_offer_tag": {\r\n            "name": "SpecialOffers",\r\n            "section": "location_offer_tag",\r\n            "child_table": "tbl_special_offers",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        },\r\n        "location_gallery_tag": {\r\n            "name": "Gallery",\r\n            "section": "location_gallery_tag",\r\n            "child_table": "tbl_gallery",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        },\r\n        "location_accomodation_tag1": {\r\n            "name": "Accommodations",\r\n            "section": "location_accomodation_tag1",\r\n            "child_table": "tbl_available_acco_type",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        },\r\n        "location_review_tag": {\r\n            "name": "Reviews",\r\n            "section": "location_review_tag",\r\n            "child_table": "tbl_rating",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::mapLatLong",\r\n        "afterEditRecord": "Cmshelper::mapLatLong"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '1', 5, 'all'),
	(9, 6, 'Help Category', 'help_category', 'tbl_HelpCategory', '{\r\n    "keyColumn": "hcid",\r\n"detailHeaderColumns":["hcid"],\r\n    "orderBy": {\r\n        "hcid": "ASC"\r\n    },\r\n    "listColumns": [\r\n        \r\n        "htype",\r\n        "hctitle",\r\n        "hcposition",\r\n        "active"\r\n    ],\r\n    "showColumns": [\r\n        "hcid",\r\n        "htype",\r\n        "hctitle",\r\n        "hcposition",\r\n        "active"\r\n    ],\r\n    "detailColumns": [\r\n        "hcid",\r\n        "htype",\r\n        "hctitle",\r\n        "hcposition",\r\n        "active"\r\n    ],\r\n    "columns": {\r\n        "hcid": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n               \r\n            }\r\n        },\r\n        "htype": {\r\n            "name": "User Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "admin": "Admin",\r\n                    "client": "Client"\r\n                },\r\n                "source_type": "array",\r\n                "label": "User Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "admin": "Admin",\r\n                    "client": "Client"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hctitle": {\r\n            "name": "Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hcposition": {\r\n            "name": "Sort Order",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Sort Order",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 5, 'all'),
	(7, 6, 'Static Content', 'static_content', 'tbl_content', '{\r\n    "keyColumn": "nContent_Id",\r\n    "detailHeaderColumns": [\r\n        "display_title"\r\n    ],\r\n    "orderBy": {\r\n        "nContent_Id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vLocation",\r\n        "vContent"\r\n    ],\r\n    "showColumns": [\r\n        "nContent_Id",\r\n        "vLocation",\r\n        "vContent"\r\n    ],\r\n    "detailColumns": [\r\n        "nContent_Id",\r\n        "vLocation",\r\n        "vContent"\r\n    ],\r\n    "columns": {\r\n        "nContent_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vLocation": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vContent": {\r\n            "name": "Content",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit",\r\n        "view"\r\n    ]\r\n}', '1', 4, 'all'),
	(8, 1, 'Inquiries', 'enquiries', 'tbl_enquiry', '{\r\n    "keyColumn": "nEnq_Id",\r\n    "orderBy": {\r\n        "dPasted_Date": "DESC"\r\n    },\r\n    "detailHeaderColumns": [\r\n        "nEnq_Id"\r\n    ],\r\n    "listColumns": [\r\n        "vName",\r\n        "dPasted_Date",\r\n        "tComments",\r\n"status"\r\n    ],\r\n    "showColumns": [\r\n        "nEnq_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n"status",\r\n        "dPasted_Date"\r\n    ],\r\n    "detailColumns": [\r\n        "nEnq_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n        "dPasted_Date",\r\n        "tComments",\r\n"status"\r\n    ],\r\n    "columns": {\r\n        "nEnq_Id": {\r\n            "name": "ID",\r\n            "sortable": "true"\r\n        },\r\n"status" :{\r\n"name" :"Status",\r\n"customColumn": "true",\r\n                "customaction": "Cmshelper::getInquiryReplyPopupUrl"\r\n},\r\n        "vName": {\r\n            "name": "Customer",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getInquiryUserPopupUrl"\r\n            }\r\n        },\r\n        "vPhone": {\r\n            "name": "Phone"\r\n        },\r\n        "vEmail": {\r\n            "name": "Email",\r\n            "searchable": "searchable"\r\n        },\r\n        "vAddress": {\r\n            "name": "Address"\r\n        },\r\n        "tComments": {\r\n            "name": "Inquiry"\r\n        },\r\n        "dPasted_Date": {\r\n            "name": "Posted Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "delete"\r\n    ]\r\n}', '1', 4, 'all'),
	(10, 6, 'Help Content', 'help_content', 'tbl_Help', '{\r\n    "keyColumn": "hid",\r\n"detailHeaderColumns":[ "hid"],\r\n    "orderBy": {\r\n        "hid": "ASC"\r\n    },\r\n    "listColumns": [\r\n     \r\n        "hcid",\r\n        "htitle",\r\n        "hdescription",\r\n        "hposition",\r\n        "active"\r\n    ],\r\n    "showColumns": [\r\n         "hid",\r\n        "hcid",\r\n        "htitle",\r\n        "hdescription",\r\n        "hposition",\r\n        "active"\r\n    ],\r\n    "detailColumns": [\r\n        "hid",\r\n        "hcid",\r\n        "htitle",\r\n        "hdescription",\r\n        "hposition",\r\n        "active"\r\n    ],\r\n    "columns": {\r\n        "hid": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n                \r\n            }\r\n        },"hcid": {\r\n           "name": "Category",\r\n           "sortable": "true",\r\n           "searchable": "true",\r\n           "editoptions": {\r\n               "validations": [\r\n                   "required"\r\n               ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllHelpCategories",\r\n                "source_type": "function",\r\n                "label": "Category",\r\n                "class": "select"\r\n           },\r\n           "external": "true",\r\n           "externalOptions": {\r\n               "externalTable": "tbl_HelpCategory",\r\n               "externalColumn": "hcid",\r\n               "externalShowColumn": "hctitle"\r\n           }\r\n       },\r\n        "htitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                \r\n                \r\n                "label": "Title",\r\n                "class": "textbox",\r\n                \r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hdescription": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hposition": {\r\n            "name": "Sort Order",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Sort Order",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 12, 'all'),
	(11, 1, 'Locations', 'destination_location_tag', 'tbl_locations', '{\r\n    "keyColumn": "nLocation_Id",\r\n "includeJsFiles": [\r\n        "cms_location.js"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Location: ",\r\n    "detailHeaderColumns": [\r\n        "vLocation_Name"\r\n    ],\r\n    "reference": {\r\n        "referenceTable": " tbl_destination",\r\n        "referenceColumn": "nDestination_Id",\r\n        "referenceTableForiegnKey": "nDestination_Id"\r\n    },\r\n    "orderBy": {\r\n        "nDestination_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAddress",\r\n        "vActive",\r\n        "vFeatured"\r\n    ],\r\n    "showColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAmenities",\r\n        "vAddress",\r\n        "vCity",\r\n        "vCountry",\r\n        "vState",\r\n "vZip",\r\n          "nStartingPrice",\r\n        "vActive",\r\n        "vFeatured"\r\n    ],\r\n    "detailColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAmenities",\r\n        "vAddress",\r\n        "vCity",\r\n        "vCountry",\r\n        "vState",\r\n       "vZip",\r\n       "nStartingPrice",\r\n        "vActive",\r\n        "vFeatured"\r\n    ],\r\n    "columns": {\r\n        "nLocation_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vLocation_Name": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Location",\r\n                "class": "textbox"\r\n            },\r\n "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getLocationPopupUrlLocationLink"\r\n            }\r\n        },\r\n        "nDestination_Id": {\r\n            "name": "Destination",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            }\r\n        },\r\n        "vLocation_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Overview",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vAmenities": {\r\n            "name": "Amenities",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Amenities",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vAddress": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textarea",\r\n                "label": "Address",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vCity": {\r\n            "name": "City",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vState": {\r\n            "name": "State",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllStates",\r\n                "source_type": "function",\r\n                "label": "State",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "vZip": {\r\n            "name": "Zip",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCountry": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllCountries",\r\n                "source_type": "function",\r\n                "label": "Country",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "nStartingPrice": {\r\n            "name": "Starting Price",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Starting Price",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        },\r\n        "vFeatured": {\r\n            "name": "Featured",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Is Featured",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationFeaturedStatus",\r\n                "enumvalues": {\r\n                    "Yes": "Featured",\r\n                    "No": "Non featured"\r\n                },\r\n                "buttonColors": {\r\n                    "Yes": "green",\r\n                    "No": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(12, 1, 'Feedback', 'feedback', 'tbl_feedbacks', '{\r\n    "keyColumn": "nFeedback_Id",\r\n     "detailHeaderColumnPrefix": "Feedback: ",\r\n\r\n    "detailHeaderColumns": [\r\n        "vName"\r\n    ],\r\n    "orderBy": {\r\n        "dPasted_Date": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vName",\r\n        "vDestination",\r\n        "dPasted_Date",\r\n        "tComments"\r\n    ],\r\n    "showColumns": [\r\n        "nFeedback_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n        "vDestination",\r\n        "dPasted_Date",\r\n        "tComments"\r\n    ],\r\n    "detailColumns": [\r\n        "nFeedback_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n        "vDestination",\r\n        "dPasted_Date",\r\n        "tComments"\r\n    ],\r\n    "columns": {\r\n        "nFeedback_Id": {\r\n            "name": "ID",\r\n            "sortable": "true"\r\n        },\r\n        "vName": {\r\n            "name": "Customer",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getFeedbackUserPopupUrl"\r\n            }\r\n        },\r\n        "vPhone": {\r\n            "name": "Phone"\r\n        },\r\n        "vEmail": {\r\n            "name": "Email",\r\n  "searchable": "true"\r\n        },\r\n        "vAddress": {\r\n            "name": "Address"\r\n        },\r\n        "vDestination": {\r\n            "name": "Destination",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n             "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            }\r\n        },\r\n        "tComments": {\r\n            "name": "Feedback"\r\n        },\r\n        "dPasted_Date": {\r\n            "name": "Posted Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "delete",\r\n        "view"\r\n    ]\r\n}', '1', 4, 'all'),
	(15, 4, 'Accommodation Types', 'accomodation_type', 'tbl_accomodation_types', '{\r\n    "keyColumn": "nAt_Id",\r\n     "detailHeaderColumnPrefix": "Accomodation Type: ",\r\n    "detailHeaderColumns": [\r\n        "vAt_Name"\r\n    ],\r\n    "orderBy": {\r\n        "nAt_Id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vAt_Name",\r\n        "vAt_Description",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nAt_Id",\r\n        "vAt_Name",\r\n        "vAt_Description",\r\n        "vActive"\r\n    ],\r\n    "detailColumns": [\r\n          "nAt_Id",\r\n        "vAt_Name",\r\n        "vAt_Description",\r\n        "vActive"\r\n    ],\r\n    "columns": {\r\n        "nAt_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vAt_Name": {\r\n            "name": "Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Type",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getAccomodationPopupUrl"\r\n            }\r\n        },\r\n        "vAt_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeAccomodationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 5, 'all'),
	(13, 4, 'Packages', 'destination_package_tag', 'tbl_packages', '{\r\n    "keyColumn": "nPackage_Id",\r\n"handleFile" : "true",\r\n   "detailHeaderColumnPrefix": "Package: ",\r\n    "detailHeaderColumns": [\r\n        "vPackage_Title"\r\n    ],\r\n    "reference": {\r\n        "referenceTable": " tbl_destination",\r\n        "referenceColumn": "nDestination_Id",\r\n        "referenceTableForiegnKey": "nDestination_Id"\r\n    },\r\n    "orderBy": {\r\n        "nPackage_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vPackage_Title",\r\n        "vPackage_Description",\r\n        "vSpecial_Offer",\r\n        "nAmount",\r\n        "vFeatured",\r\n        "vPackage_Status"\r\n    ],\r\n    "showColumns": [\r\n        "nPackage_Id",\r\n"nDestination_Id",\r\n        "vPackage_Title",\r\n        "vPackage_Description",\r\n        "vSpecial_Offer",\r\n        "vPackage_photo_below_Description",\r\n        "nAmount",\r\n        "vFeatured",\r\n        "vPackage_Status",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nPackage_Id",\r\n"nDestination_Id",\r\n        "vPackage_Title",\r\n        "vPackage_Description",\r\n        "vSpecial_Offer",\r\n        "vPackage_photo_below_Description",\r\n        "nAmount",\r\n        "vFeatured",\r\n        "vPackage_Status",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nPackage_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n"nDestination_Id":{\r\n"external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "nDestination_Id"\r\n            }\r\n},\r\n        "vPackage_Title": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vSpecial_Offer": {\r\n            "name": "Offer",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Special Offer",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vPackage_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Overview",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vPackage_photo_below_Description": {\r\n            "name": "Description in details page ",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Description in details page",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "nAmount": {\r\n            "name": "Amount ($)",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Amount ($)",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vPackage_Status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            }\r\n        },\r\n        "vFeatured": {\r\n            "name": "Featured",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Featured",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                }\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::updateAliasName",\r\n        "afterEditRecord": "Cmshelper::updateAliasName"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(14, 4, 'Special Offers', 'location_offer_tag', 'tbl_special_offers', '{\r\n    "keyColumn": "nSp_Id",\r\n"handleFile":"true",\r\n   "detailHeaderColumnPrefix": "Special Offer: ",\r\n    "detailHeaderColumns": [\r\n        "vTitle"\r\n    ],\r\n    "handleFile": "true",\r\n    "reference": {\r\n        "referenceTable": "tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "orderBy": {\r\n        "nSp_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vTitle",\r\n        "tDescription",\r\n        "nRate",\r\n        "dStartDate",\r\n        "dEndDate",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nSp_Id",\r\n        "nLocation_Id",\r\n        "vTitle",\r\n        "tDescription",\r\n        "nRate",\r\n        "dStartDate",\r\n        "dEndDate",\r\n        "vActive",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nSp_Id",\r\n        "nLocation_Id",\r\n        "vTitle",\r\n        "tDescription",\r\n        "nRate",\r\n        "dStartDate",\r\n        "dEndDate",\r\n        "vActive",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nSp_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "tDescription": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "nRate": {\r\n            "name": "Discount Price (%)",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Discount Price (%)",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "dStartDate": {\r\n            "name": "Start Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Start Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "m/d/Y"\r\n            }\r\n        },\r\n        "dEndDate": {\r\n            "name": "End Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "End Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "m/d/Y"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint":"Ideal size 200 x 130. Allowed file types are jpeg,jpg,png and gif"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::updateOfferAliasName",\r\n        "afterEditRecord": "Cmshelper::updateOfferAliasName"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(16, 1, 'Customers', 'customers', 'tbl_customers', '{\n    "keyColumn": "nCust_Id",\n    "includeJsFiles": [\n        "cms_location.js"\n    ],\n    "detailHeaderColumnPrefix": "Customer: ",\n    "detailHeaderColumns": [\n        "vFirstname"\n    ],\n    "orderBy": {\n        "nCust_Id": "ASC"\n    },\n    "listColumns": [\n        "vFirstname",\n        "vEmail",\n        "dDatejoin",\n        "vActive"\n    ],\n    "showColumns": [\n        "nCust_Id",\n        "vLogin",\n        "vPassword",\n        "vFirstname",\n        "vLastname",\n        "vEmail",\n        "vAddress1",\n        "vCity",\n        "vCountry",\n        "vState",\n        "vZip",\n        "vTelephone",\n        "dDatejoin",\n        "vActive"\n    ],\n    "detailColumns": [\n        "nCust_Id",\n        "vLogin",\n        "vPassword",\n        "vFirstname",\n        "vLastname",\n        "vEmail",\n        "vAddress1",\n        "vCity",\n        "vCountry",\n        "vState",\n        "vZip",\n        "vTelephone",\n        "dDatejoin",\n        "vActive"\n    ],\n    "columns": {\n        "nCust_Id": {\n            "name": "ID",\n            "sortable": "true",\n            "editoptions": {\n                "type": "hidden"\n            }\n        },\n        "vLogin": {\n            "name": "Login Name",\n            "sortable": "true",\n            "editoptions": {\n                "type": "textbox",\n                "label": "Login Name",\n                "class": "textbox",\n                "validations": [\n                    "required"\n                ]\n            }\n        },\n        "vPassword": {\n            "name": "Password",\n            "editoptions": {\n                "type": "password",\n                "label": "Password",\n                "class": "textbox"\n            }\n        },\n        "vFirstname": {\n            "name": "First Name",\n            "searchable": "true",\n            "sortable": "true",\n            "editoptions": {\n                "type": "textbox",\n                "label": "First Name",\n                "class": "textbox",\n                "validations": [\n                    "required"\n                ]\n            }\n        },\n        "vLastname": {\n            "name": "Last Name",\n            "sortable": "true",\n            "editoptions": {\n                "type": "textbox",\n                "label": "Last Name",\n                "class": "textbox",\n                "validations": [\n                    "required"\n                ]\n            }\n        },\n        "vEmail": {\n            "name": "Email",\n            "sortable": "true",\n            "searchable": "true",\n            "editoptions": {\n                "type": "textbox",\n                "label": "Email",\n                "class": "textbox",\n                "validations": [\n                    "required","email"\n                ]\n            }\n        },\n        "vAddress1": {\n            "name": "Address",\n            "editoptions": {\n                "type": "textarea",\n                "label": "Address",\n                "class": "textarea",\n                "validations": [\n                    "required"\n                ]\n            }\n        },\n        "vCity": {\n            "name": "City",\n            "searchable": "true",\n            "sortable": "true",\n            "editoptions": {\n                "validations": [\n                    "required"\n                ],\n                "type": "textbox",\n                "label": "City",\n                "class": "textbox"\n            }\n        },\n        "vState": {\n            "name": "State",\n            "sortable": "true",\n            "editoptions": {\n                "validations": [\n                    "required"\n                ],\n                "type": "select",\n                "source": "Cmshelper::getAllStates",\n                "source_type": "function",\n                "label": "State",\n                "class": "select"\n            },\n            "external": "true",\n            "externalOptions": {\n                "externalTable": "tbl_state",\n                "externalColumn": "ts_code",\n                "externalShowColumn": "ts_name"\n            }\n        },\n        "vZip": {\n            "name": "Zip",\n            "editoptions": {\n                "type": "textbox",\n                "label": "Zip",\n                "class": "textbox"\n            }\n        },\n        "vCountry": {\n            "name": "Country",\n            "editoptions": {\n                "validations": [\n                    "required"\n                ],\n                "type": "select",\n                "source": "Cmshelper::getAllCountries",\n                "source_type": "function",\n                "label": "Country",\n                "class": "select"\n            },\n            "external": "true",\n            "externalOptions": {\n                "externalTable": "tbl_country",\n                "externalColumn": "tc_code",\n                "externalShowColumn": "tc_name"\n            }\n        },\n        "vTelephone": {\n            "name": "Telephone",\n            "sortable": "true",\n            "editoptions": {\n                "type": "textbox",\n                "label": "Telephone",\n                "class": "textbox"\n            }\n        },\n        "vActive": {\n            "name": "Status",\n            "searchable": "true",\n            "editoptions": {\n                "type": "select",\n                "source": {\n                    "active": "Active",\n                    "inactive": "Inactive"\n                },\n                "source_type": "array",\n                "label": "Status",\n                "class": "select",\n                "enumvalues": {\n                    "active": "Active",\n                    "inactive": "Inactive"\n                },\n                "validations": [\n                    "required"\n                ]\n            },\n            "listoptions": {\n                "type": "button",\n                "customaction": "Cmshelper::changeUserStatus",\n                "enumvalues": {\n                    "active": "Active",\n                    "inactive": "Inactive"\n                },\n                "buttonColors": {\n                    "active": "green",\n                    "inactive": "red"\n                }\n            }\n        },\n        "dDatejoin": {\n            "name": "Registered On",\n            "sortable": "true",\n            "dbFormat": "date",\n            "displayFormat": "m/d/Y"\n        }\n    },\n    "customActions": {\n        "afterAddRecord": "Customer::updateCustomerRegisterTime"\n    },\n    "customOperations": {\n        "login": {\n            "options": {\n                "target": "newtab",\n                "name": "Login",\n                "linkSource": "Cmshelper::getuserLoggedInUrl"\n            }\n        }\n    },\n    "opertations": [\n        "add",\n        "view",\n        "edit",\n        "customdelete"\n    ],\n    "customDeleteOperation": "Cmshelper::deleteCustomer"\n}', '1', 5, 'all'),
	(17, 1, 'Dashboard', 'dashboard', 'tbl_lookup', '{\r\n    "dashboardPanel": "true",\r\n    "listingPanel": "true",\r\n    "listinPanelRow": "2",\r\n    "listingPanel1": {\r\n        "columns": "2",\r\n        "column1": {\r\n            "title": "Inquiries",\r\n            "titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getInquiry",\r\n            "fetchValue": "Cmshelper::fetchRecentEnquiries",\r\n            "listcolumns": {\r\n                "vName": {\r\n                    "name": "Customer"\r\n                },\r\n                "vEmail": {\r\n                    "name": "Email"\r\n                },\r\n                "dPasted_Date": {\r\n                    "name": "Inquired On"\r\n                }\r\n            }\r\n        },\r\n        "column2": {\r\n            "title": "Recent Orders",\r\n"titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getOrders",\r\n            "fetchValue": "Cmshelper::fetchRecentOrders",\r\n            "listcolumns": {\r\n                "vFirstname": {\r\n                    "name": "Customer"\r\n                },\r\n                "nAmount": {\r\n                    "name": "Amount ($)"\r\n                },\r\n                "vStatus": {\r\n                    "name": "Status"\r\n                },\r\n                "dBooking_Date": {\r\n                    "name": "Booked On"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "listingPanel2": {\r\n        "columns": "1",\r\n        "column1": {\r\n            "title": "Cancellations",\r\n"titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getCancelledOrders",\r\n            "fetchValue": "Cmshelper::getCancellations",\r\n            "listcolumns": {\r\n                "vFirstname": {\r\n                    "name": "Customer"\r\n                },\r\n                "nAmount": {\r\n                    "name": "Canceled Amount ($)"\r\n                },\r\n                "vStatus": {\r\n                    "name": "Status"\r\n                },\r\n                "dCancelDate": {\r\n                    "name": "Canceled On"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "graphPanel": "true",\r\n    "graphpanelRow": "1",\r\n    "graphPanel1": {\r\n        "columns": "2",\r\n        "graph1": {\r\n            "type": "MSColumn3D",\r\n            "caption": "Bookings",\r\n            "xAxisName": "",\r\n            "yAxisName": "BookingCount",\r\n            "width": "480",\r\n            "height": "300",\r\n            "dataSetsCount": "1",\r\n            "dataSets": {\r\n                "dataset1": {\r\n                    "name": "",\r\n                    "color": "#D3AC4F",\r\n                    "fetchValue": "Cmshelper::getBookingCount"\r\n                }\r\n            }\r\n        },\r\n        "graph2": {\r\n            "type": "MSLine",\r\n            "caption": "Accommodation Availability",\r\n            "xAxisName": "",\r\n            "yAxisName": "Available Room Count",\r\n            "width": "480",\r\n            "height": "300",\r\n            "dataSetsCount": "1",\r\n            "dataSets": {\r\n                "dataset1": {\r\n                    "name": "",\r\n                    "color": "#D3AC4F",\r\n                    "fetchValue": "Cmshelper::getAvailableRoomCount"\r\n                }\r\n            }\r\n        }\r\n    }\r\n}', '1', 1, 'all'),
	(18, 4, 'Destination Gallery', 'destination_gallery_tag', 'tbl_gallery', '{\r\n    "keyColumn": "nGallery_Id",\r\n    "detailHeaderColumnPrefix": "Gallery: ",\r\n    "detailHeaderColumns": [\r\n        "vTitle"\r\n    ],\r\n    "handleFile": "true",\r\n    "reference": {\r\n        "referenceTable": " tbl_destination",\r\n        "referenceColumn": "nDestination_Id",\r\n        "referenceTableForiegnKey": "nDestination_Id"\r\n    },\r\n    "orderBy": {\r\n        "nGallery_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "showColumns": [\r\n        "nDestination_Id",\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nDestination_Id",\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nGallery_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Thumbnail Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n"hint":"Ideal image size 120 x 112. Allowed file formats are GIF,JPG,PNG."\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nDestination_Id": {\r\n            "name": "Destination",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            }\r\n        }\r\n    },\r\n"customActions":{"afterAddRecord":"Cmshelper::moveDestinationGalleryImagefiles","afterEditRecord":"Cmshelper::moveDestinationGalleryImagefiles"},\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(19, 1, 'Gallery', 'location_gallery_tag', 'tbl_gallery', '{\r\n    "keyColumn": "nGallery_Id",\r\n    "handleFile": "true",\r\n    "detailHeaderColumnPrefix": "Gallery: ",\r\n    "detailHeaderColumns": [\r\n        "vTitle"\r\n    ],\r\n    "reference": {\r\n        "referenceTable": " tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "orderBy": {\r\n        "nGallery_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "showColumns": [\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id",\r\n        "nLocation_Id"\r\n    ],\r\n    "detailColumns": [\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id",\r\n        "nLocation_Id"\r\n    ],\r\n    "columns": {\r\n        "nGallery_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Thumbnail Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n"hint":"Ideal image size 915 x 405. Allowed file formats are GIF,JPG,PNG"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        }\r\n    },\r\n"customActions":{"afterAddRecord":"Cmshelper::moveLocationGalleryImagefiles","afterEditRecord":"Cmshelper::moveLocationGalleryImagefiles"},\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(20, 1, 'Orders', 'booking_orders', 'tbl_booking', '{\r\n    "keyColumn": "nBooking_Id",\r\n    "detailHeaderColumnPrefix": "Order: ",\r\n    "detailHeaderColumns": [\r\n        "OrderId"\r\n    ],\r\n    "dataSource": "external",\r\n    "dataSourceFunction": "Cmshelper::fetchOrderData",\r\n    "dataSourceCountFunction": "Cmshelper::fetchOrderDataCount",\r\n    "orderBy": {\r\n        "dBooking_Date": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "OrderId",\r\n        "nCust_Id",\r\n        "dArrival_Date",\r\n        "checkoutDate",\r\n        "dBooking_Date",\r\n        "nNights_Stay",\r\n        "nAmount",\r\n        "vStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "OrderId",\r\n        "nCust_Id",\r\n        "destination",\r\n        "location",\r\n        "dArrival_Date",\r\n        "checkoutDate",\r\n        "dBooking_Date",\r\n        "vBooking_Details",\r\n        "nNights_Stay",\r\n        "nRooms",\r\n        "nAmount",\r\n        "nReserveModeAmount",\r\n        "nAdults",\r\n        "nChildren",\r\n        "vStatus"\r\n    ],\r\n    "columns": {\r\n        "OrderId": {\r\n            "name": "Order ID",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getOrderId",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getInvoicePopupUrl"\r\n            }\r\n        },\r\n        "nBooking_Id": {\r\n            "name": "ID"\r\n        },\r\n        "nCust_Id": {\r\n            "name": "Customer",           \r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCustomerFromOrder",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getUserPopupUrl"\r\n            }\r\n        },\r\n        "dArrival_Date": {\r\n            "name": "Check In",\r\n            "dbFormat": "datetime",\r\n            "displayFormat": "m/d/Y",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "checkoutDate": {\r\n            "name": "Check Out",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCheckoutDate"\r\n        },\r\n        "dBooking_Date": {\r\n            "name": "Booking Date",\r\n            "dbFormat": "datetime",\r\n            "displayFormat": "m/d/Y",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "vBooking_Details": {\r\n            "name": "Booking Details"\r\n        },\r\n        "nNights_Stay": {\r\n            "name": "Days",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "nRooms": {\r\n            "name": "Rooms"\r\n        },\r\n        "nAmount": {\r\n            "name": "Amount ($)",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "nReserveModeAmount": {\r\n            "name": "Advance Amount ($)"\r\n        },\r\n        "nAdults": {\r\n            "name": "Adults"\r\n        },\r\n        "nChildren": {\r\n            "name": "Children"\r\n        },\r\n        "vStatus": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "sortable": true,\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getOrderStatusChangeLink"\r\n        },\r\n        "destination": {\r\n            "name": "Destination",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::fetchDestinationFromOrder"\r\n        },\r\n        "location": {\r\n            "name": "Location",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::fetchLocationFromOrder"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '1', 2, 'all'),
	(21, 4, 'Reservations', 'reservations', 'tbl_allotment', '{\r\n    "keyColumn": "nAllotment_Id",\r\n    "orderBy": {\r\n        "nAllotment_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "nAllotment_Id",\r\n        "dDate",\r\n        "vStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nAllotment_Id",\r\n        "dDate",\r\n        "vStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nAllotment_Id",\r\n        "dDate",\r\n        "vStatus"\r\n    ],\r\n    "combineTables": {\r\n        "tbl_available_acco_type": {\r\n            "combineColumns": [\r\n                "nAt_Id",\r\n                "nLocation_Id"\r\n            ],\r\n            "combineReferenceColumn": "nAat_Id",\r\n            "combineTableForiegnKey": "nAat_Id",\r\n            "isPrimaryKey": "true",\r\n            "tbl_locations": {\r\n                "combineColumns": [\r\n                    "nDestination_Id",\r\n                    "vLocation_Name"\r\n                ],\r\n                "combineReferenceColumn": "nLocation_Id",\r\n                "combineTableForiegnKey": "nLocation_Id",\r\n                "isPrimaryKey": "true"\r\n            }\r\n        },\r\n        "tbl_booking": {\r\n            "combineColumns": [\r\n                "nCust_Id"\r\n            ],\r\n            "combineReferenceColumn": "nBooking_Id",\r\n            "combineTableForiegnKey": "nBooking_Id",\r\n            "isPrimaryKey": "true",\r\n            "tbl_customers": {\r\n                "combineColumns": [\r\n                    "vFirstname",\r\n                    "vEmail"\r\n                ],\r\n                "combineReferenceColumn": "nCust_Id",\r\n                "combineTableForiegnKey": "nCust_Id",\r\n                "isPrimaryKey": "true"\r\n            }\r\n        }\r\n    },\r\n    "columns": {\r\n        "nAllotment_Id": {\r\n            "name": "ID",\r\n            "searchable": "true",\r\n            "sortable": "true"\r\n        },\r\n        "vLocation_Name": {\r\n            "name": "First Name",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_customers",\r\n                "externalColumn": "nCust_Id",\r\n                "externalShowColumn": "vFirstname"\r\n            }\r\n        },\r\n        "vDestination_Name": {\r\n            "name": "Destination"\r\n        },\r\n        "vAt_Name": {\r\n            "name": "Accomodation Type"\r\n        },\r\n        "dDate": {\r\n            "name": "Booking Details",\r\n            "searchable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "M,j, Y"\r\n        },\r\n        "vFirstname": {\r\n            "name": "Nights Stay",\r\n            "searchable": "true"\r\n        },\r\n        "vEmail": {\r\n            "name": "Amount"\r\n        },\r\n        "vStatus": {\r\n            "name": "Status",\r\n            "searchable": "true"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 0, 'all'),
	(22, 4, 'Accomodation', 'location_accomodation_tag', 'tbl_available_acco_type', '{\r\n    "keyColumn": "nAat_Id",\r\n    "detailHeaderColumns": [\r\n        "nAat_Id"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nAat_Id": "DESC"\r\n    },\r\n    "reference": {\r\n        "referenceTable": " tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "listColumns": [\r\n        "vCode",\r\n        "nAt_Id",\r\n        "nAmount",\r\n        "nRoom",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nAat_Id",\r\n        "nLocation_Id",\r\n        "vCode",\r\n        "nAt_Id",\r\n        "nAdults",\r\n        "nChildren",\r\n        "nAmount",\r\n        "nRoom",\r\n        "file_id",\r\n        "vActive"\r\n    ],\r\n    "detailColumns": [\r\n        "nAat_Id",\r\n        "nLocation_Id",\r\n        "vCode",\r\n        "nAt_Id",\r\n        "nAdults",\r\n        "nChildren",\r\n        "nAmount",\r\n        "nRoom",\r\n        "file_id",\r\n        "vActive"\r\n    ],\r\n    "columns": {\r\n        "nAat_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        },\r\n        "nAt_Id": {\r\n            "name": "Accomodation Type",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllAccomodationTypes",\r\n                "source_type": "function",\r\n                "label": "Accomodation Type",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": " tbl_accomodation_types",\r\n                "externalColumn": "nAt_Id",\r\n                "externalShowColumn": "vAt_Name"\r\n            }\r\n        },\r\n        "vCode": {\r\n            "name": "Code",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Code",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nAdults": {\r\n            "name": "Adults",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Adults",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nChildren": {\r\n            "name": "Children",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Children",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nAmount": {\r\n            "name": "Amount",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Amount",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nRoom": {\r\n            "name": "Room",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Room",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "relations": {\r\n        "accomodation_offer_tag": {\r\n            "name": "Offers",\r\n            "section": "accomodation_offer_tag",\r\n            "child_table": "tbl_offer_price",\r\n            "parent_join_column": "nAat_Id ",\r\n            "child_join_column": "nAat_Id "\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 0, 'all'),
	(23, 4, 'Banners', 'banners', 'tbl_Banners', '{\r\n    "keyColumn": "nBId",\r\n    "detailHeaderColumnPrefix": "Banner: ",\r\n    "detailHeaderColumns": [\r\n        "vName"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nBId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vName",\r\n        "vlocUrl",\r\n        "vLocation",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nBId",\r\n        "vName",\r\n        "vlocUrl",\r\n        "vLocation",\r\n        "vActive",\r\n        "file_id",\r\n        "nDate"\r\n    ],\r\n    "detailColumns": [\r\n        "nBId",\r\n        "vName",\r\n        "vlocUrl",\r\n        "vLocation",\r\n        "vActive",\r\n        "file_id",\r\n        "nDate"\r\n    ],\r\n    "columns": {\r\n        "nBId": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vName": {\r\n            "name": "Name",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vlocUrl": {\r\n            "name": "Target URL",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Target URL",\r\n                "class": "textbox",\n"hint":"Website to be displayed on clicking the image. Eg: www.example.com "\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n"hint":"Ideal size 1366 x 500. Allowed file types are jpg,jpeg,gif and png."\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nDate": {\r\n            "name": "Added Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "vLocation": {\r\n            "name": "Location",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "Home": "Home Page",\r\n                    "Sub": "Sub Page"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Location",\r\n                "class": "select",\r\n                "hint":"Location where the banner shows, either home page or inner pages",\r\n                "enumvalues": {\r\n                    "Home": "Home Page",\r\n                    "Sub": "Sub Page"\r\n                }\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeBannerStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "In active"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "beforeEditRecord": "Cmshelper::unsetDateField",\r\n        "afterAddRecord": "Cmshelper::updateBannerAddedDate"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '1', 2, 'all'),
	(24, 6, 'News', 'news', 'tbl_News', '{\r\n"detailHeaderColumns":[ "nid"],\r\n    "keyColumn": "nid",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nid": "ASC"\r\n    },\r\n    "listColumns": [\r\n        \r\n        "ntitle",\r\n        "ndescription",\r\n        "nposition",\r\n        "exp_date",\r\n        "active"\r\n    ],\r\n    "showColumns": [\r\n        "nid",\r\n        "ntitle",\r\n        "ndescription",\r\n        "nposition",\r\n        "active",\r\n        "exp_date",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nid",\r\n        "ntitle",\r\n        "ndescription",\r\n        "nposition",\r\n        "active",\r\n        "exp_date",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nid": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "ntitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "ndescription": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nposition": {\r\n            "name": "Position",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Position",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "exp_date": {\r\n            "name": "Expiry Date",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Expiry Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "Y-m-d"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint":"Ideal size 1366 x 500. Allowed file types are jpeg,jpg,png and gif"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        }\r\n    },\r\n   \r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::updateNewsDate" ,\r\n "afterEditRecord": "Cmshelper::updateNewsExpireDate"           \r\n    },\r\n\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 2, 'all'),
	(25, 1, 'Payments', 'payments', 'tbl_payment', '{"customAction":"true","controller":"cmshelper","method":"payments","module":"default"}\r\n', '1', 6, 'all'),
	(36, 4, 'Accomodations', 'location_accomodation_tag1', 'tbl_available_acco_type', '{"customAction":"true","controller":"cmshelper","method":"locationbasedaccomodations","module":"default"}\r\n', '0', 0, 'all'),
	(37, 5, 'Sales Report', 'sales_report', 'tbl_payment', '{"customAction":"true","controller":"cmshelper","method":"salesreport","module":"default"}\r\n', '1', 1, 'all'),
	(38, 5, 'Booking Report', 'booking_report', 'tbl_booking', '{"customAction":"true","controller":"cmshelper","method":"bookingreport","module":"default"}\r\n', '1', 2, 'all'),
	(39, 5, 'Customer Report', 'customer_report', 'tbl_customers', '{"customAction":"true","controller":"cmshelper","method":"customerreport","module":"default"}\r\n', '1', 3, 'all'),
	(40, 5, 'Inventory Report', 'inventory_report', 'tbl_allotment', '{"customAction":"true","controller":"cmshelper","method":"inventoryreport","module":"default"}\r\n', '1', 4, 'all'),
	(41, 7, 'Manage Roles', 'manage_roles', 'cms_roles', '{"customCmsAction":"true","controller":"cms","method":"manageroles","module":"cms"}', '1', 2, 'all'),
	(42, 7, 'Manage Privileges ', 'cms_privileges', 'cms_privileges', '{"customCmsAction":"true","controller":"cms","method":"manageprivilege","module":"cms"}\r\n', '1', 2, 'all'),
	(43, 7, 'Manage Admin Users', 'cms_users', 'cms_users', '{"customCmsAction":"true","controller":"cms","method":"manageusers","module":"cms"}', '1', 1, 'all'),
	(44, 1, 'Offline Bookings', 'booking', 'tbl_booking', '{"customAction":"true","controller":"cmshelper","method":"booking","module":"default"}\r\n', '1', 6, 'all'),
	(26, 4, 'Accomodation Offers', 'accomodation_offer_tag', 'tbl_offer_price', '{\r\n    "keyColumn": "offer_price_id",\r\n    "reference": {\r\n        "referenceTable": "tbl_available_acco_type",\r\n        "referenceColumn": "nAat_Id",\r\n        "referenceTableForiegnKey": "nAat_Id"\r\n    },\r\n    "orderBy": {\r\n        "offer_price_id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "offer_price_id",\r\n        "offer_start_date",\r\n        "offer_end_date",\r\n        "price",\r\n        "published",\r\n        "created_on"\r\n    ],\r\n    "showColumns": [\r\n        "offer_price_id",\r\n        "nAat_Id ",\r\n        "offer_start_date",\r\n        "offer_end_date",\r\n        "price",\r\n        "published",\r\n        "created_on"\r\n    ],\r\n    "detailColumns": [\r\n        "offer_price_id",\r\n        "nAat_Id ",\r\n        "offer_start_date ",\r\n        "offer_end_date",\r\n        "price",\r\n        "published",\r\n        "created_on"\r\n    ],\r\n    "columns": {\r\n        "offer_price_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nAat_Id ": {\r\n            "name": "Accomodation Type",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_accomodation_types",\r\n                "externalColumn": "nAat_Id",\r\n                "externalShowColumn": "nAat_Id"\r\n            }\r\n        },\r\n        "price": {\r\n            "name": "Price",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Price",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "offer_start_date": {\r\n            "name": "Offer Start Date",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Offer Start Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "d/m/Y"\r\n            }\r\n        },\r\n        "offer_end_date": {\r\n            "name": "Offer End Date",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Offer End Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "d/m/Y"\r\n            }\r\n        },\r\n        "published": {\r\n            "name": "Published",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Yes",\r\n                    "0": "No"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Published",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Yes",\r\n                    "0": "No"\r\n                }\r\n            }\r\n        },\r\n        "created_on": {\r\n            "name": "Created Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "d/m/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(35, 1, 'Affiliates', 'referrals', 'tbl_affiliates', '{\r\n    "keyColumn": "aff_id",\r\n    "detailHeaderColumnPrefix": "Affiliate: ",\r\n    "detailHeaderColumns": [\r\n        "aff_fname"\r\n    ],\r\n    "orderBy": {\r\n        "aff_id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "aff_fname",\r\n        "aff_email",\r\n        "aff_regdate",\r\n        "amount",\r\n        "settled"\r\n    ],\r\n    "detailColumns": [\r\n        "aff_id",\r\n        "aff_fname",\r\n        "aff_email",\r\n        "aff_regdate",\r\n        "amount",\r\n        "settled"\r\n    ],\r\n    "columns": {\r\n        "aff_id": {\r\n            "name": "ID"\r\n        },\r\n        "aff_fname": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        "aff_email": {\r\n            "name": "Email",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        \r\n        "aff_regdate": {\r\n            "name": "Joining Date",\r\n             "customColumn": "true",\r\n           "customaction": "Utils::getUnixDateFormat"\r\n        },\r\n        "amount": {\r\n            "name": "Amount",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getTotalAffilateAmount",\r\n            "listHeaderPostfix": "($)"\r\n        },\r\n        "settled": {\r\n            "name": "Settled",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getSettledStatus"\r\n        }\r\n        \r\n    },\r\n    "relations": {\r\n        "customer": {\r\n            "name": "Customer Count",\r\n            "section": "affiliate_customers",\r\n            "child_table": "tbl_affiliate_useraction",\r\n            "parent_join_column": "aff_id",\r\n            "child_join_column": "ua_aff_id"\r\n        }\r\n    },\r\n    \r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '1', 9, 'all'),
	(27, 4, 'Reviews', 'location_review_tag', 'tbl_rating', '{\r\n    "keyColumn": "nRatingId",\r\n    "detailHeaderColumns": [\r\n        "nRatingId"\r\n    ],\r\n    "handleFile": "true",\r\n    "reference": {\r\n        "referenceTable": "tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "orderBy": {\r\n        "nRatingId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "nCust_Id",\r\n        "nMarks",\r\n        "vFeedbackTitle",\r\n        "vFeedback",\r\n        "dPosted_Date",\r\n        "vRate_Status",\r\n        "vFeedback_Status"\r\n    ],\r\n    "showColumns": [\r\n        "nRatingId",\r\n        "nCust_Id",\r\n        "nLocation_Id",\r\n        "nMarks",\r\n        "vFeedbackTitle",\r\n        "vFeedback",\r\n        "dPosted_Date",\r\n        "vRate_Status",\r\n        "vFeedback_Status"\r\n    ],\r\n    "detailColumns": [\r\n        "nRatingId",\r\n        "nCust_Id",\r\n        "nLocation_Id",\r\n        "nMarks",\r\n        "vFeedbackTitle",\r\n        "vFeedback",\r\n        "dPosted_Date",\r\n        "vRate_Status",\r\n        "vFeedback_Status"\r\n    ],\r\n    "columns": {\r\n        "nRatingId": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nCust_Id": {\r\n            "name": "Customer",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_customers",\r\n                "externalColumn": "nCust_Id",\r\n                "externalShowColumn": "vFirstname"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        },\r\n        "nMarks": {\r\n            "name": "Marks",\r\n            "sortable": "true"\r\n            \r\n        },\r\n        "vFeedbackTitle": {\r\n            "name": "Title",\r\n            "sortable": "true"\r\n            \r\n        },\r\n        "vFeedback": {\r\n            "name": "Feedback",\r\n            "sortable": "true"\r\n            \r\n        },\r\n        "dPosted_Date": {\r\n            "name": "Posted On",\r\n            "sortable": "true",\r\n            "dbFormat": "datetime",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "vRate_Status": {\r\n            "name": "Rating Status",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Rating Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                }\r\n            }\r\n        },\r\n        "vFeedback_Status": {\r\n            "name": "Feedback Status",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Feedback Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 0, 'all'),
	(28, 6, 'Mail Templates', 'mail_templates', 'tbl_mail_template', '{\r\n    "keyColumn": "id",\r\n    "detailHeaderColumns": [\r\n        "id"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_status"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_body",\r\n        "mail_template_status",\r\n        "created_on"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_body",\r\n        "mail_template_status",\r\n        "created_on "\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "mail_template_name": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "disabled",\r\n                "label": "Template Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_sub": {\r\n            "name": "Subject",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Subject",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_body": {\r\n            "name": "Body",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Body",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_status": {\r\n            "name": "Status",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeMailTemplateStatus",\r\n                "enumvalues": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "buttonColors": {\r\n                    "0": "red",\r\n                    "1": "green"\r\n                }\r\n            }\r\n        },\r\n        "created_on": {\r\n            "name": "Created On",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 1, 'all'),
	(29, 6, 'Meta Tags', 'meta_tags', 'fw_metadata', '{\r\n "keyColumn": "id",\r\n "detailHeaderColumnPrefix": "Meta Tag : ",\r\n    "detailHeaderColumns": [\r\n        "url"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "url",\r\n        "title",\r\n        "keyword"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "title": {\r\n            "name": "Meta Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Meta Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "keyword": {\r\n            "name": "Meta Keywords",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Keywords",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "description": {\r\n            "name": "Meta Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "url": {\r\n            "name": "Page Url",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "label": "Page Url",\r\n                "type": "textbox",\r\n                "class": "textbox",\r\n                "hint":"<b>Url combinations can be : </b><br/><b style=\'color:red\'> /abc/</b> [exact location abc after your domain name] eg : www.domainname.com/abc/ ,<br/> <b style=\'color:red\'>/abc/* </b> [any combination after location abc after your domain name] eg : www.domainname.com/abc/test1,<br/> <b style=\'color:red\'>* </b>[default value] ",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 3, 'all'),
	(30, 1, 'Reserved Rooms', 'reserved_rooms', 'tbl_allotment', '{"customAction":"true","controller":"cmshelper","method":"reservedrooms","module":"default"}\r\n', '1', 8, 'all'),
	(31, 1, 'Blocked Rooms', 'blocked_rooms', 'tbl_allotment', '{"customAction":"true","controller":"cmshelper","method":"blockedrooms","module":"default"}\r\n', '1', 7, 'all'),
	(49, 6, 'Admin Help Listings', 'admin_help_listings', 'tbl_Help', '{"customAction":"true","controller":"cmshelper","method":"adminhelplistings","module":"default"}\r\n', '1', 0, 'all'),
	(33, 4, 'Group Discount', 'group_discount', 'tbl_group_discounts', '{"customAction":"true","controller":"cmshelper","method":"groupdiscount","module":"default"}\r\n', '1', 7, 'all'),
	(48, 1, 'Cancelled Orders', 'cancelled_orders', 'tbl_payments', '{"customAction":"true","controller":"cmshelper","method":"cancelledpayments","module":"default"}\r\n', '1', 3, 'all'),
	(46, 6, 'Admin Help Content', 'admin_help_content', 'tbl_HelpCategory', '{"customAction":"true","controller":"cmshelper","method":"adminhelpcontent","module":"default"}\r\n', '1', 6, 'all'),
	(47, 6, 'Client Help Content', 'client_help_content', 'tbl_HelpCategory', '{"customAction":"true","controller":"cmshelper","method":"clienthelpcontent","module":"default"}\r\n', '1', 7, 'all'),
	(50, 3, 'Layout', 'cms_layout', 'none', '{\r\n    "headerLinks": {\r\n        "helpListing": {\r\n            "title": "Help",\r\n            "linkSource": "Cmshelper::getAdminHelpListingPopupUrl"\r\n        },\r\n        "quickStartGuide": {\r\n            "title": "Quick Start Guide",\r\n            "linkSource": "Cmshelper::getQuickStartGuidePopupUrl",\r\n            "target": "popup"\r\n        }\r\n    }\r\n}', '0', 4, 'all'),
	(51, 1, 'Affiliate Links', 'affiliatelinks', ' tbl_affiliates_links', '{\r\n    "keyColumn": "link_id",\r\n    "detailHeaderColumnPrefix": "Link: ",\r\n    "detailHeaderColumns": [\r\n        "link_name"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "link_id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "link_id",\r\n        "link_name",\r\n        "link_status",\r\n        "link_type",\r\n        "link_title"\r\n    ],\r\n    "showColumns": [\r\n        "link_id",\r\n        "link_name",\r\n        "link_status",\r\n        "link_type",\r\n        "link_image"\r\n    ],\r\n    "detailColumns": [\r\n        "link_id",\r\n        "link_name",\r\n        "link_status",\r\n        "link_type",\r\n        "link_image",\r\n        "link_title"\r\n    ],\r\n    "columns": {\r\n        "link_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "link_title": {\r\n            "name": "Link Image",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getaffiliatelinks"\r\n        },\r\n        "link_name": {\r\n            "name": "Link Name",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Link Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "link_image": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint": "Ideal size 240 x 50"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "link_type": {\r\n            "name": "Location",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "0": "Image Link",\r\n                    "1": "Text Link"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Link Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "0": "Image Link",\r\n                    "1": "Text Link"\r\n                }\r\n            }\r\n        },\r\n        "link_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeAffiliateLinkStatus",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                },\r\n                "buttonColors": {\r\n                    "0": "red",\r\n                    "1": "green"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '1', 10, 'all'),
	(52, 1, 'Affiliate Customers', 'affiliate_customers', 'tbl_affiliate_useraction', '{\r\n    "keyColumn": "ua_id",\r\n    "reference": {\r\n        "referenceTable": " tbl_affiliates",\r\n        "referenceColumn": "ua_aff_id",\r\n        "referenceTableForiegnKey": "aff_id"\r\n    },\r\n    "detailHeaderColumnPrefix": "Customer: ",\r\n    "detailHeaderColumns": [\r\n        "ua_userid"\r\n    ],\r\n    \r\n    "orderBy": {\r\n        "ua_id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "ua_userid",\r\n        "ua_referalcharge",\r\n        "ua_paystatus",\r\n        "ua_date_settled"\r\n    ],\r\n    "detailColumns": [\r\n        "ua_id",\r\n        "ua_userid",\r\n        "ua_referalcharge",\r\n        "ua_paystatus",\r\n        "ua_date_settled"\r\n    ],\r\n    "columns": {\r\n        "ua_id": {\r\n            "name": "ID"\r\n        },\r\n        "ua_userid": {\r\n            "name": "Customer Name",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_customers",\r\n                "externalColumn": "nCust_Id",\r\n                "externalShowColumn": "vFirstname"\r\n            }\r\n        },\r\n        "ua_referalcharge": {\r\n            "name": "Referal Charge"\r\n        },\r\n\r\n        "ua_date_settled": {\r\n            "name": "Settled Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "ua_paystatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "enumvalues": {\r\n                        "1": "Active",\r\n                        "2": "Inactive"\r\n                }\r\n            }\r\n        }\r\n\r\n    },\r\n\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 0, 'all'),
	(56, 4, 'Seasonal_rates', 'location_accomodation_seasonal_rates', 'tbl_available_acco_type', '{"customAction":"true","controller":"cmshelper","method":"locationbasedaccomodationsseasonalrates","module":"default"}\r\n', '0', 0, 'all'),
	(57, 4, 'Currencies', 'currency', 'tbl_currency_master', '{\r\n "keyColumn": "currency_id",\r\n "detailHeaderColumnPrefix": "Currency : ",\r\n    "detailHeaderColumns": [\r\n        "Currency Name"\r\n    ],\r\n    "orderBy": {\r\n        "currency_id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "currency_name",\r\n        "currency_code",\r\n        "currency_symbol",\r\n       "status"\r\n    ],\r\n    "showColumns": [\r\n        "currency_id",\r\n        "currency_name",\r\n        "currency_code",\r\n        "currency_symbol",\r\n        "status"\r\n    ],\r\n    "detailColumns": [\r\n       "currency_id",\r\n        "currency_name",\r\n        "currency_code",\r\n        "currency_symbol",\r\n        "status"\r\n    ],\r\n    "columns": {\r\n        "currency_id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "currency_name": {\r\n            "name": "Currency Name",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Currency Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "currency_code": {\r\n            "name": "Currency Code",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Currency Code",\r\n                "class": "textbox",\r\n                 "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "currency_symbol": {\r\n            "name": "Currency Symbol",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Currency Symbol",\r\n                "class": "textbox",\r\n "hint":"It can be either a currency symbol like $ (dollar) or its numeric code  or its hexadecimal code ",\r\n                 "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "status": {\r\n            "name": "Status",\r\n           \r\n            "editoptions": {\r\n                "label": "Status",\r\n                "type": "select",\r\n                  "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n\r\n               "source_type": "array",\r\n\r\n                "class": "select",\r\n               \r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 6, 'all');


INSERT INTO `cms_users` (`id`, `type`, `username`, `password`, `email`, `role_id`, `status`) VALUES
(9, 'sadmin', 'sadmin', 'c5edac1b8c1d58bad90a246d8f08f53b ', '', 0, 'active'),
(11, 'admin', 'admin', '21232f297a57a5a743894a0e4a801fc3', '', 1, 'active');


INSERT INTO `tbl_affiliates_links` (`link_id`, `link_name`, `link_image`, `link_status`, `link_type`) VALUES
(1, 'Affiliate banner 1', 1, 1, 0);


INSERT INTO `tbl_cms_settings` (`id`, `cms_set_name`, `cms_set_value`, `created_on`) VALUES
(1, 'admin_logo', 'project/themes/default/images/logo.png', '2012-11-26 09:32:20'),
(2, 'admin_copyright', 'Powered by <a href="http://www.iscripts.com/reservelogic/" target="_blank">iScripts ReserveLogic</a> . A premium product from <a href="http://www.iscripts.com" target="_blank">iScripts.com</a>', '2012-12-26 11:53:05'),
(4, 'admin_page_count', '8', '2012-10-03 16:33:33'),
(5, 'site_logo', 'Cmshelper::bindSiteLogo', '2013-01-04 19:34:39');


INSERT INTO `tbl_content` (`nContent_Id`, `vPage`, `vLocation`, `vContent`) VALUES
(1, 'faq', 'Faq', 'Q. Are you a licensed Touring operator?<br>A. Yes, we have been licenced by the Tourist Authority. We have been operating tours and treks since 1988.<br><br>Q. How do I book a tour with you?<br>A. Simply follow the "book now" link on left. This takes you to our on-line form, after completion we will then send confirmation to you and details of your trip. We accept Visa, MasterCard and American Express.<br><br>Q. How long have you been operating Tours?<br>A. Since 1988. We were one of the first companies in the country with qualified guides showing the wonders of the area.<br><br>Q. What is the best time to go?<br>A. Anytime of year is fine. Have a look at our weather pages from the home page for more details about the rainfall and climate in the area.<br><br>Q. What if I have to cancel?<br>A. Please see the booking confirmation email that you receive at the time of booking. We will try to be as flexible as we can with cancellation fees but note that we must cover costs incurred in the event of cancellation.<br><br>'),
(2, 'aboutus', 'About Us', 'This site was created with the focus to provide customers the ease and convenience to book hotels and tour packages to any dream destination online. The website provides a clear insight about several places of interests or tourist attractions along with a list of popular and convenient hotels that you would love to stay in.<br><br>We are committed to providing the best services which will give you a once in a life time journey. Our large number of clients is forever expanding as these adventurers return home with exciting tales of exploration. We specialize in providing unique travel experiences to exciting destinations. You can have wonderful adventures to exotic destinations without the hassles, worries and uncertainties.'),
(3, 'homecenter', 'HomeCenter', 'We are here to help you plan your next fun-filled vacation getaway. As vacation specialists, we help families find that perfect escape and enable them to have many wonderful experiences. We provide discount accommodations at a large number of tourist locations.'),
(4, 'tours', 'Tours', 'Our unbelievably discounted promotional rates are only available due to our relationships with our host vacation ownership resorts.&nbsp; Staytwo.com is associated with numerous properties that are some of the most elite resorts in each respective destination.&nbsp; We simply serve as a marketing agent for these resorts and perform by gifting a target market (read terms and conditions) as a &ldquo;thank you&rdquo; for attending their presentation.<br /><br />At your promotional tour you will be given a personalized tour of some of the nicest accommodations available in your destination.<br /><br />You will also be informed of a new way of vacationing for people who enjoy the luxury of taking vacations.&nbsp; There is no obligation to purchase anything, and you should not feel pressured to do so.<br /><br />All the resort asks is that you leave 90 minutes of your time to attend the presentation.&nbsp; In return, you save money that can be spent on your family&rsquo;s vacation experience.&nbsp; We hope your experience with staytwo.com is one that will motivate you to continue to travel with us and recommend us to your friends and family.<table cellspacing="0" cellpadding="0" width="400" border="0">   <tbody><tr><td bgcolor="#0186b1"><table cellspacing="0" cellpadding="10" width="100%" border="0"><tbody><tr><td class="white" style="text-align: center"><span style="font-size: medium">Promotional Offers are Only Available By Phone</span></td></tr></tbody></table><table cellspacing="0" cellpadding="10" width="100%" border="0"><tbody><tr><td class="whiteCopy" style="text-align: center"><span style="font-size: x-large">Call Now!!!</span></td></tr><tr><td class="whiteCopy" style="text-align: center"><span style="font-size: x-large">1-888-782-9896</span></td></tr></tbody></table><table cellspacing="0" cellpadding="10" width="100%" border="0"><tbody><tr><td class="whiteCopy2"><div style="text-align: center">Offer expires: 6/31/2008.<br />This price is only available by calling our Toll-Free Number. Our vacation specialists are standing by to assist you.</div></td></tr></tbody></table></td></tr></tbody></table>'),
(5, 'contactus', 'Contact Us', 'Toll Free: 001-001-0000<br>Fax: 000-000-0000<br>Email: <a href="mailto:info@armia.com">info@Mysite.com</a><p></p><br><p>Thank you for your interest in our accommodations &amp; destinations! Please feel free to contact us by the information provided or fill out the contact us form. Thank you for your interest!</p>'),
(6, 'packages', 'Package', '<p>You can use our contact us page to get in touch with us. We will give you the best prices.</p>'),
(9, 'hotoffer', 'Hot Offer', '<p>When we release a new numbered version, we will &quot;freeze&quot; the   previous release version, meaning that we will no longer update it with   any code changes, including bug fixes, ensuring it is completely stable. Each   time we introduce a new frozen version in this manner we will retire the   existing frozen version. That is, at any given time there will be only one   frozen version available. Applications requesting numbered versions that have   been retired will automatically receive the current frozen version.</p>'),
(10, 'terms', 'Terms', 'This agreement incorporates the terms and conditions for us to provide services to the User of this website (&quot;the User&quot;) and any person(s) availing services from us through this website shall be deemed to have read, understood and expressly accepted these terms and conditions, which shall govern the desired transaction or provision of such services by us for all purposes, and shall be binding on the User. All rights and liabilities of the User and/or us with respect to any services to be provided by us shall be restricted to the scope of this agreement.<br><br>We reserves the right, in its sole discretion, to terminate the access to any or all our websites and the related services or any portion thereof at any time, without notice.<br><br>ACCEPTANCE OF AGREEMENT:<br>You agree to the terms and conditions outlined in this Terms of Use Agreement (&quot;Agreement&quot;) with respect to our Site. This Agreement constitutes the entire and only agreement between us and you with respect to the Site and supersedes all prior or contemporaneous agreements, representations, warranties and understandings with respect to the Site, the content, products or services provided by or through the Site, and the subject matter of this Agreement. This Agreement may be amended at any time by us from time to time without specific notice to you. The latest Agreement will be posted on the Site, and you must review this Agreement prior to using the Site.');


INSERT INTO `tbl_country` (`tc_id`, `tc_code`, `tc_name`, `tc_status`) VALUES
(1, 'US', 'United States', 'A'),
(2, 'IN', 'India', 'A'),
(3, 'CA', 'Canada', 'A'),
(4, 'AE', 'UAE', 'A'),
(5, 'AF', 'Afghanistan', 'A'),
(6, 'AL', 'Albania', 'A'),
(7, 'DZ', 'Algeria', 'A'),
(8, 'AS', 'AmericanSamoa', 'A'),
(9, 'AD', 'Andorra', 'A'),
(10, 'AO', 'Angola', 'A'),
(11, 'AI', 'Anguilla', 'A'),
(12, 'AQ', 'Antarctica', 'A'),
(13, 'AG', 'AntiguaandBarbuda', 'A'),
(14, 'AR', 'Argentina', 'A'),
(15, 'AM', 'Armenia', 'A'),
(16, 'AW', 'Aruba', 'A'),
(17, 'AU', 'Australia', 'A'),
(18, 'AT', 'Austria', 'A'),
(19, 'AZ', 'Azerbaijan', 'A'),
(20, 'BS', 'Bahama', 'A'),
(21, 'BH', 'Bahrain', 'A'),
(22, 'BD', 'Bangladesh', 'A'),
(23, 'BB', 'Barbados', 'A'),
(24, 'BY', 'Belarus', 'A'),
(25, 'BE', 'Belgium', 'A'),
(26, 'BZ', 'Belize', 'A'),
(27, 'BJ', 'Benin', 'A'),
(28, 'BM', 'Bermuda', 'A'),
(29, 'BT', 'Bhutan', 'A'),
(30, 'BO', 'Bolivia', 'A'),
(31, 'BA', 'BosniaandHerzegovina', 'A'),
(32, 'BW', 'Botswana', 'A'),
(33, 'BV', 'BouvetIsland', 'A'),
(34, 'BR', 'Brazil', 'A'),
(35, 'VG', 'BritishVirginIslands', 'A'),
(36, 'BN', 'BruneiDarussalam', 'A'),
(37, 'BG', 'Bulgaria', 'A'),
(38, 'BF', 'BurkinaFaso', 'A'),
(39, 'BI', 'Burundi', 'A'),
(40, 'KH', 'Cambodia', 'A'),
(41, 'CM', 'Cameroon', 'A'),
(42, 'CV', 'CapeVerde', 'A'),
(43, 'KY', 'CaymanIslands', 'A'),
(44, 'TD', 'Chad', 'A'),
(45, 'CL', 'Chile', 'A'),
(46, 'CN', 'China', 'A'),
(47, 'CX', 'ChristmasIsland', 'A'),
(48, 'CC', 'Cocos(Keeling)Islands', 'A'),
(49, 'CO', 'Colombia', 'A'),
(50, 'KM', 'Comoros', 'A'),
(51, 'CG', 'Congo', 'A'),
(52, 'CK', 'CookIslands', 'A'),
(53, 'CR', 'CostaRica', 'A'),
(54, 'HR', 'Croatia', 'A'),
(55, 'CU', 'Cuba', 'A'),
(56, 'CY', 'Cyprus', 'A'),
(57, 'CZ', 'CzechRepublic', 'A'),
(58, 'DK', 'Denmark', 'A'),
(59, 'DJ', 'Djibouti', 'A'),
(60, 'DM', 'Dominica', 'A'),
(61, 'DO', 'DominicanRepublic', 'A'),
(62, 'TP', 'EastTimor', 'A'),
(63, 'EC', 'Ecuador', 'A'),
(64, 'EG', 'Egypt', 'A'),
(65, 'SV', 'ElSalvador', 'A'),
(66, 'GQ', 'EquatorialGuinea', 'A'),
(67, 'ER', 'Eritrea', 'A'),
(68, 'EE', 'Estonia', 'A'),
(69, 'ET', 'Ethiopia', 'A'),
(70, 'FO', 'FaroeIslands', 'A'),
(71, 'FJ', 'Fiji', 'A'),
(72, 'FI', 'Finland', 'A'),
(73, 'FR', 'France', 'A'),
(74, 'GF', 'FrenchGuiana', 'A'),
(75, 'PF', 'FrenchPolynesia', 'A'),
(76, 'GA', 'Gabon', 'A'),
(77, 'GM', 'Gambia', 'A'),
(78, 'GE', 'Georgia', 'A'),
(79, 'DE', 'Germany', 'A'),
(80, 'GH', ' Ghana', 'A'),
(81, 'GI', 'Gibraltar', 'A'),
(82, 'GR', 'Greece', 'A'),
(83, 'GL', 'Greenland', 'A'),
(84, 'GD', 'Grenada', 'A'),
(85, 'GP', 'Guadeloupe', 'A'),
(86, 'GU', 'Guam', 'A'),
(87, 'GT', 'Guatemala', 'A'),
(88, 'GN', 'Guinea', 'A'),
(89, 'GW', 'Guinea-Bissau', 'A'),
(90, 'GY', 'Guyana', 'A'),
(91, 'HT', 'Haiti', 'A'),
(92, 'HN', 'Honduras', 'A'),
(93, 'HK', 'HongKong', 'A'),
(94, 'HU', 'Hungary', 'A'),
(95, 'IS', 'Iceland', 'A'),
(96, 'ID', 'Indonesia', 'A'),
(97, 'IQ', 'Iraq', 'A'),
(98, 'IE', 'Ireland', 'A'),
(99, 'IR', 'Iran', 'A'),
(100, 'IL', 'Israel', 'A'),
(101, 'IT', 'Italy', 'A'),
(102, 'JM', 'Jamaica', 'A'),
(103, 'JP', 'Japan', 'A'),
(104, 'JO', 'Jordan', 'A'),
(105, 'KZ', 'Kazakhstan', 'A'),
(106, 'KE', 'Kenya', 'A'),
(107, 'KI', 'Kiribati', 'A'),
(108, 'KR', 'Korea', 'A'),
(109, 'KW', 'Kuwait', 'A'),
(110, 'KG', 'Kyrgyzstan', 'A'),
(111, 'LV', 'Latvia', 'A'),
(112, 'LB', 'Lebanon', 'A'),
(113, 'LS', 'Lesotho', 'A'),
(114, 'LR', 'Liberia', 'A'),
(115, 'LY', 'LibyanArabJamahiriya', 'A'),
(116, 'LI', 'Liechtenstein', 'A'),
(117, 'LT', 'Lithuania', 'A'),
(118, 'LU', 'Luxembourg', 'A'),
(119, 'MO', 'Macau', 'A'),
(120, 'MG', 'Madagascar', 'A'),
(121, 'MW', 'Malawi', 'A'),
(122, 'MY', 'Malaysia', 'A'),
(123, 'MV', 'Maldives', 'A'),
(124, 'ML', 'Mali', 'A'),
(125, 'MT', 'Malta', 'A'),
(126, 'MH', 'MarshallIslands', 'A'),
(127, 'MQ', 'Martinique', 'A'),
(128, 'MR', 'Mauritania', 'A'),
(129, 'MU', 'Mauritius', 'A'),
(130, 'YT', 'Mayotte', 'A'),
(131, 'MX', 'Mexico', 'A'),
(132, 'FM', 'Micronesia', 'A'),
(133, 'MC', 'Monaco', 'A'),
(134, 'MN', 'Mongolia', 'A'),
(135, 'MS', 'Monserrat', 'A'),
(136, 'MA', 'Morocco', 'A'),
(137, 'MZ', 'Mozambique', 'A'),
(138, 'MM', 'Myanmar', 'A'),
(139, 'NA', 'Nambia', 'A'),
(140, 'NR', 'Nauru', 'A'),
(141, 'NP', 'Nepal', 'A'),
(142, 'AN', 'NetherlandsAntilles', 'A'),
(143, 'NL', 'Netherlands', 'A'),
(144, 'NC', 'NewCaledonia', 'A'),
(145, 'NZ', 'NewZealand', 'A'),
(146, 'NI', 'Nicaragua', 'A'),
(147, 'NE', 'Niger', 'A'),
(148, 'NG', 'Nigeria', 'A'),
(149, 'NU', 'Niue', 'A'),
(150, 'NF', 'NorfolkIsland', 'A'),
(151, 'MP', 'NorthernMarianaIslands', 'A'),
(152, 'NT', 'NorthwestTerritories', 'A'),
(153, 'NO', 'Norway', 'A'),
(154, 'OM', 'Oman', 'A'),
(155, 'PK', 'Pakistan', 'A'),
(156, 'PW', 'Palau', 'A'),
(157, 'PA', 'Panama', 'A'),
(158, 'PG', 'PapuaNewGuinea', 'A'),
(159, 'PY', 'Paraguay', 'A'),
(160, 'PE', 'Peru', 'A'),
(161, 'PH', 'Philippines', 'A'),
(162, 'PN', 'Pitcairn', 'A'),
(163, 'PL', 'Poland', 'A'),
(164, 'PT', 'Portugal', 'A'),
(165, 'PR', 'PuertoRico', 'A'),
(166, 'QA', 'Qatar', 'A'),
(167, 'RE', 'R&eacute;union', 'A'),
(168, 'RO', 'Romania', 'A'),
(169, 'RU', 'RussianFederation', 'A'),
(170, 'RW', 'Rwanda', 'A'),
(171, 'LC', 'SaintLucia', 'A'),
(172, 'WS', 'Samoa', 'A'),
(173, 'SM', 'SanMarino', 'A'),
(174, 'ST', 'SaoTomeandPrincipe', 'A'),
(175, 'SA', 'SaudiArabia', 'A'),
(176, 'SN', 'Senegal', 'A'),
(177, 'SC', 'Seychelles', 'A'),
(178, 'SL', 'SierraLeone', 'A'),
(179, 'SG', 'Singapore', 'A'),
(180, 'SK', 'Slovakia', 'A'),
(181, 'SI', 'Slovenia', 'A'),
(182, 'SB', 'SolomonIslands', 'A'),
(183, 'SO', 'Somalia', 'A'),
(184, 'ZA', 'SouthAfrica', 'A'),
(185, 'ES', 'Spain', 'A'),
(186, 'LK', 'SriLanka', 'A'),
(187, 'SH', 'St.Helena', 'A'),
(188, 'KN', 'St.KittsandNevis', 'A'),
(189, 'PM', 'St.PierreandMiquelon', 'A'),
(190, 'SD', 'Sudan', 'A'),
(191, 'SR', 'Suriname', 'A'),
(192, 'SZ', 'Swaziland', 'A'),
(193, 'SE', 'Sweden', 'A'),
(194, 'CH', 'Switzerland', 'A'),
(195, 'SY', 'SyrianArabRepublic', 'A'),
(196, 'TW', 'Taiwan', 'A'),
(197, 'TJ', 'Tajikistan', 'A'),
(198, 'TZ', 'Tanzania', 'A'),
(199, 'TH', 'Thailand', 'A'),
(200, 'TG', 'Togo', 'A'),
(201, 'TK', 'Tokelau', 'A'),
(202, 'TO', 'Tonga', 'A'),
(203, 'TT', 'TrinidadandTobago', 'A'),
(204, 'TN', 'Tunisia', 'A'),
(205, 'TR', 'Turkey', 'A'),
(206, 'TM', 'Turkmenistan', 'A'),
(207, 'TC', 'TurksandCaicosIslands', 'A'),
(208, 'TV', 'Tuvalu', 'A'),
(209, 'UG', 'Uganda', 'A'),
(210, 'UA', 'Ukraine', 'A'),
(211, 'GB', 'UK', 'A'),
(212, 'UY', 'Uruguay', 'A'),
(213, 'UZ', 'Uzbekistan', 'A'),
(214, 'VU', 'Vanuatu', 'A'),
(215, 'VE', 'Venezuela', 'A'),
(216, 'VN', 'VietNam', 'A'),
(217, 'EH', 'WesternSahara', 'A'),
(218, 'YE', 'Yemen', 'A'),
(219, 'YU', 'Yugoslavia', 'A'),
(220, 'ZR', 'Zaire', 'A'),
(221, 'ZM', 'Zambia', 'A'),
(222, 'ZW', 'Zimbabwe', 'A');


INSERT INTO `tbl_files` (`file_id`, `file_orig_name`, `file_extension`, `file_mime_type`, `file_type`, `file_width`, `file_height`, `file_play_time`, `file_size`, `file_path`, `file_status`, `file_title`, `file_caption`, `file_tmp_name`, `created_on`, `created_by`) VALUES
(1, 'affiliate_banner1.jpg', 'jpg', 'image/jpeg', '', 240, 50, 0, 16184, 'mg3tgymk4b7.jpg', NULL, NULL, NULL, NULL, NULL, 0),
(2, 'menvfwkyps0.jpg', 'jpg', 'image/jpeg', '', 1366, 500, 0, 643786, 'mfofodwd7yh.jpg', NULL, NULL, NULL, NULL, NULL, 0);

INSERT INTO `tbl_Help` (`hid`, `hcid`, `htitle`, `hdescription`, `hposition`, `active`, `himage`, `file_id`) VALUES
(2, 1, 'Content Management', 'The following contents of the site could be edited from this locationrnrnA) Home - The contents of the Home page could be edited from here.rnrnB) Flash Header - The contents of the header flash display could be edited from here.rnrnC) About Us - The contents of the About Us page could be edited from here.rnrnD) Contact Us - The contents of the Contact Us page could be edited from here.rnrnE) Terms and Conditions - The contents of the Terms &amp; Conditions page could be edited from here.rnrnF) FAQ - The contents of the FAQ page could be edited from here.rnrnG) Hot Offers - The contents of the Hot Offers box on Home page could be edited from here.rn', 2, '1', '1244696030_selfnotes.gif', 0),
(3, 1, 'Accommodation Types', 'The accommodation type supported by your operation could be added from here. This could be a Cottage, a Suite, Double Room, Single Room, Bed, Apartment etc depending on the service you would like to provide', 3, '1', '1244696021_other.gif', 0),
(4, 3, 'Bookings', 'This would list all the booking  that are awaiting approval/actions.', 16, '1', '1244695863_other.gif', 0),
(5, 1, 'Countries', 'The countries you would like to provide service could be set from here.', 5, '1', '1244696009_other.gif', 0),
(6, 1, 'States', 'The states of the countries you would like to provide service could be set from here.', 6, '1', '1244695999_other.gif', 0),
(7, 1, 'Help', 'All the help content of the site could be edited from this area.', 7, '1', '1244695985_help.jpg', 0),
(8, 2, 'Destinations', 'Destination could be added from this screen. A destination could be a particular tourist place like Miami or Paris.', 8, '1', '1244695974_other.gif', 0),
(9, 2, 'Locations', 'Location could be added from this screen. A Location could be a particular resort or hotel or motel at a particular Destination.', 9, '1', '1244695966_other.gif', 0),
(10, 2, 'Destination/Location Gallery', 'A set of images for a particular Destination or a Location could be added from here. These images could be viewed as a slide show at the user side.', 10, '1', '1244695957_imagegallery.gif', 0),
(11, 2, 'Accom. Type Availability', 'Here you could set which accommodation types are available at a particular location. For example a you could set if a "Suite"  or "Double Room " is available at a location like "Holiday Inn" or "Park Hotels"', 11, '1', '1244695941_other.gif', 0),
(12, 2, 'Packages', 'If you wish to provide some package to your customers for a promotion or so you could set the content from this page.', 12, '1', '1244695932_other.gif', 0),
(13, 2, 'Banners', 'You can set banners to be displayed on the site from here. You have options to set banners that you upload or openX banner zones. Both main page as well as sub page banners could be uploaded from here.', 13, '1', '1244695923_other.gif', 0),
(14, 3, 'Blocked Rooms', 'You could block a particular room at a particular location if you would like nobody to book them on a particular day. This would be helpful during maintenance.', 14, '1', '1244695899_other.gif', 0),
(15, 3, 'Reservations', 'This would list all the reservations that were done in the past.', 15, '1', '1244695882_other.gif', 0),
(16, 3, 'Customers', 'This would list all the customers who are registered with the system.', 17, '1', '1244695847_user.gif', 0),
(17, 3, 'Referrals', 'This would list all the referrals that have earned a commission on the site.', 18, '1', '1244695787_Manage referral.jpg', 0),
(18, 3, 'Payments', 'This would list all the payments that were received in the past.', 19, '1', '1244695774_Manage-Payments.jpg', 0),
(19, 3, 'Enquiries', 'This would list all the Enquiries that were received in the past.', 20, '1', '1244695712_article.gif', 0),
(20, 3, 'Feedbacks', 'This would list all the feedbacks that were received in the past.', 21, '1', '1244695703_Feedbacks.jpg', 0),
(21, 3, 'News', 'You could add news items to the site through this screen.', 22, '1', '1244695694_classified.gif', 0),
(22, 4, 'About Us', 'The information of the site owners could be read here.', 23, '1', '1244695303_selfnotes.gif', 0),
(23, 4, 'Contact Us', 'The information on how to contact site owners could be read here.', 24, '1', '1244695293_selfnotes.gif', 0),
(24, 4, ' Packages', 'The information on various packages provided by the site could be read here.', 25, '1', '1244695174_blogs.gif', 0),
(25, 4, 'FAQ''s', 'The answers to commonly asked questions by site visitors could be read here.', 26, '1', '1244695154_faq.gif', 0),
(26, 4, 'News', 'Any news posted by the site could be read here.', 27, '1', '1244695143_classified.gif', 0),
(27, 4, 'Hot Offers', 'The information on currently running hot offers could be read here.', 28, '1', '1244694856_features.jpg', 0),
(28, 4, 'Help', 'All help topics could be read here.', 29, '1', '1244694842_help.jpg', 0),
(29, 6, 'Edit Profile', 'You can edit your personal profile from here.This feature requires you to be logged in to the system.', 30, '1', '1244695507_editprofile.gif', 0),
(30, 6, 'My Orders', 'You can see the number of successful referral you have done so far. This feature requires you to be logged in to the system.', 31, '1', '1244695499_blogs.gif', 0),
(31, 6, 'Change Password', 'You can change your password from here.This feature requires you to be logged in to the system.', 32, '1', '1244695451_editprofile.gif', 0),
(32, 6, 'Logout', 'You can log out of the system by clicking here.This feature requires you to be logged in to the system.', 33, '1', '1244695414_clossaccount.gif', 0),
(33, 5, 'Register', 'You can register with site using this screen', 34, '1', '1244695634_register.gif', 0),
(34, 5, 'Enquiry', 'You could enquire about any services using this form.', 35, '1', '1244695625_article.gif', 0),
(35, 5, 'Destinations', 'You could check out all the destinations where accommodations are offered by the site.', 36, '1', '1244695614_other.gif', 0),
(36, 5, 'Booking', 'You can select  a particular destination. This will show you all the locations at that particular destination. A required room could be selected and payments could be made to block the room for the required dates', 37, '1', '1244695603_other.gif', 0),
(37, 1, 'Booking Advance', 'In this section admin can decide booking advance is enable/ disable.  \r\n\r\nIf disabled there is no booking advance   \r\n\r\nIf Amount mode is Percentage, booking advance is percentage of total amount.\r\nIf Amount mode is Amount, that amount is taken as booking advance', 38, '1', '1284458504_selfnotes.gif', 0),
(38, 1, 'Cancellation Mode', 'Admin can enable/disable online cancellation.\r\n\r\nIf no, no online cancellation.\r\n\r\nIf yes, cancellation can be done as per the type of cancellation selection.', 39, '1', '1284458591_selfnotes.gif', 0),
(39, 1, 'Type Of Cancellation', 'Two types of cancellations:\r\n\r\nOne is contact admin, in this case user need to contact admin for cancellation.\r\n\r\nSecond is by paying the penalty', 40, '1', '1284458681_selfnotes.gif', 0),
(40, 1, 'Manage Penality', 'Here admin can add/edit/delete cancellation penalty amount for different days', 41, '1', '1284458722_selfnotes.gif', 0),
(41, 2, 'Special Offers', 'Here admin can add/edit/delete special offers for specific location for the given period.', 42, '1', '1284458804_selfnotes.gif', 0);


INSERT INTO `tbl_HelpCategory` (`hcid`, `htype`, `hctitle`, `hcposition`, `active`) VALUES
(1, 'admin', 'Settings', 1, '1'),
(2, 'admin', 'Configurations', 2, '1'),
(3, 'admin', 'Operations', 3, '1'),
(4, 'client', 'Information', 4, '1'),
(5, 'client', 'Booking', 5, '1'),
(6, 'client', 'Personal', 6, '1');


INSERT INTO `tbl_lookup` (`nLookUp_Id`, `vLookUp_Name`, `vLookUp_Value`, `settinglabel`, `groupLabel`, `type`) VALUES
	(1, 'vadmin_user', 'admin', '', 'General', ''),
	(2, 'vadmin_pass', '21232f297a57a5a743894a0e4a801fc3', '', 'General', ''),
	(3, 'perpage', '2', 'Number of records per page', 'General', ''),
	(5, 'vadmin_email', 'remya.v@armiasystems.com', 'Admin Email', 'General', ''),
	(6, 'cenable_authorize', 'N', 'Enable Authorize.Net  ', 'Payment', 'checkbox'),
	(7, 'vauthorize_loginid', '', 'Authorize.Net Login Id', 'Payment', ''),
	(8, 'vauthorize_transkey', '', 'Authorize.Net Transaction Key', 'Payment', ''),
	(9, 'vauthorize_password', '', 'Authorize.Net Password', 'Payment', ''),
	(10, 'vauthorize_email', '', 'Authorize.Net Email', 'Payment', ''),
	(11, 'vauthorize_test_mode', 'Y', 'Enable Authorize.Net  Test Mode', 'Payment', 'checkbox'),
	(12, 'cenable_paypal', 'N', 'Enable Paypal', 'Payment', 'checkbox'),
	(13, 'vpaypal_test_mode', 'YES', 'Enable Paypal  Test Mode', 'Payment', 'checkbox'),
	(14, 'vpaypalidentitytoken', '', 'Paypal Identity Token', 'Payment', ''),
	(15, 'vpaypalemail', '', 'Paypal Email', 'Payment', ''),
	(16, 'nreferral_comm', '5', 'Referral Compensation', 'Advanced', ''),
	(17, 'vsecure_server', 'https://localhost/reservelogic', 'Secure URL', 'General', ''),
	(18, 'vsite_url', 'http://localhost/reservelogic', 'Site URL', 'General', ''),
	(19, 'vflashheader', 'Hi every body', 'Flash Header', 'Advanced', ''),
	(20, 'vflashfooter', 'Package Included  , Rates Inclusive', 'Flash Footer', 'Advanced', ''),
	(21, 'nflashamount1', '59', 'Flash Amount 1', 'Advanced', ''),
	(22, 'nflashamount2', '00', 'Flash Amount 2', 'Advanced', ''),
	(23, 'sitename', 'iScripts ReserveLogics', 'Site Name', 'General', ''),
	(24, 'sitelogo', 'logo.png', 'Site Logo', 'General', ''),
	(25, 'sitestyle', 'default', 'Style', 'General', ''),
	(26, 'GoogleMapValue', 'AIzaSyDZ0qMJNqSxi8QJFuUDuPdE7Pwh3TPCjpo', 'Google Map Key', 'General', ''),
	(27, 'max_num_img', '20', 'Maximum number of location images', 'General', ''),
	(28, 'email_type', 'html', 'Outgoing Email Format', 'General', ''),
	(29, 'allowedimagetypes', 'gif,jpg,jpeg,png,image/gif,image/pjpeg ,image/jpeg,image/png,image/x-png,image/pjpeg,image/bmp', 'Recommended Image Formats', 'General', ''),
	(30, 'metatagKey', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'Default Meta Keywords', 'General', 'textarea'),
	(60, 'ReserveMode', 'P', 'Reserve Mode', 'Advanced', 'radiobox'),
	(31, 'metatagDes', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'Default Meta Description', 'General', 'textarea'),
	(32, 'bookmark_enable', 'N', 'Enable Bookmark', 'General', 'checkbox'),
	(33, 'bookmark_value', 'abc', 'Bookmark Value', 'General', 'textarea'),
	(34, 'GoogleMap', 'N', 'Enable Google Map', 'General', ''),
	(95, 'social_share_enable', 'Y', 'Enable Social Share', 'General', ''),
	(96, 'expedia_country', 'US', 'Expedia Search Country', 'Expedia', ''),
	(36, 'googleaddemo', 'N', 'Enable Google Advertisement', 'General', 'checkbox'),
	(37, 'googleadvalue', '<script type="text/javascript"><!--\r\n\r\ngoogle_ad_client = "pub-7632436558048787";\r\n\r\n/* iscriptsproducts */\r\n\r\ngoogle_ad_slot = "4366873216";\r\n\r\ngoogle_ad_width = 620;\r\n\r\ngoogle_ad_height = 90;\r\n\r\n//-->\r\n\r\n</script>\r\n\r\n<script type="text/javascript"\r\n\r\nsrc="http://pagead2.googlesyndication.com/pagead/show_ads.js">\r\n\r\n</script>', 'Invocation Code for Advertisement', 'General', 'textarea'),
	(38, 'feedname', 'N', 'Enable RSS Feed', 'General', 'checkbox'),
	(39, 'userapproval', 'A', 'User Approval Type', 'General', 'radiobox'),
	(40, 'enablegoogle', 'N', 'Enable Google Checkout', 'Payment', 'checkbox'),
	(41, 'enablegooglesandbox', 'sandbox', 'Enable Google Sandbox', 'Payment', 'checkbox'),
	(42, 'googleid', '', 'GoogleMerchant ID', 'Payment', ''),
	(43, 'googlekey', '', 'GoogleMerchant Key', 'Payment', ''),
	(44, 'paymentmethod', 'YP', 'Payment Gateway', 'Payment', ''),
	(45, 'urpaystoreid', '1909177135', 'Yourpay Store Id', 'Payment', ''),
	(46, 'urpaydemo', 'YES', 'Enable Your Pay Test Mode?', 'Payment', 'checkbox'),
	(47, 'pemfolder', '1909177135.pem', '', 'Payment', ''),
	(48, 'worldpaydemo', 'N', 'Enable Worldpay Test Mode', 'Payment', 'checkbox'),
	(49, 'worldpayid', '', 'Worldpay Installation Id', 'Payment', ''),
	(50, 'worldpayemail', '', 'Worldpay Email Address', 'Payment', ''),
	(51, 'worldpaytransmode', 'A', 'Worldpay Transaction Method', 'Payment', ''),
	(52, 'enableyourpay', 'N', 'Enable Yourpay', 'Payment', ''),
	(53, 'enableworldpay', 'N', 'Enable Worldpay', 'Payment', ''),
	(54, 'enable_other_payments', 'N', 'Enable Other Payments', 'Payment', 'checkbox'),
	(55, 'admin_address', '1020 Milwakee Ave, #245\r\nDeerfield, IL - 60015\r\nUnited States', 'Communication Address', 'General', 'textarea'),
	(56, 'email_logo', 'logo.png', 'Email Logo', 'General', ''),
	(57, 'flash_header', '1', 'Enable Flash Header', 'Advanced', 'checkbox'),
	(58, 'referral', 'N', 'Enable Referral', 'Advanced', 'checkbox'),
	(59, 'operation_mode', '3', 'Operation Mode ', 'Advanced', 'radiobox'),
	(61, 'ReservePayMode', 'Per', 'Amount Mode', 'Advanced', 'radiobox'),
	(62, 'ReserveModeAmount', '50', 'Pay Mode Percentage', 'Advanced', ''),
	(63, 'AuthorizeTransMode', 'AUTH_CAPTURE', 'Autorize Type of Transaction', 'Payment', 'radiobox'),
	(64, 'AllowCancel', '1', 'Allow Online Cancellation', 'Advanced', 'radiobox'),
	(65, 'CancelType', '1', 'Type of Cancellation', 'Advanced', ''),
	(66, 'vLicenceKey', '3233', 'License Key ', 'General', ''),
	(67, 'cancellation_terms', 'cancellation terms', 'Cancellation Terms', 'Advanced', 'textarea'),
	(68, 'metaTitle', 'iScripts ReserveLogics', 'Default Page/Meta Title', 'General', ''),
	(69, 'addressfromemail', 'remya.v@armiasystems.com', '', '', ''),
	(97, 'search_filter_min_value', '0', 'Search Filter Minimum Value', 'General', ''),
	(70, 'addressfromemailname', 'remya.v@armiasystems.com', '', '', ''),
	(71, 'addressreplyemail', 'remya.v@armiasystems.com', '', '', ''),
	(72, 'addressreplyemailname', 'remya.v@armiasystems.com', '', '', ''),
	(74, 'affiliate_enable', '1', 'Enable Affiliate', 'General', ''),
	(104, 'recaptcha_enable', 'N', 'Enable Recaptcha', 'General', 'checkbox'),
	(75, 'affiliate_percentage', '', 'Affiliate Percentage', 'General', ''),
	(76, 'fbappid', '', 'Faceboo App Id', 'General', ''),
	(78, 'companyPhone', '', 'Comapny Phone Number', 'General', ''),
	(79, 'companyName', 'Reserve Logic', 'Company Name', 'General', ''),
	(80, 'companySite', 'http://www.iscripts.com/', 'Company Site', 'General', ''),
	(81, 'expedia_enable', 'N', 'Enable Expedia', 'Expedia', ''),
	(82, 'expedia_version', '', 'Enable Version', 'Expedia', ''),
	(83, 'expedia_cid', '', 'Expedia CID Value', 'Expedia', ''),
	(84, 'expedia_apikey', '', 'Expedia API Key', 'Expedia', ''),
	(85, 'expedia_currency', 'USD', 'Expedia Currency Code', 'Expedia', ''),
	(86, 'expedia_search_mode', '2', 'Expedia Search Mode', 'Expedia', ''),
	(87, 'logoFooter', 'logo-footer.png', '', '', ''),
	(88, 'expedia_locale', 'en_US', 'Expedia Locatiob', 'Expedia', ''),
	(90, 'enable_fb', 'N', 'Enable Facebook', 'Social Settings', ''),
	(91, 'fb_app_id', '', 'Facebook App ID', 'General', ''),
	(92, 'enable_twitter', 'Y', 'Enable Twitter', 'Social Settings', ''),
	(93, 'enable_pinterest', 'Y', 'Enable Pinterest', 'Social Settings', ''),
	(94, 'enable_gplus', 'Y', 'Enable GooglePlus', 'Social Settings', ''),
	(98, 'search_filter_max_value', '1000', 'Search Filter MaximumValue', 'General', ''),
	(99, 'followlink_facebook', 'https://www.facebook.com/iscripts', 'Follow Link : Facebook', 'General', ''),
	(100, 'followlink_twitter', 'https://twitter.com/iscriptsdotcom', 'Follow Link : Twitter', 'General', ''),
	(101, 'followlink_linkedin', 'http://www.linkedin.com/company/iscripts.com', 'Follow Link : Linkedin', 'General', ''),
	(103, 'admin_booking_message', 'Note: Check in like check in time is 12.00 or phone number.', '', 'General', 'textarea'),
	(105, 'recaptcha_public_key', '6LfryNQSAAAAAHh7zgGqZUYgp7oJDDmq49tBj9Rz', 'Recaptcha Public Key', 'General', ''),
	(106, 'recaptcha_private_key', '6LfryNQSAAAAAEQGT_gjWxwxVAlfRu37pDR3sR1f', 'Recaptcha Private Key', 'General', ''),
	(107, 'calendar_enable', 'N', 'Enable Calendar', 'General', 'checkbox'),
	(108, 'EnableSMTP', 'N', 'Enable SMTP', 'Advanced', ''),
	(109, 'SMTPUsername', '', 'SMTP Username', 'Advanced', ''),
	(110, 'SMTPPassword', '', 'SMTP Password', 'Advanced', ''),
	(111, 'SMTPPort', '', 'SMTP PORT', 'Advanced', ''),
	(112, 'SSLEnabled', 'N', 'SSL Enabled Or Not', 'Advanced', ''),
	(113, 'SMTPHost', '', 'SMTP Host', 'Advanced', ''),
	(114, 'currency', '1', 'Choose Default Currency', 'Payment', 'selectbox'),
	(116, 'enablebluepay', 'N', 'Enable BluePayTest Mode', 'Payment', ''),
	(117, 'bluepaypayid', '', 'BluePay Login Id', 'Payment', ''),
	(118, 'bluepaysecretkey', '', 'BluePay Secret Key', 'Payment', ''),
	(119, 'bluepaydemo', 'Y', 'Enable BluePay Demo', 'Payment', ''),
	(120, 'cenable_paypal_pro', 'N', 'Enable PayPal Pro', 'Payment', ''),
	(121, 'vpaypal_pro_test_mode', 'NO', 'Enable PayPal Pro Test Mode', 'Payment', ''),
	(122, 'vpaypalprosignature', '', 'PayPal Pro Signature', 'Payment', ''),
	(123, 'vpaypalprousername', '', 'PayPal Pro UserName', 'Payment', ''),
	(124, 'vpaypalpropassword', '', 'PayPal Pro Password', 'Payment', ''),
	(125, 'vpaypalprobncode', '', 'PayPal Pro BN code', 'Payment', ''),
	(126, 'embed_label', 'Search', 'Label', 'Embed Code', 'textbox'),
	(127, 'embed_bg_color', '#FFFFFF', 'Background Color', 'Embed Code', 'textbox'),
	(128, 'embed_color', '#000000', 'Color', 'Embed Code', 'textbox'),
	(130, 'embed_div_id', 'Embed', 'Div Id', 'Embed Code', 'textbox'),
	(132, 'embed_display_style', '1', 'Display style', 'Embed Code', 'textbox'),
	(133, 'embed_url', 'http://localhost/reservelogic', 'Url', 'Embed Code', 'textbox'),
	(134, 'embed_operation_mode', '3', 'Operation Mode', 'Embed Code', 'textbox'),
	(135, 'embed_new_tab', '1', 'Enable new tab', 'Embed Code', 'textbox'),
        (137, 'payment_gateway', 'authorize', 'Choose credit card', 'Payment', '');



INSERT INTO `tbl_mail_template` (`id`, `mail_template_name`, `mail_template_sub`, `mail_template_body`, `mail_template_status`, `created_on`) VALUES
(21, 'PasswordRecovery', '{SITE_NAME} - Password!', '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">       <title></title> <table width="600" cellspacing="0" cellpadding="0" border="0" style="border:1px solid #ccc; background-color:#FDFDFD; ">        <tbody>         <tr>             <td height="5" colspan="3">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table width="100%" cellspacing="0" cellpadding="0" border="0">                     <tbody>                         <tr>                             <td height="56" style="background-color:#FFFFFF; "><table width="100%" cellspacing="0" cellpadding="0" border="0">                                     <tbody>                                         <tr>                                             <td width="2%" height="80">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table width="100%" cellspacing="0" cellpadding="0" border="0">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Forgot password - {SITE_NAME}</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">We have received  your password reset request.</p>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Please ignore the request if it was not made by you.</p>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">&#160;</p></td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>{PasswordLink}</td><td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br> 												Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table width="100%" cellspacing="0" cellpadding="0" border="0">                                     <tbody>                                         <tr>                                             <td height="30" style="background-color:#FFFFFF; "><p style="color:#999999; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td height="10" colspan="3">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p></meta>', 1, '2013-01-15 05:05:51'),
(28, 'LoginInfo', '{SITE_NAME} - Your login informations', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56" ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your login informations is as follows ,</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:31:36'),
(23, 'PackageInquiry', '{SITE_NAME} - Package Inquiry! ', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear Administrator,</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">There is a package inquiry from a customer. The following are the details:</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30" ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:32:16'),
(24, 'OfflineBookingDetails', '{SITE_NAME} - Thank you for booking !', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your class booking has been successfully done. The booking details are as follows :</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:33:45'),
(25, 'BookingInvoice', '{SITE_NAME} - Your invoice details! ', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56" ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your booking has been successfully done. The booking details are as follows :</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30" ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:34:22'),
(26, 'contactus', 'Contact Us Inquiry From {SITE_NAME}', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear Administrator,</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">There is a package inquiry from a customer. The following are the details:</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:35:02'),
(27, 'BookingInvoiceAdmin', '{SITE_NAME} - Booking invoice details! ', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56" ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">A booking has been successfully done in {SITE_NAME}. The booking details are as follows :</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:35:55'),
(29, 'Inquiry', 'Inquiry - {SITE_NAME}', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear Administrator,</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">There is a inquiry from a customer. The following are the details:</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:36:46'),
(32, 'AdminPanelOfflineBookingInvoice', '{SITE_NAME} - Offline invoice details! ', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56" ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your class booking has been successfully done. The booking details are as follows :</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:37:21'),
(33, 'AdminPanelOfflineBookingInvoiceToAdmin', '{SITE_NAME} - Offline Booking invoice details! ', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56" ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">A booking has been successfully done in {SITE_NAME}. The booking details are as follows :</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:38:03'),
(38, 'installer_mail', 'Installer Mail', '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">\r\n<title></title>\r\n<table width="600" cellspacing="0" cellpadding="0" border="0" style="border:1px solid #ccc; background-color:#FDFDFD; ">\r\n    <tbody>\r\n        <tr>\r\n            <td height="5" colspan="3"></td>\r\n        </tr>\r\n        <tr>\r\n            <td width="5"></td>\r\n            <td width="586"><table width="100%" cellspacing="0" cellpadding="0" border="0">\r\n    <tbody>\r\n        <tr>\r\n            <td height="56" style="background-color:#324148; ">\r\n                <table width="100%" cellspacing="0" cellpadding="0" border="0">\r\n                    <tbody>\r\n                        <tr>\r\n                            <td width="2%" height="80">&#160;</td>\r\n                            <td width="37%">{SITE_LOGO}</td>\r\n                            <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>\r\n                        </tr>\r\n                    </tbody>\r\n                </table></td>\r\n        </tr>\r\n        <tr>\r\n            <td height="10">&#160;</td>\r\n        </tr>\r\n        <tr>\r\n            <td>&#160;</td>\r\n        </tr>\r\n        <tr>\r\n            <td><table width="100%" cellspacing="0" cellpadding="0" border="0">\r\n                    <tbody>\r\n                        <tr>\r\n                            <td width="2%">&#160;</td>\r\n                            <td width="28%">{MAIL_CONTENT}</td>\r\n                            <td width="2%">&#160;</td>\r\n                        </tr>\r\n                        <tr>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                        </tr>\r\n                        <tr>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                        </tr>\r\n                        <tr>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                            <td>&#160;</td>\r\n                        </tr>\r\n                    </tbody>\r\n                </table></td>\r\n        </tr>\r\n        <tr>\r\n            <td><table width="100%" cellspacing="0" cellpadding="0" border="0">\r\n                    <tbody>\r\n                        <tr>\r\n                            <td height="30" style="background-color:#324148; "><p style="color:#FFFFFF; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>\r\n                        </tr>\r\n                    </tbody>\r\n                </table></td>\r\n        </tr>\r\n    </tbody>\r\n                </table></td>\r\n                <td width="4">&#160;</td>\r\n        </tr>\r\n        <tr>\r\n            <td height="10" colspan="3">&#160;</td>\r\n        </tr>     </tbody> </table> <p>&#160;</p></meta>', 1, '2013-01-15 05:38:53');
INSERT INTO `tbl_mail_template` (`id`, `mail_template_name`, `mail_template_sub`, `mail_template_body`, `mail_template_status`, `created_on`) VALUES
(1, 'affiliateregister', '{SITE_NAME} - Activate your affiliate account ', '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">       <title></title> <table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">        <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%">{SITE_LOGO}</td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Thank you for registering as affiliate</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Click the folowing link to activate your account</p>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">&#160;</p></td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>{ActivationLink}</td><td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br> 												Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p></meta>', 1, '2013-01-15 05:39:29'),
(2, 'affiliate_pwdrequest', 'Affiliate Password reset request', '<meta content="text/html; charset=iso-8859-1" http-equiv="Content-Type">       <title></title> <table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">        <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%">{SITE_LOGO}</td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Forgot password - {SITE_NAME}</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">We have received  your password reset request.</p>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Please ignore the request if it was not made by you.</p>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">&#160;</p></td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>{PasswordLink}</td><td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br> 												Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p></meta>', 1, '2013-01-15 05:40:11'),
(34, 'AdminPanelPendingCancelConfirmation', '{SITE_NAME} - Pending Cancel Confirmation', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your cancellation for the following booking processed successfully</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:40:51'),
(35, 'CancelConfirmation', '{SITE_NAME} - Cancel Confirmation', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your cancellation for the following booking processed successfully.</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:43:06'),
(36, 'PendingBookingConfirmation', '{SITE_NAME} - Booking Confirmed!', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your booking confirmed</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:43:49'),
(37, 'CancelPaymentPending', '{SITE_NAME} - Cancel Request Received', '<table border="0" cellpadding="0" cellspacing="0" style="border:1px solid #ccc; background-color:#FDFDFD; " width="600">     <tbody>         <tr>             <td colspan="3" height="5">&#160;</td>         </tr>         <tr>             <td width="5">&#160;</td>             <td width="586"><table border="0" cellpadding="0" cellspacing="0" width="100%">                     <tbody>                         <tr>                             <td height="56"  ><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="80" width="2%">&#160;</td>                                             <td width="37%"><span style="background-color: rgb(253, 253, 253);">{SITE_LOGO}</span></td>                                             <td width="61%"><p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#CCCCCC; text-align:right; padding:0 15px 0 0; ">{Date}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td height="10">&#160;</td>                         </tr>                         <tr>                             <td>&#160;</td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td width="2%">&#160;</td>                                             <td width="97%"><h3 style="font-family:Arial, Helvetica, sans-serif; font-size:18px; color:#333333; font-weight:normal; margin:5px 0 5px 0; ">Dear {NAME},</h3>                                                 <p style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333333; line-height:21px; text-align:justify; ">Your cancel request is received. Cancel will be processed once payment is received</p>                                                 {MAIL_BODY}</td>                                             <td width="2%">&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>Thank You<br>                                             Team {SITE_NAME}</td>                                             <td>&#160;</td>                                         </tr>                                         <tr>                                             <td>&#160;</td>                                             <td>&#160;</td>                                             <td>&#160;</td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                         <tr>                             <td><table border="0" cellpadding="0" cellspacing="0" width="100%">                                     <tbody>                                         <tr>                                             <td height="30"  ><p style="color:#CCC; font-family:Arial, Helvetica, sans-serif; font-size:12px; padding:0 0 0 15px; ">{COPYRIGHT}</p></td>                                         </tr>                                     </tbody>                                 </table></td>                         </tr>                     </tbody>                 </table></td>             <td width="4">&#160;</td>         </tr>         <tr>             <td colspan="3" height="10">&#160;</td>         </tr>     </tbody> </table> <p>&#160;</p>', 1, '2013-01-15 05:44:23');


INSERT INTO `tbl_MetaTags` (`nId`, `vTitle`, `vKeywords`, `vDescription`, `vPageName`) VALUES
(1, 'About Us', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'aboutus'),
(2, 'Contact us', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating\r\n', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'contactus'),
(3, 'Search', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'search'),
(4, 'Destinations', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'destination'),
(5, 'Location Details', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'location'),
(6, 'News', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'news'),
(7, 'Inquiry', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'inquiry'),
(8, 'Home', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'home'),
(9, 'Affiliates', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'affiliates'),
(10, 'Register As Affiliate', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'affiliate_register'),
(12, 'Affiliate Home', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'affiliate_home'),
(11, 'Forgot password', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'affiliate_forgotpassword'),
(13, 'Payment History', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'affiliate_payment_history'),
(14, 'Profile', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'affiliate_profile'),
(15, 'Change Password', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'affiliate_change_password'),
(16, 'Get URLS', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'affiliate_geturls'),
(17, 'Packages', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'package'),
(18, 'Special Offers', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'offers'),
(19, 'Password Recovery', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'password_recovery'),
(20, 'Booking Details', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'booknow'),
(20, 'Cancellation', 'Online Hotel Booking, Online Hotel Reservation, Book Hotels Online, Vacation Tour Packages,Hotel Reviews, Hotel Booking ,Hotel Guide, Hotels Ratings, Hotel rating', 'We offer Cheapest hotel rates and discounted vacation tour packages.', 'cancel');


INSERT INTO `tbl_state` (`ts_id`, `tc_id`, `ts_code`, `ts_name`, `ts_status`) VALUES
(1, 1, 'AL', 'ALABAMA', 'A'),
(2, 1, 'AK', 'ALASKA', 'A'),
(3, 1, 'AS', 'AMERICAN SAMOA', 'A'),
(4, 1, 'AZ', 'ARIZONA', 'A'),
(5, 1, 'AR', 'ARKANSAS', 'A'),
(6, 1, 'CA', 'CALIFORNIA', 'A'),
(7, 1, 'CO', 'COLORADO', 'A'),
(8, 1, 'CT', 'CONNECTICUT', 'A'),
(9, 1, 'DE', 'DELAWARE', 'A'),
(10, 1, 'DC', 'DISTRICT OF COLUMBIA', 'A'),
(11, 1, 'FM', 'FEDERATED STATES OF MICRONESIA', 'A'),
(12, 1, 'FL', 'FLORIDA', 'A'),
(13, 1, 'GA', 'GEORGIA', 'A'),
(14, 1, 'GU', 'GUAM', 'A'),
(15, 1, 'HI', 'HAWAII', 'A'),
(16, 1, 'ID', 'IDAHO', 'A'),
(17, 1, 'IL', 'ILLINOIS', 'A'),
(18, 1, 'IN', 'INDIANA', 'A'),
(19, 1, 'IA', 'IOWA', 'A'),
(20, 1, 'KS', 'KANSAS', 'A'),
(21, 1, 'KY', 'KENTUCKY', 'A'),
(22, 1, 'LA', 'LOUISIANA', 'A'),
(23, 1, 'ME', 'MAINE', 'A'),
(24, 1, 'MH', 'MARSHALL ISLANDS', 'A'),
(25, 1, 'MD', 'MARYLAND', 'A'),
(26, 1, 'MA', 'MASSACHUSETTS', 'A'),
(27, 1, 'MI', 'MICHIGAN', 'A'),
(28, 1, 'MN', 'MINNESOTA', 'A'),
(29, 1, 'MS', 'MISSISSIPPI', 'A'),
(30, 1, 'MO', 'MISSOURI', 'A'),
(31, 1, 'MT', 'MONTANA', 'A'),
(32, 1, 'NE', 'NEBRASKA', 'A'),
(33, 1, 'NV', 'NEVADA', 'A'),
(34, 1, 'NH', 'NEW HAMPSHIRE', 'A'),
(35, 1, 'NJ', 'NEW JERSEY', 'A'),
(36, 1, 'NM', 'NEW MEXICO', 'A'),
(37, 1, 'NY', 'NEW YORK', 'A'),
(38, 1, 'NC', 'NORTH CAROLINA', 'A'),
(39, 1, 'ND', 'NORTH DAKOTA', 'A'),
(40, 1, 'MP', 'NORTHERN MARIANA ISLANDS', 'A'),
(41, 1, 'OH', 'OHIO', 'A'),
(42, 1, 'OK', 'OKLAHOMA', 'A'),
(43, 1, 'OR', 'OREGON', 'A'),
(44, 1, 'PW', 'PALAU', 'A'),
(45, 1, 'PA', 'PENNSYLVANIA', 'A'),
(46, 1, 'PR', 'PUERTO RICO', 'A'),
(47, 1, 'RI', 'RHODE ISLAND', 'A'),
(48, 1, 'SC', 'SOUTH CAROLINA', 'A'),
(49, 1, 'SD', 'SOUTH DAKOTA', 'A'),
(50, 1, 'TN', 'TENNESSEE', 'A'),
(51, 1, 'TX', 'TEXAS', 'A'),
(52, 1, 'UT', 'UTAH', 'A'),
(53, 1, 'VT', 'VERMONT', 'A'),
(54, 1, 'VI', 'VIRGIN ISLANDS', 'A'),
(55, 1, 'VA', 'VIRGINIA', 'A'),
(56, 1, 'WA', 'WASHINGTON', 'A'),
(57, 1, 'WV', 'WEST VIRGINIA', 'A'),
(58, 1, 'WI', 'WISCONSIN', 'A'),
(59, 1, 'WY', 'WYOMING', 'A'),
(61, 3, 'AB', 'Alberta', 'I'),
(62, 3, 'BC', 'British Columbia', 'I'),
(63, 3, 'MB', 'Manitoba', 'I'),
(64, 3, 'NB', 'New Brunswick', 'I'),
(65, 3, 'NL', 'Newfoundland and Labrador', 'I'),
(66, 3, 'NT', 'Northwest Territories', 'I'),
(67, 3, 'NS', 'Nova Scotia', 'I'),
(68, 3, 'NU', 'Nunavut', 'I'),
(69, 3, 'PE', 'Prince Edward Island', 'I'),
(70, 3, 'SK', 'Saskatchewan', 'I'),
(71, 3, 'ON', 'Ontario', 'I'),
(72, 3, 'QC', 'Quebec', 'I'),
(73, 3, 'YT', 'Yukon', 'I'),
(74, 2, 'AP', 'Andhra Pradesh', 'I'),
(75, 2, 'ARP', 'Arunachal Pradesh', 'I'),
(76, 2, 'AM', 'Assam', 'I'),
(77, 2, 'BM', 'Bihar', 'I'),
(78, 2, 'CHH', 'Chhattisgarh', 'I'),
(79, 2, 'ND', 'New Delhi', 'I'),
(80, 2, 'GO', 'Goa', 'I'),
(81, 2, 'GJ', 'Gujarat', 'I'),
(82, 2, 'HA', 'Haryana', 'I'),
(83, 2, 'HP', 'Himachal Pradesh', 'I'),
(84, 2, 'JK', 'Jammu and Kashmir', 'I'),
(85, 2, 'JD', 'Jharkhand', 'I'),
(86, 2, 'KT', 'Karnataka', 'I'),
(87, 2, 'KL', 'Kerala', 'I'),
(88, 2, 'MP', 'Madhya Pradesh', 'I'),
(89, 2, 'MH', 'Maharashtra', 'I'),
(90, 2, 'MN', 'Manipur', 'I'),
(91, 2, 'MG', 'Meghalaya', 'I'),
(93, 2, 'MZ', 'Mizoram', 'I'),
(94, 2, 'NG', 'Nagaland', 'I'),
(95, 2, 'OR', 'Orissa', 'I'),
(96, 2, 'PN', 'Punjab', 'I'),
(97, 2, 'RJ', 'Rajasthan', 'I'),
(98, 2, 'SK', 'Sikkim', 'I'),
(99, 2, 'TN', 'Tamil Nadu', 'I'),
(100, 2, 'TP', 'Tripura', 'I'),
(101, 2, 'UT', 'Uttaranchal', 'I'),
(102, 2, 'UP', 'Uttar Pradesh', 'I'),
(103, 2, 'WB', 'West Bengal', 'I');


UPDATE `tbl_country` SET `tc_name` = 'United States' WHERE `tbl_country`.`tc_id` =1;


INSERT INTO `tbl_currency_master` (`currency_id`, `currency_name`, `currency_code`, `currency_symbol`, `status`) VALUES
	(1, 'US Dollar', 'USD', '$', 'active');
	
INSERT INTO `tbl_Banners` (`vName`,`vlocUrl`,`vImg`,`nDate`,`vWidth`,`vHeight`,`nPosition`,`vActive`,`vLocation`,`nCount`,`nType`,`vOpenxDes`,`file_id`) VALUES ('Banner','GOOGLE.COM',NULL,'2012-12-13',NULL,NULL,NULL,'1','Home',0,'Normal',NULL,2);




