<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/
class Cancel {
    public static function checkPenalty($bookingDate) {
        $db = new Db;
        $nDays          = self::calculateNumberOfDays($bookingDate);
        return $db->selectResult('Range','*'," vActive='1' AND  day_start_range<='".$nDays."' AND day_end_range>='".$nDays."' ORDER BY nRId LIMIT 1");
    }


    public static function getBookingDetails($bookingId) {
        $db = new Db;
        $bookingDetails = $db->selectResult("booking B
        LEFT JOIN ".$db->tablePrefix."allotment A ON B.nBooking_Id = A.nBooking_Id
        LEFT JOIN ".$db->tablePrefix."available_acco_type AAT ON A.nAat_Id = AAT.nAat_Id
	INNER JOIN ".$db->tablePrefix."accomodation_types AT ON AT.nAt_Id = AAT.nAt_Id
	INNER JOIN ".$db->tablePrefix."locations L ON L.nLocation_Id = AAT.nLocation_Id
        INNER JOIN ".$db->tablePrefix."destination D ON D.nDestination_Id = L.nDestination_Id
	
	INNER JOIN ".$db->tablePrefix."customers C ON C.nCust_Id = B.nCust_Id", 
                "D.vDestination_Name,A.nAllotment_Id,L.vLocation_Name,L.nLocation_Id,AT.vAt_Name,A.vStatus,C.vFirstname,C.vEmail,AAT.nAdults as adults,AAT.nChildren as children,AAT.nAat_id as Aat_Id,
            A.dDate, A.nDays,B.nRooms, B.dArrival_Date, B.dBooking_Date,B.nReserveModeAmount ,CONCAT(L.vAddress,', ',L.vCity,', ',L.vState,', ',L.vZip,', ',L.vCountry) AS Address, B.nAmount, B.nAdults , B.nChildren,B.nNights_Stay", " B.nBooking_Id = $bookingId   GROUP BY B.nBooking_Id ORDER BY dDate DESC");
        return $bookingDetails;

    }

    public static function calculatePenalty($penaltyDetails, $totalAmount) {
        if($penaltyDetails[0]->vType =='Amt') {
            return $penaltyDetails[0]->nAmount;
        }
        else {
            return ($totalAmount*$penaltyDetails[0]->nAmount)/100;
        }
    }

    private static function calculateNumberOfDays($bookingDate) {
        $now = time();
        $diff = abs($now - strtotime($bookingDate));
        $years          = floor($diff / (365*60*60*24));
        $months         = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
        $nDays          = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));
        return $nDays;
    }

    public static function cancelBooking($requestArray) {
        $dbh = new Db;
        $dbh->update($dbh->tablePrefix."booking",array('vStatus'=>'canceled','dCancelDate'=>date('Y-m-d')), "nBooking_Id =".$requestArray['nBooking_Id'] );
        $dbh->update($dbh->tablePrefix."allotment",array("vStatus"=>'canceled'), "nBooking_Id=".$requestArray['nBooking_Id']);
        $requestArray['transactionType'] = 'CANCEL';
        return  $dbh->addFields("payment", $requestArray);
    }

    public static function cancelBookingWithoutPayment($bookingId) {
        $dbh = new Db;
        $dbh->update($dbh->tablePrefix."booking",array('vStatus'=>'canceled','dCancelDate'=>date('Y-m-d')), "nBooking_Id =".$bookingId );
        $dbh->update($dbh->tablePrefix."allotment",array("vStatus"=>'canceled'), " 	nBooking_Id=".$bookingId);
    }

    public static function changeBookingCanceltoPending($requestArray) {
        $dbh = new Db;
        $dbh->update($dbh->tablePrefix."booking",array('vStatus'=>'cancelPending','dCancelDate'=>date('Y-m-d')), "nBooking_Id =".$requestArray['nBooking_Id'] );
        $dbh->update($dbh->tablePrefix."allotment",array("vStatus"=>'cancelPending'), " 	nBooking_Id=".$requestArray['nBooking_Id']);
        $requestArray['transactionType'] = 'CANCEL';
        return  $dbh->addFields("payment", $requestArray);
    }
    public static function addBankDetails($dataArray) {
        $db = new Db;
        $db->addFields('bank_details', $dataArray);
    }

    public static function sendCancelConfirmationMail($bookingId, $penalty , $userLevel="User") {
        $penalty = $penalty?$penalty:0;
        $bookingDetails = Cancel::getBookingDetails($bookingId);

        if($userLevel=='Admin')
            $replaceParameters['name']      .= 'Administrator';
        else
            $replaceParameters['name']      .= $bookingDetails[0]->vFirstname;

        if($userLevel=='Admin'){
            $replaceParameters['user'] = $bookingDetails[0]->vFirstname;
        }
        
        $replaceParameters['mailBody']  .= '<table border="0">';
        $replaceParameters['mailBody']  .= '<tr><th colspan="2" align="left">'.CANCELLATION_MAIL_DETAIL_HEADING.'</th></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_DESTINATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vDestination_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_LOCATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vLocation_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_ACCOMMODATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vAt_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_ROOMS.':</td><td>'.$bookingDetails[0]->nRooms.'</td></tr>';

        $bookingDetails[0]->dArrival_Date = date('Y-m-d' , strtotime($bookingDetails[0]->dArrival_Date));
        $arrivalDate                     = Utils::dateFormat($bookingDetails[0]->dArrival_Date, 'Y-m-d', 'm/d/Y');



        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_CHECK_IN.':</td><td>'.$arrivalDate.'</td></tr>';

        $nightStay                       = intval($bookingDetails[0]->nNights_Stay);
        $nightStay                       = ($nightStay == 0 || $nightStay == '' ) ? 1 : $nightStay ;

        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_CHECK_OUT.':</td><td>'.date('m/d/Y',  strtotime($bookingDetails[0]->dArrival_Date.'+'.$nightStay.'days')).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_ADULTS.':</td><td>'.$bookingDetails[0]->nAdults.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_CHILDREN.':</td><td>'.$bookingDetails[0]->nChildren .'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_PENALTY.':</td><td>'.SITE_CURRENCY.' '.$penalty.'</td></tr>';

        $replaceParameters['mailBody']    .= '</table>';

        if($userLevel == 'Admin') {
            $emailAddress = Apputils::fetchSettings('vadmin_email');
            Utils::sendUserMail($emailAddress, 'CancelConfirmation', $replaceParameters);
        }else
            Utils::sendUserMail($bookingDetails[0]->vEmail, "CancelConfirmation", $replaceParameters);
        
    }


    public static function sendCancelPendingMail($bookingId, $penalty, $userLevel="User") {
        $penalty = $penalty?$penalty:0;
        $bookingDetails = Cancel::getBookingDetails($bookingId);

        if($userLevel=='Admin')
            $replaceParameters['name']      .= 'Administrator';
        else
            $replaceParameters['name']      .= $bookingDetails[0]->vFirstname;

        if($userLevel=='Admin'){
            $replaceParameters['user'] = $bookingDetails[0]->vFirstname;
        }

        $replaceParameters['mailBody']  .= '<table border="0">';
        $replaceParameters['mailBody']  .= '<tr><th colspan="2" align="left">'.CANCELLATION_MAIL_DETAIL_HEADING.'</th></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_DESTINATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vDestination_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_LOCATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vLocation_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_ACCOMMODATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vAt_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_ROOMS.':</td><td>'.$bookingDetails[0]->nRooms.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_CHECK_IN.':</td><td>'.date('m/d/Y',  strtotime($bookingDetails[0]->dArrival_Date)).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_CHECK_OUT.':</td><td>'.date('m/d/Y',  strtotime($bookingDetails[0]->dArrival_Date.'+'.intval($bookingDetails[0]->nNights_Stay).'days')).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_ADULTS.':</td><td>'.$bookingDetails[0]->nAdults.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_CHILDREN.':</td><td>'.$bookingDetails[0]->nChildren .'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_PENALTY.':</td><td>'.SITE_CURRENCY.' '.$penalty  .'</td></tr>';

        $replaceParameters['mailBody']    .= '</table>';

        if($userLevel == 'Admin') {
            $emailAddress = Apputils::fetchSettings('vadmin_email');
            Utils::sendUserMail($emailAddress, 'AdminCancelPaymentPending', $replaceParameters);

        }else
            Utils::sendUserMail($bookingDetails[0]->vEmail, "CancelPaymentPending", $replaceParameters);
        
    }


    public static function sendCancelMail($bookingId, $userLevel="User") {

        $objSession     = new LibSession();
        $bookingDetails = Cancel::getBookingDetails($bookingId);
        
        $locationId = $bookingDetails[0]->nLocation_Id;


        if($userLevel=='Admin')
            $replaceParameters['name']      .= 'Administrator';
        else
            $replaceParameters['name']      .= $bookingDetails[0]->vFirstname;


        $replaceParameters['mailBody']  .= '<table border="0">';
        $replaceParameters['mailBody']  .= '<tr><th colspan="2" align="left">'.CANCELLATION_MAIL_DETAIL_HEADING.'</th></tr>';

        if($userLevel=='User') {
            //$replaceParameters['mailBody']  .= '<tr><th colspan="2" align="left">'.CANCELLATION_MAIL_DETAIL_MESSAGE.'</th></tr>';
        }else {
            $replaceParameters['user'] = $bookingDetails[0]->vFirstname;
        }

        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_DESTINATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vDestination_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_LOCATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vLocation_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_ACCOMMODATION_NAME.':</td><td>'.stripslashes($bookingDetails[0]->vAt_Name).'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_ROOMS.':</td><td>'.$bookingDetails[0]->nRooms.'</td></tr>';


        $bookingDetails[0]->dArrival_Date = date('m/d/Y' , strtotime($bookingDetails[0]->dArrival_Date));
        $arrivalDate                     = Utils::dateFormat($bookingDetails[0]->dArrival_Date, 'm/d/Y', 'm/d/Y');

        $nightStay                       = intval($bookingDetails[0]->nNights_Stay);
        $nightStay                       = ($nightStay == 0 || $nightStay == '' ) ? 1 : $nightStay ;

        $checkoutDate                    = date('m/d/Y',  strtotime($bookingDetails[0]->dArrival_Date.'+'.$nightStay.'days'));

        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_CHECK_IN.':</td><td>'.$arrivalDate.'</td></tr>';

        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_CHECK_OUT.':</td><td>'.$checkoutDate.'</td></tr>';

        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_ADULTS.':</td><td>'.$bookingDetails[0]->nAdults.'</td></tr>';
        $replaceParameters['mailBody']  .= '<tr><td>'.CANCELLATION_MAIL_LABEL_NO_OF_CHILDREN.':</td><td>'.$bookingDetails[0]->nChildren .'</td></tr>';
        $replaceParameters['mailBody']    .= '</table>';
        $customerDetails                = json_decode($objSession->get('customer'));
        $customerId                     = $customerDetails->nCust_Id;
        $userDetails = Customer::getCustomerDetails($customerId);


        if($userLevel == 'Admin') {
            $emailAddress = Apputils::fetchSettings('vadmin_email');
            Utils::sendUserMail($emailAddress, 'AdminCancelConfirmation', $replaceParameters);
        }else
            Utils::sendUserMail($userDetails[0]->vEmail, "CancelConfirmation", $replaceParameters);

    }

}
?>
