<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | This page is for user section management. Login checking , new user registration, user listing etc.                                      |
// | File name : index.php                                                  |
// | PHP version >= 5.2                                                   |
// | Created On	: 	Nov 17 2011                                               |
// +----------------------------------------------------------------------+
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2010                                      |
// | All rights reserved                                                  |
// +------------------------------------------------------


class ControllerSearch extends BaseController {
    /*
		construction function. we can initialize the models here
    */
    public function init() {

        Pagecontext::$response->ignoreFilters = FALSE;
        Apputils::fetchSettings("operation_mode");
        parent::init();

        $this->_session         = new LibSession();

        PageContext::$body_class= 'search';
        PageContext::addStyle("results.css",true);
        PageContext::addScript("login.js");
        PageContext::addStyle("jquery-ui-1.8.23.custom.css",true);
        PageContext::addScript("jquery.validate.js");
        PageContext::addScript("jquery.metadata.js");
        if(PageContext::$response->settings['GoogleMap']=='Y')
            Apputils::loadGoogleMapConfigurations();
        PageContext::addScript('jquery-ui-timepicker-addon.js');
        PageContext::addScript("search.js");
        PageContext::addScript('tooltip.js');

        $this->_common	 = new ModelCommon();

        PageContext::addJsVar("BASE_URL", BASE_URL);
        PageContext::addJsVar("BASIC_LIST_COUNT", BASIC_LIST_COUNT);

        $search_filter_min_value = Utils::getSettingsData('search_filter_min_value');
        $search_filter_max_value = Utils::getSettingsData('search_filter_max_value');
        PageContext::addJsVar("jq_search_filter_min_value", $search_filter_min_value);
        PageContext::addJsVar("jq_search_filter_max_value", $search_filter_max_value);

        PageContext::addScript("modal.popup.js");
        PageContext::addJsVar("LOAD_SEARCH_RESULTS_URL", BASE_URL."search/searchresults/ajax");
    }

    /*
    function to load the search results template
    */
    public function index($destinationId) {
        //$destinationId          =  urldecode($destinationId);
        $db                     = new Db();
        $getDestination         = $db->selectResult('destination','nDestination_Id'," destination_alias='$destinationId'");
        $destinationId          = $getDestination[0]->nDestination_Id;
        PageContext::$metaTitle = SITENAME .' Search';
        PageContext::addJsVar("SEARCH_RESULTS_COUNT_MESSAGE",SEARCH_RESULTS_COUNT_MESSAGE);
        if($destinationId) {
            Pagecontext::$response->ignoreFilters                 = TRUE;
            PageContext::$response->selectedDestinationId         = $destinationId;
        }

        PageContext::registerPostAction("search", "searchpanel","search","default");
        if(PageContext::$response->settings['GoogleMap']=='Y')
            PageContext::registerPostAction("center-left","mappanel","search","default");


        PageContext::registerPostAction("center-left","leftpanel","search","default");
        PageContext::registerPostAction("center-main", "index","search","default");
        PageContext::$response->operation_mode = Apputils::fetchSettings("operation_mode");
        PageContext::$response->loadMoreEnabled = FALSE;
        $destinations = Search::fetchDestinations();

        if(count($destinations)>0)
            PageContext::$response->destinations = $destinations;

        $accomodationTypes = Search::fetchAccomodationTypes();

        if(count($accomodationTypes)>0)
            PageContext::$response->accomodationTypes = $accomodationTypes;

        PageContext::addPostAction("searchresults", "search","default");
        PageContext::addPostAction("ajaxloader", "search", "default");
    }



    /* Function to load search panel*/
    public function searchpanel() {

    }

    /* Function to load left panel*/
    public function leftpanel() {

    }

    /* Function to load search panel*/
    public function mappanel($ajaxCall = false) {
        if($ajaxCall == 'ajax') {
            PageContext::addPostAction("mappanel","search","default");
            PageContext::renderPostAction("mappanel","search","default");
            exit;
        }
    }

    /*Function to load  search results */
    public function searchresults($ajaxCall = false) {

        $objSearchParams = $this->_session->get('SearchObject');

        //Fetching paramters from page request
        $searchRequestArray['ignoreFilters'] = PageContext::$request['ignoreSearchFilter']?PageContext::$request['ignoreSearchFilter']:Pagecontext::$response->ignoreFilters;

        if(!Pagecontext::$response->ignoreFilters) {
            $searchRequestArray['destination'] = PageContext::$request['jqSearchDestination'];

            if($searchRequestArray['destination'] == '' && $objSearchParams->searchDestination > 0)
                $searchRequestArray['destination'] = $objSearchParams->searchDestination;
        }
        else
            $searchRequestArray['destination']    = PageContext::$response->selectedDestinationId;

        if($searchRequestArray['arrivalDate'] == '' && $objSearchParams->SearchStartDate == '')
            $searchRequestArray['arrivalDate'] = date('m-d-Y');

        else if($objSearchParams->SearchStartDate != '')
            $searchRequestArray['arrivalDate'] = $objSearchParams->SearchStartDate;

        if($searchRequestArray['departureDate'] == '' && $objSearchParams->SearchEndDate == '')
            $searchRequestArray['departureDate'] = date('m-d-Y',strtotime('+1 day'));

        else if($searchRequestArray['departureDate'] == '' && $objSearchParams->SearchEndDate != '')
            $searchRequestArray['departureDate'] = $objSearchParams->SearchEndDate;

        if($searchRequestArray['room1'] == '')
            $searchRequestArray['room1'] = ($objSearchParams->NumberOfRooms > 0 ) ? $objSearchParams->NumberOfRooms : 1;

        if($searchRequestArray['minRate'] == '')
            $searchRequestArray['minRate'] = 0;

        if(($searchRequestArray['guestCount'] == '' || $searchRequestArray['guestCount'] == 0) && $objSearchParams->GuestCount >0 )
            $searchRequestArray['guestCount'] = $objSearchParams->GuestCount;

        if(($searchRequestArray['numberOfRooms'] == '' || $searchRequestArray['numberOfRooms'] == 0) && $objSearchParams->NumberOfRooms > 0 )
            $searchRequestArray['numberOfRooms'] = $objSearchParams->NumberOfRooms;

        if(($searchRequestArray['guestChildrenCount'] == '' || $searchRequestArray['guestChildrenCount'] == 0) && $objSearchParams->GuestChildrenCount > 0)
            $searchRequestArray['guestChildrenCount'] = $objSearchParams->GuestChildrenCount;

        Pagecontext::$response->ignoreFilters  = FALSE;
        $searchRequestArray['ignoreFilters']   = FALSE;


        if(PageContext::$request['jqSearchDestination'] > 0)
            $searchRequestArray['destination'] = PageContext::$request['jqSearchDestination'];

        if(PageContext::$request['jqSearchStartDate'] != '')
            $searchRequestArray['startDate']              = PageContext::$request['jqSearchStartDate'];
        else
            $searchRequestArray['startDate']              = $searchRequestArray['arrivalDate'];


        if(PageContext::$request['jqSearchEndDate'] != '')
            $searchRequestArray['endDate']                = PageContext::$request['jqSearchEndDate'];
        else
            $searchRequestArray['endDate']                = $searchRequestArray['departureDate'];



        if(PageContext::$request['jqGuestCount'] > 0 )
            $searchRequestArray['guestCount']             = PageContext::$request['jqGuestCount'];
        else
            $searchRequestArray['guestCount']             = $searchRequestArray['guestCount'];


        if(PageContext::$request['jqGuestChildrenCount'] > 0 )
            $searchRequestArray['guestChildrenCount']     = PageContext::$request['jqGuestChildrenCount'];
        else if($searchRequestArray['guestChildrenCount'] == '')
            $searchRequestArray['guestChildrenCount']     = 0;


        if(PageContext::$request['jqNumberOfRooms'] > 0)
            $searchRequestArray['numberOfRooms']          = PageContext::$request['jqNumberOfRooms'];
        else if($searchRequestArray['numberOfRooms'] == '' || $searchRequestArray['numberOfRooms'] == 0)
            $searchRequestArray['numberOfRooms']          = 1;

        $searchRequestArray['searchKeyword']          = PageContext::$request['jqSearchKeyword'];
        $searchRequestArray['searchSortBy']           = PageContext::$request['jqSearchSortBy'];
        $searchRequestArray['searchPriceMinRange']    = PageContext::$request['jqPriceStartRange'];
        $search_filter_max_value                      = Utils::getSettingsData('search_filter_max_value');
        $searchRequestArray['searchPriceMaxRange']    = PageContext::$request['jqPriceEndRange']!=0?PageContext::$request['jqPriceEndRange']:$search_filter_max_value;
        $searchRequestArray['accomodationTypes']      = PageContext::$request['jqLocationAccomodationTypes'];
        $searchRequestArray['amneties']               = PageContext::$request['jqLocationAmneties'];


        Search::processSearchObject($searchRequestArray);
        $searchResults = Search::getSearchResults(0,PageContext::$response->operation_mode);
        $searchMode 	=  Utils::getSettingsData('expedia_search_mode');

        $dbSearchResultCount = $searchResults['totalResultCount'];


        if($searchMode == 3)
            $dbSearchResultCount = 0;

        $perpageCount = Apputils::fetchSettings('perpage');

        if($perpageCount >= $dbSearchResultCount )
            $expediaSearchLimit = $perpageCount - $dbSearchResultCount;



        $expediaSearchLimit = ($expediaSearchLimit < 0) ? 0 : $expediaSearchLimit;



        /* *************************************************************************
         * expedia API integration starts here
        */


        $expediaSearchResultCounter = 0;

        if(!Pagecontext::$response->ignoreFilters) {
            $checkExpediaEnable = Utils::getSettingsData('expedia_enable');
            if($checkExpediaEnable == 'Y')	// check whether expedia enable
            {
                if($searchRequestArray['destination'] != '') {
                    $searchMode 	=  Utils::getSettingsData('expedia_search_mode');

                    // getting the state code and city name
                    $stateDetails 	= Utils::getStateCode($searchRequestArray['destination']);




                    $searchArray['city'] 				= urlencode($stateDetails->vDestination_Name);
                    $searchArray['stateProvinceCode'] 		= $stateDetails->vState; //TOO


                    $searchArray['countryCode'] 			= Utils::getSettingsData('expedia_country');

                    if(PageContext::$request['jqSearchStartDate'] != '')
                        $searchArray['arrivalDate'] 			= PageContext::$request['jqSearchStartDate'];
                    else
                        $searchArray['arrivalDate'] 			= $searchRequestArray['arrivalDate'];



                    if(PageContext::$request['jqSearchEndDate'] != '')
                        $searchArray['departureDate'] 			= PageContext::$request['jqSearchEndDate'];
                    else
                        $searchArray['departureDate'] 			= $searchRequestArray['departureDate'];



                    //$searchArray['numberOfResults'] 		= $expediaSearchLimit;

                    if(PageContext::$request['jqNumberOfRooms'] > 0)
                        $searchArray['room1'] 					= PageContext::$request['jqNumberOfRooms'];
                    else
                        $searchArray['room1'] 					= $searchRequestArray['room1'];


                    $searchArray['minRate'] 				= $searchRequestArray['searchPriceMinRange'];
                    $searchArray['maxRate'] 				= $searchRequestArray['searchPriceMaxRange'];



                    if(trim($stateDetails->vDestination_Name) != '' && $expediaSearchLimit>0 ) {
                        
                        switch ($searchMode) {
                            case '1'://Enable search only if there is no location data available for a search

                                if(sizeof($searchResults['data']) <= 0 ) {
                                    $expediaResult 		= self::expediasearch($searchArray);
                                    $searchResults['data'] 	= $expediaResult['data'];
                                    $searchPagination  	= $expediaResult['pages'];

                                    $expediaSearchResultCounter = count($searchResults['data']);
                                }
                                break;

                            case '2':// Enable search data along with the location search results
                                $expediaResult 	= self::expediasearch($searchArray);
                                $apiresult 			= $expediaResult['data'];
                                $searchPagination  	= $expediaResult['pages'];
                                if(sizeof($searchResults['data']) > 0)
                                    $searchResults['data'] 		= array_merge($searchResults['data'],$apiresult);
                                else {
                                    $searchResults['data'] 		= $apiresult;
                                    $expediaSearchResultCounter = count($apiresult);

                                }
                                break;
                            case '3':// Show Expedia results only
                                $expediaResult 			=  self::expediasearch($searchArray);
                                $searchResults['data'] 	= $expediaResult['data'];
                                $searchPagination  		= $expediaResult['pages'];
                                $expediaSearchResultCounter = count($searchResults['data']);

                                break;
                            default:
                                break;
                        }

                    }
                }
            }
            /*
         * expedia API integration ends here
         * ***************************************************************************
            */
        }
        //echopre($searchPagination);
        PageContext::$response->totalResultCount = $searchResults['totalResultCount'] + $expediaSearchResultCounter;



        // Pagination ...

        PageContext::$response->searchResults = $searchResults['data'];



        //  PageContext::$response->apiSearchResults = $searchResults['apiresult'];

        PageContext::$response->guestCountModified = $searchResults['guestCountModified'];
        PageContext::$response->specialOffers = $searchResults['special_offers'];
        PageContext::addPostAction("offers", "search", "default");
        $defaults = Search::setDefaults();
        //Assigning to form objects
        PageContext::$response->searchDestination     = $searchRequestArray['destination']?$searchRequestArray['destination']:$defaults['defaultDestination'];
        PageContext::$response->SearchStartDate       = $searchRequestArray['startDate']?str_replace("-", "/", $searchRequestArray['startDate']):$defaults['defaultStartDate'];
        PageContext::$response->SearchEndDate         = $searchRequestArray['endDate']?str_replace("-", "/", $searchRequestArray['endDate']):$defaults['defaultEndDate'];
        PageContext::$response->GuestCount            = $searchRequestArray['guestCount']?$searchRequestArray['guestCount']:$defaults['defaultGuestCount'];
        PageContext::$response->GuestChildrenCount = $searchRequestArray['guestChildrenCount'];
        PageContext::$response->SearchKeyword = $searchRequestArray['searchKeyword'];
        PageContext::$response->SearchSortBy = $searchRequestArray['searchSortBy'];
        PageContext::$response->NumberOfRooms = $searchRequestArray['numberOfRooms']?$searchRequestArray['numberOfRooms']:$defaults['defaultRoomCount'];
        PageContext::$response->defaultMinPriceRange =  $defaults['defaultMinPriceRange'];
        PageContext::$response->defaultMaxPriceRange = $defaults['defaultMaxPriceRange'];
        if($ajaxCall== 'ajax') {

            PageContext::addPostAction("searchresults", "search","default");
            PageContext::renderPostAction("searchresults", "search","default");
            exit;
        }
    }
    /* Function to load more results */
    public function loadmoreresults($limit) {

        PageContext::$response->limit             = $limit;

        $checkExpediaEnable = Utils::getSettingsData('expedia_enable');
        if($checkExpediaEnable != 'Y')	// check whether expedia enable
        {
            $searchResults                            = Search::getSearchResults($limit,PageContext::$response->operation_mode);
            PageContext::$response->totalResultCount  = $searchResults['totalResultCount'];
            PageContext::$response->searchResults     = $searchResults['data'];
            PageContext::$response->loadMoreEnabled   = TRUE;

        }

        PageContext::addPostAction("loadmoreresults", "search", "default");
        PageContext::renderPostAction("loadmoreresults", "search", "default");

        exit;


    }

    /* Function to load ajax loader */
    public function ajaxloader() {

    }

    /* Function to load ajax loader */
    public function offers() {

    }



    public function expediasearch($searchArray = array()) {



        $searchParams = array();
        $searchParams['city'] = $searchArray['city'];
        $searchParams['stateProvinceCode'] = $searchArray['stateProvinceCode'];
        $searchParams['countryCode'] = $searchArray['countryCode'];
        $searchParams['arrivalDate'] = $searchArray['arrivalDate'];
        $searchParams['departureDate'] = $searchArray['departureDate'];
        $searchParams['numberOfResults'] = $searchArray['numberOfResults'];
        $searchParams['supplierCacheTolerance'] = 'MED_ENHANCED';
        //$searchParams['RoomGroup'] = array('Room'=> array ('numberOfAdults' => '1'));
        $searchParams['room1'] = $searchArray['room1'];
        $searchParams['minRate'] 					= $searchArray['minRate'];
        $searchParams['maxRate'] 					= $searchArray['maxRate'];
       $searchParams['hotelName'] 					= $searchArray['jqSearchKeyword'];

        $searchres = Apisearch::expediaListHotels($searchParams);
        

        //Utils::echopre($searchres);
        //exit();
        return $searchres;
    }

    public function expediahotelinfo($hotelid) {

        $searchParams = array();
        $searchParams['hotelId'] = $hotelid;
        $hotelInfo = Apisearch::expediaHotelInfo($searchParams);
        Utils::echopre($hotelInfo);
        exit();

    }



    /*
     * help section
    */
    public function help($subcatid='',$pageid='') {
        PageContext::addStyle('affiliates.css',true);
        // get the help categories
        PageContext::$response->helpcategory = Utils::getHelpCategories('client');

        if($pageid != '')
            PageContext::$response->pageDetails = Utils::getHelpPage($pageid);
        else {
            if($subcatid == '')
                $subcatid = Utils::getHelpItem();

            // getting the help descriptions
            PageContext::$response->helpDetails = Utils::getHelpDetails($subcatid);
        }

        // getting the active tab
        foreach(PageContext::$response->helpcategory as $cats) {
            if($subcatid == $cats->hcid) {
                PageContext::$response->activeHelpCatid  = $cats->hcid;
                PageContext::$response->activeHelpCat  = $cats->hctitle;
                break;
            }
        }


        // echopre(PageContext::$response->helpDetails);
        PageContext::registerPostAction("center-left","leftpanelhelp","search","default");
        PageContext::registerPostAction("center-main", "help","search","default");
    }



}

?>