DROP TABLE IF EXISTS `tbl_language`;
CREATE TABLE IF NOT EXISTS `tbl_language` (
  `id` int(8) NOT NULL,
  `lang_id` char(50) NOT NULL default 'en',
  `lang_key` varchar(100) default NULL,
  `lang_value` text character set utf8 collate utf8_unicode_ci,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `cms_groups`;
CREATE TABLE IF NOT EXISTS `cms_groups` (
  `id` int(11) NOT NULL auto_increment,
  `group_name` varchar(50) default NULL,
  `position` int(3) default '0',
  `published` tinyint(1) default '1',
  `user_privilege` varchar(256) NOT NULL default 'all',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=8 ;


DROP TABLE IF EXISTS `cms_privileges`;
CREATE TABLE IF NOT EXISTS `cms_privileges` (
  `privilege_id` int(11) NOT NULL auto_increment,
  `entity_type` enum('group','section') NOT NULL,
  `entity_id` int(11) NOT NULL,
  `view_role_id` int(11) NOT NULL,
  `add_role_id` int(11) NOT NULL,
  `edit_role_id` int(11) NOT NULL,
  `delete_role_id` int(11) NOT NULL,
  `publish_role_id` int(11) NOT NULL,
  PRIMARY KEY  (`privilege_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=18 ;


DROP TABLE IF EXISTS `cms_roles`;
CREATE TABLE IF NOT EXISTS `cms_roles` (
  `role_id` int(11) NOT NULL auto_increment,
  `role_name` varchar(256) NOT NULL,
  `parent_role_id` int(11) NOT NULL,
  PRIMARY KEY  (`role_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=13 ;


DROP TABLE IF EXISTS `cms_sections`;
CREATE TABLE IF NOT EXISTS `cms_sections` (
  `id` int(8) NOT NULL auto_increment,
  `group_id` int(8) default NULL,
  `section_name` varchar(200) default NULL,
  `section_alias` varchar(200) default NULL,
  `table_name` varchar(100) default NULL,
  `section_config` text,
  `visibilty` enum('0','1') NOT NULL,
  `display_order` int(11) NOT NULL,
  `user_privilege` varchar(256) NOT NULL default 'all',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=51 ;


DROP TABLE IF EXISTS `cms_users`;
CREATE TABLE IF NOT EXISTS `cms_users` (
  `id` int(11) NOT NULL auto_increment,
  `type` enum('sadmin','admin') NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `email` varchar(256) NOT NULL,
  `role_id` int(11) NOT NULL,
  `status` enum('active','deleted') NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;

DROP TABLE IF EXISTS `tbl_cms_settings`;
CREATE TABLE IF NOT EXISTS `tbl_cms_settings` (
  `id` int(11) NOT NULL auto_increment,
  `cms_set_name` varchar(100) NOT NULL,
  `cms_set_value` varchar(255) NOT NULL,
  `created_on` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `sessions`;
CREATE TABLE IF NOT EXISTS `sessions` (
  `session_id` varchar(100) NOT NULL default '',
  `session_data` text NOT NULL,
  `expires` int(11) NOT NULL default '0',
  PRIMARY KEY  (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `tbl_files`;
CREATE TABLE IF NOT EXISTS `tbl_files` (
  `file_id` int(11) NOT NULL auto_increment,
  `file_orig_name` varchar(255) default NULL,
  `file_extension` varchar(10) default NULL,
  `file_mime_type` varchar(50) default NULL,
  `file_type` varchar(50) default NULL COMMENT 'video/photo',
  `file_width` int(4) default NULL,
  `file_height` int(4) default NULL,
  `file_play_time` int(11) default NULL,
  `file_size` int(11) default NULL,
  `file_path` text,
  `file_status` int(11) default NULL,
  `file_title` varchar(255) default NULL,
  `file_caption` text,
  `file_tmp_name` varchar(255) default NULL,
  `created_on` datetime default NULL,
  `created_by` int(11) default NULL,
  PRIMARY KEY  (`file_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=221 ;

DROP TABLE IF EXISTS `tbl_audit`;
CREATE TABLE IF NOT EXISTS `tbl_audit` (
  `id` int(11) NOT NULL auto_increment,
  `audit_table` varchar(255) default NULL,
  `audit_data` longtext,
  `where_condition` text,
  `audit_type` enum('insert','update','delete') default NULL,
  `created_by` int(11) default NULL,
  `created_on` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=351 ;

DROP TABLE IF EXISTS `tbl_reviews`;
CREATE TABLE IF NOT EXISTS `tbl_reviews` (
  `review_id` int(10) NOT NULL auto_increment,
  `reviewType` enum('Dst','Loc','Usr') NOT NULL,
  `reviewTitle` varchar(200) NOT NULL,
  `reviewed_entity_id` int(10) NOT NULL,
  `reviewDescription` text NOT NULL,
  `createdBy` int(10) NOT NULL,
  `createdOn` datetime NOT NULL,
  `isApproved` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`review_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

DROP TABLE IF EXISTS `tbl_group_discounts`;
CREATE TABLE IF NOT EXISTS `tbl_group_discounts` (
  `discount_id` int(10) NOT NULL auto_increment,
  `nAat_id` int(10) default NULL,
  `group_size` int(10) default NULL,
  `group_size_range` int(10) default NULL,
  `discount_percentage` float default NULL,
  PRIMARY KEY  (`discount_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=17 ;

DROP TABLE IF EXISTS `tbl_offer_price`;
CREATE TABLE IF NOT EXISTS `tbl_offer_price` (
  `offer_price_id` int(10) NOT NULL auto_increment,
  `nAat_Id` int(10) NOT NULL default '0',
  `offer_start_date` date NOT NULL,
  `offer_end_date` date NOT NULL,
  `price` float NOT NULL,
  `published` tinyint(1) NOT NULL default '0',
  `created_on` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`offer_price_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=9 ;

DROP TABLE IF EXISTS `tbl_mail_template`;
CREATE TABLE IF NOT EXISTS `tbl_mail_template` (
  `id` int(5) unsigned NOT NULL auto_increment,
  `mail_template_name` varchar(255) collate latin1_general_ci NOT NULL,
  `mail_template_sub` varchar(255) collate latin1_general_ci NOT NULL,
  `mail_template_body` text collate latin1_general_ci NOT NULL,
  `mail_template_status` smallint(1) NOT NULL,
  `created_on` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `test` (`id`),
  FULLTEXT KEY `mail_template_title` (`mail_template_sub`,`mail_template_body`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='templates for all emails sent out from system' AUTO_INCREMENT=38 ;

DROP TABLE IF EXISTS `tbl_affiliates`;
CREATE TABLE IF NOT EXISTS `tbl_affiliates` (
  `aff_id` int(11) NOT NULL auto_increment,
  `aff_email` varchar(100) NOT NULL,
  `aff_pwd` varchar(255) NOT NULL,
  `aff_activation_key` varchar(100) NOT NULL,
  `aff_fname` varchar(100) NOT NULL,
  `aff_lname` varchar(100) NOT NULL,
  `aff_address1` text NOT NULL,
  `aff_address2` text NOT NULL,
  `aff_city` varchar(100) NOT NULL,
  `aff_country` varchar(100) NOT NULL,
  `aff_state` varchar(100) NOT NULL,
  `aff_zip` varchar(10) NOT NULL,
  `aff_phone` varchar(15) NOT NULL,
  `aff_fax` varchar(10) NOT NULL,
  `aff_regdate` varchar(30) NOT NULL,
  `aff_status` tinyint(1) NOT NULL,
  PRIMARY KEY  (`aff_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=16 ;

DROP TABLE IF EXISTS `tbl_affiliates_links`;
CREATE TABLE IF NOT EXISTS `tbl_affiliates_links` (
  `link_id` int(11) NOT NULL auto_increment,
  `link_name` varchar(255) NOT NULL,
  `link_image` varchar(255) NOT NULL,
  `link_status` tinyint(1) NOT NULL COMMENT '1-> active; 0 -> disabled',
  `link_type` tinyint(1) NOT NULL COMMENT '0-> image link,  1-> text link',
  PRIMARY KEY  (`link_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;


DROP TABLE IF EXISTS `tbl_affiliate_useraction`;
CREATE TABLE IF NOT EXISTS `tbl_affiliate_useraction` (
  `ua_id` int(11) NOT NULL auto_increment,
  `ua_aff_id` int(11) NOT NULL,
  `ua_userid` int(11) NOT NULL,
  `ua_actiontype` tinyint(1) NOT NULL COMMENT '1-> registration, 2-> booking',
  `ua_booking_id` int(11) NOT NULL,
  `ua_actiondate` varchar(30) NOT NULL,
  `ua_payment` decimal(10,0) NOT NULL,
  `ua_referalcharge` decimal(10,0) NOT NULL,
  `ua_paystatus` tinyint(1) NOT NULL COMMENT '1-> Un paid, 2 ->paid, 3->rejected',
  `ua_displaystatus` tinyint(1) NOT NULL COMMENT '1->show; 2->hide',
  `ua_date_settled` datetime NOT NULL,
  `ua_settled_ref` varchar(100) NOT NULL,
  `ua_settled_type` tinyint(1) NOT NULL COMMENT '1=>Cheque,2=>DD',
  PRIMARY KEY  (`ua_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

DROP TABLE IF EXISTS `tbl_expedia_location_details`;
CREATE TABLE IF NOT EXISTS `tbl_expedia_location_details` (
  `ex_id` int(11) NOT NULL auto_increment,
  `booking_id` int(11) NOT NULL,
  `locationid` int(11) NOT NULL,
  `location_name` varchar(255) NOT NULL,
  `destination_name` varchar(255) NOT NULL,
  `accomadation_name` varchar(255) NOT NULL,
  PRIMARY KEY  (`ex_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=7 ;

DROP TABLE IF EXISTS `fw_metadata`;
CREATE TABLE IF NOT EXISTS `fw_metadata` (
  `id` int(11) NOT NULL auto_increment,
  `url` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

DROP TABLE IF EXISTS `tbl_rating`;
CREATE TABLE IF NOT EXISTS `tbl_rating` (
  `nRatingId` bigint(20) NOT NULL auto_increment,
  `nCust_Id` bigint(20) NOT NULL,
  `nLocation_Id` bigint(20) NOT NULL,
  `nDestination_Id` bigint(20) NOT NULL,
  `nMarks` bigint(20) NOT NULL,
  `vFeedbackTitle` varchar(150) NOT NULL,
  `vFeedback` varchar(256) NOT NULL,
  `dPosted_Date` datetime NOT NULL,
  `vRate_Status` varchar(20) NOT NULL default 'deactive',
  `vFeedback_Status` varchar(20) NOT NULL,
  PRIMARY KEY  (`nRatingId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tbl_bank_details`;
CREATE TABLE IF NOT EXISTS `tbl_bank_details` (
  `bid` int(10) unsigned NOT NULL auto_increment,
  `paymentId` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `bank` varchar(255) NOT NULL,
  `reference_no` varchar(255) NOT NULL,
  `payment_mode` varchar(50) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

ALTER TABLE `tbl_lookup` ADD `settinglabel` varchar(250) NOT NULL;
ALTER TABLE `tbl_lookup` ADD `groupLabel` varchar(50) NOT NULL;
ALTER TABLE `tbl_lookup` ADD `type` varchar(256) NOT NULL;

ALTER TABLE `tbl_destination` ADD `file_id` int(11) NOT NULL;
ALTER TABLE `tbl_gallery` ADD `file_id` int(11) NOT NULL;
ALTER TABLE `tbl_News` ADD `file_id` int(11) NOT NULL;

ALTER TABLE `tbl_available_acco_type` ADD `file_id` int(11) NOT NULL;
ALTER TABLE `tbl_available_acco_type` ADD `created_on` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP;

ALTER TABLE `tbl_Banners` ADD `file_id` int(11) NOT NULL;
ALTER TABLE `tbl_packages` ADD `file_id` int(11) NOT NULL;

ALTER TABLE `tbl_special_offers` ADD `file_id` int(11) NOT NULL;
ALTER TABLE `tbl_locations` ADD `vLatitude` VARCHAR( 50 ) NULL AFTER `vCountry` ,
ADD `vLongtitude` VARCHAR( 50 ) NULL AFTER `vLatitude`;

ALTER TABLE `tbl_rating` ADD `vFeedbackTitle` VARCHAR( 150 ) NOT NULL AFTER `nMarks`;
ALTER TABLE `tbl_customers` ADD `activation_key` VARCHAR( 255 ) NULL AFTER `vFax` ;


ALTER TABLE `tbl_booking` ADD `nReserveModeAmount` DOUBLE( 20, 2 ) NULL AFTER `nAmount` ;
ALTER TABLE `tbl_booking` ADD `nRooms` INT NOT NULL AFTER `nChildren` ;
ALTER TABLE `tbl_booking` ADD `vBookedBy` ENUM( 'USERS', 'ADMIN' ) NOT NULL DEFAULT 'USERS',
ADD `cancellationStatus` VARCHAR( 50 ) NOT NULL;

ALTER TABLE `tbl_enquiry` ADD `status` int(11) NOT NULL COMMENT '0 for received and 1 for replied';

ALTER TABLE `tbl_Range` CHANGE `vTitle` `day_start_range` INT NOT NULL DEFAULT '0';
ALTER TABLE `tbl_Range` ADD `day_end_range` INT NOT NULL AFTER `day_start_range` ;

ALTER TABLE `tbl_Help` ADD `file_id` int(11) NOT NULL;
ALTER TABLE `tbl_payment` ADD `transactionType` ENUM( 'BOOKING', 'CANCEL' ) NOT NULL DEFAULT 'BOOKING';

ALTER TABLE `tbl_booking` ADD `api_flag` ENUM( 'Y', 'N' ) NOT NULL DEFAULT 'N' COMMENT 'flag to know whether this booking is done through any third part api';
